/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.logging;

import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.ByteSink;
import com.google.common.io.ByteSource;
import com.google.common.io.CharSink;
import com.google.escapevelocity.Template;
import com.google.protobuf.ExtensionRegistry;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.template.soy.logging.AnnotatedLoggableElement;
import com.google.template.soy.logging.AnnotatedLoggingConfig;
import com.google.template.soy.logging.AutoValue_VeMetadataGenerator_Options;
import com.google.template.soy.logging.LoggableElementMetadata;
import com.google.template.soy.logging.RuntimeVeMetadata;
import com.google.template.soy.logging.VeMetadataExtensionRegistry;
import com.google.template.soy.types.SoyTypeRegistry;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;

public final class VeMetadataGenerator {
    private final Mode mode;
    private final ByteSource loggingConfigBytes;
    private final String generator;
    private final SoyTypeRegistry typeRegistry;
    private final CharSink output;
    private final Optional<ByteSink> resourceOutput;

    public VeMetadataGenerator(Mode mode, ByteSource loggingConfigBytes, String generator, SoyTypeRegistry typeRegistry, CharSink output, Optional<ByteSink> resourceOutput) {
        this.mode = mode;
        this.loggingConfigBytes = loggingConfigBytes;
        this.generator = generator;
        this.typeRegistry = typeRegistry;
        this.output = output;
        this.resourceOutput = resourceOutput;
    }

    public void generateAndWrite() throws IOException {
        ExtensionRegistry registry = new VeMetadataExtensionRegistry(this.typeRegistry).createRegistry();
        AnnotatedLoggingConfig loggingConfig = this.parseLoggingConfig(registry);
        Options options = Options.create(loggingConfig, this.generator);
        this.mode.generateAndWrite(loggingConfig, options, registry, this.output, this.resourceOutput);
    }

    private AnnotatedLoggingConfig parseLoggingConfig(ExtensionRegistry registry) throws IOException {
        try (InputStream input = this.loggingConfigBytes.openStream();){
            AnnotatedLoggingConfig annotatedLoggingConfig = AnnotatedLoggingConfig.parseFrom(input, (ExtensionRegistryLite)registry);
            return annotatedLoggingConfig;
        }
    }

    @AutoValue
    static abstract class Options {
        Options() {
        }

        private static Options create(AnnotatedLoggingConfig loggingConfig, String generator) {
            String javaPackage = loggingConfig.getElement(0).getJavaPackage();
            String className = loggingConfig.getElement(0).getClassName();
            String javaResourceFilename = loggingConfig.getElement(0).getJavaResourceFilename();
            loggingConfig.getElementList().forEach(e -> Options.validateElement(e, javaPackage, className, javaResourceFilename));
            return new AutoValue_VeMetadataGenerator_Options(javaPackage, className, javaResourceFilename, generator);
        }

        private static void validateElement(AnnotatedLoggableElement element, String javaPackage, String className, String javaResourceFilename) {
            Preconditions.checkState((boolean)javaPackage.equals(element.getJavaPackage()), (String)"expected %s but got %s", (Object)javaPackage, (Object)element.getJavaPackage());
            Preconditions.checkState((boolean)className.equals(element.getClassName()), (String)"expected %s but got %s", (Object)className, (Object)element.getClassName());
            Preconditions.checkState((boolean)javaResourceFilename.equals(element.getJavaResourceFilename()), (String)"expected %s but got %s", (Object)javaResourceFilename, (Object)element.getJavaResourceFilename());
        }

        abstract String javaPackage();

        abstract String className();

        abstract String javaResourceFilename();

        abstract String generator();
    }

    public static enum Mode {
        SERVER{

            @Override
            void generateAndWrite(AnnotatedLoggingConfig loggingConfig, Options options, ExtensionRegistry registry, CharSink output, Optional<ByteSink> resourceOutput) throws IOException {
                Preconditions.checkState((boolean)resourceOutput.isPresent());
                ImmutableMap templateVars = ImmutableMap.of((Object)"package", (Object)options.javaPackage(), (Object)"javaResourceFilename", (Object)options.javaResourceFilename());
                output.write((CharSequence)Mode.generateMetadataFile("server_ve_metadata.vm", options, (ImmutableMap<String, Object>)templateVars));
                RuntimeVeMetadata.Builder runtimeVeMetadata = RuntimeVeMetadata.newBuilder();
                for (AnnotatedLoggableElement element : loggingConfig.getElementList()) {
                    if (!element.getHasMetadata()) continue;
                    runtimeVeMetadata.putMetadata(element.getElement().getId(), element.getElement().getMetadata());
                }
                resourceOutput.get().write(runtimeVeMetadata.build().toByteArray());
            }
        }
        ,
        CLIENT{

            @Override
            void generateAndWrite(AnnotatedLoggingConfig loggingConfig, Options options, ExtensionRegistry registry, CharSink output, Optional<ByteSink> resourceOutput) throws IOException {
                Preconditions.checkState((!resourceOutput.isPresent() ? 1 : 0) != 0);
                Function<LoggableElementMetadata, String> serializeFunction = metadata -> Arrays.toString(metadata.toByteArray());
                ImmutableMap veMetadatas = (ImmutableMap)loggingConfig.getElementList().stream().filter(AnnotatedLoggableElement::getHasMetadata).map(AnnotatedLoggableElement::getElement).collect(ImmutableMap.toImmutableMap(e -> e.getId(), e -> (String)serializeFunction.apply(e.getMetadata())));
                output.write((CharSequence)Mode.generateMetadataFile("client_ve_metadata.vm", options, (ImmutableMap<String, Object>)ImmutableMap.of((Object)"veMetadatas", (Object)veMetadatas)));
            }
        };


        abstract void generateAndWrite(AnnotatedLoggingConfig var1, Options var2, ExtensionRegistry var3, CharSink var4, Optional<ByteSink> var5) throws IOException;

        private static String generateMetadataFile(String metadataTemplateFilename, Options options, ImmutableMap<String, Object> extraTemplateVars) throws IOException {
            Template template = Template.parseFrom((Reader)new BufferedReader(new InputStreamReader(VeMetadataGenerator.class.getResourceAsStream(metadataTemplateFilename), StandardCharsets.UTF_8)));
            ImmutableMap vars = ImmutableMap.builder().putAll(extraTemplateVars).put((Object)"className", (Object)options.className()).put((Object)"generator", (Object)options.generator()).build();
            return template.evaluate((Map)vars);
        }
    }
}

