/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.logging;

import com.google.common.io.CharSource;
import com.google.protobuf.ExtensionRegistry;
import com.google.protobuf.Message;
import com.google.protobuf.TextFormat;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.logging.AnnotatedLoggableElement;
import com.google.template.soy.logging.AnnotatedLoggingConfig;
import com.google.template.soy.logging.LoggableElement;
import com.google.template.soy.logging.LoggingConfig;
import com.google.template.soy.logging.ValidatedLoggingConfig;
import com.google.template.soy.logging.VeMetadataExtensionRegistry;
import com.google.template.soy.types.SoyTypeRegistry;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;

public final class AnnotatedLoggingConfigGenerator {
    private static final SoyErrorKind TEXT_PROTO_PARSE_ERROR = SoyErrorKind.of("Error parsing logging config textproto: {0}", SoyErrorKind.StyleAllowance.NO_PUNCTUATION);
    private static final SoyErrorKind DUPLICATE_VE = SoyErrorKind.of("Logging config contains different VEs with the same ID:\n\n{0}\nand\n\n{1}", SoyErrorKind.StyleAllowance.NO_PUNCTUATION);
    private final CharSource rawLoggingConfig;
    private final String javaPackage;
    private final String jsPackage;
    private final String className;
    private final String javaResourceFilename;
    private final SoyTypeRegistry typeRegistry;
    private final ErrorReporter errorReporter;

    public AnnotatedLoggingConfigGenerator(CharSource rawLoggingConfig, String javaPackage, String jsPackage, String className, String javaResourceFilename, SoyTypeRegistry typeRegistry, ErrorReporter errorReporter) {
        this.rawLoggingConfig = rawLoggingConfig;
        this.javaPackage = javaPackage;
        this.jsPackage = jsPackage;
        this.className = className;
        this.javaResourceFilename = javaResourceFilename;
        this.typeRegistry = typeRegistry;
        this.errorReporter = errorReporter;
    }

    private LoggingConfig parseLoggingConfig() throws IOException {
        ExtensionRegistry extensions = new VeMetadataExtensionRegistry(this.typeRegistry).createRegistry();
        LoggingConfig.Builder loggingConfig = LoggingConfig.newBuilder();
        try (Reader input = this.rawLoggingConfig.openStream();){
            TextFormat.merge((Readable)input, (ExtensionRegistry)extensions, (Message.Builder)loggingConfig);
        }
        catch (TextFormat.ParseException e) {
            this.errorReporter.report(SourceLocation.UNKNOWN, TEXT_PROTO_PARSE_ERROR, e.getMessage());
        }
        return loggingConfig.build();
    }

    public AnnotatedLoggingConfig generate() throws IOException {
        LoggingConfig loggingConfig = this.parseLoggingConfig();
        AnnotatedLoggingConfig.Builder builder = AnnotatedLoggingConfig.newBuilder().addElement(ValidatedLoggingConfig.UNDEFINED_VE.toBuilder().setHasMetadata(false).setJavaPackage(this.javaPackage).setJsPackage(this.jsPackage).setClassName(this.className).setJavaResourceFilename(this.javaResourceFilename).build());
        HashMap<Long, LoggableElement> elements = new HashMap<Long, LoggableElement>();
        for (LoggableElement element : loggingConfig.getElementList()) {
            AnnotatedLoggableElement annotatedElement = AnnotatedLoggableElement.newBuilder().setHasMetadata(element.getMetadata().getSerializedSize() > 0).setElement(element).setJavaPackage(this.javaPackage).setJsPackage(this.jsPackage).setClassName(this.className).setJavaResourceFilename(this.javaResourceFilename).build();
            if (elements.containsKey(element.getId())) {
                if (element.equals(elements.get(element.getId()))) continue;
                this.errorReporter.report(SourceLocation.UNKNOWN, DUPLICATE_VE, element, elements.get(element.getId()));
                continue;
            }
            builder.addElement(annotatedElement);
            elements.put(element.getId(), element);
        }
        return builder.build();
    }
}

