/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jssrc.internal;

import com.google.common.collect.ImmutableList;
import com.google.template.soy.base.SourceFilePath;
import com.google.template.soy.base.internal.SanitizedContentKind;
import com.google.template.soy.base.internal.UniqueNameGenerator;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.jssrc.dsl.CodeChunk;
import com.google.template.soy.jssrc.dsl.Expression;
import com.google.template.soy.jssrc.dsl.GoogRequire;
import com.google.template.soy.jssrc.dsl.JsDoc;
import com.google.template.soy.jssrc.dsl.Statement;
import com.google.template.soy.jssrc.dsl.VariableDeclaration;
import com.google.template.soy.jssrc.internal.AliasUtils;
import com.google.template.soy.jssrc.internal.GenLitExprVisitor;
import com.google.template.soy.jssrc.internal.IsComputableAsLitTemplateVisitor;
import com.google.template.soy.jssrc.internal.JavaScriptValueFactoryImpl;
import com.google.template.soy.jssrc.internal.JsCodeBuilder;
import com.google.template.soy.jssrc.internal.JsRuntime;
import com.google.template.soy.jssrc.internal.JsSrcNameGenerators;
import com.google.template.soy.jssrc.internal.JsType;
import com.google.template.soy.jssrc.internal.SoyToJsVariableMappings;
import com.google.template.soy.jssrc.internal.TemplateAliases;
import com.google.template.soy.jssrc.internal.TranslateExprNodeVisitor;
import com.google.template.soy.jssrc.internal.TranslationContext;
import com.google.template.soy.soytree.AbstractSoyNodeVisitor;
import com.google.template.soy.soytree.ConstNode;
import com.google.template.soy.soytree.ExternNode;
import com.google.template.soy.soytree.FileSetMetadata;
import com.google.template.soy.soytree.ImportNode;
import com.google.template.soy.soytree.JsImplNode;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyFileSetNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.TemplateDelegateNode;
import com.google.template.soy.soytree.TemplateNode;
import com.google.template.soy.soytree.Visibility;
import com.google.template.soy.soytree.defn.ConstVar;
import com.google.template.soy.soytree.defn.ImportedVar;
import com.google.template.soy.soytree.defn.TemplateParam;
import com.google.template.soy.types.SoyType;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;

public final class GenLitCodeVisitor
extends AbstractSoyNodeVisitor<List<String>> {
    private final FileSetMetadata fileSetMetadata;
    private TemplateAliases templateAliases = null;
    private JsCodeBuilder jsCodeBuilder;
    private List<String> jsFilesContents;
    private ErrorReporter errorReporter;
    private SoyToJsVariableMappings topLevelSymbols;
    private final IsComputableAsLitTemplateVisitor isComputableAsLitTemplateVisitor;
    private final GenLitExprVisitor.GenLitExprVisitorFactory genLitExprVisitorFactory;
    private final JavaScriptValueFactoryImpl javaScriptValueFactory;
    private final UniqueNameGenerator nameGenerator = JsSrcNameGenerators.forLocalVariables();
    private final CodeChunk.Generator codeGenerator = CodeChunk.Generator.create(this.nameGenerator);

    GenLitCodeVisitor(FileSetMetadata fileSetMetadata, JavaScriptValueFactoryImpl javaScriptValueFactory, IsComputableAsLitTemplateVisitor isComputableAsLitTemplateVisitor, GenLitExprVisitor.GenLitExprVisitorFactory genLitExprVisitorFactory) {
        this.fileSetMetadata = fileSetMetadata;
        this.javaScriptValueFactory = javaScriptValueFactory;
        this.isComputableAsLitTemplateVisitor = isComputableAsLitTemplateVisitor;
        this.genLitExprVisitorFactory = genLitExprVisitorFactory;
    }

    @Override
    protected void visit(SoyNode node) {
        try {
            super.visit(node);
        }
        catch (RuntimeException e) {
            throw new AssertionError("error from : " + (Object)((Object)node.getKind()) + " @ " + node.getSourceLocation(), e);
        }
    }

    public List<String> gen(SoyFileSetNode node, ErrorReporter errorReporter) {
        this.errorReporter = errorReporter;
        this.jsFilesContents = new ArrayList<String>();
        this.jsCodeBuilder = null;
        this.visit(node);
        return this.jsFilesContents;
    }

    @Override
    protected void visitSoyFileSetNode(SoyFileSetNode node) {
        for (SoyFileNode soyFile : node.getChildren()) {
            this.visit(soyFile);
        }
    }

    private void addCodeToDeclareGoogModule(StringBuilder header, SoyFileNode soyFile) {
        String exportNamespace = soyFile.getNamespace() + ".lit";
        header.append("goog.module('").append(exportNamespace).append("');\n\n");
    }

    @Override
    protected void visitSoyFileNode(SoyFileNode node) {
        StringBuilder file = new StringBuilder();
        file.append("// This file was automatically generated by the Soy compiler.\n").append("// Please don't edit this file by hand.\n").append("// source: ").append(node.getFilePath().path()).append('\n');
        if (node.numChildren() == 0) {
            this.jsFilesContents.add(file.toString());
            return;
        }
        file.append("\n");
        String fileOverviewDescription = "Templates in namespace " + node.getNamespace() + ".";
        JsDoc.Builder jsDocBuilder = JsDoc.builder();
        jsDocBuilder.addAnnotation("fileoverview", fileOverviewDescription);
        file.append(jsDocBuilder.build());
        file.append("\n\n");
        this.jsCodeBuilder = new JsCodeBuilder();
        this.templateAliases = AliasUtils.createTemplateAliases(node, this.fileSetMetadata);
        this.addCodeToDeclareGoogModule(file, node);
        this.topLevelSymbols = SoyToJsVariableMappings.newEmpty();
        for (ImportNode importNode : node.getImports()) {
            this.visit(importNode);
        }
        for (ConstNode constant : node.getConstants()) {
            this.jsCodeBuilder.appendLine(new String[0]).appendLine(new String[0]);
            this.visit(constant);
        }
        node.getExterns().stream().map(ExternNode::getJsImpl).filter(Optional::isPresent).map(Optional::get).forEach(jsExtern -> {
            this.jsCodeBuilder.appendLine(new String[0]).appendLine(new String[0]);
            this.visit((SoyNode)jsExtern);
        });
        for (TemplateNode template : node.getTemplates()) {
            this.jsCodeBuilder.appendLine(new String[0]).appendLine(new String[0]);
            this.visit(template);
        }
        this.jsCodeBuilder.appendGoogRequiresTo(file);
        this.jsCodeBuilder.appendCodeTo(file);
        this.jsFilesContents.add(file.toString());
        this.jsCodeBuilder = null;
    }

    @Override
    protected void visitTemplateNode(TemplateNode node) {
        SanitizedContentKind kind = node.getContentKind();
        if (kind == SanitizedContentKind.ATTRIBUTES || kind == SanitizedContentKind.JS || kind == SanitizedContentKind.CSS || node instanceof TemplateDelegateNode || node.getVisibility() == Visibility.PRIVATE) {
            return;
        }
        ImmutableList.Builder declarations = ImmutableList.builder();
        String templateName = node.getTemplateName();
        String alias = this.templateAliases.get(templateName);
        String partialName = node.getLocalTemplateSymbol();
        Expression aliasExp = Expression.dottedIdNoRequire(alias);
        JsDoc jsDoc = this.generateFunctionJsDoc(alias, kind);
        Expression function = Expression.function(jsDoc, this.generateFunctionBody(node));
        declarations.add((Object)VariableDeclaration.builder(alias).setJsDoc(jsDoc).setRhs(function).build());
        declarations.add((Object)Statement.assign(JsRuntime.EXPORTS.dotAccess(partialName), aliasExp));
        if (!this.hasOnlyImplicitParams(node)) {
            declarations.add((Object)aliasExp.dotAccess("Params").asStatement(JsDoc.builder().addParameterizedAnnotation("typedef", this.genParamsRecordType(node)).build()));
        }
        this.jsCodeBuilder.append(Statement.of((Iterable<Statement>)declarations.build()));
    }

    private String genParamsRecordType(TemplateNode node) {
        LinkedHashMap<String, String> record = new LinkedHashMap<String, String>();
        for (TemplateParam param : node.getParams()) {
            if (param.isImplicit()) continue;
            JsType jsType = JsType.forLitSrc(param.type());
            String typeForRecord = jsType.typeExprForRecordMember(!param.isRequired());
            record.put(param.name(), typeForRecord);
            for (GoogRequire require : jsType.getGoogRequires()) {
                this.jsCodeBuilder.addGoogRequire(require);
            }
        }
        return JsType.toRecord(record);
    }

    private boolean hasOnlyImplicitParams(TemplateNode node) {
        for (TemplateParam param : node.getParams()) {
            if (param.isImplicit()) continue;
            return false;
        }
        return true;
    }

    private JsDoc generateFunctionJsDoc(String alias, SanitizedContentKind kind) {
        JsDoc.Builder jsDocBuilder = JsDoc.builder();
        jsDocBuilder.addParam("$data", "!" + alias + ".Params");
        if (kind == SanitizedContentKind.TEXT) {
            jsDocBuilder.addParameterizedAnnotation("return", "string");
        } else {
            jsDocBuilder.addParameterizedAnnotation("return", "lit_element.TemplateResult");
        }
        return jsDocBuilder.build();
    }

    private Statement generateFunctionBody(TemplateNode node) {
        if (!((Boolean)this.isComputableAsLitTemplateVisitor.exec(node)).booleanValue()) {
            return Statement.throwValue(Expression.construct(Expression.id("Error"), Expression.stringLiteral("No implementation yet for the lit soy backend")));
        }
        TranslationContext templateTranslationContext = TranslationContext.of(SoyToJsVariableMappings.startingWith(this.topLevelSymbols), this.codeGenerator, this.nameGenerator);
        GenLitExprVisitor genLitExprVisitor = this.genLitExprVisitorFactory.create(templateTranslationContext, this.templateAliases, this.errorReporter);
        Expression functionBody = genLitExprVisitor.exec(node);
        return Statement.returnValue(functionBody);
    }

    @Override
    protected void visitImportNode(ImportNode node) {
        if (node.getImportType() == ImportNode.ImportType.TEMPLATE) {
            node.getIdentifiers().forEach(id -> this.visitImportNode(node, (ImportedVar)id, node.getModuleType()));
        }
    }

    private void visitImportNode(ImportNode node, ImportedVar var, SoyType parentType) {
        if (parentType != null && parentType.getKind() == SoyType.Kind.TEMPLATE_MODULE && var.type().getKind() != SoyType.Kind.TEMPLATE_TYPE) {
            String namespace = this.namespaceForPath(node.getSourceFilePath());
            namespace = this.templateAliases.getNamespaceAlias(namespace);
            Expression translation = Expression.dottedIdNoRequire(namespace + "." + var.getSymbol());
            if (parentType.getKind() != SoyType.Kind.FUNCTION) {
                translation = translation.call(JsRuntime.SOY_INTERNAL_CALL_MARKER);
            }
            this.topLevelSymbols.put(var.name(), translation);
        }
        var.getNestedTypes().forEach(name -> this.visitImportNode(node, var.nested((String)name), var.type()));
    }

    private String namespaceForPath(SourceFilePath path) {
        return this.fileSetMetadata.getFile(path).getNamespace();
    }

    @Override
    protected void visitConstNode(ConstNode node) {
        String partialName;
        ConstVar var = node.getVar();
        ImmutableList.Builder declarations = ImmutableList.builder();
        JsDoc jsDoc = JsDoc.builder().addAnnotation(node.isExported() ? "public" : "private").addParameterizedAnnotation("return", this.getJsTypeForParamForDeclaration(var.type()).typeExpr()).build();
        String alias = partialName = var.name();
        Expression aliasExp = Expression.dottedIdNoRequire(alias);
        Expression constantGetterFunction = Expression.function(jsDoc, Statement.returnValue(this.translateExpr(node.getExpr())));
        declarations.add((Object)VariableDeclaration.builder(alias).setJsDoc(jsDoc).setRhs(constantGetterFunction).build());
        if (node.isExported()) {
            declarations.add((Object)Statement.assign(JsRuntime.EXPORTS.dotAccess(partialName), aliasExp));
        }
        this.jsCodeBuilder.append(Statement.of((Iterable<Statement>)declarations.build()));
        this.topLevelSymbols.put(var.name(), aliasExp.call(JsRuntime.SOY_INTERNAL_CALL_MARKER));
    }

    @Override
    protected void visitJsImplNode(JsImplNode node) {
        ExternNode externNode = node.getParent();
        String externName = externNode.getIdentifier().originalName();
        if (this.topLevelSymbols.has(externName)) {
            return;
        }
        GoogRequire externRequire = GoogRequire.createWithAlias(node.module(), node.module().replace('.', '$'));
        Expression externReference = Expression.dottedIdNoRequire(externRequire.alias()).dotAccess(node.function());
        this.jsCodeBuilder.addGoogRequire(externRequire);
        this.topLevelSymbols.put(externName, externReference);
        if (externNode.isExported()) {
            Expression export = JsRuntime.EXPORTS.dotAccess(externName);
            this.jsCodeBuilder.append(Statement.assign(export, externReference));
        }
    }

    private JsType getJsTypeForParamForDeclaration(SoyType paramType) {
        return JsType.forJsSrc(paramType);
    }

    private TranslateExprNodeVisitor getExprTranslator() {
        return new TranslateExprNodeVisitor(this.javaScriptValueFactory, TranslationContext.of(SoyToJsVariableMappings.startingWith(this.topLevelSymbols), this.codeGenerator, this.nameGenerator), this.templateAliases, this.errorReporter, JsRuntime.OPT_DATA);
    }

    private Expression translateExpr(ExprNode expr) {
        return (Expression)this.getExprTranslator().exec(expr);
    }

    @Override
    protected void visitChildren(SoyNode.ParentSoyNode<?> node) {
        for (SoyNode child : node.getChildren()) {
            this.visit(child);
        }
    }
}

