/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jssrc.dsl;

import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.Immutable;
import com.google.template.soy.exprtree.Operator;
import com.google.template.soy.jssrc.dsl.AutoValue_TaggedTemplateLiteral;
import com.google.template.soy.jssrc.dsl.Expression;
import com.google.template.soy.jssrc.dsl.FormattingContext;
import com.google.template.soy.jssrc.dsl.GoogRequire;
import com.google.template.soy.jssrc.dsl.OperandPosition;
import com.google.template.soy.jssrc.dsl.Operation;
import com.google.template.soy.jssrc.dsl.Statement;
import com.google.template.soy.jssrc.dsl.TemplateLiteral;
import java.util.function.Consumer;

@Immutable
@AutoValue
public abstract class TaggedTemplateLiteral
extends Operation {
    abstract Expression tag();

    abstract TemplateLiteral templateLiteral();

    public static TaggedTemplateLiteral create(Expression tag, TemplateLiteral templateLiteral) {
        ImmutableList initialStatements = ImmutableList.builder().addAll(tag.initialStatements()).addAll(templateLiteral.initialStatements()).build();
        return new AutoValue_TaggedTemplateLiteral((ImmutableList<Statement>)initialStatements, tag, templateLiteral);
    }

    @Override
    int precedence() {
        return Integer.MAX_VALUE;
    }

    @Override
    Operator.Associativity associativity() {
        return Operator.Associativity.LEFT;
    }

    @Override
    public void collectRequires(Consumer<GoogRequire> collector) {
        this.tag().collectRequires(collector);
        this.templateLiteral().collectRequires(collector);
    }

    @Override
    void doFormatOutputExpr(FormattingContext ctx) {
        this.formatOperand(this.tag(), OperandPosition.LEFT, ctx);
        this.templateLiteral().doFormatOutputExpr(ctx);
    }

    @Override
    void doFormatInitialStatements(FormattingContext ctx) {
        ctx.appendInitialStatements(this.tag());
        ctx.appendInitialStatements(this.templateLiteral());
    }

    @Override
    boolean initialExpressionIsObjectLiteral() {
        return this.tag().initialExpressionIsObjectLiteral();
    }
}

