/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jbcsrc.restricted;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.errorprone.annotations.ForOverride;
import com.google.errorprone.annotations.FormatMethod;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.jbcsrc.restricted.BytecodeProducer;
import com.google.template.soy.jbcsrc.restricted.BytecodeUtils;
import com.google.template.soy.jbcsrc.restricted.CodeBuilder;
import com.google.template.soy.jbcsrc.restricted.Flags;
import com.google.template.soy.jbcsrc.restricted.MethodRef;
import com.google.template.soy.jbcsrc.restricted.Statement;
import java.util.Collections;
import java.util.EnumSet;
import org.objectweb.asm.Label;
import org.objectweb.asm.Type;

public abstract class Expression
extends BytecodeProducer {
    private final Features features;
    private final Type resultType;

    public static boolean areAllCheap(Iterable<? extends Expression> args) {
        for (Expression expression : args) {
            if (expression.isCheap()) continue;
            return false;
        }
        return true;
    }

    public static boolean areAllCheap(Expression first, Expression ... rest) {
        return Expression.areAllCheap((Iterable<? extends Expression>)ImmutableList.builder().add((Object)first).add((Object[])rest).build());
    }

    static void checkTypes(ImmutableList<Type> types, Iterable<? extends Expression> exprs) {
        int size = Iterables.size(exprs);
        Preconditions.checkArgument((size == types.size() ? 1 : 0) != 0, (String)"Supplied the wrong number of parameters. Expected %s, got %s", types, exprs);
        if (Flags.DEBUG) {
            int i = 0;
            for (Expression expression : exprs) {
                expression.checkAssignableTo((Type)types.get(i), "Parameter %s", i);
                ++i;
            }
        }
    }

    protected Expression(Type resultType) {
        this(resultType, Features.of());
    }

    protected Expression(Type resultType, Feature first, Feature ... rest) {
        this(resultType, Features.of(first, rest));
    }

    protected Expression(Type resultType, Features features) {
        this(resultType, features, SourceLocation.UNKNOWN);
    }

    protected Expression(Type resultType, Features features, SourceLocation location) {
        super(location);
        this.resultType = (Type)Preconditions.checkNotNull((Object)resultType);
        this.features = Features.forType(resultType, features);
    }

    @Override
    protected abstract void doGen(CodeBuilder var1);

    public Expression withSourceLocation(SourceLocation location) {
        Preconditions.checkNotNull((Object)location);
        if (location.equals(this.location)) {
            return this;
        }
        return new Expression(this.resultType, this.features, location){

            @Override
            protected void doGen(CodeBuilder adapter) {
                Expression.this.gen(adapter);
            }
        };
    }

    public final Type resultType() {
        return this.resultType;
    }

    public boolean isCheap() {
        return this.features.has(Feature.CHEAP);
    }

    public boolean isNonNullable() {
        return this.features.has(Feature.NON_NULLABLE);
    }

    public Features features() {
        return this.features;
    }

    public final void checkAssignableTo(Type expected) {
        this.checkAssignableTo(expected, "", new Object[0]);
    }

    @FormatMethod
    public final void checkAssignableTo(Type expected, String fmt, Object ... args) {
        if (Flags.DEBUG && !BytecodeUtils.isPossiblyAssignableFrom(expected, this.resultType())) {
            String message = String.format("Type mismatch. %s not assignable to %s.", this.resultType().getClassName(), expected.getClassName());
            if (!fmt.isEmpty()) {
                message = String.format(fmt, args) + ". " + message;
            }
            throw new IllegalArgumentException(message);
        }
    }

    public Statement toStatement() {
        return new Statement(){

            @Override
            protected void doGen(CodeBuilder adapter) {
                Expression.this.gen(adapter);
                switch (Expression.this.resultType().getSize()) {
                    case 0: {
                        throw new AssertionError((Object)"void expressions are not allowed");
                    }
                    case 1: {
                        adapter.pop();
                        break;
                    }
                    case 2: {
                        adapter.pop2();
                        break;
                    }
                    default: {
                        throw new AssertionError();
                    }
                }
            }
        };
    }

    public Expression asCheap() {
        if (this.isCheap()) {
            return this;
        }
        return new Expression(this.resultType, this.features.plus(Feature.CHEAP)){

            @Override
            protected void doGen(CodeBuilder adapter) {
                Expression.this.gen(adapter);
            }
        };
    }

    public Expression asNonNullable() {
        if (this.isNonNullable()) {
            return this;
        }
        return new Expression(this.resultType, this.features.plus(Feature.NON_NULLABLE)){

            @Override
            protected void doGen(CodeBuilder adapter) {
                Expression.this.gen(adapter);
            }
        };
    }

    public Expression asNullable() {
        if (!this.isNonNullable()) {
            return this;
        }
        return new Expression(this.resultType, this.features.minus(Feature.NON_NULLABLE)){

            @Override
            protected void doGen(CodeBuilder adapter) {
                Expression.this.gen(adapter);
            }
        };
    }

    public Expression checkedCast(Type target) {
        Preconditions.checkArgument((target.getSort() == 10 ? 1 : 0) != 0, (String)"cast targets must be reference types. (%s)", (Object)target.getClassName());
        Preconditions.checkArgument((this.resultType().getSort() == 10 ? 1 : 0) != 0, (String)"you may only cast from reference types. (%s)", (Object)this.resultType().getClassName());
        if (BytecodeUtils.isDefinitelyAssignableFrom(target, this.resultType())) {
            return this;
        }
        return new Expression(target, this.features()){

            @Override
            protected void doGen(CodeBuilder adapter) {
                Expression.this.gen(adapter);
                adapter.checkCast(this.resultType());
            }
        };
    }

    public Expression checkedCast(Class<?> target) {
        return this.checkedCast(Type.getType(target));
    }

    public Expression invoke(MethodRef method, Expression ... args) {
        return method.invoke((Iterable<? extends Expression>)ImmutableList.builder().add((Object)this).add((Object[])args).build());
    }

    public Statement invokeVoid(MethodRef method, Expression ... args) {
        return method.invokeVoid((Iterable<? extends Expression>)ImmutableList.builder().add((Object)this).add((Object[])args).build());
    }

    public Expression labelStart(final Label label) {
        return new Expression(this.resultType(), this.features){

            @Override
            protected void doGen(CodeBuilder adapter) {
                adapter.mark(label);
                Expression.this.gen(adapter);
            }
        };
    }

    public Expression labelEnd(final Label label) {
        return new Expression(this.resultType(), this.features){

            @Override
            protected void doGen(CodeBuilder adapter) {
                Expression.this.gen(adapter);
                adapter.mark(label);
            }
        };
    }

    @ForOverride
    protected void extraToStringProperties(MoreObjects.ToStringHelper helper) {
    }

    public String toString() {
        String name = this.getClass().getSimpleName();
        if (name.isEmpty()) {
            name = "Expression";
        }
        MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)name).omitNullValues();
        helper.add("type", (Object)this.resultType());
        this.extraToStringProperties(helper);
        helper.add("cheap", (Object)(this.features.has(Feature.CHEAP) ? "true" : null));
        helper.add("non-null", this.features.has(Feature.NON_NULLABLE) && !BytecodeUtils.isPrimitive(this.resultType) ? "true" : null);
        return helper + ":\n" + this.trace();
    }

    public static final class Features {
        private static final Features EMPTY = new Features(EnumSet.noneOf(Feature.class));
        private final EnumSet<Feature> set;

        public static Features of() {
            return EMPTY;
        }

        public static Features of(Feature first, Feature ... rest) {
            EnumSet<Feature> set = EnumSet.of(first);
            Collections.addAll(set, rest);
            return new Features(set);
        }

        private static Features forType(Type expressionType, Features features) {
            switch (expressionType.getSort()) {
                case 9: 
                case 10: {
                    return features;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    return features.plus(Feature.NON_NULLABLE);
                }
                case 0: 
                case 11: {
                    throw new IllegalArgumentException("Invalid type: " + expressionType);
                }
            }
            throw new AssertionError((Object)("unexpected type " + expressionType));
        }

        private Features(EnumSet<Feature> set) {
            this.set = (EnumSet)Preconditions.checkNotNull(set);
        }

        public boolean has(Feature feature) {
            return this.set.contains((Object)feature);
        }

        public Features plus(Feature feature) {
            if (this.set.contains((Object)feature)) {
                return this;
            }
            EnumSet<Feature> newSet = this.copyFeatures();
            newSet.add(feature);
            return new Features(newSet);
        }

        public Features minus(Feature feature) {
            if (!this.set.contains((Object)feature)) {
                return this;
            }
            EnumSet<Feature> newSet = this.copyFeatures();
            newSet.remove((Object)feature);
            return new Features(newSet);
        }

        private EnumSet<Feature> copyFeatures() {
            EnumSet<Feature> newSet = EnumSet.noneOf(Feature.class);
            newSet.addAll(this.set);
            return newSet;
        }
    }

    public static enum Feature {
        NON_NULLABLE,
        CHEAP;

    }
}

