/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jbcsrc.restricted;

import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.html.types.SafeHtml;
import com.google.common.html.types.SafeHtmlProto;
import com.google.common.html.types.SafeUrl;
import com.google.common.html.types.SafeUrlProto;
import com.google.common.html.types.TrustedResourceUrl;
import com.google.common.html.types.TrustedResourceUrlProto;
import com.google.protobuf.Message;
import com.google.template.soy.base.internal.SanitizedContentKind;
import com.google.template.soy.data.Dir;
import com.google.template.soy.data.LoggingAdvisingAppendable;
import com.google.template.soy.data.SanitizedContent;
import com.google.template.soy.data.SoyLegacyObjectMap;
import com.google.template.soy.data.SoyList;
import com.google.template.soy.data.SoyMap;
import com.google.template.soy.data.SoyProtoValue;
import com.google.template.soy.data.SoyRecord;
import com.google.template.soy.data.SoyValue;
import com.google.template.soy.data.SoyValueProvider;
import com.google.template.soy.data.SoyVisualElement;
import com.google.template.soy.data.SoyVisualElementData;
import com.google.template.soy.data.internal.Converters;
import com.google.template.soy.data.restricted.BooleanData;
import com.google.template.soy.data.restricted.FloatData;
import com.google.template.soy.data.restricted.IntegerData;
import com.google.template.soy.data.restricted.NumberData;
import com.google.template.soy.data.restricted.StringData;
import com.google.template.soy.internal.proto.JavaQualifiedNames;
import com.google.template.soy.jbcsrc.api.RenderResult;
import com.google.template.soy.jbcsrc.restricted.CodeBuilder;
import com.google.template.soy.jbcsrc.restricted.ConstructorRef;
import com.google.template.soy.jbcsrc.restricted.Expression;
import com.google.template.soy.jbcsrc.restricted.FieldRef;
import com.google.template.soy.jbcsrc.restricted.LocalVariable;
import com.google.template.soy.jbcsrc.restricted.MethodRef;
import com.google.template.soy.jbcsrc.restricted.SoyExpression;
import com.google.template.soy.jbcsrc.restricted.SoyRuntimeType;
import com.google.template.soy.jbcsrc.restricted.TypeInfo;
import com.google.template.soy.jbcsrc.shared.CompiledTemplate;
import com.google.template.soy.jbcsrc.shared.LargeStringConstantFactory;
import com.google.template.soy.jbcsrc.shared.RenderContext;
import com.google.template.soy.jbcsrc.shared.StackFrame;
import com.google.template.soy.logging.LoggableElementMetadata;
import com.google.template.soy.types.SoyProtoEnumType;
import com.google.template.soy.types.SoyProtoType;
import com.google.template.soy.types.SoyType;
import java.io.Closeable;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Handle;
import org.objectweb.asm.Label;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.Method;
import org.objectweb.asm.util.Printer;

public final class BytecodeUtils {
    private static final int MAX_CONSTANT_STRING_LENGTH = 65535;
    public static final TypeInfo OBJECT = TypeInfo.create(Object.class);
    private static final Type OBJECT_ARRAY_TYPE = Type.getType(Object[].class);
    public static final Type LOGGING_ADVISING_APPENDABLE_TYPE = Type.getType(LoggingAdvisingAppendable.class);
    public static final Type LOGGING_ADVISING_BUILDER_TYPE = Type.getType(LoggingAdvisingAppendable.BufferingAppendable.class);
    public static final Type COMPILED_TEMPLATE_TYPE = Type.getType(CompiledTemplate.class);
    public static final Type COMPILED_TEMPLATE_TEMPLATE_VALUE_TYPE = Type.getType(CompiledTemplate.TemplateValue.class);
    public static final Type CONTENT_KIND_TYPE = Type.getType(SanitizedContent.ContentKind.class);
    public static final Type CLOSEABLE_TYPE = Type.getType(Closeable.class);
    public static final Type DIR_TYPE = Type.getType(Dir.class);
    public static final Type HASH_MAP_TYPE = Type.getType(HashMap.class);
    public static final Type NUMBER_DATA_TYPE = Type.getType(NumberData.class);
    public static final Type INTEGER_DATA_TYPE = Type.getType(IntegerData.class);
    public static final Type FLOAT_DATA_TYPE = Type.getType(FloatData.class);
    public static final Type BOOLEAN_DATA_TYPE = Type.getType(BooleanData.class);
    public static final Type STRING_DATA_TYPE = Type.getType(StringData.class);
    public static final Type LINKED_HASH_MAP_TYPE = Type.getType(LinkedHashMap.class);
    public static final Type LIST_TYPE = Type.getType(List.class);
    public static final Type IMMUTIBLE_LIST_TYPE = Type.getType(ImmutableList.class);
    public static final Type IMMUTIBLE_MAP_TYPE = Type.getType(ImmutableMap.class);
    public static final Type MAP_TYPE = Type.getType(Map.class);
    public static final Type MAP_ENTRY_TYPE = Type.getType(Map.Entry.class);
    public static final Type MESSAGE_TYPE = Type.getType(Message.class);
    public static final Type NULL_POINTER_EXCEPTION_TYPE = Type.getType(NullPointerException.class);
    public static final Type RENDER_CONTEXT_TYPE = Type.getType(RenderContext.class);
    public static final Type RENDER_RESULT_TYPE = Type.getType(RenderResult.class);
    public static final Type SANITIZED_CONTENT_TYPE = Type.getType(SanitizedContent.class);
    public static final Type SOY_LIST_TYPE = Type.getType(SoyList.class);
    public static final Type SOY_LEGACY_OBJECT_MAP_TYPE = Type.getType(SoyLegacyObjectMap.class);
    public static final Type SOY_MAP_TYPE = Type.getType(SoyMap.class);
    public static final Type SOY_PROTO_VALUE_TYPE = Type.getType(SoyProtoValue.class);
    public static final Type SOY_RECORD_TYPE = Type.getType(SoyRecord.class);
    public static final Type SOY_VALUE_TYPE = Type.getType(SoyValue.class);
    public static final Type SOY_VALUE_PROVIDER_TYPE = Type.getType(SoyValueProvider.class);
    public static final Type SOY_STRING_TYPE = Type.getType(StringData.class);
    public static final Type STRING_TYPE = Type.getType(String.class);
    public static final Type THROWABLE_TYPE = Type.getType(Throwable.class);
    public static final Type ILLEGAL_STATE_EXCEPTION_TYPE = Type.getType(IllegalStateException.class);
    public static final Type SOY_VISUAL_ELEMENT_TYPE = Type.getType(SoyVisualElement.class);
    public static final Type SOY_VISUAL_ELEMENT_DATA_TYPE = Type.getType(SoyVisualElementData.class);
    public static final Type CLASS_TYPE = Type.getType(Class.class);
    public static final Type INTEGER_TYPE = Type.getType(Integer.class);
    public static final Type BOXED_LONG_TYPE = Type.getType(Long.class);
    public static final Type BOXED_BOOLEAN_TYPE = Type.getType(Boolean.class);
    public static final Type BOXED_DOUBLE_TYPE = Type.getType(Double.class);
    public static final Type BOXED_FLOAT_TYPE = Type.getType(Float.class);
    public static final Type NUMBER_TYPE = Type.getType(Number.class);
    public static final Type LOGGABLE_ELEMENT_METADATA_TYPE = Type.getType(LoggableElementMetadata.class);
    public static final Type STACK_FRAME_TYPE = Type.getType(StackFrame.class);
    public static final Type SAFE_URL_TYPE = Type.getType(SafeUrl.class);
    public static final Type SAFE_URL_PROTO_TYPE = Type.getType(SafeUrlProto.class);
    public static final Type TRUSTED_RESOURCE_PROTO_TYPE = Type.getType(TrustedResourceUrlProto.class);
    public static final Type SAFE_HTML_PROTO_TYPE = Type.getType(SafeHtmlProto.class);
    public static final Type SAFE_HTML_TYPE = Type.getType(SafeHtml.class);
    public static final Type TRUSTED_RESOURCE_URL_TYPE = Type.getType(TrustedResourceUrl.class);
    public static final Method CLASS_INIT = Method.getMethod((String)"void <clinit>()");
    public static final Method NULLARY_INIT = Method.getMethod((String)"void <init>()");
    private static final LoadingCache<Type, Optional<Class<?>>> objectTypeToClassCache = CacheBuilder.newBuilder().build(new CacheLoader<Type, Optional<Class<?>>>(){

        public Optional<Class<?>> load(Type key) throws Exception {
            switch (key.getSort()) {
                case 9: {
                    Optional elementType = (Optional)objectTypeToClassCache.getUnchecked((Object)key.getElementType());
                    if (elementType.isPresent()) {
                        return Optional.of(Array.newInstance((Class)elementType.get(), 0).getClass());
                    }
                    return Optional.empty();
                }
                case 0: {
                    return Optional.of(Void.TYPE);
                }
                case 1: {
                    return Optional.of(Boolean.TYPE);
                }
                case 3: {
                    return Optional.of(Byte.TYPE);
                }
                case 2: {
                    return Optional.of(Character.TYPE);
                }
                case 8: {
                    return Optional.of(Double.TYPE);
                }
                case 5: {
                    return Optional.of(Integer.TYPE);
                }
                case 4: {
                    return Optional.of(Short.TYPE);
                }
                case 7: {
                    return Optional.of(Long.TYPE);
                }
                case 6: {
                    return Optional.of(Float.TYPE);
                }
                case 10: {
                    try {
                        String className = key.getClassName();
                        if (className.startsWith("com.google.template.soy.jbcsrc.gen.")) {
                            return Optional.empty();
                        }
                        return Optional.of(Class.forName(className, false, BytecodeUtils.class.getClassLoader()));
                    }
                    catch (ClassNotFoundException e) {
                        return Optional.empty();
                    }
                }
            }
            throw new IllegalArgumentException("unsupported type: " + key);
        }
    });
    private static final Expression FALSE = new Expression(Type.BOOLEAN_TYPE, Expression.Feature.CHEAP, new Expression.Feature[0]){

        @Override
        protected void doGen(CodeBuilder mv) {
            mv.pushBoolean(false);
        }
    };
    private static final Expression TRUE = new Expression(Type.BOOLEAN_TYPE, Expression.Feature.CHEAP, new Expression.Feature[0]){

        @Override
        protected void doGen(CodeBuilder mv) {
            mv.pushBoolean(true);
        }
    };
    private static final Handle LARGE_STRING_CONSTANT_HANDLE = MethodRef.create(LargeStringConstantFactory.class, "bootstrapLargeStringConstant", MethodHandles.Lookup.class, String.class, MethodType.class, String[].class).asHandle();

    private BytecodeUtils() {
    }

    public static boolean isPossiblyAssignableFrom(Type left, Type right) {
        return BytecodeUtils.doIsAssignableFrom(left, right, true);
    }

    public static boolean isDefinitelyAssignableFrom(Type left, Type right) {
        return BytecodeUtils.doIsAssignableFrom(left, right, false);
    }

    private static boolean doIsAssignableFrom(Type left, Type right, boolean failOpen) {
        if (left.equals((Object)right)) {
            return true;
        }
        if (left.getSort() != right.getSort()) {
            return false;
        }
        if (left.getSort() != 10) {
            return false;
        }
        Optional leftClass = (Optional)objectTypeToClassCache.getUnchecked((Object)left);
        Optional rightClass = (Optional)objectTypeToClassCache.getUnchecked((Object)right);
        if (!leftClass.isPresent() || !rightClass.isPresent()) {
            return failOpen;
        }
        return ((Class)leftClass.get()).isAssignableFrom((Class)rightClass.get());
    }

    public static Class<?> classFromAsmType(Type type) {
        Optional maybeClass = (Optional)objectTypeToClassCache.getUnchecked((Object)type);
        if (!maybeClass.isPresent()) {
            throw new IllegalArgumentException("Could not load: " + type);
        }
        return (Class)maybeClass.get();
    }

    public static Expression constant(boolean value) {
        return value ? TRUE : FALSE;
    }

    public static Expression constant(final int value) {
        return new Expression(Type.INT_TYPE, Expression.Feature.CHEAP, new Expression.Feature[0]){

            @Override
            protected void doGen(CodeBuilder mv) {
                mv.pushInt(value);
            }
        };
    }

    public static Expression constant(final char value) {
        return new Expression(Type.CHAR_TYPE, Expression.Feature.CHEAP, new Expression.Feature[0]){

            @Override
            protected void doGen(CodeBuilder mv) {
                mv.pushInt(value);
            }
        };
    }

    public static Expression constant(final long value) {
        return new Expression(Type.LONG_TYPE, Expression.Feature.CHEAP, new Expression.Feature[0]){

            @Override
            protected void doGen(CodeBuilder mv) {
                mv.pushLong(value);
            }
        };
    }

    public static Expression constant(final double value) {
        return new Expression(Type.DOUBLE_TYPE, Expression.Feature.CHEAP, new Expression.Feature[0]){

            @Override
            protected void doGen(CodeBuilder mv) {
                mv.pushDouble(value);
            }
        };
    }

    public static Expression constant(String value) {
        int previousStart = 0;
        final ArrayList<String> stringConstants = new ArrayList<String>();
        int byteCount = 0;
        for (int index = 0; index < value.length(); ++index) {
            char c = value.charAt(index);
            int charBytes = c >= '\u0001' && c <= '\u007f' ? 1 : (c > '\u07ff' ? 3 : 2);
            if (byteCount + charBytes > 65535) {
                stringConstants.add(value.substring(previousStart, index));
                byteCount = 0;
                previousStart = index;
            }
            byteCount += charBytes;
        }
        stringConstants.add(value.substring(previousStart));
        return new Expression(STRING_TYPE, Expression.Feature.CHEAP, new Expression.Feature[]{Expression.Feature.NON_NULLABLE}){

            @Override
            protected void doGen(CodeBuilder cb) {
                if (stringConstants.size() == 1) {
                    cb.pushString((String)stringConstants.get(0));
                } else {
                    cb.visitInvokeDynamicInsn("constantString", Type.getMethodDescriptor((Type)STRING_TYPE, (Type[])new Type[0]), LARGE_STRING_CONSTANT_HANDLE, stringConstants.toArray());
                }
            }
        };
    }

    public static Expression constant(@Nullable SanitizedContent.ContentKind kind) {
        return kind == null ? BytecodeUtils.constantNull(CONTENT_KIND_TYPE) : FieldRef.enumReference(kind).accessor();
    }

    public static Expression constant(@Nullable Dir dir) {
        return dir == null ? BytecodeUtils.constantNull(DIR_TYPE) : FieldRef.enumReference(dir).accessor();
    }

    public static Expression constant(final Type type) {
        return new Expression(CLASS_TYPE, Expression.Feature.CHEAP, new Expression.Feature[]{Expression.Feature.NON_NULLABLE}){

            @Override
            protected void doGen(CodeBuilder mv) {
                mv.pushType(type);
            }
        };
    }

    public static Expression constantSanitizedContentKindAsContentKind(SanitizedContentKind kind) {
        return FieldRef.enumReference(Converters.contentKindfromSanitizedContentKind(kind)).accessor();
    }

    public static Expression constantNull(Type type) {
        Preconditions.checkArgument((type.getSort() == 10 || type.getSort() == 9 ? 1 : 0) != 0, (String)"%s is not a reference type", (Object)type);
        return new Expression(type, Expression.Feature.CHEAP, new Expression.Feature[0]){

            @Override
            protected void doGen(CodeBuilder mv) {
                mv.visitInsn(1);
            }
        };
    }

    public static Expression numericConversion(final Expression expr, final Type to) {
        if (to.equals((Object)expr.resultType())) {
            return expr;
        }
        if (!BytecodeUtils.isNumericPrimitive(to) || !BytecodeUtils.isNumericPrimitive(expr.resultType())) {
            throw new IllegalArgumentException("Cannot convert from " + expr.resultType() + " to " + to);
        }
        return new Expression(to, expr.features()){

            @Override
            protected void doGen(CodeBuilder adapter) {
                expr.gen(adapter);
                adapter.cast(expr.resultType(), to);
            }
        };
    }

    private static boolean isNumericPrimitive(Type type) {
        int sort = type.getSort();
        switch (sort) {
            case 0: 
            case 1: 
            case 9: 
            case 10: 
            case 11: {
                return false;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return true;
            }
        }
        throw new AssertionError((Object)("unexpected type " + type));
    }

    public static boolean isPrimitive(Type type) {
        switch (type.getSort()) {
            case 9: 
            case 10: {
                return false;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return true;
            }
            case 0: 
            case 11: {
                throw new IllegalArgumentException("Invalid type: " + type);
            }
        }
        throw new AssertionError((Object)("unexpected type " + type));
    }

    public static void defineDefaultConstructor(ClassVisitor cv, TypeInfo ownerType) {
        CodeBuilder mg = new CodeBuilder(1, NULLARY_INIT, null, cv);
        mg.visitCode();
        Label start = mg.mark();
        Label end = mg.newLabel();
        LocalVariable thisVar = LocalVariable.createThisVar(ownerType, start, end);
        thisVar.gen(mg);
        mg.invokeConstructor(OBJECT.type(), NULLARY_INIT);
        mg.returnValue();
        mg.mark(end);
        thisVar.tableEntry(mg);
        mg.endMethod();
    }

    public static Expression compare(final int comparisonOpcode, final Expression left, final Expression right) {
        Preconditions.checkArgument((boolean)left.resultType().equals((Object)right.resultType()), (String)"left and right must have matching types, found %s and %s", (Object)left.resultType(), (Object)right.resultType());
        BytecodeUtils.checkIntComparisonOpcode(left.resultType(), comparisonOpcode);
        Expression.Features features = Expression.areAllCheap(left, right) ? Expression.Features.of(Expression.Feature.CHEAP, new Expression.Feature[0]) : Expression.Features.of();
        return new Expression(Type.BOOLEAN_TYPE, features){

            @Override
            protected void doGen(CodeBuilder mv) {
                left.gen(mv);
                right.gen(mv);
                Label ifTrue = mv.newLabel();
                Label end = mv.newLabel();
                mv.ifCmp(left.resultType(), comparisonOpcode, ifTrue);
                mv.pushBoolean(false);
                mv.goTo(end);
                mv.mark(ifTrue);
                mv.pushBoolean(true);
                mv.mark(end);
            }
        };
    }

    private static void checkIntComparisonOpcode(Type comparisonType, int opcode) {
        switch (opcode) {
            case 153: 
            case 154: {
                return;
            }
            case 155: 
            case 156: 
            case 157: 
            case 158: {
                if (comparisonType.getSort() == 9 || comparisonType.getSort() == 10) {
                    throw new IllegalArgumentException("Type: " + comparisonType + " cannot be compared via " + Printer.OPCODES[opcode]);
                }
                return;
            }
        }
        throw new IllegalArgumentException("Unsupported opcode for comparison operation: " + opcode);
    }

    public static Expression logicalNot(final Expression baseExpr) {
        baseExpr.checkAssignableTo(Type.BOOLEAN_TYPE);
        Preconditions.checkArgument((boolean)baseExpr.resultType().equals((Object)Type.BOOLEAN_TYPE), (Object)"not a boolean expression");
        return new Expression(Type.BOOLEAN_TYPE, baseExpr.features()){

            @Override
            protected void doGen(CodeBuilder mv) {
                baseExpr.gen(mv);
                Label ifTrue = mv.newLabel();
                Label end = mv.newLabel();
                mv.ifZCmp(154, ifTrue);
                mv.pushBoolean(true);
                mv.goTo(end);
                mv.mark(ifTrue);
                mv.pushBoolean(false);
                mv.mark(end);
            }
        };
    }

    public static Expression compareSoyEquals(SoyExpression left, SoyExpression right) {
        SoyRuntimeType leftRuntimeType = left.soyRuntimeType();
        SoyRuntimeType rightRuntimeType = right.soyRuntimeType();
        if (leftRuntimeType.isKnownString()) {
            return BytecodeUtils.doEqualsString(left.unboxAsString(), right);
        }
        if (rightRuntimeType.isKnownString()) {
            return BytecodeUtils.doEqualsString(right.unboxAsString(), left);
        }
        if (leftRuntimeType.isKnownInt() && rightRuntimeType.isKnownInt() && left.isNonNullable() && right.isNonNullable()) {
            return BytecodeUtils.compare(153, left.unboxAsLong(), right.unboxAsLong());
        }
        if (leftRuntimeType.isKnownNumber() && rightRuntimeType.isKnownNumber() && left.isNonNullable() && right.isNonNullable() && (leftRuntimeType.isKnownFloat() || rightRuntimeType.isKnownFloat())) {
            return BytecodeUtils.compare(153, left.coerceToDouble(), right.coerceToDouble());
        }
        return MethodRef.RUNTIME_EQUAL.invoke(left.box(), right.box());
    }

    private static Expression doEqualsString(SoyExpression stringExpr, SoyExpression other) {
        SoyRuntimeType otherRuntimeType = other.soyRuntimeType();
        if (otherRuntimeType.isKnownStringOrSanitizedContent()) {
            if (stringExpr.isNonNullable()) {
                return stringExpr.invoke(MethodRef.EQUALS, other.unboxAsString());
            }
            return MethodRef.OBJECTS_EQUALS.invoke(stringExpr, other.unboxAsString());
        }
        if (otherRuntimeType.isKnownNumber() && other.isNonNullable()) {
            return MethodRef.RUNTIME_STRING_EQUALS_AS_NUMBER.invoke(stringExpr, other.coerceToDouble());
        }
        return MethodRef.RUNTIME_COMPARE_NULLABLE_STRING.invoke(stringExpr, other.box());
    }

    public static Expression firstNonNull(final Expression left, final Expression right) {
        Preconditions.checkArgument((left.resultType().getSort() == 10 ? 1 : 0) != 0);
        Preconditions.checkArgument((right.resultType().getSort() == 10 ? 1 : 0) != 0);
        Expression.Features features = Expression.Features.of();
        if (Expression.areAllCheap(left, right)) {
            features = features.plus(Expression.Feature.CHEAP);
        }
        if (right.isNonNullable()) {
            features = features.plus(Expression.Feature.NON_NULLABLE);
        }
        return new Expression(left.resultType(), features){

            @Override
            protected void doGen(CodeBuilder cb) {
                Label leftIsNonNull = new Label();
                left.gen(cb);
                cb.dup();
                cb.ifNonNull(leftIsNonNull);
                cb.pop();
                right.gen(cb);
                cb.mark(leftIsNonNull);
            }
        };
    }

    public static Expression ternary(Expression condition, Expression trueBranch, Expression falseBranch) {
        Type ternaryType;
        Type falseType;
        Type trueType = trueBranch.resultType();
        if (BytecodeUtils.isDefinitelyAssignableFrom(trueType, falseType = falseBranch.resultType())) {
            ternaryType = trueType;
        } else if (BytecodeUtils.isDefinitelyAssignableFrom(falseType, trueType)) {
            ternaryType = falseType;
        } else {
            throw new IllegalArgumentException(String.format("true (%s) and false (%s) branches must be compatible", trueType, falseType));
        }
        return BytecodeUtils.ternary(condition, trueBranch, falseBranch, ternaryType);
    }

    public static Expression ternary(final Expression condition, final Expression trueBranch, final Expression falseBranch, Type resultType) {
        Preconditions.checkArgument((boolean)condition.resultType().equals((Object)Type.BOOLEAN_TYPE), (String)"The condition must be a boolean, got %s", (Object)condition.resultType());
        Preconditions.checkArgument((boolean)BytecodeUtils.isPossiblyAssignableFrom(resultType, trueBranch.resultType()), (String)"expected %s to be assignable to %s", (Object)trueBranch.resultType(), (Object)resultType);
        Preconditions.checkArgument((boolean)BytecodeUtils.isPossiblyAssignableFrom(resultType, falseBranch.resultType()), (String)"expected %s to be assignable to %s", (Object)falseBranch.resultType(), (Object)resultType);
        Expression.Features features = Expression.Features.of();
        if (Expression.areAllCheap(condition, trueBranch, falseBranch)) {
            features = features.plus(Expression.Feature.CHEAP);
        }
        if (trueBranch.isNonNullable() && falseBranch.isNonNullable()) {
            features = features.plus(Expression.Feature.NON_NULLABLE);
        }
        return new Expression(resultType, features){

            @Override
            protected void doGen(CodeBuilder mv) {
                condition.gen(mv);
                Label ifFalse = new Label();
                Label end = new Label();
                mv.visitJumpInsn(153, ifFalse);
                trueBranch.gen(mv);
                mv.visitJumpInsn(167, end);
                mv.visitLabel(ifFalse);
                falseBranch.gen(mv);
                mv.visitLabel(end);
            }
        };
    }

    public static Expression logicalOr(Expression ... expressions) {
        return BytecodeUtils.logicalOr((List<? extends Expression>)ImmutableList.copyOf((Object[])expressions));
    }

    public static Expression logicalOr(List<? extends Expression> expressions) {
        return BytecodeUtils.doShortCircuitingLogicalOperator((ImmutableList<? extends Expression>)ImmutableList.copyOf(expressions), true);
    }

    public static Expression logicalAnd(Expression ... expressions) {
        return BytecodeUtils.logicalAnd((List<? extends Expression>)ImmutableList.copyOf((Object[])expressions));
    }

    public static Expression logicalAnd(List<? extends Expression> expressions) {
        return BytecodeUtils.doShortCircuitingLogicalOperator((ImmutableList<? extends Expression>)ImmutableList.copyOf(expressions), false);
    }

    private static Expression doShortCircuitingLogicalOperator(final ImmutableList<? extends Expression> expressions, final boolean isOrOperator) {
        Preconditions.checkArgument((!expressions.isEmpty() ? 1 : 0) != 0);
        for (Expression expr : expressions) {
            expr.checkAssignableTo(Type.BOOLEAN_TYPE);
        }
        if (expressions.size() == 1) {
            return (Expression)expressions.get(0);
        }
        return new Expression(Type.BOOLEAN_TYPE, Expression.areAllCheap(expressions) ? Expression.Features.of(Expression.Feature.CHEAP, new Expression.Feature[0]) : Expression.Features.of()){

            @Override
            protected void doGen(CodeBuilder adapter) {
                Label end = new Label();
                Label shortCircuit = new Label();
                for (int i = 0; i < expressions.size(); ++i) {
                    Expression expr = (Expression)expressions.get(i);
                    expr.gen(adapter);
                    if (i == expressions.size() - 1) {
                        adapter.goTo(end);
                        continue;
                    }
                    adapter.ifZCmp(isOrOperator ? 154 : 153, shortCircuit);
                }
                adapter.mark(shortCircuit);
                adapter.pushBoolean(isOrOperator);
                adapter.mark(end);
            }
        };
    }

    public static Expression asImmutableList(Iterable<? extends Expression> items) {
        ImmutableList copy = ImmutableList.copyOf(items);
        if (copy.size() < MethodRef.IMMUTABLE_LIST_OF.size()) {
            return ((MethodRef)MethodRef.IMMUTABLE_LIST_OF.get(copy.size())).invoke((Iterable<? extends Expression>)copy);
        }
        ImmutableList explicit = copy.subList(0, MethodRef.IMMUTABLE_LIST_OF.size());
        Expression remainder = BytecodeUtils.asArray(OBJECT_ARRAY_TYPE, (ImmutableList<? extends Expression>)copy.subList(MethodRef.IMMUTABLE_LIST_OF.size(), copy.size()));
        return MethodRef.IMMUTABLE_LIST_OF_ARRAY.invoke(Iterables.concat((Iterable)explicit, (Iterable)ImmutableList.of((Object)remainder)));
    }

    private static Expression asArray(Type arrayType, final ImmutableList<? extends Expression> elements) {
        final Type elementType = arrayType.getElementType();
        return new Expression(arrayType, Expression.Feature.NON_NULLABLE, new Expression.Feature[0]){

            @Override
            protected void doGen(CodeBuilder adapter) {
                adapter.pushInt(elements.size());
                adapter.newArray(elementType);
                for (int i = 0; i < elements.size(); ++i) {
                    adapter.dup();
                    adapter.pushInt(i);
                    ((Expression)elements.get(i)).gen(adapter);
                    adapter.arrayStore(elementType);
                }
            }
        };
    }

    public static Expression asList(Iterable<? extends Expression> items) {
        final ImmutableList copy = ImmutableList.copyOf(items);
        if (copy.isEmpty()) {
            return ((MethodRef)MethodRef.IMMUTABLE_LIST_OF.get(0)).invoke(new Expression[0]);
        }
        final Expression construct = ConstructorRef.ARRAY_LIST_SIZE.construct(BytecodeUtils.constant(copy.size()));
        return new Expression(LIST_TYPE, Expression.Feature.NON_NULLABLE, new Expression.Feature[0]){

            @Override
            protected void doGen(CodeBuilder mv) {
                construct.gen(mv);
                for (Expression child : copy) {
                    mv.dup();
                    child.gen(mv);
                    MethodRef.ARRAY_LIST_ADD.invokeUnchecked(mv);
                    mv.pop();
                }
            }
        };
    }

    public static void nullCoalesce(CodeBuilder builder, Label nullExit) {
        builder.dup();
        Label nonNull = new Label();
        builder.ifNonNull(nonNull);
        builder.pop();
        builder.pushNull();
        builder.goTo(nullExit);
        builder.mark(nonNull);
    }

    public static Type unboxUnchecked(CodeBuilder cb, SoyRuntimeType soyType, Class<?> asType) {
        Preconditions.checkArgument((boolean)soyType.isBoxed(), (String)"Expected %s to be a boxed type", (Object)soyType);
        Type fromType = soyType.runtimeType();
        Preconditions.checkArgument((!SoyValue.class.isAssignableFrom(asType) ? 1 : 0) != 0, (String)"Can't use unboxUnchecked() to convert from %s to a SoyValue: %s.", (Object)fromType, asType);
        if (BytecodeUtils.isDefinitelyAssignableFrom(Type.getType(asType), fromType)) {
            return fromType;
        }
        if (asType.equals(Boolean.TYPE)) {
            MethodRef.SOY_VALUE_BOOLEAN_VALUE.invokeUnchecked(cb);
            return Type.BOOLEAN_TYPE;
        }
        if (asType.equals(Long.TYPE)) {
            MethodRef.SOY_VALUE_LONG_VALUE.invokeUnchecked(cb);
            return Type.LONG_TYPE;
        }
        if (asType.equals(Double.TYPE)) {
            MethodRef.SOY_VALUE_FLOAT_VALUE.invokeUnchecked(cb);
            return Type.DOUBLE_TYPE;
        }
        if (asType.equals(String.class)) {
            MethodRef.SOY_VALUE_STRING_VALUE.invokeUnchecked(cb);
            return STRING_TYPE;
        }
        if (asType.equals(List.class)) {
            cb.checkCast(SOY_LIST_TYPE);
            MethodRef.SOY_LIST_AS_JAVA_LIST.invokeUnchecked(cb);
            return LIST_TYPE;
        }
        if (asType.equals(Message.class)) {
            if (!BytecodeUtils.isDefinitelyAssignableFrom(SOY_PROTO_VALUE_TYPE, fromType)) {
                cb.checkCast(SOY_PROTO_VALUE_TYPE);
            }
            MethodRef.SOY_PROTO_VALUE_GET_PROTO.invokeUnchecked(cb);
            return MESSAGE_TYPE;
        }
        throw new UnsupportedOperationException("Can't unbox top of stack from " + fromType + " to " + asType);
    }

    public static Expression newHashMap(Iterable<? extends Expression> keys, Iterable<? extends Expression> values) {
        return BytecodeUtils.newMap(keys, values, ConstructorRef.HASH_MAP_CAPACITY, HASH_MAP_TYPE);
    }

    public static Expression newLinkedHashMap(Iterable<? extends Expression> keys, Iterable<? extends Expression> values) {
        return BytecodeUtils.newMap(keys, values, ConstructorRef.LINKED_HASH_MAP_CAPACITY, LINKED_HASH_MAP_TYPE);
    }

    private static Expression newMap(Iterable<? extends Expression> keys, Iterable<? extends Expression> values, ConstructorRef constructorRef, Type mapType) {
        final ImmutableList keysCopy = ImmutableList.copyOf(keys);
        final ImmutableList valuesCopy = ImmutableList.copyOf(values);
        Preconditions.checkArgument((keysCopy.size() == valuesCopy.size() ? 1 : 0) != 0);
        for (int i = 0; i < keysCopy.size(); ++i) {
            Preconditions.checkArgument((((Expression)keysCopy.get(i)).resultType().getSort() == 10 ? 1 : 0) != 0);
            Preconditions.checkArgument((((Expression)valuesCopy.get(i)).resultType().getSort() == 10 ? 1 : 0) != 0);
        }
        final Expression construct = constructorRef.construct(BytecodeUtils.constant(BytecodeUtils.hashMapCapacity(keysCopy.size())));
        return new Expression(mapType, Expression.Feature.NON_NULLABLE, new Expression.Feature[0]){

            @Override
            protected void doGen(CodeBuilder mv) {
                construct.gen(mv);
                for (int i = 0; i < keysCopy.size(); ++i) {
                    Expression key = (Expression)keysCopy.get(i);
                    Expression value = (Expression)valuesCopy.get(i);
                    mv.dup();
                    key.gen(mv);
                    value.gen(mv);
                    MethodRef.MAP_PUT.invokeUnchecked(mv);
                    mv.pop();
                }
            }
        };
    }

    private static int hashMapCapacity(int expectedSize) {
        if (expectedSize < 3) {
            return expectedSize + 1;
        }
        if (expectedSize < 0x40000000) {
            return (int)((float)expectedSize / 0.75f + 1.0f);
        }
        return Integer.MAX_VALUE;
    }

    public static SoyExpression isNonNull(final Expression expr) {
        if (BytecodeUtils.isPrimitive(expr.resultType())) {
            return SoyExpression.forBool(expr.toStatement().then(BytecodeUtils.constant(true)));
        }
        return SoyExpression.forBool(new Expression(Type.BOOLEAN_TYPE, expr.features()){

            @Override
            protected void doGen(CodeBuilder adapter) {
                expr.gen(adapter);
                Label isNull = new Label();
                adapter.ifNull(isNull);
                adapter.pushBoolean(true);
                Label end = new Label();
                adapter.goTo(end);
                adapter.mark(isNull);
                adapter.pushBoolean(false);
                adapter.mark(end);
            }
        });
    }

    public static SoyExpression isNull(final Expression expr) {
        if (BytecodeUtils.isPrimitive(expr.resultType())) {
            return SoyExpression.forBool(expr.toStatement().then(BytecodeUtils.constant(false)));
        }
        return SoyExpression.forBool(new Expression(Type.BOOLEAN_TYPE, expr.features()){

            @Override
            protected void doGen(CodeBuilder adapter) {
                expr.gen(adapter);
                Label isNull = new Label();
                adapter.ifNull(isNull);
                adapter.pushBoolean(false);
                Label end = new Label();
                adapter.goTo(end);
                adapter.mark(isNull);
                adapter.pushBoolean(true);
                adapter.mark(end);
            }
        });
    }

    public static Type getTypeForClassName(String name) {
        return Type.getType((String)('L' + name.replace('.', '/') + ';'));
    }

    public static Type getTypeForSoyType(SoyType type) {
        switch (type.getKind()) {
            case INT: {
                return BOXED_LONG_TYPE;
            }
            case FLOAT: {
                return BOXED_DOUBLE_TYPE;
            }
            case BOOL: {
                return BOXED_BOOLEAN_TYPE;
            }
            case STRING: {
                return STRING_TYPE;
            }
            case PROTO: {
                return BytecodeUtils.getTypeForClassName(JavaQualifiedNames.getClassName(((SoyProtoType)type).getDescriptor()));
            }
            case PROTO_ENUM: {
                return BytecodeUtils.getTypeForClassName(JavaQualifiedNames.getClassName(((SoyProtoEnumType)type).getDescriptor()));
            }
        }
        throw new IllegalArgumentException("unsupported type: " + type);
    }

    public static Expression boxJavaPrimitive(SoyExpression actualParam) {
        Type type = actualParam.soyRuntimeType().runtimeType();
        switch (type.getSort()) {
            case 5: {
                return MethodRef.BOX_INTEGER.invoke(actualParam);
            }
            case 7: {
                return MethodRef.BOX_LONG.invoke(actualParam);
            }
            case 1: {
                return MethodRef.BOX_BOOLEAN.invoke(actualParam);
            }
            case 6: {
                return MethodRef.BOX_FLOAT.invoke(actualParam);
            }
            case 8: {
                return MethodRef.BOX_DOUBLE.invoke(actualParam);
            }
        }
        throw new IllegalArgumentException(type.getClassName());
    }
}

