/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jbcsrc.restricted;

import com.google.common.base.Preconditions;
import com.google.errorprone.annotations.ForOverride;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.jbcsrc.restricted.CodeBuilder;
import com.google.template.soy.jbcsrc.restricted.Flags;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.util.Printer;
import org.objectweb.asm.util.Textifier;
import org.objectweb.asm.util.TraceMethodVisitor;

public abstract class BytecodeProducer {
    private static final ThreadLocal<Boolean> isGenerating = Flags.DEBUG ? new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return false;
        }
    } : null;
    protected final SourceLocation location;

    protected BytecodeProducer() {
        this(SourceLocation.UNKNOWN);
    }

    protected BytecodeProducer(SourceLocation location) {
        if (Flags.DEBUG && isGenerating.get().booleanValue()) {
            throw new IllegalStateException("All bytecode producers should be constructed prior to code generation (.gen()) being called.\nThis helps to ensure that code generation is idempotent since many Statement/Expression construction routines interact with mutable compiler data structures");
        }
        this.location = (SourceLocation)Preconditions.checkNotNull((Object)location);
    }

    public final SourceLocation location() {
        return this.location;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void gen(CodeBuilder adapter) {
        boolean shouldClearIsGeneratingBit = false;
        if (Flags.DEBUG && !isGenerating.get().booleanValue()) {
            isGenerating.set(true);
            shouldClearIsGeneratingBit = true;
        }
        try {
            if (this.location.isKnown()) {
                Label start = new Label();
                adapter.mark(start);
                adapter.visitLineNumber(this.location.getBeginLine(), start);
            }
            this.doGen(adapter);
            if (this.location.isKnown()) {
                Label end = new Label();
                adapter.mark(end);
                adapter.visitLineNumber(this.location.getEndLine(), end);
            }
        }
        finally {
            if (shouldClearIsGeneratingBit) {
                isGenerating.set(false);
            }
        }
    }

    @ForOverride
    protected abstract void doGen(CodeBuilder var1);

    public final String trace() {
        Textifier textifier = new Textifier(458752){
            {
                this.tab = null;
                this.tab2 = "  ";
                this.tab3 = "";
                this.ltab = "";
            }
        };
        this.gen(new CodeBuilder((MethodVisitor)new TraceMethodVisitor((Printer)textifier), 0, "trace", "()V"));
        StringWriter writer = new StringWriter();
        textifier.print(new PrintWriter(writer));
        return writer.toString();
    }
}

