/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jbcsrc.api;

import com.google.common.base.Ascii;
import com.google.common.base.Preconditions;
import com.google.common.base.Suppliers;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSortedSet;
import com.google.errorprone.annotations.concurrent.GuardedBy;
import com.google.template.soy.data.SanitizedContent;
import com.google.template.soy.data.SoyRecord;
import com.google.template.soy.data.SoyTemplate;
import com.google.template.soy.data.SoyTemplateData;
import com.google.template.soy.data.SoyValueConverter;
import com.google.template.soy.data.SoyValueProvider;
import com.google.template.soy.data.UnsafeSanitizedContentOrdainer;
import com.google.template.soy.data.internal.ParamStore;
import com.google.template.soy.internal.i18n.BidiGlobalDir;
import com.google.template.soy.jbcsrc.api.AdvisingAppendable;
import com.google.template.soy.jbcsrc.api.AppendableAsAdvisingAppendable;
import com.google.template.soy.jbcsrc.api.Continuations;
import com.google.template.soy.jbcsrc.api.OutputAppendable;
import com.google.template.soy.jbcsrc.api.RenderResult;
import com.google.template.soy.jbcsrc.api.SoySauce;
import com.google.template.soy.jbcsrc.shared.CompiledTemplate;
import com.google.template.soy.jbcsrc.shared.CompiledTemplates;
import com.google.template.soy.jbcsrc.shared.LegacyFunctionAdapter;
import com.google.template.soy.jbcsrc.shared.Names;
import com.google.template.soy.jbcsrc.shared.RenderContext;
import com.google.template.soy.logging.SoyLogger;
import com.google.template.soy.msgs.SoyMsgBundle;
import com.google.template.soy.plugin.java.PluginInstances;
import com.google.template.soy.shared.SoyCssRenamingMap;
import com.google.template.soy.shared.SoyIdRenamingMap;
import com.google.template.soy.shared.internal.SoyScopedData;
import com.google.template.soy.shared.restricted.SoyFunction;
import com.google.template.soy.shared.restricted.SoyJavaFunction;
import com.google.template.soy.shared.restricted.SoyJavaPrintDirective;
import com.google.template.soy.shared.restricted.SoyPrintDirective;
import java.io.IOException;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nullable;

public final class SoySauceImpl
implements SoySauce {
    private final CompiledTemplates templates;
    private final SoyScopedData.Enterable apiCallScope;
    private final PluginInstances pluginInstances;
    private final ImmutableMap<String, SoyJavaPrintDirective> printDirectives;

    public SoySauceImpl(CompiledTemplates templates, SoyScopedData.Enterable apiCallScope, ImmutableList<? extends SoyFunction> functions, ImmutableList<? extends SoyPrintDirective> printDirectives, PluginInstances pluginInstances) {
        this.templates = (CompiledTemplates)Preconditions.checkNotNull((Object)templates);
        this.apiCallScope = (SoyScopedData.Enterable)Preconditions.checkNotNull((Object)apiCallScope);
        ImmutableMap.Builder pluginInstanceBuilder = ImmutableMap.builder();
        for (SoyFunction fn : functions) {
            if (!(fn instanceof SoyJavaFunction)) continue;
            pluginInstanceBuilder.put((Object)fn.getName(), (Object)Suppliers.ofInstance((Object)new LegacyFunctionAdapter((SoyJavaFunction)fn)));
        }
        ImmutableMap.Builder soyJavaPrintDirectives = ImmutableMap.builder();
        for (SoyPrintDirective printDirective : printDirectives) {
            if (!(printDirective instanceof SoyJavaPrintDirective)) continue;
            soyJavaPrintDirectives.put((Object)printDirective.getName(), (Object)((SoyJavaPrintDirective)printDirective));
        }
        this.printDirectives = soyJavaPrintDirectives.build();
        this.pluginInstances = pluginInstances.combine((Map<String, ? extends Supplier<Object>>)pluginInstanceBuilder.build());
    }

    public ImmutableSortedSet<String> getTransitiveIjParamsForTemplate(String templateName) {
        return this.templates.getTransitiveIjParamsForTemplate(templateName);
    }

    @Override
    public ImmutableList<String> getAllRequiredCssNamespaces(String templateName, Predicate<String> enabledDelpackages, boolean collectCssFromDelvariants) {
        return this.templates.getAllRequiredCssNamespaces(templateName, enabledDelpackages, collectCssFromDelvariants);
    }

    @Override
    public ImmutableList<String> getAllRequiredCssPaths(String templateName, Predicate<String> enabledDelpackages, boolean collectCssFromDelvariants) {
        return this.templates.getAllRequiredCssPaths(templateName, enabledDelpackages, collectCssFromDelvariants);
    }

    @Override
    public boolean hasTemplate(String template) {
        try {
            this.templates.getTemplate(template);
            return true;
        }
        catch (IllegalArgumentException iae) {
            return false;
        }
    }

    @Override
    public RendererImpl renderTemplate(String template) {
        CompiledTemplates.TemplateData data = this.templates.getTemplateData(template);
        return new RendererImpl(template, data.template(), data.kind(), null);
    }

    @Override
    public RendererImpl newRenderer(SoyTemplate params) {
        String template = params.getTemplateName();
        CompiledTemplates.TemplateData data = this.templates.getTemplateData(template);
        return new RendererImpl(template, data.template(), data.kind(), params.getParamsAsMap());
    }

    private static SoySauce.WriteContinuation doRender(RendererClosure renderer, Scoper scoper) throws IOException {
        RenderResult result;
        try (SoyScopedData.InScope scope = scoper.enter();){
            result = renderer.render();
        }
        catch (Throwable t) {
            Names.rewriteStackTrace(t);
            Throwables.throwIfInstanceOf((Throwable)t, IOException.class);
            throw t;
        }
        if (result.isDone()) {
            return Continuations.done();
        }
        return new WriteContinuationImpl(result, renderer, scoper);
    }

    private static final class Scoper {
        final SoyScopedData.Enterable scope;
        final BidiGlobalDir dir;

        Scoper(SoyScopedData.Enterable scope, BidiGlobalDir dir) {
            this.scope = scope;
            this.dir = dir;
        }

        SoyScopedData.InScope enter() {
            return this.scope.enter(this.dir);
        }
    }

    private static final class WriteContinuationImpl
    implements SoySauce.WriteContinuation {
        final RenderResult result;
        final Object lock = new Object();
        @GuardedBy(value="lock")
        final Scoper scoper;
        @GuardedBy(value="lock")
        final RendererClosure renderer;
        @GuardedBy(value="lock")
        boolean hasContinueBeenCalled;

        WriteContinuationImpl(RenderResult result, RendererClosure renderer, Scoper scoper) {
            Preconditions.checkArgument((!result.isDone() ? 1 : 0) != 0);
            this.result = (RenderResult)Preconditions.checkNotNull((Object)result);
            this.renderer = (RendererClosure)Preconditions.checkNotNull((Object)renderer);
            this.scoper = (Scoper)Preconditions.checkNotNull((Object)scoper);
        }

        @Override
        public RenderResult result() {
            return this.result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public SoySauce.WriteContinuation continueRender() throws IOException {
            Object object = this.lock;
            synchronized (object) {
                if (this.hasContinueBeenCalled) {
                    throw new IllegalStateException("continueRender() has already been called.");
                }
                this.hasContinueBeenCalled = true;
                return SoySauceImpl.doRender(this.renderer, this.scoper);
            }
        }
    }

    @FunctionalInterface
    private static interface RendererClosure {
        public RenderResult render() throws IOException;
    }

    final class RendererImpl
    implements SoySauce.Renderer {
        private final String templateName;
        private final CompiledTemplate template;
        private final SanitizedContent.ContentKind contentKind;
        private final RenderContext.Builder contextBuilder;
        private SoyRecord data;
        private SoyRecord ij;
        private boolean dataSetInConstructor;

        RendererImpl(String templateName, CompiledTemplate template, @Nullable SanitizedContent.ContentKind contentKind, Map<String, ?> data) {
            this.contextBuilder = new RenderContext.Builder(SoySauceImpl.this.templates, (ImmutableMap<String, SoyJavaPrintDirective>)SoySauceImpl.this.printDirectives, SoySauceImpl.this.pluginInstances);
            this.templateName = templateName;
            this.template = (CompiledTemplate)Preconditions.checkNotNull((Object)template);
            this.contentKind = contentKind;
            if (data != null) {
                this.data = this.soyValueProviderMapAsParamStore(data);
                this.dataSetInConstructor = true;
            }
        }

        private ParamStore soyValueProviderMapAsParamStore(Map<String, ?> source) {
            ParamStore dest = new ParamStore(source.size());
            for (Map.Entry<String, ?> entry : source.entrySet()) {
                dest.setField(entry.getKey(), (SoyValueProvider)entry.getValue());
            }
            return dest;
        }

        private ParamStore mapAsParamStore(Map<String, ?> source) {
            ParamStore dest = new ParamStore(source.size());
            for (Map.Entry<String, ?> entry : source.entrySet()) {
                SoyValueProvider value;
                String key = entry.getKey();
                try {
                    value = SoyValueConverter.INSTANCE.convert(entry.getValue());
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Unable to convert param " + key + " to a SoyValue", e);
                }
                dest.setField(key, value);
            }
            return dest;
        }

        @Override
        public RendererImpl setIj(Map<String, ?> record) {
            this.ij = this.mapAsParamStore(record);
            return this;
        }

        @Override
        public RendererImpl setIj(SoyTemplateData templateData) {
            this.ij = this.soyValueProviderMapAsParamStore(templateData.getParamsAsMap());
            return this;
        }

        @Override
        public RendererImpl setPluginInstances(Map<String, com.google.common.base.Supplier<Object>> pluginInstances) {
            this.contextBuilder.withPluginInstances(SoySauceImpl.this.pluginInstances.combine(pluginInstances));
            return this;
        }

        @Override
        public RendererImpl setData(Map<String, ?> record) {
            Preconditions.checkState((!this.dataSetInConstructor ? 1 : 0) != 0, (Object)"May not call setData on a Renderer created from a TemplateParams");
            this.data = this.mapAsParamStore(record);
            return this;
        }

        @Override
        public RendererImpl setActiveDelegatePackageSelector(Predicate<String> active) {
            this.contextBuilder.withActiveDelPackageSelector((Predicate)Preconditions.checkNotNull(active));
            return this;
        }

        @Override
        public RendererImpl setCssRenamingMap(SoyCssRenamingMap cssRenamingMap) {
            this.contextBuilder.withCssRenamingMap(cssRenamingMap);
            return this;
        }

        @Override
        public RendererImpl setXidRenamingMap(SoyIdRenamingMap xidRenamingMap) {
            this.contextBuilder.withXidRenamingMap(xidRenamingMap);
            return this;
        }

        @Override
        public RendererImpl setMsgBundle(SoyMsgBundle msgs) {
            this.contextBuilder.withMessageBundle(msgs);
            return this;
        }

        @Override
        public RendererImpl setDebugSoyTemplateInfo(boolean debugSoyTemplateInfo) {
            this.contextBuilder.withDebugSoyTemplateInfo(debugSoyTemplateInfo);
            return this;
        }

        @Override
        public RendererImpl setSoyLogger(SoyLogger logger) {
            this.contextBuilder.withLogger(logger);
            return this;
        }

        @Override
        public SoySauce.WriteContinuation renderHtml(AdvisingAppendable out) throws IOException {
            return this.startRender(out, SanitizedContent.ContentKind.HTML);
        }

        @Override
        public SoySauce.Continuation<SanitizedContent> renderHtml() {
            return this.renderToSanitizedContent(SanitizedContent.ContentKind.HTML);
        }

        @Override
        public SoySauce.WriteContinuation renderJs(AdvisingAppendable out) throws IOException {
            return this.startRender(out, SanitizedContent.ContentKind.JS);
        }

        @Override
        public SoySauce.Continuation<SanitizedContent> renderJs() {
            return this.renderToSanitizedContent(SanitizedContent.ContentKind.JS);
        }

        @Override
        public SoySauce.WriteContinuation renderUri(AdvisingAppendable out) throws IOException {
            return this.startRender(out, SanitizedContent.ContentKind.URI);
        }

        @Override
        public SoySauce.Continuation<SanitizedContent> renderUri() {
            return this.renderToSanitizedContent(SanitizedContent.ContentKind.URI);
        }

        @Override
        public SoySauce.WriteContinuation renderTrustedResourceUri(AdvisingAppendable out) throws IOException {
            return this.startRender(out, SanitizedContent.ContentKind.TRUSTED_RESOURCE_URI);
        }

        @Override
        public SoySauce.Continuation<SanitizedContent> renderTrustedResourceUri() {
            return this.renderToSanitizedContent(SanitizedContent.ContentKind.TRUSTED_RESOURCE_URI);
        }

        @Override
        public SoySauce.WriteContinuation renderAttributes(AdvisingAppendable out) throws IOException {
            return this.startRender(out, SanitizedContent.ContentKind.ATTRIBUTES);
        }

        @Override
        public SoySauce.Continuation<SanitizedContent> renderAttributes() {
            return this.renderToSanitizedContent(SanitizedContent.ContentKind.ATTRIBUTES);
        }

        @Override
        public SoySauce.WriteContinuation renderCss(AdvisingAppendable out) throws IOException {
            return this.startRender(out, SanitizedContent.ContentKind.CSS);
        }

        @Override
        public SoySauce.Continuation<SanitizedContent> renderCss() {
            return this.renderToSanitizedContent(SanitizedContent.ContentKind.CSS);
        }

        @Override
        public SoySauce.WriteContinuation renderText(AdvisingAppendable out) throws IOException {
            return this.startRender(out, SanitizedContent.ContentKind.TEXT);
        }

        @Override
        public SoySauce.Continuation<String> renderText() {
            return this.renderToValue(Function.identity());
        }

        private SoySauce.Continuation<SanitizedContent> renderToSanitizedContent(SanitizedContent.ContentKind kind) {
            this.enforceContentKind(kind);
            return this.renderToValue(s -> UnsafeSanitizedContentOrdainer.ordainAsSafe(s, kind));
        }

        private <T> SoySauce.Continuation<T> renderToValue(Function<String, T> factory) {
            StringBuilder sb = new StringBuilder();
            try {
                return Continuations.valueContinuation(this.startRender(AppendableAsAdvisingAppendable.asAdvisingAppendable(sb), this.contentKind), () -> factory.apply(sb.toString()));
            }
            catch (IOException e) {
                throw new AssertionError("impossible", e);
            }
        }

        private <T> SoySauce.WriteContinuation startRender(AdvisingAppendable out, SanitizedContent.ContentKind contentKind) throws IOException {
            this.enforceContentKind(contentKind);
            SoyRecord params = this.data == null ? ParamStore.EMPTY_INSTANCE : this.data;
            SoyRecord injectedParams = this.ij == null ? ParamStore.EMPTY_INSTANCE : this.ij;
            RenderContext context = this.contextBuilder.build();
            OutputAppendable output = OutputAppendable.create(out, context.getLogger());
            RendererClosure renderer = () -> this.template.render(params, injectedParams, output, context);
            return SoySauceImpl.doRender(renderer, new Scoper(SoySauceImpl.this.apiCallScope, context.getBidiGlobalDir()));
        }

        private void enforceContentKind(SanitizedContent.ContentKind expectedContentKind) {
            if (expectedContentKind == SanitizedContent.ContentKind.TEXT) {
                return;
            }
            if (expectedContentKind != this.contentKind) {
                throw new IllegalStateException("Expected template '" + this.templateName + "' to be kind=\"" + Ascii.toLowerCase((String)expectedContentKind.name()) + "\" but was kind=\"" + Ascii.toLowerCase((String)this.contentKind.name()) + "\"");
            }
        }
    }
}

