/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jbcsrc.api;

import com.google.common.base.Preconditions;
import com.google.template.soy.data.SanitizedContent;
import com.google.template.soy.jbcsrc.api.RenderResult;
import com.google.template.soy.jbcsrc.api.SoySauce;
import java.io.IOException;

public final class Continuations {
    private Continuations() {
    }

    public static SoySauce.WriteContinuation done() {
        return FinalContinuation.INSTANCE;
    }

    public static SoySauce.Continuation<String> done(String value) {
        return new ResultContinuation<String>(value);
    }

    public static SoySauce.Continuation<SanitizedContent> done(SanitizedContent value) {
        return new ResultContinuation<SanitizedContent>(value);
    }

    static <T> SoySauce.Continuation<T> valueContinuation(SoySauce.WriteContinuation delegate, ValueSupplier<T> suppler) {
        if (delegate.result().isDone()) {
            return new ResultContinuation<T>(suppler.get());
        }
        return new PendingValueContinuation<T>(delegate, suppler);
    }

    private static final class ResultContinuation<T>
    implements SoySauce.Continuation<T> {
        final T value;

        ResultContinuation(T value) {
            this.value = Preconditions.checkNotNull(value);
        }

        @Override
        public RenderResult result() {
            return RenderResult.done();
        }

        @Override
        public T get() {
            return this.value;
        }

        @Override
        public SoySauce.Continuation<T> continueRender() {
            throw new IllegalStateException("Rendering is already complete and cannot be continued");
        }
    }

    private static enum FinalContinuation implements SoySauce.WriteContinuation
    {
        INSTANCE;


        @Override
        public RenderResult result() {
            return RenderResult.done();
        }

        @Override
        public SoySauce.WriteContinuation continueRender() {
            throw new IllegalStateException("Rendering is already complete and cannot be continued");
        }
    }

    private static final class PendingValueContinuation<T>
    implements SoySauce.Continuation<T> {
        final SoySauce.WriteContinuation delegate;
        final ValueSupplier<T> supplier;

        PendingValueContinuation(SoySauce.WriteContinuation delegate, ValueSupplier<T> supplier) {
            this.delegate = delegate;
            this.supplier = supplier;
        }

        @Override
        public final RenderResult result() {
            return this.delegate.result();
        }

        @Override
        public final T get() {
            throw new IllegalStateException("Rendering is not complete: " + this.delegate.result());
        }

        @Override
        public final SoySauce.Continuation<T> continueRender() {
            try {
                return Continuations.valueContinuation(this.delegate.continueRender(), this.supplier);
            }
            catch (IOException e) {
                throw new AssertionError("impossible", e);
            }
        }
    }

    @FunctionalInterface
    static interface ValueSupplier<T> {
        public T get();
    }
}

