/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jbcsrc;

import com.google.common.base.Suppliers;
import com.google.template.soy.jbcsrc.restricted.BytecodeUtils;
import com.google.template.soy.jbcsrc.restricted.CodeBuilder;
import com.google.template.soy.jbcsrc.restricted.Expression;
import com.google.template.soy.jbcsrc.restricted.MethodRef;
import com.google.template.soy.jbcsrc.restricted.Statement;
import java.util.function.Supplier;
import org.objectweb.asm.Label;

interface ExpressionDetacher {
    public Expression resolveSoyValueProvider(Expression var1);

    public Expression waitForSoyValueProvider(Expression var1);

    public Expression resolveSoyValueProviderList(Expression var1);

    public Expression resolveSoyValueProviderMap(Expression var1);

    public static final class BasicDetacher
    implements ExpressionDetacher {
        static final BasicDetacher INSTANCE = new BasicDetacher(() -> Statement.NULL_STATEMENT);
        private final Supplier<Statement> saveOperationSupplier = Suppliers.memoize(saveOperationSupplier::get);

        BasicDetacher(Supplier<Statement> saveOperationSupplier) {
        }

        @Override
        public Expression waitForSoyValueProvider(final Expression soyValueProvider) {
            soyValueProvider.checkAssignableTo(BytecodeUtils.SOY_VALUE_PROVIDER_TYPE);
            final Statement saveOperation = this.saveOperationSupplier.get();
            return new Expression(soyValueProvider.resultType()){

                @Override
                protected void doGen(CodeBuilder adapter) {
                    soyValueProvider.gen(adapter);
                    adapter.dup();
                    MethodRef.SOY_VALUE_PROVIDER_STATUS.invokeUnchecked(adapter);
                    adapter.dup();
                    MethodRef.RENDER_RESULT_IS_DONE.invokeUnchecked(adapter);
                    Label end = new Label();
                    adapter.ifZCmp(154, end);
                    saveOperation.gen(adapter);
                    adapter.returnValue();
                    adapter.mark(end);
                    adapter.pop();
                }
            };
        }

        @Override
        public Expression resolveSoyValueProvider(Expression soyValueProvider) {
            soyValueProvider.checkAssignableTo(BytecodeUtils.SOY_VALUE_PROVIDER_TYPE);
            if (BytecodeUtils.isDefinitelyAssignableFrom(BytecodeUtils.SOY_VALUE_TYPE, soyValueProvider.resultType())) {
                return soyValueProvider;
            }
            return this.waitForSoyValueProvider(soyValueProvider).invoke(MethodRef.SOY_VALUE_PROVIDER_RESOLVE, new Expression[0]);
        }

        @Override
        public Expression resolveSoyValueProviderList(final Expression soyValueProviderList) {
            soyValueProviderList.checkAssignableTo(BytecodeUtils.LIST_TYPE);
            final Statement saveOperation = this.saveOperationSupplier.get();
            return new Expression(soyValueProviderList.resultType()){

                @Override
                protected void doGen(CodeBuilder cb) {
                    soyValueProviderList.gen(cb);
                    cb.dup();
                    MethodRef.RUNTIME_GET_LIST_STATUS.invokeUnchecked(cb);
                    cb.dup();
                    MethodRef.RENDER_RESULT_IS_DONE.invokeUnchecked(cb);
                    Label end = new Label();
                    cb.ifZCmp(154, end);
                    saveOperation.gen(cb);
                    cb.returnValue();
                    cb.mark(end);
                    cb.pop();
                }
            };
        }

        @Override
        public Expression resolveSoyValueProviderMap(final Expression soyValueProviderMap) {
            soyValueProviderMap.checkAssignableTo(BytecodeUtils.MAP_TYPE);
            final Statement saveOperation = this.saveOperationSupplier.get();
            return new Expression(soyValueProviderMap.resultType()){

                @Override
                protected void doGen(CodeBuilder cb) {
                    soyValueProviderMap.gen(cb);
                    cb.dup();
                    MethodRef.RUNTIME_GET_MAP_STATUS.invokeUnchecked(cb);
                    cb.dup();
                    MethodRef.RENDER_RESULT_IS_DONE.invokeUnchecked(cb);
                    Label end = new Label();
                    cb.ifZCmp(154, end);
                    saveOperation.gen(cb);
                    cb.returnValue();
                    cb.mark(end);
                    cb.pop();
                }
            };
        }
    }

    public static final class NullDetatcher
    implements ExpressionDetacher,
    Factory {
        static final NullDetatcher INSTANCE = new NullDetatcher();

        @Override
        public NullDetatcher createExpressionDetacher(Label reattachPoint) {
            return this;
        }

        @Override
        public Expression waitForSoyValueProvider(Expression soyValueProvider) {
            soyValueProvider.checkAssignableTo(BytecodeUtils.SOY_VALUE_PROVIDER_TYPE);
            return soyValueProvider;
        }

        @Override
        public Expression resolveSoyValueProvider(Expression soyValueProvider) {
            soyValueProvider.checkAssignableTo(BytecodeUtils.SOY_VALUE_PROVIDER_TYPE);
            return soyValueProvider.checkedCast(BytecodeUtils.SOY_VALUE_PROVIDER_TYPE).invoke(MethodRef.SOY_VALUE_PROVIDER_RESOLVE, new Expression[0]);
        }

        @Override
        public Expression resolveSoyValueProviderList(Expression soyValueProviderList) {
            soyValueProviderList.checkAssignableTo(BytecodeUtils.LIST_TYPE);
            return MethodRef.RUNTIME_CHECK_RESOLVED_LIST.invoke(soyValueProviderList);
        }

        @Override
        public Expression resolveSoyValueProviderMap(Expression soyValueProviderMap) {
            soyValueProviderMap.checkAssignableTo(BytecodeUtils.MAP_TYPE);
            return MethodRef.RUNTIME_CHECK_RESOLVED_MAP.invoke(soyValueProviderMap);
        }
    }

    public static interface Factory {
        public ExpressionDetacher createExpressionDetacher(Label var1);
    }
}

