/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jbcsrc;

import com.google.template.soy.exprtree.AbstractReturningExprNodeVisitor;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.FunctionNode;
import com.google.template.soy.exprtree.ListComprehensionNode;
import com.google.template.soy.exprtree.VarDefn;
import com.google.template.soy.exprtree.VarRefNode;
import com.google.template.soy.jbcsrc.UnexpectedCompilerFailureException;
import com.google.template.soy.shared.internal.BuiltinFunction;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.defn.ConstVar;
import com.google.template.soy.soytree.defn.ImportedVar;
import com.google.template.soy.soytree.defn.LocalVar;
import com.google.template.soy.soytree.defn.TemplateParam;

abstract class EnhancedAbstractExprNodeVisitor<T>
extends AbstractReturningExprNodeVisitor<T> {
    EnhancedAbstractExprNodeVisitor() {
    }

    @Override
    protected T visit(ExprNode node) {
        try {
            return (T)super.visit(node);
        }
        catch (UnexpectedCompilerFailureException e) {
            e.addLocation(node);
            throw e;
        }
        catch (Throwable t) {
            throw new UnexpectedCompilerFailureException(node, t);
        }
    }

    @Override
    protected final T visitVarRefNode(VarRefNode node) {
        VarDefn defn = node.getDefnDecl();
        switch (defn.kind()) {
            case LOCAL_VAR: {
                LocalVar local = (LocalVar)defn;
                SoyNode.LocalVarNode declaringNode = (SoyNode.LocalVarNode)local.declaringNode();
                switch (declaringNode.getKind()) {
                    case FOR_NONEMPTY_NODE: {
                        return this.visitForLoopVar(node, local);
                    }
                    case LET_CONTENT_NODE: 
                    case LET_VALUE_NODE: {
                        return this.visitLetNodeVar(node, local);
                    }
                }
                throw new AssertionError((Object)("Unexpected local variable: " + local));
            }
            case PARAM: {
                return this.visitParam(node, (TemplateParam)defn);
            }
            case STATE: {
                throw new AssertionError((Object)"state should have been desugared");
            }
            case COMPREHENSION_VAR: {
                return this.visitListComprehensionVar(node, (ListComprehensionNode.ComprehensionVarDefn)defn);
            }
            case CONST: {
                return this.visitConstVar(node, (ConstVar)defn);
            }
            case IMPORT_VAR: {
                return this.visitImportedVar(node, (ImportedVar)defn);
            }
            case TEMPLATE: 
            case EXTERN: 
            case UNDECLARED: {
                throw new RuntimeException((Object)((Object)defn.kind()) + " are not supported by jbcsrc");
            }
        }
        throw new AssertionError((Object)defn.kind());
    }

    @Override
    protected final T visitFunctionNode(FunctionNode node) {
        Object function = node.getSoyFunction();
        if (function instanceof BuiltinFunction) {
            BuiltinFunction builtinFn = (BuiltinFunction)function;
            switch (builtinFn) {
                case IS_PARAM_SET: {
                    return this.visitIsSetFunction(node);
                }
                case CHECK_NOT_NULL: {
                    return this.visitCheckNotNullFunction(node);
                }
                case CSS: {
                    return this.visitCssFunction(node);
                }
                case XID: {
                    return this.visitXidFunction(node);
                }
                case IS_PRIMARY_MSG_IN_USE: {
                    return this.visitIsPrimaryMsgInUse(node);
                }
                case TO_FLOAT: {
                    return this.visitToFloatFunction(node);
                }
                case DEBUG_SOY_TEMPLATE_INFO: {
                    return this.visitDebugSoyTemplateInfoFunction(node);
                }
                case VE_DATA: {
                    return this.visitVeDataFunction(node);
                }
                case SOY_SERVER_KEY: {
                    return this.visitSoyServerKeyFunction(node);
                }
                case PROTO_INIT: {
                    return this.visitProtoInitFunction(node);
                }
                case MSG_WITH_ID: 
                case REMAINDER: 
                case UNKNOWN_JS_GLOBAL: 
                case LEGACY_DYNAMIC_TAG: {
                    throw new AssertionError();
                }
            }
        }
        return this.visitPluginFunction(node);
    }

    T visitForLoopVar(VarRefNode varRef, LocalVar local) {
        return (T)this.visitExprNode(varRef);
    }

    T visitConstVar(VarRefNode node, ConstVar c) {
        return (T)this.visitExprNode(node);
    }

    T visitImportedVar(VarRefNode node, ImportedVar c) {
        return (T)this.visitExprNode(node);
    }

    T visitLetNodeVar(VarRefNode node, LocalVar local) {
        return (T)this.visitExprNode(node);
    }

    T visitParam(VarRefNode varRef, TemplateParam param) {
        return (T)this.visitExprNode(varRef);
    }

    T visitListComprehensionVar(VarRefNode varRef, ListComprehensionNode.ComprehensionVarDefn var) {
        return (T)this.visitExprNode(varRef);
    }

    T visitIsSetFunction(FunctionNode node) {
        return (T)this.visitExprNode(node);
    }

    T visitCheckNotNullFunction(FunctionNode node) {
        return (T)this.visitExprNode(node);
    }

    T visitCssFunction(FunctionNode node) {
        return (T)this.visitExprNode(node);
    }

    T visitXidFunction(FunctionNode node) {
        return (T)this.visitExprNode(node);
    }

    T visitSoyServerKeyFunction(FunctionNode node) {
        return (T)this.visitExprNode(node);
    }

    T visitIsPrimaryMsgInUse(FunctionNode node) {
        return (T)this.visitExprNode(node);
    }

    T visitToFloatFunction(FunctionNode node) {
        return (T)this.visitExprNode(node);
    }

    T visitDebugSoyTemplateInfoFunction(FunctionNode node) {
        return (T)this.visitExprNode(node);
    }

    T visitVeDataFunction(FunctionNode node) {
        return (T)this.visitExprNode(node);
    }

    T visitProtoInitFunction(FunctionNode node) {
        return (T)this.visitExprNode(node);
    }

    T visitPluginFunction(FunctionNode node) {
        return (T)this.visitExprNode(node);
    }
}

