/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.internal.util;

import com.google.common.collect.Iterables;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public final class BreadthFirstStream {
    private BreadthFirstStream() {
    }

    public static <T> Stream<? extends T> of(T root, final Function<T, Iterable<? extends T>> successors) {
        final ArrayDeque<T> generations = new ArrayDeque<T>();
        generations.add(root);
        return StreamSupport.stream(new Spliterators.AbstractSpliterator<T>(Long.MAX_VALUE, 17){

            @Override
            public boolean tryAdvance(Consumer<? super T> action) {
                Object next = generations.poll();
                if (next == null) {
                    return false;
                }
                Iterables.addAll((Collection)generations, (Iterable)((Iterable)successors.apply(next)));
                action.accept(next);
                return true;
            }
        }, false);
    }
}

