/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.incrementaldomsrc;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.template.soy.base.internal.SanitizedContentKind;
import com.google.template.soy.soytree.AbstractSoyNodeVisitor;
import com.google.template.soy.soytree.CallNode;
import com.google.template.soy.soytree.CallParamContentNode;
import com.google.template.soy.soytree.HtmlAttributeNode;
import com.google.template.soy.soytree.HtmlAttributeValueNode;
import com.google.template.soy.soytree.HtmlCloseTagNode;
import com.google.template.soy.soytree.HtmlCommentNode;
import com.google.template.soy.soytree.HtmlContext;
import com.google.template.soy.soytree.HtmlOpenTagNode;
import com.google.template.soy.soytree.LetContentNode;
import com.google.template.soy.soytree.LogNode;
import com.google.template.soy.soytree.MsgFallbackGroupNode;
import com.google.template.soy.soytree.PrintNode;
import com.google.template.soy.soytree.RawTextNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.TagName;
import com.google.template.soy.soytree.TemplateNode;
import java.util.ArrayDeque;

final class HtmlContextVisitor
extends AbstractSoyNodeVisitor<Void> {
    private final ArrayDeque<HtmlContext> stateStack = new ArrayDeque();
    private static final ImmutableMap<TagName.RcDataTagName, HtmlContext> TAG_TO_CONTENT_TYPE = ImmutableMap.of((Object)((Object)TagName.RcDataTagName.SCRIPT), (Object)((Object)HtmlContext.JS), (Object)((Object)TagName.RcDataTagName.TITLE), (Object)((Object)HtmlContext.HTML_RCDATA), (Object)((Object)TagName.RcDataTagName.TEXTAREA), (Object)((Object)HtmlContext.HTML_RCDATA), (Object)((Object)TagName.RcDataTagName.XMP), (Object)((Object)HtmlContext.HTML_RCDATA), (Object)((Object)TagName.RcDataTagName.STYLE), (Object)((Object)HtmlContext.CSS));

    HtmlContextVisitor() {
    }

    @Override
    protected void visitTemplateNode(TemplateNode node) {
        Preconditions.checkState((boolean)this.stateStack.isEmpty());
        SanitizedContentKind contentKind = node.getContentKind();
        this.pushState(this.contextForKind(contentKind));
        this.visitChildren(node);
        this.popState();
        Preconditions.checkState((boolean)this.stateStack.isEmpty());
    }

    @Override
    protected void visitCallParamContentNode(CallParamContentNode node) {
        this.pushState(this.contextForKind(node.getContentKind()));
        this.visitChildren(node);
        this.popState();
    }

    @Override
    protected void visitLetContentNode(LetContentNode node) {
        this.pushState(this.contextForKind(node.getContentKind()));
        this.visitChildren(node);
        this.popState();
    }

    @Override
    protected void visitHtmlCloseTagNode(HtmlCloseTagNode node) {
        if (TAG_TO_CONTENT_TYPE.containsKey((Object)node.getTagName().getRcDataTagName())) {
            this.popState();
        }
        this.pushState(HtmlContext.HTML_TAG_NAME);
        this.visitChildren(node);
        this.popState();
    }

    @Override
    protected void visitHtmlOpenTagNode(HtmlOpenTagNode node) {
        this.pushState(HtmlContext.HTML_TAG_NAME);
        this.visit((SoyNode)node.getChild(0));
        this.popState();
        this.pushState(HtmlContext.HTML_TAG);
        for (int i = 1; i < node.numChildren(); ++i) {
            this.visit((SoyNode)node.getChild(i));
        }
        this.popState();
        if (TAG_TO_CONTENT_TYPE.containsKey((Object)node.getTagName().getRcDataTagName())) {
            this.pushState((HtmlContext)((Object)TAG_TO_CONTENT_TYPE.get((Object)node.getTagName().getRcDataTagName())));
        }
    }

    @Override
    protected void visitHtmlAttributeNode(HtmlAttributeNode node) {
        boolean hasValue = node.hasValue();
        if (hasValue) {
            this.pushState(HtmlContext.HTML_ATTRIBUTE_NAME);
        }
        this.visit((SoyNode)node.getChild(0));
        if (hasValue) {
            this.popState();
            for (int i = 1; i < node.numChildren(); ++i) {
                this.visit((SoyNode)node.getChild(i));
            }
        }
    }

    @Override
    protected void visitHtmlAttributeValueNode(HtmlAttributeValueNode node) {
        this.pushState(HtmlContext.HTML_NORMAL_ATTR_VALUE);
        super.visitHtmlAttributeValueNode(node);
        this.popState();
    }

    @Override
    protected void visitLogNode(LogNode node) {
        this.pushState(HtmlContext.TEXT);
        this.visitChildren(node);
        this.popState();
    }

    @Override
    protected void visitMsgFallbackGroupNode(MsgFallbackGroupNode node) {
        node.setHtmlContext(this.getState());
        this.visitChildren(node);
    }

    @Override
    protected void visitPrintNode(PrintNode node) {
        node.setHtmlContext(this.getState());
    }

    @Override
    protected void visitCallNode(CallNode node) {
        node.setHtmlContext(this.getState());
        this.visitChildren(node);
    }

    @Override
    protected void visitHtmlCommentNode(HtmlCommentNode node) {
        this.pushState(HtmlContext.TEXT);
        this.visitChildren(node);
        this.popState();
    }

    @Override
    protected void visitRawTextNode(RawTextNode node) {
        node.setHtmlContext(this.getState());
    }

    @Override
    protected void visitSoyNode(SoyNode node) {
        if (node instanceof SoyNode.ParentSoyNode) {
            this.visitChildren((SoyNode.ParentSoyNode)node);
        }
    }

    private void pushState(HtmlContext context) {
        this.stateStack.push(context);
    }

    private void popState() {
        this.stateStack.pop();
    }

    private HtmlContext getState() {
        return this.stateStack.peek();
    }

    private HtmlContext contextForKind(SanitizedContentKind contentKind) {
        switch (contentKind) {
            case HTML: 
            case HTML_ELEMENT: {
                return HtmlContext.HTML_PCDATA;
            }
            case ATTRIBUTES: {
                return HtmlContext.HTML_TAG;
            }
        }
        return HtmlContext.TEXT;
    }
}

