/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.exprtree;

import com.google.protobuf.Descriptors;
import com.google.template.soy.base.internal.Identifier;
import com.google.template.soy.basetree.CopyState;
import com.google.template.soy.exprtree.AbstractPrimitiveNode;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.types.SoyProtoEnumType;

public final class ProtoEnumValueNode
extends AbstractPrimitiveNode {
    private final Identifier id;
    private final SoyProtoEnumType type;
    private final int enumNumber;

    public ProtoEnumValueNode(Identifier id, SoyProtoEnumType type, int enumNumber) {
        super(id.location());
        this.id = id;
        this.type = type;
        this.enumNumber = enumNumber;
    }

    private ProtoEnumValueNode(ProtoEnumValueNode orig, CopyState copyState) {
        super(orig, copyState);
        this.id = orig.id;
        this.type = orig.type;
        this.enumNumber = orig.enumNumber;
    }

    public Identifier getIdentifier() {
        return this.id;
    }

    @Override
    public ExprNode.Kind getKind() {
        return ExprNode.Kind.PROTO_ENUM_VALUE_NODE;
    }

    @Override
    public SoyProtoEnumType getType() {
        return this.type;
    }

    public long getValue() {
        return this.enumNumber;
    }

    public Descriptors.EnumValueDescriptor getEnumValueDescriptor() {
        return this.type.getDescriptor().findValueByNumber(this.enumNumber);
    }

    @Override
    public String toSourceString() {
        return this.id.identifier();
    }

    @Override
    public ProtoEnumValueNode copy(CopyState copyState) {
        return new ProtoEnumValueNode(this, copyState);
    }
}

