/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.exprtree;

import com.google.common.collect.ImmutableList;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.basetree.CopyState;
import com.google.template.soy.exprtree.AbstractParentExprNode;
import com.google.template.soy.exprtree.ExprNode;
import java.util.List;
import java.util.Optional;

public final class ListLiteralNode
extends AbstractParentExprNode {
    private final Optional<ImmutableList<SourceLocation.Point>> commaLocations;

    public ListLiteralNode(List<ExprNode> items, SourceLocation sourceLocation, List<SourceLocation.Point> commaLocations) {
        super(sourceLocation);
        this.addChildren((List<? extends ExprNode>)items);
        this.commaLocations = Optional.of(ImmutableList.copyOf(commaLocations));
    }

    public ListLiteralNode(List<ExprNode> items, SourceLocation sourceLocation) {
        super(sourceLocation);
        this.addChildren((List<? extends ExprNode>)items);
        this.commaLocations = Optional.empty();
    }

    private ListLiteralNode(ListLiteralNode orig, CopyState copyState) {
        super(orig, copyState);
        this.commaLocations = orig.commaLocations;
    }

    public Optional<ImmutableList<SourceLocation.Point>> getCommaLocations() {
        return this.commaLocations;
    }

    @Override
    public ExprNode.Kind getKind() {
        return ExprNode.Kind.LIST_LITERAL_NODE;
    }

    @Override
    public String toSourceString() {
        StringBuilder sourceSb = new StringBuilder();
        sourceSb.append('[');
        boolean isFirst = true;
        for (ExprNode child : this.getChildren()) {
            if (isFirst) {
                isFirst = false;
            } else {
                sourceSb.append(", ");
            }
            sourceSb.append(child.toSourceString());
        }
        sourceSb.append(']');
        return sourceSb.toString();
    }

    @Override
    public ListLiteralNode copy(CopyState copyState) {
        return new ListLiteralNode(this, copyState);
    }
}

