/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.exprtree;

import com.google.common.base.Preconditions;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.basetree.Node;
import com.google.template.soy.exprtree.AbstractVarDefn;
import com.google.template.soy.types.SoyType;

public abstract class AbstractLocalVarDefn<T extends Node>
extends AbstractVarDefn {
    private final T declaringNode;
    private final String originalName;

    public AbstractLocalVarDefn(String name, SourceLocation nameLocation, T declaringNode, SoyType type) {
        super(name.startsWith("$") ? name.substring(1) : name, nameLocation, type);
        this.declaringNode = declaringNode;
        this.originalName = name;
    }

    public AbstractLocalVarDefn(AbstractLocalVarDefn<T> localVar, T declaringNode) {
        super(localVar);
        Preconditions.checkArgument((localVar.declaringNode != declaringNode ? 1 : 0) != 0);
        this.declaringNode = declaringNode;
        this.originalName = localVar.originalName;
    }

    @Override
    public String refName() {
        return "$" + this.name();
    }

    public String getOriginalName() {
        return this.originalName;
    }

    public void setType(SoyType type) {
        this.type = type;
    }

    public T declaringNode() {
        return this.declaringNode;
    }

    @Override
    public boolean isInjected() {
        return false;
    }
}

