/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.data;

import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.template.soy.data.SoyTemplateParam;
import com.google.template.soy.data.SoyValueConverter;
import com.google.template.soy.data.SoyValueProvider;
import com.google.template.soy.data.SoyValueUnconverter;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;

public final class SoyTemplateData {
    public static final SoyTemplateData EMPTY = SoyTemplateData.builder().build();
    private final ImmutableMap<String, SoyValueProvider> data;

    public static Builder builder() {
        return new Builder();
    }

    private SoyTemplateData(Builder builder) {
        this.data = ImmutableMap.copyOf((Map)builder.data);
    }

    public Map<String, ?> getParamsAsMap() {
        return this.data;
    }

    public Map<String, Object> getRawParamsAsMap() {
        return this.data.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> SoyValueUnconverter.unconvert((SoyValueProvider)e.getValue())));
    }

    public boolean equals(Object o) {
        return o instanceof SoyTemplateData && this.data.equals(((SoyTemplateData)o).data);
    }

    public int hashCode() {
        return this.data.hashCode();
    }

    public static final class Builder {
        private final Map<String, SoyValueProvider> data = new HashMap<String, SoyValueProvider>();
        private final SoyValueConverter soyValueConverter = SoyValueConverter.INSTANCE;

        private Builder() {
        }

        public <T> Builder setParam(SoyTemplateParam<? super T> param, T value) {
            this.data.put(param.getName(), this.soyValueConverter.convert(value));
            return this;
        }

        public <T> Builder setParamFuture(SoyTemplateParam<? super T> param, ListenableFuture<T> value) {
            this.data.put(param.getName(), this.soyValueConverter.convert(value));
            return this;
        }

        public SoyTemplateData build() {
            return new SoyTemplateData(this);
        }
    }
}

