/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.conformance;

import com.google.common.collect.ImmutableSet;
import com.google.template.soy.conformance.Rule;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.FunctionNode;
import com.google.template.soy.exprtree.StringNode;

final class BannedCssSelector
extends Rule<FunctionNode> {
    private final ImmutableSet<String> bannedSelectors;
    private final boolean whenPrefix;

    BannedCssSelector(ImmutableSet<String> bannedSelectors, boolean whenPrefix, SoyErrorKind error) {
        super(error);
        this.bannedSelectors = bannedSelectors;
        this.whenPrefix = whenPrefix;
    }

    @Override
    protected void doCheckConformance(FunctionNode node, ErrorReporter errorReporter) {
        if ("css".equals(node.getFunctionName()) && node.numChildren() > 0) {
            ExprNode selectorTextNode;
            ExprNode exprNode = selectorTextNode = node.numChildren() == 2 ? node.getChild(1) : node.getChild(0);
            if (selectorTextNode instanceof StringNode) {
                String selector = ((StringNode)selectorTextNode).getValue();
                if (this.whenPrefix) {
                    for (String bannedSelector : this.bannedSelectors) {
                        if (!selector.startsWith(bannedSelector)) continue;
                        errorReporter.report(selectorTextNode.getSourceLocation(), this.error, new Object[0]);
                    }
                } else if (this.bannedSelectors.contains((Object)selector)) {
                    errorReporter.report(selectorTextNode.getSourceLocation(), this.error, new Object[0]);
                }
            }
        }
    }
}

