/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy;

import com.google.common.collect.ImmutableList;
import com.google.common.io.CharSource;
import com.google.common.io.FileWriteMode;
import com.google.common.io.Files;
import com.google.template.soy.AbstractSoyCompiler;
import com.google.template.soy.PluginLoader;
import com.google.template.soy.SoyFileSet;
import com.google.template.soy.SoyInputCache;
import com.google.template.soy.base.internal.BaseUtils;
import com.google.template.soy.base.internal.SoyJarFileWriter;
import com.google.template.soy.shared.internal.gencode.GeneratedFile;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.kohsuke.args4j.Option;

public final class SoyParseInfoGenerator
extends AbstractSoyCompiler {
    @Option(name="--generateInvocationBuilders", usage="[Reqiured] Whether to generate the new java template invocation builders (FooTemplates.java). If false, generates the old FooSoyInfo.java files instead.")
    private boolean generateInvocationBuilders = false;
    @Option(name="--outputDirectory", usage="[Optional] The path to the output directory. If files with the same names already exist at this location, they will be overwritten. Either --outputDirectory or --outputJar must be set.")
    private String outputDirectory = "";
    @Option(name="--outputSrcJar", usage="[Optional]  The path to the source jar to write. If a file with the same name already exists at this location, it will be overwritten. Either --outputDirectory or --outputJar must be set.")
    private File outputSrcJar;
    @Option(name="--javaPackage", required=true, usage="[Required] The Java package name to use for the generated classes.")
    private String javaPackage = "";
    @Option(name="--javaClassNameSource", required=true, usage="[Required for *SoyInfo mode, Ignored for invocation builder mode (i.e. if --generateInvocationBuilders=true)]. The source for the generated class names. Valid values are \"filename\", \"namespace\", and \"generic\". Option \"filename\" turns a Soy file name AaaBbb.soy or aaa_bbb.soy into AaaBbbSoyInfo. Option \"namespace\" turns a namespace aaa.bbb.cccDdd into CccDddSoyInfo (note it only uses the last part of the namespace). Option \"generic\" generates class names such as File1SoyInfo, File2SoyInfo.")
    private String javaClassNameSource = "";

    SoyParseInfoGenerator(PluginLoader loader, SoyInputCache cache) {
        super(loader, cache);
    }

    SoyParseInfoGenerator() {
    }

    public static void main(String[] args) throws IOException {
        new SoyParseInfoGenerator().runMain(args);
    }

    @Override
    protected void validateFlags() {
        if (this.javaPackage.length() == 0) {
            SoyParseInfoGenerator.exitWithError("Must provide Java package.");
        }
        if (this.outputDirectory.isEmpty() == (this.outputSrcJar == null)) {
            SoyParseInfoGenerator.exitWithError("Must provide exactly one of --outputDirectory or --outputSrcJar");
        }
        if (!this.generateInvocationBuilders && this.javaClassNameSource.isEmpty()) {
            SoyParseInfoGenerator.exitWithError("Must provide Java class name source.");
        }
    }

    @Override
    protected void compile(SoyFileSet.Builder sfsBuilder) throws IOException {
        ImmutableList<GeneratedFile> genFiles;
        SoyFileSet sfs = sfsBuilder.build();
        ImmutableList<GeneratedFile> immutableList = genFiles = this.generateInvocationBuilders ? sfs.generateInvocationBuilders(this.javaPackage) : sfs.generateParseInfo(this.javaPackage, this.javaClassNameSource);
        if (this.outputSrcJar == null) {
            for (GeneratedFile genFile : genFiles) {
                File outputFile = new File(this.outputDirectory, genFile.fileName());
                BaseUtils.ensureDirsExistInPath(outputFile.getPath());
                Files.asCharSink((File)outputFile, (Charset)StandardCharsets.UTF_8, (FileWriteMode[])new FileWriteMode[0]).write((CharSequence)genFile.contents());
            }
        } else {
            String resourcePath = this.javaPackage.replace('.', '/') + "/";
            try (SoyJarFileWriter writer = new SoyJarFileWriter(new FileOutputStream(this.outputSrcJar));){
                for (GeneratedFile genFile : genFiles) {
                    writer.writeEntry(resourcePath + genFile.fileName(), CharSource.wrap((CharSequence)genFile.contents()).asByteSource(StandardCharsets.UTF_8));
                }
            }
        }
    }
}

