/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Ascii;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.MultimapBuilder;
import com.google.common.io.MoreFiles;
import com.google.template.soy.CommandLineError;
import com.google.template.soy.SoyCmdLineParser;
import com.google.template.soy.base.SourceFilePath;
import com.google.template.soy.shared.internal.MainEntryPointUtils;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import org.kohsuke.args4j.Option;

final class PerInputOutputFiles {
    static final Joiner JS_JOINER = Joiner.on((String)"\n;\n");
    @Option(name="--outputPathFormat", usage="[Required] A format string that specifies how to build the path to each output file. If not generating localized JS, then there will be one output JS file (UTF-8) for each input Soy file. If generating localized JS, then there will be one output JS file for each combination of input Soy file and locale. The format string can include literal characters as well as the placeholders {INPUT_DIRECTORY}, {INPUT_FILE_NAME}, {INPUT_FILE_NAME_NO_EXT}, {LOCALE}, {LOCALE_LOWER_CASE}. Note {LOCALE_LOWER_CASE} also turns dash into underscore, e.g. pt-BR becomes pt_br.")
    private String outputPathFormat;
    @Option(name="--inputRoots", usage="[Optional] May be set along with the --outputDirectory flag to modify how input paths are transformed into output paths.  See --outputDirectory for more information.", handler=SoyCmdLineParser.PathListOptionHandler.class)
    private List<Path> inputRoots = new ArrayList<Path>();
    @Option(name="--outputDirectory", usage="[Optional] The directory where to output generated code.. The generated file names will be based on the input file names with the following rules:\n * All files will be output with a '.js' suffix.\n * If a src file starts with a registered --inputRoot then the output path will be the same relative path within the output directory.\n  * If generated localized srcs, the file name will use the locale as an additional segment, e.g. foo.soy -> foo__fr.soy.js\n\nThis flag may not be used if --outputPathFormat is set")
    private Path outputDirectory;
    @Option(name="--subdir", usage="[Optional] A subdirectory (relative to the input file) to put the corresponding output file in. For example, if the input is my/path/foo.soy, and the subdir is 'jsouts', then the output file would be located at: my/path/jsouts/foo.soy.js'.")
    private String subdir;
    private final String extension;
    private final Optional<Joiner> fileJoiner;

    PerInputOutputFiles(String extension, @Nullable Joiner fileJoiner) {
        this.extension = extension;
        this.fileJoiner = Optional.ofNullable(fileJoiner);
    }

    PerInputOutputFiles(String extension) {
        this(extension, null);
    }

    void validateFlags() {
        if (!(this.outputPathFormat == null || this.inputRoots.isEmpty() && this.outputDirectory == null)) {
            PerInputOutputFiles.exitWithError("Must set either --outputPathFormat or --outputDirectory and --inputRoots.");
        }
        if (this.outputPathFormat == null && this.outputDirectory == null) {
            PerInputOutputFiles.exitWithError("Must set at least one of --outputPathFormat or --outputDirectory.");
        }
    }

    void writeFiles(List<File> srcs, List<String> outFileContents) {
        this.writeFiles(srcs, outFileContents, null, false);
    }

    void writeFiles(List<File> srcs, List<String> outFileContents, @Nullable String locale) {
        this.writeFiles(srcs, outFileContents, locale, false);
    }

    void writeFiles(List<File> srcs, List<String> outFileContents, @Nullable String locale, boolean omitIfEmpty) {
        if (srcs.size() != outFileContents.size()) {
            throw new AssertionError((Object)String.format("Expected to generate %d code chunk(s), got %d", srcs.size(), outFileContents.size()));
        }
        ListMultimap outputPathToContents = MultimapBuilder.linkedHashKeys().arrayListValues().build();
        for (int i = 0; i < srcs.size(); ++i) {
            outputPathToContents.put((Object)this.getOutputPath(srcs.get(i), locale), (Object)outFileContents.get(i));
        }
        for (Path outputPath : outputPathToContents.keySet()) {
            if (outputPath.getParent() != null) {
                outputPath.getParent().toFile().mkdirs();
            }
            try {
                String contents;
                if (this.fileJoiner.isPresent()) {
                    contents = this.fileJoiner.get().join((Iterable)outputPathToContents.get((Object)outputPath));
                    if (omitIfEmpty && contents.isEmpty()) continue;
                    MoreFiles.asCharSink((Path)outputPath, (Charset)StandardCharsets.UTF_8, (OpenOption[])new OpenOption[0]).write((CharSequence)contents);
                    continue;
                }
                Preconditions.checkState((outputPathToContents.get((Object)outputPath).size() == 1 ? 1 : 0) != 0, (Object)"A file joiner must be specified if multiple sources will map to a single output file");
                contents = (String)Iterables.getOnlyElement((Iterable)outputPathToContents.get((Object)outputPath));
                if (omitIfEmpty && contents.isEmpty()) continue;
                MoreFiles.asCharSink((Path)outputPath, (Charset)StandardCharsets.UTF_8, (OpenOption[])new OpenOption[0]).write((CharSequence)contents);
            }
            catch (IOException ioe) {
                throw new CommandLineError("Failed to write: " + outputPath + ": " + ioe.getMessage(), ioe);
            }
        }
    }

    ImmutableMap<SourceFilePath, Path> getOutputFilePathsForInputs(List<SourceFilePath> srcs) {
        return (ImmutableMap)srcs.stream().collect(ImmutableMap.toImmutableMap(srcPath -> srcPath, srcPath -> this.getOutputPath(Paths.get(srcPath.path(), new String[0]), null)));
    }

    @VisibleForTesting
    Path getOutputPath(File input, @Nullable String locale) {
        return this.getOutputPath(input.toPath(), locale);
    }

    @VisibleForTesting
    Path getOutputPath(Path inputPath, @Nullable String locale) {
        String transformedLocale;
        String string = transformedLocale = locale == null ? null : Ascii.toLowerCase((String)locale).replace('-', '_');
        if (this.outputDirectory != null) {
            int extensionLocation;
            for (Path root : this.inputRoots) {
                if (!inputPath.startsWith(root)) continue;
                inputPath = root.relativize(inputPath);
                break;
            }
            String fileName = inputPath.getFileName().toString();
            if (this.subdir != null && this.subdir.length() > 0) {
                fileName = this.subdir + "/" + fileName;
            }
            if ((extensionLocation = fileName.lastIndexOf(46)) == -1) {
                extensionLocation = fileName.length();
            }
            fileName = fileName.substring(0, extensionLocation) + (transformedLocale != null ? "_" + transformedLocale : "") + "." + this.extension;
            inputPath = inputPath.resolveSibling(fileName);
            inputPath = this.outputDirectory.resolve(inputPath);
            return inputPath;
        }
        return Paths.get(MainEntryPointUtils.buildFilePath(this.outputPathFormat, locale, inputPath.toString()), new String[0]);
    }

    Optional<Path> getOutputDirectoryFlag() {
        return Optional.ofNullable(this.outputDirectory);
    }

    static final RuntimeException exitWithError(String errorMsg) {
        throw new CommandLineError("Error: " + errorMsg);
    }
}

