/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.xliffmsgplugin;

import com.google.common.collect.ImmutableMap;
import com.google.common.escape.Escaper;
import com.google.common.xml.XmlEscapers;
import com.google.template.soy.base.internal.IndentedLinesBuilder;
import com.google.template.soy.msgs.SoyMsgBundle;
import com.google.template.soy.msgs.restricted.SoyMsg;
import com.google.template.soy.msgs.restricted.SoyMsgPart;
import com.google.template.soy.msgs.restricted.SoyMsgPlaceholderPart;
import com.google.template.soy.msgs.restricted.SoyMsgRawTextPart;
import java.util.Optional;
import javax.annotation.Nullable;

class XliffGenerator {
    private static final ImmutableMap<String, String> CONTENT_TYPE_TO_XLIFF_DATATYPE_MAP = ImmutableMap.builder().put((Object)"text/plain", (Object)"plaintext").put((Object)"text/html", (Object)"html").put((Object)"application/xhtml+xml", (Object)"xhtml").put((Object)"application/javascript", (Object)"javascript").put((Object)"text/css", (Object)"css").put((Object)"text/xml", (Object)"xml").build();

    private XliffGenerator() {
    }

    static CharSequence generateXliff(SoyMsgBundle msgBundle, String sourceLocaleString, @Nullable String targetLocaleString) {
        Escaper attributeEscaper = XmlEscapers.xmlAttributeEscaper();
        Escaper contentEscaper = XmlEscapers.xmlContentEscaper();
        boolean hasTarget = targetLocaleString != null && targetLocaleString.length() > 0;
        IndentedLinesBuilder ilb = new IndentedLinesBuilder(2);
        ilb.appendLine("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        ilb.appendLine("<xliff version=\"1.2\" xmlns=\"urn:oasis:names:tc:xliff:document:1.2\">");
        ilb.increaseIndent();
        ilb.appendLineStart("<file original=\"SoyMsgBundle\" datatype=\"x-soy-msg-bundle\"", " xml:space=\"preserve\"", " source-language=\"", attributeEscaper.escape(sourceLocaleString), "\"");
        if (hasTarget) {
            ilb.appendParts(" target-language=\"", attributeEscaper.escape(targetLocaleString), "\"");
        }
        ilb.appendLineEnd(">");
        ilb.increaseIndent();
        ilb.appendLine("<body>");
        ilb.increaseIndent();
        for (SoyMsg msg : msgBundle) {
            String meaning;
            String desc;
            ilb.appendLineStart("<trans-unit id=\"", Long.toString(msg.getId()), "\"");
            String contentType = msg.getContentType();
            if (contentType != null && contentType.length() > 0) {
                String xliffDatatype = (String)CONTENT_TYPE_TO_XLIFF_DATATYPE_MAP.get((Object)contentType);
                if (xliffDatatype == null) {
                    xliffDatatype = contentType;
                }
                ilb.appendParts(" datatype=\"", attributeEscaper.escape(xliffDatatype), "\"");
            }
            ilb.appendLineEnd(">");
            ilb.increaseIndent();
            ilb.appendLineStart("<source>");
            for (SoyMsgPart msgPart : msg.getParts()) {
                if (msgPart instanceof SoyMsgRawTextPart) {
                    String rawText = ((SoyMsgRawTextPart)msgPart).getRawText();
                    ilb.append(contentEscaper.escape(rawText));
                    continue;
                }
                if (msgPart instanceof SoyMsgPlaceholderPart) {
                    SoyMsgPlaceholderPart placeholder = (SoyMsgPlaceholderPart)msgPart;
                    Optional<String> example = placeholder.getPlaceholderExample();
                    ilb.appendParts("<x id=\"", attributeEscaper.escape(placeholder.getPlaceholderName()), "\"" + (example.isPresent() ? " example=\"" + attributeEscaper.escape(example.get()) + "\"" : "") + "/>");
                    continue;
                }
                throw new RuntimeException("Xliff doesn't support plurals or genders. " + msg.getSourceLocations());
            }
            ilb.appendLineEnd("</source>");
            if (hasTarget) {
                ilb.appendLine("<target/>");
            }
            if ((desc = msg.getDesc()) != null && desc.length() > 0) {
                ilb.appendLine("<note priority=\"1\" from=\"description\">", contentEscaper.escape(desc), "</note>");
            }
            if ((meaning = msg.getMeaning()) != null && meaning.length() > 0) {
                ilb.appendLine("<note priority=\"1\" from=\"meaning\">", contentEscaper.escape(meaning), "</note>");
            }
            ilb.decreaseIndent();
            ilb.appendLine("</trans-unit>");
        }
        ilb.decreaseIndent();
        ilb.appendLine("</body>");
        ilb.decreaseIndent();
        ilb.appendLine("</file>");
        ilb.decreaseIndent();
        ilb.appendLine("</xliff>");
        return ilb;
    }
}

