/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.types;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.Interner;
import com.google.common.collect.Interners;
import com.google.protobuf.Descriptors;
import com.google.template.soy.base.internal.Identifier;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.internal.proto.Field;
import com.google.template.soy.types.AnyType;
import com.google.template.soy.types.BoolType;
import com.google.template.soy.types.FloatType;
import com.google.template.soy.types.ImportType;
import com.google.template.soy.types.IntType;
import com.google.template.soy.types.MessageType;
import com.google.template.soy.types.NullType;
import com.google.template.soy.types.ProtoEnumImportType;
import com.google.template.soy.types.ProtoExtensionImportType;
import com.google.template.soy.types.ProtoImportType;
import com.google.template.soy.types.ProtoModuleImportType;
import com.google.template.soy.types.SanitizedType;
import com.google.template.soy.types.SoyProtoType;
import com.google.template.soy.types.SoyType;
import com.google.template.soy.types.SoyTypeRegistry;
import com.google.template.soy.types.SoyTypes;
import com.google.template.soy.types.StringType;
import com.google.template.soy.types.TypeInterner;
import com.google.template.soy.types.TypeRegistry;
import com.google.template.soy.types.UnknownType;
import com.google.template.soy.types.VeDataType;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import javax.annotation.Nullable;

public final class TypeRegistries {
    private static final SoyErrorKind PROTO_FQN = SoyErrorKind.of("Proto types must be imported rather than referenced by their fully qualified names.", new SoyErrorKind.StyleAllowance[0]);
    private static final BuiltinTypeRegistry INSTANCE = new BuiltinTypeRegistry();

    private TypeRegistries() {
    }

    public static TypeInterner newTypeInterner() {
        return new TypeInternerImpl();
    }

    public static TypeRegistry builtinTypeRegistry() {
        return INSTANCE;
    }

    public static SoyTypeRegistry newComposite(TypeRegistry typeRegistry, TypeInterner typeInterner) {
        return new CompositeSoyTypeRegistry(typeRegistry, typeInterner);
    }

    public static SoyType getTypeOrProtoFqn(SoyTypeRegistry registry, ErrorReporter errorReporter, Identifier id) {
        return TypeRegistries.getTypeOrProtoFqn(registry, errorReporter, id, id.identifier());
    }

    public static SoyType getTypeOrProtoFqn(SoyTypeRegistry registry, ErrorReporter errorReporter, Identifier id, String typeName) {
        SoyType nonProtoFqnType = registry.getType(typeName);
        if (nonProtoFqnType != null) {
            return nonProtoFqnType;
        }
        SoyType protoFqnType = registry.getProtoRegistry().getProtoType(typeName);
        if (protoFqnType != null) {
            errorReporter.report(id.location(), PROTO_FQN, new Object[0]);
        }
        return null;
    }

    private static final class CompositeSoyTypeRegistry
    implements SoyTypeRegistry {
        private final TypeRegistry typeRegistry;
        private final TypeInterner typeInterner;

        public CompositeSoyTypeRegistry(TypeRegistry typeRegistry, TypeInterner typeInterner) {
            this.typeRegistry = typeRegistry;
            this.typeInterner = typeInterner;
        }

        @Override
        @Nullable
        public SoyType getType(String typeName) {
            return this.typeRegistry.getType(typeName);
        }

        @Override
        public Iterable<String> getAllSortedTypeNames() {
            return this.typeRegistry.getAllSortedTypeNames();
        }

        @Override
        public <T extends SoyType> T intern(T type) {
            return this.typeInterner.intern(type);
        }

        @Override
        public SoyProtoType getOrComputeProtoType(Descriptors.Descriptor descriptor, Function<? super String, ? extends SoyProtoType> mapper) {
            return this.typeInterner.getOrComputeProtoType(descriptor, mapper);
        }

        @Override
        public SoyType getOrCreateElementType(String tagName) {
            return this.typeInterner.getOrCreateElementType(tagName);
        }

        @Override
        public ImportType getProtoImportType(Descriptors.GenericDescriptor descriptor) {
            return this.typeInterner.getProtoImportType(descriptor);
        }

        @Override
        public SoyType getProtoImportType(Descriptors.FileDescriptor descriptor, String member) {
            return this.typeInterner.getProtoImportType(descriptor, member);
        }

        @Override
        public SoyType getProtoImportType(Descriptors.Descriptor descriptor, String member) {
            return this.typeInterner.getProtoImportType(descriptor, member);
        }
    }

    private static final class BuiltinTypeRegistry
    implements TypeRegistry {
        private static final ImmutableMap<String, SoyType> BUILTIN_TYPES = ImmutableSortedMap.naturalOrder().put((Object)"?", (Object)UnknownType.getInstance()).put((Object)"any", (Object)AnyType.getInstance()).put((Object)"null", (Object)NullType.getInstance()).put((Object)"bool", (Object)BoolType.getInstance()).put((Object)"int", (Object)IntType.getInstance()).put((Object)"float", (Object)FloatType.getInstance()).put((Object)"string", (Object)StringType.getInstance()).put((Object)"number", (Object)SoyTypes.NUMBER_TYPE).put((Object)"html", (Object)SanitizedType.HtmlType.getInstance()).put((Object)"attributes", (Object)SanitizedType.AttributesType.getInstance()).put((Object)"css", (Object)SanitizedType.StyleType.getInstance()).put((Object)"uri", (Object)SanitizedType.UriType.getInstance()).put((Object)"trusted_resource_uri", (Object)SanitizedType.TrustedResourceUriType.getInstance()).put((Object)"js", (Object)SanitizedType.JsType.getInstance()).put((Object)"ve_data", (Object)VeDataType.getInstance()).put((Object)"Message", (Object)MessageType.getInstance()).buildOrThrow();

        private BuiltinTypeRegistry() {
        }

        @Override
        @Nullable
        public SoyType getType(String typeName) {
            return (SoyType)BUILTIN_TYPES.get((Object)typeName);
        }

        public ImmutableSet<String> getAllSortedTypeNames() {
            return BUILTIN_TYPES.keySet();
        }
    }

    private static final class TypeInternerImpl
    implements TypeInterner {
        private final Interner<SoyType> types = Interners.newStrongInterner();
        private final Map<String, SoyProtoType> protoTypes = new ConcurrentHashMap<String, SoyProtoType>();
        private final Map<Descriptors.GenericDescriptor, ImmutableMap<String, Descriptors.GenericDescriptor>> protoMembersCache = new ConcurrentHashMap<Descriptors.GenericDescriptor, ImmutableMap<String, Descriptors.GenericDescriptor>>();
        private final Map<Descriptors.GenericDescriptor, ImportType> protoImportTypes = new ConcurrentHashMap<Descriptors.GenericDescriptor, ImportType>();

        public TypeInternerImpl() {
            Preconditions.checkState((this.types.intern((Object)SoyTypes.NUMBER_TYPE) == SoyTypes.NUMBER_TYPE ? 1 : 0) != 0);
        }

        @Override
        public <T extends SoyType> T intern(T type) {
            return (T)((SoyType)this.types.intern(type));
        }

        @Override
        public SoyProtoType getOrComputeProtoType(Descriptors.Descriptor descriptor, Function<? super String, ? extends SoyProtoType> mapper) {
            return this.protoTypes.computeIfAbsent(descriptor.getFullName(), mapper);
        }

        @Override
        public ImportType getProtoImportType(Descriptors.GenericDescriptor descriptor) {
            return this.protoImportTypes.computeIfAbsent(descriptor, d -> {
                if (d instanceof Descriptors.FileDescriptor) {
                    return ProtoModuleImportType.create((Descriptors.FileDescriptor)d);
                }
                if (d instanceof Descriptors.Descriptor) {
                    return ProtoImportType.create((Descriptors.Descriptor)d);
                }
                if (d instanceof Descriptors.EnumDescriptor) {
                    return ProtoEnumImportType.create((Descriptors.EnumDescriptor)d);
                }
                if (d instanceof Descriptors.FieldDescriptor && ((Descriptors.FieldDescriptor)d).isExtension()) {
                    return ProtoExtensionImportType.create((Descriptors.FieldDescriptor)d);
                }
                throw new ClassCastException(d.getClass().getName());
            });
        }

        @Override
        public SoyType getProtoImportType(Descriptors.FileDescriptor descriptor, String member) {
            return this.getProtoImportType((Map)this.protoMembersCache.computeIfAbsent((Descriptors.GenericDescriptor)descriptor, TypeInternerImpl::buildMemberIndex), member);
        }

        @Override
        public SoyType getProtoImportType(Descriptors.Descriptor descriptor, String member) {
            return this.getProtoImportType((Map)this.protoMembersCache.computeIfAbsent((Descriptors.GenericDescriptor)descriptor, TypeInternerImpl::buildMemberIndex), member);
        }

        private SoyType getProtoImportType(Map<String, Descriptors.GenericDescriptor> index, String member) {
            Descriptors.GenericDescriptor d = index.get(member);
            if (d != null) {
                return this.getProtoImportType(d);
            }
            return UnknownType.getInstance();
        }

        private static ImmutableMap<String, Descriptors.GenericDescriptor> buildMemberIndex(Descriptors.GenericDescriptor d) {
            ImmutableMap.Builder index = ImmutableMap.builder();
            if (d instanceof Descriptors.FileDescriptor) {
                Descriptors.FileDescriptor fileDescriptor = (Descriptors.FileDescriptor)d;
                fileDescriptor.getMessageTypes().forEach(t -> index.put((Object)t.getName(), t));
                fileDescriptor.getEnumTypes().forEach(t -> index.put((Object)t.getName(), t));
                fileDescriptor.getExtensions().forEach(t -> index.put((Object)Field.computeSoyName(t), t));
            } else if (d instanceof Descriptors.Descriptor) {
                Descriptors.Descriptor descriptor = (Descriptors.Descriptor)d;
                descriptor.getNestedTypes().forEach(t -> index.put((Object)t.getName(), t));
                descriptor.getEnumTypes().forEach(t -> index.put((Object)t.getName(), t));
                descriptor.getExtensions().forEach(t -> index.put((Object)Field.computeSoyName(t), t));
            } else {
                throw new AssertionError((Object)d.getClass().getName());
            }
            return index.build();
        }
    }
}

