/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.types;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.common.html.types.SafeHtmlProto;
import com.google.common.html.types.SafeScriptProto;
import com.google.common.html.types.SafeStyleProto;
import com.google.common.html.types.SafeStyleSheetProto;
import com.google.common.html.types.SafeUrlProto;
import com.google.common.html.types.TrustedResourceUrlProto;
import com.google.template.soy.internal.util.BreadthFirstStream;
import com.google.template.soy.types.AbstractMapType;
import com.google.template.soy.types.BoolType;
import com.google.template.soy.types.FloatType;
import com.google.template.soy.types.FunctionType;
import com.google.template.soy.types.ImportType;
import com.google.template.soy.types.IntType;
import com.google.template.soy.types.LegacyObjectMapType;
import com.google.template.soy.types.ListType;
import com.google.template.soy.types.MapType;
import com.google.template.soy.types.MessageType;
import com.google.template.soy.types.NullType;
import com.google.template.soy.types.PrimitiveType;
import com.google.template.soy.types.RecordType;
import com.google.template.soy.types.SanitizedType;
import com.google.template.soy.types.SoyProtoEnumType;
import com.google.template.soy.types.SoyProtoType;
import com.google.template.soy.types.SoyType;
import com.google.template.soy.types.SoyTypeRegistry;
import com.google.template.soy.types.SoyTypeVisitor;
import com.google.template.soy.types.StringType;
import com.google.template.soy.types.TemplateType;
import com.google.template.soy.types.UnionType;
import com.google.template.soy.types.VeType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public final class SoyTypes {
    public static final SoyType NUMBER_TYPE = UnionType.of(IntType.getInstance(), FloatType.getInstance());
    public static final ImmutableMap<String, SanitizedType> SAFE_PROTO_TO_SANITIZED_TYPE = ImmutableMap.builder().put((Object)SafeHtmlProto.getDescriptor().getFullName(), (Object)SanitizedType.HtmlType.getInstance()).put((Object)SafeScriptProto.getDescriptor().getFullName(), (Object)SanitizedType.JsType.getInstance()).put((Object)SafeStyleProto.getDescriptor().getFullName(), (Object)SanitizedType.StyleType.getInstance()).put((Object)SafeStyleSheetProto.getDescriptor().getFullName(), (Object)SanitizedType.StyleType.getInstance()).put((Object)SafeUrlProto.getDescriptor().getFullName(), (Object)SanitizedType.UriType.getInstance()).put((Object)TrustedResourceUrlProto.getDescriptor().getFullName(), (Object)SanitizedType.TrustedResourceUriType.getInstance()).build();
    private static final ImmutableSet<SoyType.Kind> ALWAYS_COMPARABLE_KINDS = Sets.immutableEnumSet((Enum)SoyType.Kind.UNKNOWN, (Enum[])new SoyType.Kind[]{SoyType.Kind.ANY, SoyType.Kind.NULL});
    private static final ImmutableSet<SoyType.Kind> NUMERIC_PRIMITIVES = Sets.immutableEnumSet((Enum)SoyType.Kind.INT, (Enum[])new SoyType.Kind[]{SoyType.Kind.FLOAT, SoyType.Kind.PROTO_ENUM});

    private SoyTypes() {
    }

    private static boolean isDefiniteComparable(SoyType type) {
        return ALWAYS_COMPARABLE_KINDS.contains((Object)type.getKind());
    }

    private static boolean isDefinitePrimitive(SoyType type) {
        return type.getKind() == SoyType.Kind.BOOL || SoyTypes.isNumericPrimitive(type) || type.getKind().isKnownStringOrSanitizedContent();
    }

    public static boolean isNumericPrimitive(SoyType type) {
        return SoyTypes.isKindOrUnionOfKinds(type, NUMERIC_PRIMITIVES);
    }

    public static SoyType removeNull(SoyType type) {
        Preconditions.checkArgument((!NullType.getInstance().equals(type) ? 1 : 0) != 0, (Object)"Can't remove null from null");
        if (type.getKind() == SoyType.Kind.UNION) {
            return ((UnionType)type).removeNullability();
        }
        return type;
    }

    public static SoyType tryRemoveNull(SoyType soyType) {
        if (soyType == NullType.getInstance()) {
            return NullType.getInstance();
        }
        return SoyTypes.removeNull(soyType);
    }

    public static SoyType makeNullable(SoyType type) {
        if (SoyTypes.isNullable(type)) {
            return type;
        }
        return UnionType.of(type, NullType.getInstance());
    }

    public static boolean isNullable(SoyType type) {
        return type.equals(NullType.getInstance()) || type.getKind() == SoyType.Kind.UNION && ((UnionType)type).isNullable();
    }

    public static boolean isNumericOrUnknown(SoyType type) {
        return type.getKind() == SoyType.Kind.UNKNOWN || NUMBER_TYPE.isAssignableFromStrict(type);
    }

    public static SoyType computeLowestCommonType(SoyTypeRegistry typeRegistry, SoyType t0, SoyType t1) {
        if (t0.isAssignableFromStrict(t1)) {
            return t0;
        }
        if (t1.isAssignableFromStrict(t0)) {
            return t1;
        }
        return typeRegistry.getOrCreateUnionType(t0, t1);
    }

    public static SoyType computeLowestCommonType(SoyTypeRegistry typeRegistry, Collection<SoyType> types) {
        SoyType result = null;
        for (SoyType type : types) {
            result = result == null ? type : SoyTypes.computeLowestCommonType(typeRegistry, result, type);
        }
        return result;
    }

    public static Optional<SoyType> computeLowestCommonTypeArithmetic(SoyType t0, SoyType t1) {
        if (!SoyTypes.isNumericOrUnknown(t0) || !SoyTypes.isNumericOrUnknown(t1)) {
            return Optional.empty();
        }
        if (t0.isAssignableFromStrict(t1)) {
            return Optional.of(t0);
        }
        if (t1.isAssignableFromStrict(t0)) {
            return Optional.of(t1);
        }
        return Optional.of(FloatType.getInstance());
    }

    @Nullable
    private static SoyType getSoyTypeFromUnionForBinaryOperator(UnionType t0, SoyType t1, boolean isNullable, SoyTypeBinaryOperator operator) {
        ArrayList<SoyType> subTypes = new ArrayList<SoyType>();
        for (SoyType unionMember : t0.getMembers()) {
            SoyType result = SoyTypes.getSoyTypeForBinaryOperator(unionMember, t1, operator);
            if (result == null) {
                return null;
            }
            subTypes.add(result);
        }
        SoyType result = UnionType.of(subTypes);
        return isNullable ? SoyTypes.makeNullable(result) : result;
    }

    @Nullable
    public static SoyType getSoyTypeForBinaryOperator(SoyType t0, SoyType t1, SoyTypeBinaryOperator operator) {
        boolean isNullable = SoyTypes.isNullable(t0) && SoyTypes.isNullable(t1);
        SoyType left = SoyTypes.tryRemoveNull(t0);
        SoyType right = SoyTypes.tryRemoveNull(t1);
        if (left.getKind() == SoyType.Kind.UNION) {
            return SoyTypes.getSoyTypeFromUnionForBinaryOperator((UnionType)left, right, isNullable, operator);
        }
        if (right.getKind() == SoyType.Kind.UNION) {
            return SoyTypes.getSoyTypeFromUnionForBinaryOperator((UnionType)right, left, isNullable, operator);
        }
        SoyType result = operator.resolve(left, right);
        if (result == null) {
            return null;
        }
        return isNullable ? SoyTypes.makeNullable(result) : result;
    }

    public static boolean isKindOrUnionOfKind(SoyType type, SoyType.Kind kind) {
        return SoyTypes.isKindOrUnionOfKinds(type, (Set<SoyType.Kind>)ImmutableSet.of((Object)((Object)kind)));
    }

    public static boolean isKindOrUnionOfKinds(SoyType type, Set<SoyType.Kind> kinds) {
        return SoyTypes.expandUnions(type).stream().allMatch(t -> kinds.contains((Object)t.getKind()));
    }

    public static ImmutableList<SoyType> expandUnions(SoyType type) {
        if (type.getKind() == SoyType.Kind.UNION) {
            return ImmutableList.copyOf(((UnionType)type).getMembers());
        }
        return ImmutableList.of((Object)type);
    }

    public static boolean transitivelyContainsKind(SoyType type, SoyType.Kind ... kind) {
        Predicate<SoyType> kindTest;
        if (kind.length == 1) {
            kindTest = t -> t.getKind() == kind[0];
        } else {
            ImmutableSet kinds = ImmutableSet.copyOf((Object[])kind);
            kindTest = arg_0 -> SoyTypes.lambda$transitivelyContainsKind$2((Set)kinds, arg_0);
        }
        return type.accept(new SoyTypeVisitor<Boolean>(){

            @Override
            public Boolean visit(LegacyObjectMapType type) {
                return kindTest.test(type) || type.getKeyType() != null && type.getKeyType().accept(this) != false || type.getValueType() != null && type.getValueType().accept(this) != false;
            }

            @Override
            public Boolean visit(ListType type) {
                return kindTest.test(type) || type.getElementType() != null && type.getElementType().accept(this) != false;
            }

            @Override
            public Boolean visit(MapType type) {
                return kindTest.test(type) || type.getKeyType() != null && type.getKeyType().accept(this) != false || type.getValueType() != null && type.getValueType().accept(this) != false;
            }

            @Override
            public Boolean visit(PrimitiveType type) {
                return kindTest.test(type);
            }

            @Override
            public Boolean visit(RecordType type) {
                if (kindTest.test(type)) {
                    return true;
                }
                for (RecordType.Member member : type.getMembers()) {
                    if (!member.type().accept(this).booleanValue()) continue;
                    return true;
                }
                return false;
            }

            @Override
            public Boolean visit(SoyProtoEnumType type) {
                return kindTest.test(type);
            }

            @Override
            public Boolean visit(SoyProtoType type) {
                return kindTest.test(type);
            }

            @Override
            public Boolean visit(TemplateType type) {
                if (kindTest.test(type)) {
                    return true;
                }
                for (TemplateType.Parameter parameter : type.getParameters()) {
                    if (!parameter.getType().accept(this).booleanValue()) continue;
                    return true;
                }
                return false;
            }

            @Override
            public Boolean visit(UnionType type) {
                if (kindTest.test(type)) {
                    return true;
                }
                for (SoyType member : type.getMembers()) {
                    if (!member.accept(this).booleanValue()) continue;
                    return true;
                }
                return false;
            }

            @Override
            public Boolean visit(VeType type) {
                return kindTest.test(type);
            }

            @Override
            public Boolean visit(MessageType type) {
                return kindTest.test(type);
            }

            @Override
            public Boolean visit(ImportType type) {
                return kindTest.test(type);
            }

            @Override
            public Boolean visit(FunctionType type) {
                return kindTest.test(type);
            }
        });
    }

    public static boolean containsKinds(SoyType type, Set<SoyType.Kind> kinds) {
        if (kinds.contains((Object)type.getKind())) {
            return true;
        }
        if (type instanceof UnionType) {
            return ((UnionType)type).getMembers().stream().map(SoyType::getKind).anyMatch(kinds::contains);
        }
        return false;
    }

    public static Iterator<? extends SoyType> getTypeTraverser(SoyType root, @Nullable SoyTypeRegistry registry) {
        return BreadthFirstStream.of(root, new SoyTypeSuccessorsFunction(registry)).iterator();
    }

    @Nullable
    public static String localToFqn(String localSymbol, Map<String, String> localToFqn) {
        String fqnRoot;
        if (localToFqn.containsKey(localSymbol)) {
            return localToFqn.get(localSymbol);
        }
        String localRoot = SoyTypes.getFirstSegment(localSymbol);
        if (!localToFqn.containsKey(localRoot)) {
            localRoot = SoyTypes.getFirstTwoSegments(localSymbol);
        }
        if ((fqnRoot = localToFqn.get(localRoot)) == null) {
            return null;
        }
        return localSymbol.replaceFirst(localRoot, fqnRoot);
    }

    private static String getFirstSegment(String symbol) {
        int index = symbol.indexOf(46);
        return index >= 0 ? symbol.substring(0, index) : symbol;
    }

    private static String getFirstTwoSegments(String symbol) {
        int firstDot = symbol.indexOf(46);
        int secondDot = symbol.indexOf(46, firstDot + 1);
        if (secondDot >= 0) {
            return symbol.substring(0, secondDot);
        }
        return symbol;
    }

    private static /* synthetic */ boolean lambda$transitivelyContainsKind$2(Set kinds, SoyType t) {
        return kinds.contains((Object)t.getKind());
    }

    private static class SoyTypeSuccessorsFunction
    implements Function<SoyType, Iterable<? extends SoyType>> {
        private final SoyTypeRegistry typeRegistry;

        public SoyTypeSuccessorsFunction(@Nullable SoyTypeRegistry typeRegistry) {
            this.typeRegistry = typeRegistry;
        }

        @Override
        public Iterable<? extends SoyType> apply(SoyType type) {
            switch (type.getKind()) {
                case UNION: {
                    return ((UnionType)type).getMembers();
                }
                case LIST: {
                    return ImmutableList.of((Object)((ListType)type).getElementType());
                }
                case MAP: 
                case LEGACY_OBJECT_MAP: {
                    AbstractMapType mapType = (AbstractMapType)type;
                    return ImmutableList.of((Object)mapType.getKeyType(), (Object)mapType.getValueType());
                }
                case RECORD: {
                    return ((RecordType)type).getMembers().stream().map(RecordType.Member::type).collect(Collectors.toList());
                }
                case VE: {
                    VeType veType = (VeType)type;
                    if (this.typeRegistry == null || !veType.getDataType().isPresent()) break;
                    String protoFqn = veType.getDataType().get();
                    SoyType protoType = this.typeRegistry.getProtoRegistry().getProtoType(protoFqn);
                    if (protoType == null) {
                        throw new IllegalArgumentException(protoFqn);
                    }
                    return ImmutableList.of((Object)protoType);
                }
            }
            return ImmutableList.of();
        }
    }

    public static final class SoyTypeArithmeticOperator
    implements SoyTypeBinaryOperator {
        @Override
        @Nullable
        public SoyType resolve(SoyType left, SoyType right) {
            Optional<SoyType> arithmeticType = SoyTypes.computeLowestCommonTypeArithmetic(left, right);
            return arithmeticType.orElse(null);
        }
    }

    public static final class SoyTypePlusOperator
    implements SoyTypeBinaryOperator {
        private boolean isIllegalOperandForPlusOps(SoyType type) {
            return type.getKind().isIllegalOperandForBinaryOps() && !type.getKind().isKnownStringOrSanitizedContent();
        }

        @Override
        @Nullable
        public SoyType resolve(SoyType left, SoyType right) {
            Optional<SoyType> arithmeticType = SoyTypes.computeLowestCommonTypeArithmetic(left, right);
            if (arithmeticType.isPresent()) {
                return arithmeticType.get();
            }
            if (this.isIllegalOperandForPlusOps(left) || this.isIllegalOperandForPlusOps(right)) {
                return null;
            }
            if (left.getKind().isKnownStringOrSanitizedContent() || right.getKind().isKnownStringOrSanitizedContent()) {
                return StringType.getInstance();
            }
            return null;
        }
    }

    public static final class SoyTypeComparisonOp
    implements SoyTypeBinaryOperator {
        @Override
        @Nullable
        public SoyType resolve(SoyType left, SoyType right) {
            BoolType boolType = BoolType.getInstance();
            if (SoyTypes.isDefiniteComparable(left) || SoyTypes.isDefiniteComparable(right)) {
                return boolType;
            }
            if (SoyTypes.isNumericPrimitive(left) && SoyTypes.isNumericPrimitive(right)) {
                return boolType;
            }
            if (left.getKind().isKnownStringOrSanitizedContent() && right.getKind().isKnownStringOrSanitizedContent()) {
                return boolType;
            }
            return null;
        }
    }

    public static final class SoyTypeEqualComparisonOp
    implements SoyTypeBinaryOperator {
        @Override
        @Nullable
        public SoyType resolve(SoyType left, SoyType right) {
            BoolType boolType = BoolType.getInstance();
            if (SoyTypes.isDefiniteComparable(left) || SoyTypes.isDefiniteComparable(right)) {
                return boolType;
            }
            if (SoyTypes.isDefinitePrimitive(left) && SoyTypes.isDefinitePrimitive(right)) {
                return boolType;
            }
            return left.equals(right) ? boolType : null;
        }
    }

    public static interface SoyTypeBinaryOperator {
        public SoyType resolve(SoyType var1, SoyType var2);
    }
}

