/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.types;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.protobuf.Descriptors;
import com.google.template.soy.base.SoyBackendKind;
import com.google.template.soy.internal.proto.Field;
import com.google.template.soy.internal.proto.FieldVisitor;
import com.google.template.soy.internal.proto.JavaQualifiedNames;
import com.google.template.soy.internal.proto.ProtoUtils;
import com.google.template.soy.soytree.SoyTypeP;
import com.google.template.soy.types.BoolType;
import com.google.template.soy.types.FloatType;
import com.google.template.soy.types.IntType;
import com.google.template.soy.types.ProtoTypeRegistry;
import com.google.template.soy.types.SanitizedType;
import com.google.template.soy.types.SoyType;
import com.google.template.soy.types.SoyTypeVisitor;
import com.google.template.soy.types.StringType;
import com.google.template.soy.types.TypeInterner;
import com.google.template.soy.types.TypeRegistries;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;

public final class SoyProtoType
extends SoyType {
    private final Object scope;
    private final Descriptors.Descriptor typeDescriptor;
    private final ImmutableMap<String, FieldWithType> fields;
    private final ImmutableSet<String> extensionFieldNames;

    public static SoyProtoType newForTest(Descriptors.Descriptor d) {
        return new SoyProtoType(TypeRegistries.newTypeInterner(), fqn -> null, d, (Set<Descriptors.FieldDescriptor>)ImmutableSet.of());
    }

    SoyProtoType(TypeInterner interner, ProtoTypeRegistry registry, Descriptors.Descriptor descriptor, Set<Descriptors.FieldDescriptor> extensions) {
        this((Object)interner, new TypeVisitor(interner, registry), descriptor, extensions);
    }

    private SoyProtoType(Object scope, TypeVisitor visitor, Descriptors.Descriptor descriptor, Set<Descriptors.FieldDescriptor> extensions) {
        this.scope = scope;
        this.typeDescriptor = descriptor;
        this.fields = Field.getFieldsForType(descriptor, extensions, fieldDescriptor -> new FieldWithType(fieldDescriptor, visitor));
        this.extensionFieldNames = (ImmutableSet)extensions.stream().map(Field::computeSoyFullyQualifiedName).sorted().collect(ImmutableSet.toImmutableSet());
    }

    @Override
    public SoyType.Kind getKind() {
        return SoyType.Kind.PROTO;
    }

    @Override
    boolean doIsAssignableFromNonUnionType(SoyType fromType) {
        return fromType == this;
    }

    public Descriptors.Descriptor getDescriptor() {
        return this.typeDescriptor;
    }

    public String getDescriptorExpression() {
        return ProtoUtils.getQualifiedOuterClassname((Descriptors.GenericDescriptor)this.typeDescriptor);
    }

    public Descriptors.FieldDescriptor getFieldDescriptor(String fieldName) {
        FieldWithType field = (FieldWithType)this.fields.get((Object)fieldName);
        if (field == null) {
            throw new IllegalArgumentException(String.format("Cannot find field %s in %s. Known fields are %s.", fieldName, this, this.getFieldNames()));
        }
        return field.getDescriptor();
    }

    @Nullable
    public SoyType getFieldType(String fieldName) {
        FieldWithType field = (FieldWithType)this.fields.get((Object)fieldName);
        return field != null ? field.getType() : null;
    }

    public ImmutableSet<String> getFieldNames() {
        return this.fields.keySet();
    }

    public ImmutableSet<String> getExtensionFieldNames() {
        return this.extensionFieldNames;
    }

    public String getNameForBackend(SoyBackendKind backend) {
        switch (backend) {
            case JS_SRC: {
                return ProtoUtils.calculateQualifiedJsName((Descriptors.GenericDescriptor)this.typeDescriptor);
            }
            case TOFU: 
            case JBC_SRC: {
                return JavaQualifiedNames.getClassName(this.typeDescriptor);
            }
            case PYTHON_SRC: {
                throw new UnsupportedOperationException();
            }
        }
        throw new AssertionError((Object)backend);
    }

    @Override
    public String toString() {
        return this.typeDescriptor.getFullName();
    }

    @Override
    void doToProto(SoyTypeP.Builder builder) {
        builder.setProto(this.typeDescriptor.getFullName());
    }

    public boolean shouldCheckFieldPresenceToEmulateJspbNullability(String fieldName) {
        return ((FieldWithType)this.fields.get((Object)fieldName)).shouldCheckFieldPresenceToEmulateJspbNullability();
    }

    @Override
    public <T> T accept(SoyTypeVisitor<T> visitor) {
        return visitor.visit(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SoyProtoType that = (SoyProtoType)o;
        if (this.scope != that.scope) {
            throw new IllegalArgumentException(String.format("Illegal comparison of two SoyProtoType's from different type registries %s and %s.", this.scope, that.scope));
        }
        return com.google.common.base.Objects.equal((Object)this.typeDescriptor.getFullName(), (Object)that.typeDescriptor.getFullName());
    }

    public int hashCode() {
        return Objects.hashCode(this.typeDescriptor.getFullName());
    }

    private static final class FieldWithType
    extends Field {
        @GuardedBy(value="this")
        SoyType type;
        @GuardedBy(value="this")
        TypeVisitor visitor;

        FieldWithType(Descriptors.FieldDescriptor fieldDesc, TypeVisitor visitor) {
            super(fieldDesc);
            this.visitor = visitor;
        }

        synchronized SoyType getType() {
            if (this.type == null) {
                this.type = FieldVisitor.visitField(this.getDescriptor(), this.visitor);
                Preconditions.checkNotNull((Object)this.type, (String)"Couldn't find a type for: %s", (Object)this.getDescriptor());
                this.visitor = null;
            }
            return this.type;
        }
    }

    private static final class TypeVisitor
    extends FieldVisitor<SoyType> {
        private final TypeInterner interner;
        private final ProtoTypeRegistry registry;

        TypeVisitor(TypeInterner interner, ProtoTypeRegistry registry) {
            this.interner = interner;
            this.registry = registry;
        }

        @Override
        protected SoyType visitMap(Descriptors.FieldDescriptor mapField, SoyType keyType, SoyType valueType) {
            return this.interner.getOrCreateMapType(keyType, valueType);
        }

        @Override
        protected SoyType visitRepeated(SoyType value) {
            return this.interner.getOrCreateListType(value);
        }

        @Override
        protected SoyType visitMessage(Descriptors.Descriptor messageType) {
            return this.registry.getProtoType(messageType.getFullName());
        }

        @Override
        protected SoyType visitEnum(Descriptors.EnumDescriptor enumType, Descriptors.FieldDescriptor fieldType) {
            return this.registry.getProtoType(enumType.getFullName());
        }

        @Override
        protected SoyType visitLongAsInt() {
            return IntType.getInstance();
        }

        @Override
        protected SoyType visitUnsignedInt() {
            return IntType.getInstance();
        }

        @Override
        protected SoyType visitUnsignedLongAsString() {
            return StringType.getInstance();
        }

        @Override
        protected SoyType visitLongAsString() {
            return StringType.getInstance();
        }

        @Override
        protected SoyType visitBool() {
            return BoolType.getInstance();
        }

        @Override
        protected SoyType visitInt() {
            return IntType.getInstance();
        }

        @Override
        protected SoyType visitBytes() {
            return StringType.getInstance();
        }

        @Override
        protected SoyType visitString() {
            return StringType.getInstance();
        }

        @Override
        protected SoyType visitDoubleAsFloat() {
            return FloatType.getInstance();
        }

        @Override
        protected SoyType visitFloat() {
            return FloatType.getInstance();
        }

        @Override
        protected SoyType visitSafeHtml() {
            return SanitizedType.HtmlType.getInstance();
        }

        @Override
        protected SoyType visitSafeScript() {
            return SanitizedType.JsType.getInstance();
        }

        @Override
        protected SoyType visitSafeStyle() {
            return SanitizedType.StyleType.getInstance();
        }

        @Override
        protected SoyType visitSafeStyleSheet() {
            return SanitizedType.StyleType.getInstance();
        }

        @Override
        protected SoyType visitSafeUrl() {
            return SanitizedType.UriType.getInstance();
        }

        @Override
        protected SoyType visitTrustedResourceUrl() {
            return SanitizedType.TrustedResourceUriType.getInstance();
        }
    }
}

