/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.basetree.CopyState;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.exprtree.ExprEquivalence;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.soytree.AbstractBlockCommandNode;
import com.google.template.soy.soytree.CommandTagAttribute;
import com.google.template.soy.soytree.HtmlCloseTagNode;
import com.google.template.soy.soytree.HtmlOpenTagNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.SoyTreeUtils;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;

public final class VeLogNode
extends AbstractBlockCommandNode
implements SoyNode.ExprHolderNode,
SoyNode.StatementNode,
SoyNode.MsgBlockNode,
CommandTagAttribute.CommandTagAttributesHolder {
    private static final SoyErrorKind DATA_ATTRIBUTE_UNSUPPORTED = SoyErrorKind.of("The ''data='' attribute is no longer supported, use the new data syntax instead: '''{velog ve_data(MyVe, $data)}'''.", new SoyErrorKind.StyleAllowance[0]);
    private final ExprRootNode veDataExpr;
    private boolean needsSyntheticVelogNode = false;
    private final List<CommandTagAttribute> attributes;
    @Nullable
    private final ExprRootNode logonlyExpr;

    public VeLogNode(int id, SourceLocation location, SourceLocation openTagLocation, ExprNode veDataExpr, List<CommandTagAttribute> attributes, ErrorReporter errorReporter) {
        super(id, location, openTagLocation, "velog");
        this.veDataExpr = new ExprRootNode((ExprNode)Preconditions.checkNotNull((Object)veDataExpr));
        ExprRootNode logonlyExpr = null;
        this.attributes = attributes;
        block8: for (CommandTagAttribute attr : attributes) {
            switch (attr.getName().identifier()) {
                case "logonly": {
                    logonlyExpr = attr.valueAsExpr(errorReporter);
                    continue block8;
                }
                case "data": {
                    errorReporter.report(attr.getName().location(), DATA_ATTRIBUTE_UNSUPPORTED, new Object[0]);
                    continue block8;
                }
            }
            errorReporter.report(attr.getName().location(), CommandTagAttribute.UNSUPPORTED_ATTRIBUTE_KEY, attr.getName().identifier(), "velog", ImmutableList.of((Object)"logonly"));
        }
        this.logonlyExpr = logonlyExpr;
    }

    private VeLogNode(VeLogNode orig, CopyState copyState) {
        super(orig, copyState);
        this.veDataExpr = orig.veDataExpr.copy(copyState);
        this.attributes = (List)orig.attributes.stream().map(c -> c.copy(copyState)).collect(ImmutableList.toImmutableList());
        this.logonlyExpr = orig.logonlyExpr == null ? null : orig.logonlyExpr.copy(copyState);
        this.needsSyntheticVelogNode = orig.needsSyntheticVelogNode;
        copyState.updateRefs(orig, this);
    }

    @Override
    public List<CommandTagAttribute> getAttributes() {
        return this.attributes;
    }

    SamenessKey getSamenessKey() {
        return new SamenessKey(this);
    }

    public void setNeedsSyntheticVelogNode(boolean needsSyntheticVelogNode) {
        this.needsSyntheticVelogNode = needsSyntheticVelogNode;
    }

    public boolean needsSyntheticVelogNode() {
        return this.needsSyntheticVelogNode;
    }

    public ExprRootNode getVeDataExpression() {
        return this.veDataExpr;
    }

    @Nullable
    public ExprRootNode getLogonlyExpression() {
        return this.logonlyExpr;
    }

    @Override
    public SoyNode.Kind getKind() {
        return SoyNode.Kind.VE_LOG_NODE;
    }

    @Nullable
    public HtmlOpenTagNode getOpenTagNode() {
        if (this.numChildren() > 0) {
            return (HtmlOpenTagNode)SoyTreeUtils.getNodeAsHtmlTagNode((SoyNode)this.getChild(0), true);
        }
        return null;
    }

    @Nullable
    public HtmlCloseTagNode getCloseTagNode() {
        if (this.numChildren() > 1) {
            return (HtmlCloseTagNode)SoyTreeUtils.getNodeAsHtmlTagNode((SoyNode)this.getChild(this.numChildren() - 1), false);
        }
        return null;
    }

    @Override
    public String getCommandText() {
        return this.veDataExpr.toSourceString() + (this.logonlyExpr != null ? " logonly=\"" + this.logonlyExpr.toSourceString() + "\"" : "");
    }

    @Override
    public SoyNode.BlockNode getParent() {
        return (SoyNode.BlockNode)super.getParent();
    }

    @Override
    public VeLogNode copy(CopyState copyState) {
        return new VeLogNode(this, copyState);
    }

    @Override
    public ImmutableList<ExprRootNode> getExprList() {
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.add((Object)this.veDataExpr);
        if (this.logonlyExpr != null) {
            builder.add((Object)this.logonlyExpr);
        }
        return builder.build();
    }

    @Override
    public String toSourceString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getTagString());
        this.appendSourceStringForChildren(sb);
        sb.append("{/velog}");
        return sb.toString();
    }

    static final class SamenessKey {
        private VeLogNode delegate;

        private SamenessKey(VeLogNode delegate) {
            this.delegate = delegate;
        }

        private SamenessKey(SamenessKey orig, CopyState copyState) {
            this.delegate = orig.delegate;
            copyState.registerRefListener(orig.delegate, newDelegate -> {
                this.delegate = newDelegate;
            });
        }

        SamenessKey copy(CopyState copyState) {
            return new SamenessKey(this, copyState);
        }

        public boolean equals(Object other) {
            if (!(other instanceof SamenessKey)) {
                return false;
            }
            ExprEquivalence exprEquivalence = new ExprEquivalence();
            SamenessKey otherKey = (SamenessKey)other;
            return exprEquivalence.equivalent(this.delegate.veDataExpr, otherKey.delegate.veDataExpr) && exprEquivalence.equivalent(this.delegate.logonlyExpr, otherKey.delegate.logonlyExpr);
        }

        public int hashCode() {
            return new ExprEquivalence().hash(Arrays.asList(this.delegate.veDataExpr, this.delegate.logonlyExpr));
        }
    }
}

