/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.base.internal.Identifier;
import com.google.template.soy.basetree.CopyState;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.soytree.AbstractBlockNode;
import com.google.template.soy.soytree.ForNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.defn.LocalVar;
import javax.annotation.Nullable;

public final class ForNonemptyNode
extends AbstractBlockNode
implements SoyNode.ConditionalBlockNode,
SoyNode.LocalVarBlockNode {
    private final LocalVar var;
    @Nullable
    private final LocalVar indexVar;

    public ForNonemptyNode(int id, Identifier varIdentifier, Identifier indexVarIdentifier, SourceLocation contentLocation) {
        super(id, contentLocation);
        this.var = new LocalVar(varIdentifier.identifier(), varIdentifier.location(), this, null);
        this.indexVar = indexVarIdentifier == null ? null : new LocalVar(indexVarIdentifier.identifier(), indexVarIdentifier.location(), this, null);
    }

    private ForNonemptyNode(ForNonemptyNode orig, CopyState copyState) {
        super(orig, copyState);
        this.var = new LocalVar(orig.var, this);
        this.indexVar = orig.indexVar == null ? null : new LocalVar(orig.indexVar, this);
        copyState.updateRefs(orig.var, this.var);
        if (orig.indexVar != null) {
            copyState.updateRefs(orig.indexVar, this.indexVar);
        }
    }

    @Override
    public SoyNode.Kind getKind() {
        return SoyNode.Kind.FOR_NONEMPTY_NODE;
    }

    public int getForNodeId() {
        return this.getParent().getId();
    }

    public final LocalVar getVar() {
        return this.var;
    }

    @Nullable
    public final LocalVar getIndexVar() {
        return this.indexVar;
    }

    @Nullable
    public final String getIndexVarName() {
        return this.indexVar.name();
    }

    public ExprRootNode getExpr() {
        return this.getParent().getExpr();
    }

    @Override
    public String toSourceString() {
        StringBuilder sb = new StringBuilder();
        this.appendSourceStringForChildren(sb);
        return sb.toString();
    }

    @Override
    public ForNode getParent() {
        return (ForNode)super.getParent();
    }

    @Override
    public ForNonemptyNode copy(CopyState copyState) {
        return new ForNonemptyNode(this, copyState);
    }
}

