/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.common.base.CaseFormat;
import com.google.common.collect.ImmutableMap;
import com.google.template.soy.base.internal.SanitizedContentKind;
import java.util.Map;
import javax.annotation.Nullable;

public enum EscapingMode {
    ESCAPE_HTML(true, SanitizedContentKind.HTML, true),
    NORMALIZE_HTML(true, null, true),
    ESCAPE_HTML_RCDATA(true, null, true),
    FILTER_HTML_SCRIPT_PHRASING_DATA(false, null, true),
    ESCAPE_HTML_ATTRIBUTE(true, null, true),
    ESCAPE_HTML_HTML_ATTRIBUTE(false, null, true),
    ESCAPE_HTML_ATTRIBUTE_NOSPACE(true, null, true),
    FILTER_NUMBER(true, null, true),
    FILTER_HTML_ELEMENT_NAME(true, null, true),
    FILTER_HTML_ATTRIBUTES(true, null, true),
    ESCAPE_JS_STRING(false, null, true),
    ESCAPE_JS_VALUE(false, null, true),
    ESCAPE_JS_REGEX(false, null, true),
    ESCAPE_CSS_STRING(true, null, true),
    FILTER_CSS_VALUE(false, SanitizedContentKind.CSS, true),
    ESCAPE_URI(true, SanitizedContentKind.URI),
    NORMALIZE_URI(false, SanitizedContentKind.URI),
    FILTER_NORMALIZE_URI(false, SanitizedContentKind.URI, true),
    FILTER_NORMALIZE_MEDIA_URI(false, SanitizedContentKind.URI, true),
    FILTER_NORMALIZE_REFRESH_URI(false, SanitizedContentKind.URI, true),
    FILTER_TRUSTED_RESOURCE_URI(false, null, true),
    TEXT(false, SanitizedContentKind.TEXT, true);

    public final String directiveName = "|" + CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, this.name());
    public final boolean isHtmlEmbeddable;
    @Nullable
    public final SanitizedContentKind contentKind;
    public final boolean isInternalOnly;
    private static final Map<String, EscapingMode> DIRECTIVE_TO_ESCAPING_MODE;

    private EscapingMode(boolean escapesQuotes, SanitizedContentKind contentKind, boolean internalOnly) {
        this.isHtmlEmbeddable = escapesQuotes;
        this.contentKind = contentKind;
        this.isInternalOnly = internalOnly;
    }

    private EscapingMode(boolean escapesQuotes, SanitizedContentKind contentKind) {
        this(escapesQuotes, contentKind, false);
    }

    @Nullable
    public static EscapingMode fromDirective(String directiveName) {
        return DIRECTIVE_TO_ESCAPING_MODE.get(directiveName);
    }

    public String toString() {
        return this.directiveName;
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (EscapingMode mode : EscapingMode.values()) {
            builder.put((Object)mode.directiveName, (Object)mode);
        }
        DIRECTIVE_TO_ESCAPING_MODE = builder.buildOrThrow();
    }
}

