/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.base.internal.BaseUtils;
import com.google.template.soy.base.internal.Identifier;
import com.google.template.soy.base.internal.QuoteStyle;
import com.google.template.soy.basetree.CopyState;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.shared.restricted.SoyPrintDirective;
import com.google.template.soy.soytree.AbstractParentCommandNode;
import com.google.template.soy.soytree.CallParamNode;
import com.google.template.soy.soytree.CommandTagAttribute;
import com.google.template.soy.soytree.HtmlContext;
import com.google.template.soy.soytree.MessagePlaceholder;
import com.google.template.soy.soytree.SoyNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;

public abstract class CallNode
extends AbstractParentCommandNode<CallParamNode>
implements SoyNode.StandaloneNode,
SoyNode.SplitLevelTopNode<CallParamNode>,
SoyNode.StatementNode,
HtmlContext.HtmlContextHolder,
SoyNode.ExprHolderNode,
SoyNode.MsgPlaceholderInitialNode,
CommandTagAttribute.CommandTagAttributesHolder {
    private static final String FALLBACK_BASE_PLACEHOLDER_NAME = "XXX";
    static final String KEY = "key";
    static final String DATA = "data";
    private boolean isPassingAllData;
    private final boolean selfClosing;
    private ImmutableList<CommandTagAttribute> attributes;
    private final SourceLocation openTagLocation;
    private final MessagePlaceholder placeholder;
    @Nullable
    private HtmlContext htmlContext;
    @Nullable
    private String callKey;
    private ImmutableList<SoyPrintDirective> escapingDirectives = ImmutableList.of();
    private boolean isPcData = false;

    protected CallNode(int id, SourceLocation location, SourceLocation openTagLocation, String commandName, List<CommandTagAttribute> attributes, boolean selfClosing, ErrorReporter reporter) {
        super(id, location, commandName);
        SourceLocation phNameLocation = null;
        String phName = null;
        Optional<String> phExample = Optional.empty();
        for (CommandTagAttribute attr : attributes) {
            String name;
            switch (name = attr.getName().identifier()) {
                case "data": {
                    if (!attr.hasExprValue() && "all".equals(attr.getValue())) {
                        this.isPassingAllData = true;
                        break;
                    }
                    this.isPassingAllData = false;
                    attr.checkAsExpr(reporter);
                    break;
                }
                case "key": {
                    attr.checkAsExpr(reporter);
                    break;
                }
                case "phname": {
                    phNameLocation = attr.getValueLocation();
                    phName = MessagePlaceholder.validatePlaceholderName(attr.getValue(), phNameLocation, reporter);
                    break;
                }
                case "phex": {
                    phExample = Optional.ofNullable(MessagePlaceholder.validatePlaceholderExample(attr.getValue(), attr.getValueLocation(), reporter));
                    break;
                }
            }
        }
        this.attributes = ImmutableList.copyOf(attributes);
        this.selfClosing = selfClosing;
        this.placeholder = phName == null ? MessagePlaceholder.create(FALLBACK_BASE_PLACEHOLDER_NAME, phExample) : MessagePlaceholder.createWithUserSuppliedName(BaseUtils.convertToUpperUnderscore(phName), phName, phNameLocation, phExample);
        this.openTagLocation = openTagLocation;
    }

    protected CallNode(CallNode orig, CopyState copyState) {
        super(orig, copyState);
        this.isPassingAllData = orig.isPassingAllData;
        this.placeholder = orig.placeholder;
        this.escapingDirectives = orig.escapingDirectives;
        this.callKey = orig.callKey;
        this.isPcData = orig.getIsPcData();
        this.htmlContext = orig.htmlContext;
        this.openTagLocation = orig.openTagLocation;
        this.selfClosing = orig.selfClosing;
        this.attributes = (ImmutableList)orig.attributes.stream().map(c -> c.copy(copyState)).collect(ImmutableList.toImmutableList());
        copyState.updateRefs(orig, this);
    }

    @Override
    public HtmlContext getHtmlContext() {
        return (HtmlContext)((Object)Preconditions.checkNotNull((Object)((Object)this.htmlContext), (Object)"Cannot access HtmlContext before HtmlContextVisitor or InferenceEngine."));
    }

    public void setHtmlContext(HtmlContext value) {
        this.htmlContext = value;
    }

    public boolean isPassingData() {
        return this.isPassingAllData || this.getDataExpr() != null;
    }

    public void setTemplateCallKey(String key) {
        this.callKey = key;
    }

    public String getTemplateCallKey() {
        return this.callKey;
    }

    public boolean isPassingAllData() {
        return this.isPassingAllData;
    }

    public boolean isSelfClosing() {
        return this.selfClosing;
    }

    @Override
    public List<CommandTagAttribute> getAttributes() {
        return this.attributes;
    }

    @Nullable
    public ExprRootNode getDataExpr() {
        return this.attributes.stream().filter(a -> a.hasName(DATA) && a.hasExprValue()).findFirst().map(a -> (ExprRootNode)a.valueAsExprList().get(0)).orElse(null);
    }

    @Nullable
    public ExprRootNode getKeyExpr() {
        return this.attributes.stream().filter(a -> a.hasName(KEY)).findFirst().map(a -> (ExprRootNode)a.valueAsExprList().get(0)).orElse(null);
    }

    public void setKeyExpr(ExprRootNode expr) {
        CommandTagAttribute existing = this.attributes.stream().filter(a -> a.hasName(KEY)).findFirst().orElse(null);
        if (existing == null && expr == null) {
            return;
        }
        ArrayList<CommandTagAttribute> newAttr = new ArrayList<CommandTagAttribute>((Collection<CommandTagAttribute>)this.attributes);
        if (existing != null) {
            newAttr.remove(existing);
            if (expr != null) {
                newAttr.add(new CommandTagAttribute(existing.getName(), existing.getQuoteStyle(), (ImmutableList<ExprNode>)ImmutableList.of((Object)expr.getRoot()), existing.getSourceLocation()));
            }
        } else {
            newAttr.add(new CommandTagAttribute(Identifier.create(KEY, SourceLocation.UNKNOWN), QuoteStyle.DOUBLE, (ImmutableList<ExprNode>)ImmutableList.of((Object)expr.getRoot()), SourceLocation.UNKNOWN));
        }
        this.attributes = ImmutableList.copyOf(newAttr);
    }

    public boolean getIsPcData() {
        return this.isPcData;
    }

    public void setIsPcData(boolean isPcData) {
        this.isPcData = isPcData;
    }

    @Override
    public MessagePlaceholder getPlaceholder() {
        return this.placeholder;
    }

    @Override
    public SoyNode.MsgPlaceholderInitialNode.SamenessKey genSamenessKey() {
        return new SoyNode.MsgPlaceholderInitialNode.IdentitySamenessKey(this);
    }

    @Override
    public String getTagString() {
        return this.getTagString(this.numChildren() == 0);
    }

    @Override
    public String toSourceString() {
        return this.numChildren() == 0 ? this.getTagString() : super.toSourceString();
    }

    @Override
    public ImmutableList<ExprRootNode> getExprList() {
        return (ImmutableList)this.attributes.stream().filter(CommandTagAttribute::hasExprValue).flatMap(a -> a.valueAsExprList().stream()).collect(ImmutableList.toImmutableList());
    }

    @Override
    public SoyNode.ParentSoyNode<SoyNode.StandaloneNode> getParent() {
        return super.getParent();
    }

    @Override
    public SourceLocation getOpenTagLocation() {
        return this.openTagLocation;
    }

    public abstract SourceLocation getSourceCalleeLocation();

    public ImmutableList<SoyPrintDirective> getEscapingDirectives() {
        return this.escapingDirectives;
    }

    public void setEscapingDirectives(ImmutableList<SoyPrintDirective> escapingDirectives) {
        this.escapingDirectives = escapingDirectives;
    }
}

