/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.base.internal.Identifier;
import com.google.template.soy.basetree.CopyState;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.soytree.CallNode;
import com.google.template.soy.soytree.CommandTagAttribute;
import com.google.template.soy.soytree.SoyNode;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;

public final class CallDelegateNode
extends CallNode {
    private final Identifier sourceDelCalleeName;
    private final String delCalleeName;
    private final boolean allowEmptyDefault;
    private final Supplier<ExprRootNode> memoizedVariantExpr = Suppliers.memoize(() -> this.getAttributes().stream().filter(a -> "variant".equals(a.getName().identifier()) && a.hasExprValue()).findFirst().map(a -> (ExprRootNode)a.valueAsExprList().get(0)).orElse(null));

    public CallDelegateNode(int id, SourceLocation location, SourceLocation openTagLocation, Identifier delCalleeName, List<CommandTagAttribute> attributes, boolean selfClosing, ErrorReporter errorReporter) {
        super(id, location, openTagLocation, "delcall", attributes, selfClosing, errorReporter);
        this.delCalleeName = delCalleeName.identifier();
        this.sourceDelCalleeName = delCalleeName;
        boolean allowEmptyDefault = false;
        block13: for (CommandTagAttribute attr : attributes) {
            String name;
            switch (name = attr.getName().identifier()) {
                case "data": 
                case "key": 
                case "phname": 
                case "phex": {
                    continue block13;
                }
                case "variant": {
                    continue block13;
                }
                case "allowemptydefault": {
                    allowEmptyDefault = attr.valueAsEnabled(errorReporter);
                    continue block13;
                }
            }
            errorReporter.report(attr.getName().location(), CommandTagAttribute.UNSUPPORTED_ATTRIBUTE_KEY, name, "call", ImmutableList.of((Object)"data", (Object)"key", (Object)"phname", (Object)"phex", (Object)"variant", (Object)"allowemptydefault"));
        }
        this.allowEmptyDefault = allowEmptyDefault;
    }

    private CallDelegateNode(CallDelegateNode orig, CopyState copyState) {
        super(orig, copyState);
        this.delCalleeName = orig.delCalleeName;
        this.sourceDelCalleeName = orig.sourceDelCalleeName;
        this.allowEmptyDefault = orig.allowEmptyDefault;
    }

    @Override
    public SoyNode.Kind getKind() {
        return SoyNode.Kind.CALL_DELEGATE_NODE;
    }

    public String getDelCalleeName() {
        return this.delCalleeName;
    }

    @Override
    public SourceLocation getSourceCalleeLocation() {
        return this.sourceDelCalleeName.location();
    }

    @Nullable
    public ExprRootNode getDelCalleeVariantExpr() {
        return this.memoizedVariantExpr.get();
    }

    public boolean allowEmptyDefault() {
        return this.allowEmptyDefault;
    }

    @Override
    public String getCommandText() {
        StringBuilder commandText = new StringBuilder(this.delCalleeName);
        if (this.isPassingAllData()) {
            commandText.append(" data=\"all\"");
        } else if (this.getDataExpr() != null) {
            commandText.append(" data=\"").append(this.getDataExpr().toSourceString()).append('\"');
        }
        this.getPlaceholder().userSuppliedName().ifPresent(phname -> commandText.append(" phname=\"").append((String)phname).append('\"'));
        this.getPlaceholder().example().ifPresent(phex -> commandText.append(" phex=\"").append((String)phex).append('\"'));
        ExprRootNode variantExpr = this.getDelCalleeVariantExpr();
        if (variantExpr != null) {
            commandText.append(" variant=\"").append(variantExpr.toSourceString()).append('\"');
        }
        if (this.allowEmptyDefault) {
            commandText.append(" allowemptydefault=\"true\"");
        }
        return commandText.toString();
    }

    @Override
    public CallDelegateNode copy(CopyState copyState) {
        return new CallDelegateNode(this, copyState);
    }
}

