/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soyparse;

import com.google.common.base.Preconditions;
import com.google.template.soy.base.SourceFilePath;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.base.internal.IdGenerator;
import com.google.template.soy.soyparse.SoyFileParserConstants;
import com.google.template.soy.soyparse.Token;
import com.google.template.soy.soyparse.Tokens;
import com.google.template.soy.soytree.CommandChar;
import com.google.template.soy.soytree.RawTextNode;
import com.google.template.soy.soytree.WhitespaceMode;
import javax.annotation.Nullable;

final class RawTextBuilder {
    private final RawTextNode.SourceOffsets.Builder offsets = new RawTextNode.SourceOffsets.Builder();
    private final StringBuilder buffer = new StringBuilder();
    private final SourceFilePath fileName;
    private final IdGenerator nodeIdGen;
    private final WhitespaceMode whitespaceMode;
    private int basicStart = -1;
    private int basicStartOfWhitespace = -1;
    private int endLineAtStartOfWhitespace;
    private int endColumnAtStartOfWhitespace;
    private boolean basicHasNewline = false;
    private RawTextNode.SourceOffsets.Reason discontinuityReason = RawTextNode.SourceOffsets.Reason.NONE;

    RawTextBuilder(SourceFilePath fileName, IdGenerator nodeIdGen, WhitespaceMode whitespaceMode) {
        this.fileName = (SourceFilePath)Preconditions.checkNotNull((Object)fileName);
        this.nodeIdGen = (IdGenerator)Preconditions.checkNotNull((Object)nodeIdGen);
        this.whitespaceMode = (WhitespaceMode)((Object)Preconditions.checkNotNull((Object)((Object)whitespaceMode)));
    }

    void addBasic(Token token) {
        if (this.basicStart == -1) {
            this.basicStart = this.buffer.length();
            this.basicStartOfWhitespace = -1;
            this.basicHasNewline = false;
        }
        switch (token.kind) {
            case 105: {
                if (token.image.indexOf(13) != -1 || token.image.indexOf(10) != -1) {
                    this.basicHasNewline = true;
                }
                if (this.basicStartOfWhitespace != -1 || this.whitespaceMode != WhitespaceMode.JOIN) break;
                this.basicStartOfWhitespace = this.buffer.length();
                this.endLineAtStartOfWhitespace = this.offsets.endLine();
                this.endColumnAtStartOfWhitespace = this.offsets.endColumn();
                break;
            }
            case 106: {
                this.maybeCollapseWhitespace(token.image);
                break;
            }
            default: {
                throw new AssertionError((Object)(SoyFileParserConstants.tokenImage[token.kind] + " is not a basic text token"));
            }
        }
        this.append(token, token.image);
    }

    RawTextNode buildLiteral(Token literalContent, SourceLocation location) {
        Preconditions.checkArgument((literalContent.kind == 104 ? 1 : 0) != 0);
        return RawTextNode.newLiteral(this.nodeIdGen.genId(), literalContent.image, location);
    }

    static RawTextNode buildCommandCharNode(Token token, SourceFilePath fileName, IdGenerator nodeIdGen) {
        CommandChar commandChar = RawTextBuilder.rawTextCmdToCommandCharType(token);
        return RawTextNode.newCommandCharNode(nodeIdGen.genId(), commandChar, Tokens.createSrcLoc(fileName, token, new Token[0]));
    }

    private static CommandChar rawTextCmdToCommandCharType(Token token) {
        switch (token.kind) {
            case 50: {
                return CommandChar.SPACE;
            }
            case 53: {
                return CommandChar.CARRIAGE_RETURN;
            }
            case 52: {
                return CommandChar.NEWLINE;
            }
            case 54: {
                return CommandChar.TAB;
            }
            case 55: {
                return CommandChar.LEFT_BRACE;
            }
            case 56: {
                return CommandChar.RIGHT_BRACE;
            }
            case 57: {
                return CommandChar.NBSP;
            }
            case 51: {
                return CommandChar.NIL;
            }
        }
        throw new IllegalArgumentException("unexpected token: " + SoyFileParserConstants.tokenImage[token.kind]);
    }

    RawTextNode build() {
        this.maybeFinishBasic();
        String text = this.buffer.toString();
        RawTextNode.SourceOffsets sourceOffsets = this.offsets.build(text.length(), this.discontinuityReason);
        return new RawTextNode(this.nodeIdGen.genId(), text, sourceOffsets.getSourceLocation(this.fileName), sourceOffsets);
    }

    private void append(Token token, String content) {
        if (content.isEmpty()) {
            throw new IllegalStateException(String.format("shouldn't append empty content: %s @ %s", SoyFileParserConstants.tokenImage[token.kind], Tokens.createSrcLoc(this.fileName, token, new Token[0])));
        }
        boolean addOffset = false;
        if (this.offsets.isEmpty()) {
            addOffset = true;
        } else if (this.discontinuityReason != RawTextNode.SourceOffsets.Reason.NONE) {
            addOffset = true;
        } else if (this.offsets.endLine() == token.beginLine) {
            if (this.offsets.endColumn() + 1 != token.beginColumn) {
                addOffset = true;
                this.discontinuityReason = RawTextNode.SourceOffsets.Reason.COMMENT;
            }
        } else if (this.offsets.endLine() + 1 == token.beginLine && token.beginColumn != 1) {
            addOffset = true;
            this.discontinuityReason = RawTextNode.SourceOffsets.Reason.COMMENT;
        }
        if (addOffset) {
            this.offsets.add(this.buffer.length(), token.beginLine, token.beginColumn, this.discontinuityReason);
            this.discontinuityReason = RawTextNode.SourceOffsets.Reason.NONE;
        }
        this.offsets.setEndLocation(token.endLine, token.endColumn);
        this.buffer.append(content);
    }

    private void maybeFinishBasic() {
        if (this.basicStart != -1) {
            this.maybeCollapseWhitespace(null);
            this.basicStart = -1;
        }
    }

    private void maybeCollapseWhitespace(@Nullable String next) {
        if (this.basicStartOfWhitespace != -1) {
            if (this.basicHasNewline) {
                this.offsets.delete(this.basicStartOfWhitespace);
                if (this.basicStart == this.basicStartOfWhitespace || next == null) {
                    this.buffer.setLength(this.basicStartOfWhitespace);
                    if (next == null && this.endColumnAtStartOfWhitespace != -1) {
                        this.offsets.setEndLocation(this.endLineAtStartOfWhitespace, this.endColumnAtStartOfWhitespace);
                    }
                } else if (next.charAt(0) == '<' || this.buffer.charAt(this.basicStartOfWhitespace - 1) == '>') {
                    this.buffer.setLength(this.basicStartOfWhitespace);
                } else {
                    this.buffer.setLength(this.basicStartOfWhitespace);
                    this.buffer.append(' ');
                }
                this.discontinuityReason = RawTextNode.SourceOffsets.Reason.WHITESPACE;
                this.basicHasNewline = false;
            }
            this.basicStartOfWhitespace = -1;
        }
    }
}

