/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.sharedpasses.opti;

import com.google.template.soy.data.SoyDataException;
import com.google.template.soy.data.SoyValue;
import com.google.template.soy.data.internalutils.InternalValueUtils;
import com.google.template.soy.data.restricted.BooleanData;
import com.google.template.soy.data.restricted.FloatData;
import com.google.template.soy.data.restricted.IntegerData;
import com.google.template.soy.data.restricted.NullData;
import com.google.template.soy.data.restricted.PrimitiveData;
import com.google.template.soy.data.restricted.StringData;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.exprtree.AbstractExprNodeVisitor;
import com.google.template.soy.exprtree.BooleanNode;
import com.google.template.soy.exprtree.DataAccessNode;
import com.google.template.soy.exprtree.ExprEquivalence;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.exprtree.FieldAccessNode;
import com.google.template.soy.exprtree.FloatNode;
import com.google.template.soy.exprtree.FunctionNode;
import com.google.template.soy.exprtree.IntegerNode;
import com.google.template.soy.exprtree.ItemAccessNode;
import com.google.template.soy.exprtree.ListLiteralNode;
import com.google.template.soy.exprtree.MapLiteralNode;
import com.google.template.soy.exprtree.NullNode;
import com.google.template.soy.exprtree.NullSafeAccessNode;
import com.google.template.soy.exprtree.OperatorNodes;
import com.google.template.soy.exprtree.ProtoEnumValueNode;
import com.google.template.soy.exprtree.RecordLiteralNode;
import com.google.template.soy.exprtree.StringNode;
import com.google.template.soy.logging.LoggingFunction;
import com.google.template.soy.shared.internal.BuiltinFunction;
import com.google.template.soy.sharedpasses.opti.PreevalVisitor;
import com.google.template.soy.sharedpasses.render.Environment;
import com.google.template.soy.sharedpasses.render.RenderException;
import javax.annotation.Nullable;

final class SimplifyExprVisitor
extends AbstractExprNodeVisitor<Void> {
    private static final SoyErrorKind SOY_DATA_ERROR = SoyErrorKind.of("Invalid value: {0}.", new SoyErrorKind.StyleAllowance[0]);
    private final PreevalVisitor preevalVisitor = new PreevalVisitor(Environment.prerenderingEnvironment());
    private final ErrorReporter errorReporter;

    SimplifyExprVisitor(ErrorReporter errorReporter) {
        this.errorReporter = errorReporter;
    }

    @Override
    protected void visitExprRootNode(ExprRootNode node) {
        this.visit(node.getRoot());
    }

    @Override
    protected void visitListLiteralNode(ListLiteralNode node) {
        this.visitChildren(node);
    }

    @Override
    protected void visitRecordLiteralNode(RecordLiteralNode node) {
        this.visitChildren(node);
    }

    @Override
    protected void visitMapLiteralNode(MapLiteralNode node) {
        this.visitChildren(node);
    }

    @Override
    protected void visitAndOpNode(OperatorNodes.AndOpNode node) {
        this.visitChildren(node);
        SoyValue operand0 = SimplifyExprVisitor.getConstantOrNull(node.getChild(0));
        if (operand0 != null) {
            ExprNode replacementNode = operand0.coerceToBoolean() ? node.getChild(1) : node.getChild(0);
            node.getParent().replaceChild(node, replacementNode);
        }
    }

    @Override
    protected void visitOrOpNode(OperatorNodes.OrOpNode node) {
        this.visitChildren(node);
        SoyValue operand0 = SimplifyExprVisitor.getConstantOrNull(node.getChild(0));
        if (operand0 != null) {
            ExprNode replacementNode = operand0.coerceToBoolean() ? node.getChild(0) : node.getChild(1);
            node.getParent().replaceChild(node, replacementNode);
        }
    }

    @Override
    protected void visitConditionalOpNode(OperatorNodes.ConditionalOpNode node) {
        this.visitChildren(node);
        SoyValue operand0 = SimplifyExprVisitor.getConstantOrNull(node.getChild(0));
        if (operand0 == null) {
            return;
        }
        ExprNode replacementNode = operand0.coerceToBoolean() ? node.getChild(1) : node.getChild(2);
        node.getParent().replaceChild(node, replacementNode);
    }

    @Override
    protected void visitNullCoalescingOpNode(OperatorNodes.NullCoalescingOpNode node) {
        this.visitChildren(node);
        SoyValue operand0 = SimplifyExprVisitor.getConstantOrNull(node.getChild(0));
        if (operand0 != null) {
            if (operand0 instanceof NullData) {
                node.getParent().replaceChild(node, node.getChild(1));
            } else {
                node.getParent().replaceChild(node, node.getChild(0));
            }
        } else {
            switch (node.getChild(0).getKind()) {
                case LIST_LITERAL_NODE: 
                case RECORD_LITERAL_NODE: {
                    node.getParent().replaceChild(node, node.getChild(0));
                    break;
                }
            }
        }
    }

    @Override
    protected void visitFieldAccessNode(FieldAccessNode node) {
        this.visitExprNode(node);
        if (node.getParent() == null) {
            return;
        }
        ExprNode baseExpr = node.getChild(0);
        ExprNode replacement = SimplifyExprVisitor.visitFieldAccessNode(node, baseExpr);
        if (replacement != null) {
            node.getParent().replaceChild(node, replacement);
        }
    }

    @Nullable
    private static ExprNode visitFieldAccessNode(FieldAccessNode node, ExprNode baseExpr) {
        if (baseExpr instanceof RecordLiteralNode) {
            RecordLiteralNode recordLiteral = (RecordLiteralNode)baseExpr;
            for (int i = 0; i < recordLiteral.numChildren(); ++i) {
                if (!recordLiteral.getKey(i).identifier().equals(node.getFieldName())) continue;
                return recordLiteral.getChild(i);
            }
        }
        return null;
    }

    @Override
    protected void visitItemAccessNode(ItemAccessNode node) {
        this.visitExprNode(node);
        if (node.getParent() == null) {
            return;
        }
        ExprNode baseExpr = node.getChild(0);
        ExprNode replacement = SimplifyExprVisitor.visitItemAccessNode(node, baseExpr);
        if (replacement != null) {
            node.getParent().replaceChild(node, replacement);
        }
    }

    private static ExprNode visitItemAccessNode(ItemAccessNode node, ExprNode baseExpr) {
        ExprNode keyExpr = node.getChild(1);
        if (baseExpr instanceof ListLiteralNode && keyExpr instanceof IntegerNode) {
            ListLiteralNode listLiteral = (ListLiteralNode)baseExpr;
            long index = ((IntegerNode)keyExpr).getValue();
            if (index >= 0L && index < (long)listLiteral.numChildren()) {
                return listLiteral.getChild((int)index);
            }
            return new NullNode(node.getSourceLocation());
        }
        if (baseExpr instanceof MapLiteralNode) {
            MapLiteralNode mapLiteral = (MapLiteralNode)baseExpr;
            boolean areAllKeysConstants = true;
            ExprEquivalence exprEquivalence = new ExprEquivalence();
            for (int i = 0; i < mapLiteral.numChildren(); i += 2) {
                ExprNode key = mapLiteral.getChild(i);
                ExprNode value = mapLiteral.getChild(i + 1);
                if (exprEquivalence.equivalent(keyExpr, key)) {
                    return value;
                }
                areAllKeysConstants = areAllKeysConstants && SimplifyExprVisitor.isConstant(key);
            }
            if (SimplifyExprVisitor.isConstant(keyExpr) && areAllKeysConstants) {
                return new NullNode(node.getSourceLocation());
            }
        }
        return null;
    }

    @Override
    protected void visitNullSafeAccessNode(NullSafeAccessNode node) {
        ExprNode dataAccessChild;
        block6: while (true) {
            this.visit(node.getBase());
            ExprNode base = node.getBase();
            if (base.getKind() == ExprNode.Kind.NULL_NODE) {
                node.getParent().replaceChild(node, base);
                return;
            }
            dataAccessChild = node.getDataAccess();
            switch (dataAccessChild.getKind()) {
                case ASSERT_NON_NULL_OP_NODE: {
                    return;
                }
                case NULL_SAFE_ACCESS_NODE: {
                    NullSafeAccessNode nullSafeAccessChild = (NullSafeAccessNode)dataAccessChild;
                    DataAccessNode dataAccessChain = (DataAccessNode)nullSafeAccessChild.getBase();
                    DataAccessNode dataAccessChainBase = SimplifyExprVisitor.findBaseDataAccess(dataAccessChain);
                    ExprNode replacement = SimplifyExprVisitor.findReplacement(dataAccessChainBase, base);
                    if (replacement == null) {
                        return;
                    }
                    node.getParent().replaceChild(node, nullSafeAccessChild);
                    if (dataAccessChainBase == dataAccessChain) {
                        nullSafeAccessChild.replaceChild(nullSafeAccessChild.getBase(), replacement);
                    } else {
                        dataAccessChainBase.getParent().replaceChild(dataAccessChainBase, replacement);
                    }
                    node = nullSafeAccessChild;
                    continue block6;
                }
                case FIELD_ACCESS_NODE: 
                case ITEM_ACCESS_NODE: {
                    DataAccessNode dataAccessChainBase = SimplifyExprVisitor.findBaseDataAccess((DataAccessNode)dataAccessChild);
                    ExprNode replacement = SimplifyExprVisitor.findReplacement(dataAccessChainBase, base);
                    if (replacement == null) {
                        return;
                    }
                    if (dataAccessChild == dataAccessChainBase) {
                        node.getParent().replaceChild(node, replacement);
                        this.visit(replacement);
                    } else {
                        dataAccessChainBase.getParent().replaceChild(dataAccessChainBase, replacement);
                        node.getParent().replaceChild(node, dataAccessChild);
                        this.visit(dataAccessChild);
                    }
                    return;
                }
                case METHOD_CALL_NODE: {
                    return;
                }
            }
            break;
        }
        throw new AssertionError((Object)dataAccessChild.getKind());
    }

    @Nullable
    private static ExprNode findReplacement(DataAccessNode dataAccessChainBase, ExprNode base) {
        switch (dataAccessChainBase.getKind()) {
            case FIELD_ACCESS_NODE: {
                return SimplifyExprVisitor.visitFieldAccessNode((FieldAccessNode)dataAccessChainBase, base);
            }
            case ITEM_ACCESS_NODE: {
                return SimplifyExprVisitor.visitItemAccessNode((ItemAccessNode)dataAccessChainBase, base);
            }
            case METHOD_CALL_NODE: {
                return null;
            }
        }
        throw new AssertionError((Object)dataAccessChainBase.getKind());
    }

    private static DataAccessNode findBaseDataAccess(DataAccessNode node) {
        if (node.getBaseExprChild() instanceof DataAccessNode) {
            return SimplifyExprVisitor.findBaseDataAccess((DataAccessNode)node.getBaseExprChild());
        }
        return node;
    }

    @Override
    protected void visitFunctionNode(FunctionNode node) {
        if (node.getSoyFunction() instanceof BuiltinFunction) {
            return;
        }
        if (node.getSoyFunction() instanceof LoggingFunction) {
            return;
        }
        this.visitExprNode(node);
    }

    @Override
    protected void visitExprNode(ExprNode node) {
        if (!(node instanceof ExprNode.ParentExprNode)) {
            return;
        }
        ExprNode.ParentExprNode nodeAsParent = (ExprNode.ParentExprNode)node;
        this.visitChildren(nodeAsParent);
        if (!SimplifyExprVisitor.childrenAreConstant(nodeAsParent)) {
            return;
        }
        this.attemptPreeval(nodeAsParent);
    }

    private void attemptPreeval(ExprNode node) {
        ExprNode.PrimitiveNode newNode;
        SoyValue preevalResult;
        try {
            preevalResult = (SoyValue)this.preevalVisitor.exec(node);
        }
        catch (RenderException e) {
            return;
        }
        catch (SoyDataException e) {
            this.errorReporter.report(node.getSourceLocation(), SOY_DATA_ERROR, e.getMessage());
            return;
        }
        if (preevalResult instanceof PrimitiveData && (newNode = InternalValueUtils.convertPrimitiveDataToExpr((PrimitiveData)preevalResult, node.getSourceLocation())) != null) {
            node.getParent().replaceChild(node, newNode);
        }
    }

    private static boolean childrenAreConstant(ExprNode.ParentExprNode parent) {
        if (parent.getKind() == ExprNode.Kind.NULL_SAFE_ACCESS_NODE) {
            NullSafeAccessNode nullSafe = (NullSafeAccessNode)parent;
            return SimplifyExprVisitor.isConstant(nullSafe.getBase()) && SimplifyExprVisitor.childrenAreConstant((ExprNode.ParentExprNode)nullSafe.getDataAccess());
        }
        for (ExprNode child : parent.getChildren()) {
            if (SimplifyExprVisitor.isConstant(child)) continue;
            return false;
        }
        return true;
    }

    static boolean isConstant(ExprNode expr) {
        return expr instanceof ExprNode.PrimitiveNode;
    }

    static SoyValue getConstantOrNull(ExprNode expr) {
        switch (expr.getKind()) {
            case NULL_NODE: {
                return NullData.INSTANCE;
            }
            case BOOLEAN_NODE: {
                return BooleanData.forValue(((BooleanNode)expr).getValue());
            }
            case INTEGER_NODE: {
                return IntegerData.forValue(((IntegerNode)expr).getValue());
            }
            case FLOAT_NODE: {
                return FloatData.forValue(((FloatNode)expr).getValue());
            }
            case STRING_NODE: {
                return StringData.forValue(((StringNode)expr).getValue());
            }
            case PROTO_ENUM_VALUE_NODE: {
                return IntegerData.forValue(((ProtoEnumValueNode)expr).getValue());
            }
            case GLOBAL_NODE: {
                return null;
            }
        }
        return null;
    }
}

