/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.shared.internal;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.template.soy.data.LogStatement;
import com.google.template.soy.data.LoggingAdvisingAppendable;
import com.google.template.soy.data.LoggingFunctionInvocation;
import com.google.template.soy.shared.internal.EscapingConventions;
import java.io.IOException;

public final class StreamingEscaper
extends LoggingAdvisingAppendable {
    private final LoggingAdvisingAppendable delegate;
    private final EscapingConventions.CrossLanguageStringXform transform;
    private final Appendable escapedAppendable;

    public static StreamingEscaper create(LoggingAdvisingAppendable delegate, EscapingConventions.CrossLanguageStringXform transform) {
        if (delegate instanceof StreamingEscaper) {
            StreamingEscaper delegateAsStreamingEscaper = (StreamingEscaper)delegate;
            if (delegateAsStreamingEscaper.transform == transform) {
                return delegateAsStreamingEscaper;
            }
        }
        return new StreamingEscaper(delegate, transform);
    }

    private StreamingEscaper(LoggingAdvisingAppendable delegate, EscapingConventions.CrossLanguageStringXform transform) {
        this.delegate = (LoggingAdvisingAppendable)Preconditions.checkNotNull((Object)delegate);
        this.transform = (EscapingConventions.CrossLanguageStringXform)((Object)Preconditions.checkNotNull((Object)((Object)transform)));
        this.escapedAppendable = transform.escape(delegate);
    }

    @Override
    public final LoggingAdvisingAppendable append(CharSequence csq) throws IOException {
        this.escapedAppendable.append(csq);
        return this;
    }

    @Override
    public final LoggingAdvisingAppendable append(CharSequence csq, int start, int end) throws IOException {
        this.escapedAppendable.append(csq, start, end);
        return this;
    }

    @Override
    public final LoggingAdvisingAppendable append(char c) throws IOException {
        this.escapedAppendable.append(c);
        return this;
    }

    @Override
    public LoggingAdvisingAppendable appendLoggingFunctionInvocation(LoggingFunctionInvocation funCall, ImmutableList<Function<String, String>> escapers) throws IOException {
        this.escapedAppendable.append(StreamingEscaper.escapePlaceholder(funCall.placeholderValue(), escapers));
        return this;
    }

    @Override
    public final boolean softLimitReached() {
        return this.delegate.softLimitReached();
    }

    @Override
    public LoggingAdvisingAppendable enterLoggableElement(LogStatement statement) {
        return this;
    }

    @Override
    public LoggingAdvisingAppendable exitLoggableElement() {
        return this;
    }

    @Override
    public void flushBuffers(int depth) throws IOException {
        if (depth > 0) {
            this.delegate.flushBuffers(depth - 1);
        }
    }
}

