/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.shared.internal;

import com.google.template.soy.data.SanitizedContent;
import com.google.template.soy.data.SoyMap;
import com.google.template.soy.data.SoyRecord;
import com.google.template.soy.data.SoyValue;
import com.google.template.soy.data.SoyValueProvider;
import com.google.template.soy.data.internal.SoyMapImpl;
import com.google.template.soy.data.restricted.FloatData;
import com.google.template.soy.data.restricted.IntegerData;
import com.google.template.soy.data.restricted.NumberData;
import com.google.template.soy.data.restricted.StringData;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.OptionalInt;

public final class SharedRuntime {
    public static boolean equal(SoyValue operand0, SoyValue operand1) {
        if (operand0 instanceof StringData) {
            return SharedRuntime.compareString(operand0.stringValue(), operand1);
        }
        if (operand1 instanceof StringData) {
            return SharedRuntime.compareString(operand1.stringValue(), operand0);
        }
        return Objects.equals(operand0, operand1);
    }

    public static SoyValue plus(SoyValue operand0, SoyValue operand1) {
        if (operand0 instanceof IntegerData && operand1 instanceof IntegerData) {
            return IntegerData.forValue(operand0.longValue() + operand1.longValue());
        }
        if (operand0 instanceof NumberData && operand1 instanceof NumberData) {
            return FloatData.forValue(operand0.numberValue() + operand1.numberValue());
        }
        return StringData.forValue(operand0.coerceToString() + operand1.coerceToString());
    }

    public static SoyValue minus(SoyValue operand0, SoyValue operand1) {
        if (operand0 instanceof IntegerData && operand1 instanceof IntegerData) {
            return IntegerData.forValue(operand0.longValue() - operand1.longValue());
        }
        return FloatData.forValue(operand0.numberValue() - operand1.numberValue());
    }

    public static NumberData times(SoyValue operand0, SoyValue operand1) {
        if (operand0 instanceof IntegerData && operand1 instanceof IntegerData) {
            return IntegerData.forValue(operand0.longValue() * operand1.longValue());
        }
        return FloatData.forValue(operand0.numberValue() * operand1.numberValue());
    }

    public static double dividedBy(SoyValue operand0, SoyValue operand1) {
        return operand0.numberValue() / operand1.numberValue();
    }

    public static NumberData mod(SoyValue operand0, SoyValue operand1) {
        if (operand0 instanceof IntegerData && operand1 instanceof IntegerData) {
            return IntegerData.forValue(operand0.longValue() % operand1.longValue());
        }
        return FloatData.forValue(operand0.numberValue() % operand1.numberValue());
    }

    public static boolean lessThan(SoyValue left, SoyValue right) {
        if (left instanceof StringData && right instanceof StringData) {
            return left.stringValue().compareTo(right.stringValue()) < 0;
        }
        if (left instanceof IntegerData && right instanceof IntegerData) {
            return left.longValue() < right.longValue();
        }
        return left.numberValue() < right.numberValue();
    }

    public static boolean lessThanOrEqual(SoyValue left, SoyValue right) {
        if (left instanceof StringData && right instanceof StringData) {
            return left.stringValue().compareTo(right.stringValue()) <= 0;
        }
        if (left instanceof IntegerData && right instanceof IntegerData) {
            return left.longValue() <= right.longValue();
        }
        return left.numberValue() <= right.numberValue();
    }

    public static NumberData negative(SoyValue node) {
        if (node instanceof IntegerData) {
            return IntegerData.forValue(-node.longValue());
        }
        return FloatData.forValue(-node.floatValue());
    }

    public static boolean compareString(String string, SoyValue other) {
        if (other instanceof StringData || other instanceof SanitizedContent) {
            return string.equals(other.toString());
        }
        if (other instanceof NumberData) {
            try {
                return Double.parseDouble(string) == other.numberValue();
            }
            catch (NumberFormatException nfe) {
                return false;
            }
        }
        return false;
    }

    public static String soyServerKey(SoyValue key) {
        if (key instanceof NumberData) {
            return SharedRuntime.serialize(key.coerceToString(), "#");
        }
        if (key == null) {
            return SharedRuntime.serialize("null", "_");
        }
        return SharedRuntime.serialize(key.coerceToString(), ":");
    }

    public static SoyMap constructMapFromList(List<? extends SoyValueProvider> list) {
        HashMap<SoyValue, SoyValueProvider> map = new HashMap<SoyValue, SoyValueProvider>();
        for (int i = 0; i < list.size(); ++i) {
            SoyValue recordEntry = list.get(i).resolve();
            SharedRuntime.checkMapFromListConstructorCondition(recordEntry instanceof SoyRecord, recordEntry, OptionalInt.of(i));
            SharedRuntime.checkMapFromListConstructorCondition(((SoyRecord)recordEntry).hasField("key") && ((SoyRecord)recordEntry).hasField("value"), recordEntry, OptionalInt.of(i));
            SoyValue key = ((SoyRecord)recordEntry).getField("key");
            SoyValueProvider valueProvider = ((SoyRecord)recordEntry).getFieldProvider("value");
            SharedRuntime.checkMapFromListConstructorCondition(key != null && SoyMap.isAllowedKeyType(key), recordEntry, OptionalInt.of(i));
            map.put(key, valueProvider);
        }
        return SoyMapImpl.forProviderMap(map);
    }

    public static void checkMapFromListConstructorCondition(boolean condition, SoyValue list, OptionalInt index) {
        if (!condition) {
            String exceptionString = String.format("Error constructing map. Expected a list where each item is a record of 'key', 'value' pairs, with the 'key' fields holding primitive values. Found: %s", list);
            if (index.isPresent()) {
                exceptionString = exceptionString + String.format(" at index %d", index.getAsInt());
            }
            throw new IllegalArgumentException(exceptionString);
        }
    }

    private static String serialize(String key, String delimiter) {
        return key.length() + delimiter + key;
    }

    private SharedRuntime() {
    }
}

