/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.plugin.java;

import com.google.common.base.Preconditions;
import com.google.template.soy.plugin.java.MethodChecker;
import java.util.List;

public final class DelegatingMethodChecker
implements MethodChecker {
    private final List<MethodChecker> methodCheckers;

    public DelegatingMethodChecker(List<MethodChecker> methodCheckers) {
        this.methodCheckers = methodCheckers;
    }

    @Override
    public MethodChecker.Response findMethod(String className, String methodName, String returnType, List<String> arguments) {
        if (this.methodCheckers.isEmpty()) {
            return MethodChecker.Response.error(MethodChecker.Code.NO_SUCH_CLASS);
        }
        MethodChecker.Response lastResponse = null;
        for (MethodChecker methodChecker : this.methodCheckers) {
            lastResponse = methodChecker.findMethod(className, methodName, returnType, arguments);
            if (lastResponse.getCode() != MethodChecker.Code.EXISTS) continue;
            return lastResponse;
        }
        return (MethodChecker.Response)Preconditions.checkNotNull(lastResponse);
    }
}

