/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.plugin.internal;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.template.soy.base.SourceFilePath;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.base.internal.SoyFileSupplier;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyError;
import com.google.template.soy.plugin.java.internal.JavaPluginValidator;
import com.google.template.soy.plugin.java.internal.MethodSignatureValidator;
import com.google.template.soy.plugin.java.internal.ValidatorErrorReporter;
import com.google.template.soy.plugin.java.restricted.SoyJavaSourceFunction;
import com.google.template.soy.plugin.restricted.SoySourceFunction;
import com.google.template.soy.shared.restricted.Signature;
import com.google.template.soy.shared.restricted.SoyFunctionSignature;
import com.google.template.soy.soyparse.SoyFileParser;
import com.google.template.soy.types.SoyType;
import com.google.template.soy.types.SoyTypeRegistry;
import com.google.template.soy.types.UnknownType;
import com.google.template.soy.types.ast.TypeNode;
import com.google.template.soy.types.ast.TypeNodeConverter;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public final class PluginValidator {
    private final SoyTypeRegistry typeRegistry;
    private final ErrorReporter errorReporter;
    private final JavaPluginValidator javaValidator;
    private final MethodSignatureValidator methodSignatureValidator;

    public PluginValidator(ErrorReporter errorReporter, SoyTypeRegistry typeRegistry, List<File> pluginRuntimeJars) {
        this.typeRegistry = typeRegistry;
        this.errorReporter = errorReporter;
        this.javaValidator = new JavaPluginValidator(errorReporter, typeRegistry);
        this.methodSignatureValidator = new MethodSignatureValidator(pluginRuntimeJars, errorReporter);
    }

    public void validate(Iterable<SoySourceFunction> fns) {
        for (SoySourceFunction fn : fns) {
            if (!(fn instanceof SoyJavaSourceFunction)) continue;
            this.validateJavaFunction((SoyJavaSourceFunction)fn);
        }
    }

    private void validateJavaFunction(SoyJavaSourceFunction fn) {
        SoyFunctionSignature fnSig = fn.getClass().getAnnotation(SoyFunctionSignature.class);
        String fnName = fnSig.name();
        SourceLocation location = new SourceLocation(SourceFilePath.create(fn.getClass().getName()));
        this.methodSignatureValidator.validate(fnName, fn, location, false);
        ValidatorErrorReporter validatorReporter = new ValidatorErrorReporter(this.errorReporter, fnName, fn.getClass(), location, false);
        for (Signature sig : fnSig.value()) {
            ErrorReporter.Checkpoint checkpoint = this.errorReporter.checkpoint();
            List paramTypes = (List)Arrays.stream(sig.parameterTypes()).map(p -> this.typeFor((String)p, (Class<? extends SoySourceFunction>)fn.getClass(), validatorReporter)).collect(ImmutableList.toImmutableList());
            SoyType returnType = this.typeFor(sig.returnType(), fn.getClass(), validatorReporter);
            if (this.errorReporter.errorsSince(checkpoint)) continue;
            this.javaValidator.validate(fnName, fn, paramTypes, returnType, location, false);
        }
    }

    private SoyType typeFor(String typeStr, Class<? extends SoySourceFunction> fnClass, ValidatorErrorReporter validatorReporter) {
        ErrorReporter localReporter = ErrorReporter.create((Map<SourceFilePath, SoyFileSupplier>)ImmutableMap.of());
        TypeNode typeNode = SoyFileParser.parseType(typeStr, SourceFilePath.create(fnClass.getName()), localReporter);
        UnknownType type = typeNode == null ? UnknownType.getInstance() : TypeNodeConverter.builder(localReporter).setTypeRegistry(this.typeRegistry).setSystemExternal(true).build().getOrCreateType(typeNode);
        validatorReporter.wrapErrors((Iterable<SoyError>)localReporter.getErrors());
        validatorReporter.wrapWarnings((Iterable<SoyError>)localReporter.getWarnings());
        return type;
    }
}

