/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.plugin.internal;

import com.google.common.collect.ImmutableList;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.basetree.Node;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.FunctionNode;
import com.google.template.soy.exprtree.MethodCallNode;
import com.google.template.soy.plugin.java.restricted.SoyJavaSourceFunction;
import com.google.template.soy.shared.restricted.SoySourceFunctionMethod;
import com.google.template.soy.types.SoyType;

public final class JavaPluginExecContext {
    private final SoyJavaSourceFunction sourceFunction;
    private final ExprNode node;
    private final String functionName;
    private final ImmutableList<SoyType> paramTypes;

    public static JavaPluginExecContext forMethodCallNode(MethodCallNode methodNode, SoySourceFunctionMethod method) {
        return new JavaPluginExecContext((SoyJavaSourceFunction)method.getImpl(), methodNode, methodNode.getMethodName().identifier(), (ImmutableList<SoyType>)ImmutableList.builder().add((Object)method.getBaseType()).addAll(method.getArgTypes()).build());
    }

    public static JavaPluginExecContext forFunctionNode(FunctionNode node, SoyJavaSourceFunction fn) {
        return new JavaPluginExecContext(fn, node, node.getStaticFunctionName(), node.getAllowedParamTypes());
    }

    private JavaPluginExecContext(SoyJavaSourceFunction sourceFunction, ExprNode node, String functionName, ImmutableList<SoyType> paramTypes) {
        this.sourceFunction = sourceFunction;
        this.node = node;
        this.functionName = functionName;
        this.paramTypes = paramTypes;
    }

    public SoyJavaSourceFunction getSourceFunction() {
        return this.sourceFunction;
    }

    public ImmutableList<SoyType> getParamTypes() {
        return this.paramTypes;
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public String toSourceString() {
        return this.node.toSourceString();
    }

    public SourceLocation getSourceLocation() {
        return this.node.getSourceLocation();
    }

    public SoyType getReturnType() {
        return this.node.getType();
    }

    public Node getNode() {
        return this.node;
    }
}

