/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.passes;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.base.internal.IdGenerator;
import com.google.template.soy.base.internal.TemplateContentKind;
import com.google.template.soy.basetree.Node;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.MethodCallNode;
import com.google.template.soy.exprtree.TemplateLiteralNode;
import com.google.template.soy.passes.CompilerFileSetPass;
import com.google.template.soy.passes.RunAfter;
import com.google.template.soy.passes.StrictHtmlValidationPass;
import com.google.template.soy.soytree.CallBasicNode;
import com.google.template.soy.soytree.FileSetMetadata;
import com.google.template.soy.soytree.HtmlElementMetadataP;
import com.google.template.soy.soytree.HtmlOpenTagNode;
import com.google.template.soy.soytree.HtmlTagNode;
import com.google.template.soy.soytree.KeyNode;
import com.google.template.soy.soytree.PrintNode;
import com.google.template.soy.soytree.SkipNode;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.TagName;
import com.google.template.soy.soytree.TemplateDelegateNode;
import com.google.template.soy.soytree.TemplateElementNode;
import com.google.template.soy.soytree.TemplateMetadata;
import com.google.template.soy.soytree.TemplateNode;
import com.google.template.soy.soytree.VeLogNode;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.Nullable;

@RunAfter(value={StrictHtmlValidationPass.class})
public final class SoyElementPass
implements CompilerFileSetPass {
    private static final SoyErrorKind SOYELEMENT_CANNOT_BE_SKIPPED = SoyErrorKind.of("Soy elements cannot be skipped.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind SOY_ELEMENT_MUST_HAVE_STATIC_TAG = SoyErrorKind.of("Soy elements must have static tags.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind SOYELEMENT_CANNOT_WRAP_ITSELF_RECURSIVELY = SoyErrorKind.of("The root node of Soy elements must not recursively call itself. The cycle is ''{0}''.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind SOYELEMENT_CANNOT_WRAP_SOY_ELEMENT = SoyErrorKind.of("The root node of Soy elements must not be another Soy element.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind ROOT_HAS_KEY_NODE = SoyErrorKind.of("The root node of Soy elements must not have a key. Instead, consider wrapping the Soy element in a keyed tag node.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind SOY_ELEMENT_OPEN_TAG_CLOSE_AMBIGUOUS = SoyErrorKind.of("Soy element open tags must map to exactly one close tag.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind SOY_ELEMENT_EXACTLY_ONE_TAG = SoyErrorKind.of("Soy elements must contain exactly one top-level HTML element (e.g, span, div). Calls to templates (but not deltemplates) that contain one top-level HTML element are also allowed, but not as function calls. Replace function calls with call commands or element composition instead.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind ELEMENT_TEMPLATE_EXACTLY_ONE_TAG = SoyErrorKind.of("Templates with kind=\"html<?>\" must contain exactly one top-level HTML element (e.g, span, div).", new SoyErrorKind.StyleAllowance[0]);
    static final ImmutableSet<SoyNode.Kind> ALLOWED_CHILD_NODES = Sets.immutableEnumSet((Enum)SoyNode.Kind.LET_CONTENT_NODE, (Enum[])new SoyNode.Kind[]{SoyNode.Kind.LET_VALUE_NODE, SoyNode.Kind.DEBUGGER_NODE, SoyNode.Kind.LOG_NODE});
    private static final HtmlElementMetadataP DEFAULT_HTML_METADATA = HtmlElementMetadataP.newBuilder().setIsHtmlElement(false).setIsVelogged(false).build();
    private final ErrorReporter errorReporter;
    private final Supplier<FileSetMetadata> templateRegistryFromDeps;

    SoyElementPass(ErrorReporter errorReporter, Supplier<FileSetMetadata> templateRegistryFromDeps) {
        this.errorReporter = errorReporter;
        this.templateRegistryFromDeps = templateRegistryFromDeps;
    }

    @Override
    public CompilerFileSetPass.Result run(ImmutableList<SoyFileNode> sourceFiles, IdGenerator idGenerator) {
        HashSet<TemplateNode> visited;
        LinkedHashMap<String, TemplateNode> templatesInLibrary = new LinkedHashMap<String, TemplateNode>();
        HashSet<TemplateNode> delegateTemplates = new HashSet<TemplateNode>();
        for (SoyFileNode file : sourceFiles) {
            for (TemplateNode template : file.getTemplates()) {
                if (!template.getContentKind().isHtml()) {
                    template.setHtmlElementMetadata(DEFAULT_HTML_METADATA);
                    continue;
                }
                if (template instanceof TemplateDelegateNode) {
                    delegateTemplates.add(template);
                    continue;
                }
                templatesInLibrary.put(template.getTemplateName(), template);
            }
        }
        for (TemplateNode template : templatesInLibrary.values()) {
            visited = new HashSet<TemplateNode>();
            this.getTemplateMetadata(template, templatesInLibrary, visited);
        }
        for (TemplateNode template : delegateTemplates) {
            visited = new HashSet();
            this.getTemplateMetadata(template, templatesInLibrary, visited);
        }
        return CompilerFileSetPass.Result.CONTINUE;
    }

    private HtmlElementMetadataP getTemplateMetadata(TemplateNode template, Map<String, TemplateNode> templatesInLibrary, Set<TemplateNode> visited) {
        if (visited.contains(template)) {
            if (template instanceof TemplateElementNode) {
                this.errorReporter.report(template.getSourceLocation(), SOYELEMENT_CANNOT_WRAP_ITSELF_RECURSIVELY, visited.stream().map(TemplateNode::getTemplateName).sorted().collect(ImmutableSet.toImmutableSet()));
            }
            template.setHtmlElementMetadata(DEFAULT_HTML_METADATA);
            return null;
        }
        visited.add(template);
        boolean isSoyElement = template instanceof TemplateElementNode;
        VeLogNode veLogNode = null;
        HtmlOpenTagNode openTag = null;
        HtmlTagNode closeTag = null;
        for (int i = 0; i < template.numChildren(); ++i) {
            Node child = template.getChild(i);
            if (ALLOWED_CHILD_NODES.contains((Object)child.getKind())) continue;
            if (openTag == null && child instanceof CallBasicNode && ((CallBasicNode)child).isStaticCall() && i == template.numChildren() - 1) {
                if (template.getTemplateContentKind() instanceof TemplateContentKind.ElementContentKind) {
                    this.errorReporter.report(child.getSourceLocation(), ELEMENT_TEMPLATE_EXACTLY_ONE_TAG, new Object[0]);
                }
                if (isSoyElement && ((CallBasicNode)child).getKeyExpr() != null) {
                    this.errorReporter.report(((CallBasicNode)child).getSourceCalleeLocation(), ROOT_HAS_KEY_NODE, new Object[0]);
                }
                return this.getTemplateMetadataForStaticCall(template, ((CallBasicNode)child).getCalleeName(), child.getSourceLocation(), templatesInLibrary, visited);
            }
            if (openTag == null && child instanceof HtmlOpenTagNode) {
                closeTag = SoyElementPass.checkHtmlOpenTag(template, (HtmlOpenTagNode)child, this.errorReporter, isSoyElement);
                if (closeTag == null) break;
                i = template.getChildIndex(closeTag);
                openTag = (HtmlOpenTagNode)child;
                continue;
            }
            if (openTag == null && child instanceof VeLogNode) {
                veLogNode = (VeLogNode)child;
                HtmlOpenTagNode maybeOpenTagNode = veLogNode.getOpenTagNode();
                if (maybeOpenTagNode != null) {
                    closeTag = SoyElementPass.checkHtmlOpenTag(veLogNode, maybeOpenTagNode, this.errorReporter, isSoyElement);
                    if (closeTag == null) break;
                    openTag = maybeOpenTagNode;
                    continue;
                }
                if (template.getTemplateContentKind() instanceof TemplateContentKind.ElementContentKind) {
                    this.errorReporter.report(template.getSourceLocation(), ELEMENT_TEMPLATE_EXACTLY_ONE_TAG, new Object[0]);
                    continue;
                }
                List callNodes = (List)veLogNode.getChildren().stream().filter(p -> p instanceof CallBasicNode).map(CallBasicNode.class::cast).collect(ImmutableList.toImmutableList());
                if (callNodes.size() == 1 && ((CallBasicNode)callNodes.get(0)).isStaticCall()) {
                    if (isSoyElement && ((CallBasicNode)callNodes.get(0)).getKeyExpr() != null) {
                        this.errorReporter.report(((CallBasicNode)callNodes.get(0)).getSourceLocation(), ROOT_HAS_KEY_NODE, new Object[0]);
                    }
                    return this.getTemplateMetadataForStaticCall(template, ((CallBasicNode)callNodes.get(0)).getCalleeName(), ((CallBasicNode)callNodes.get(0)).getSourceLocation(), templatesInLibrary, visited);
                }
                if (!isSoyElement) continue;
                this.errorReporter.report(veLogNode.getSourceLocation(), SOY_ELEMENT_EXACTLY_ONE_TAG, new Object[0]);
                continue;
            }
            openTag = null;
            closeTag = null;
            if (isSoyElement) {
                this.errorReporter.report(child.getSourceLocation(), SOY_ELEMENT_EXACTLY_ONE_TAG, new Object[0]);
            }
            if (!(template.getTemplateContentKind() instanceof TemplateContentKind.ElementContentKind)) break;
            this.errorReporter.report(child.getSourceLocation(), ELEMENT_TEMPLATE_EXACTLY_ONE_TAG, new Object[0]);
            break;
        }
        if (openTag != null) {
            openTag.setElementRoot();
        }
        boolean isValid = openTag != null && closeTag != null;
        boolean hasSkipNode = false;
        String delegateTemplate = null;
        String tagName = "";
        if (isValid) {
            for (SoyNode.StandaloneNode child : openTag.getChildren()) {
                if (!(child instanceof SkipNode)) continue;
                hasSkipNode = true;
            }
            delegateTemplate = SoyElementPass.getStaticDelegateCall(openTag);
            if (openTag.getTagName().isStatic()) {
                tagName = openTag.getTagName().getStaticTagName();
            } else if (delegateTemplate != null) {
                HtmlElementMetadataP metadata = this.getTemplateMetadataForStaticCall(template, delegateTemplate, openTag.getSourceLocation(), templatesInLibrary, visited);
                tagName = metadata.getTag();
            } else {
                tagName = "?";
            }
            if (hasSkipNode && template instanceof TemplateElementNode) {
                this.errorReporter.report(openTag.getSourceLocation(), SOYELEMENT_CANNOT_BE_SKIPPED, new Object[0]);
            }
        } else if (isSoyElement) {
            this.errorReporter.report(template.getSourceLocation(), ELEMENT_TEMPLATE_EXACTLY_ONE_TAG, new Object[0]);
        }
        String finalCallee = "";
        if (delegateTemplate != null) {
            HtmlElementMetadataP htmlMetadata = this.getTemplateMetadataForStaticCall(template, delegateTemplate, openTag.getSourceLocation(), templatesInLibrary, visited);
            finalCallee = htmlMetadata.getFinalCallee().isEmpty() ? delegateTemplate : htmlMetadata.getFinalCallee();
        }
        HtmlElementMetadataP info = HtmlElementMetadataP.newBuilder().setIsHtmlElement(isValid).setTag(tagName).setIsVelogged(veLogNode != null).setIsSkip(hasSkipNode).setDelegateElement(Strings.nullToEmpty((String)delegateTemplate)).setFinalCallee(finalCallee).build();
        template.setHtmlElementMetadata(info);
        return info;
    }

    private static String getStaticDelegateCall(HtmlOpenTagNode openTag) {
        TagName tagName = openTag.getTagName();
        if (tagName.isStatic()) {
            return null;
        }
        PrintNode printNode = tagName.getDynamicTagName();
        ExprNode exprNode = printNode.getExpr().getRoot();
        if (exprNode instanceof TemplateLiteralNode) {
            return ((TemplateLiteralNode)exprNode).getResolvedName();
        }
        if (exprNode.getKind() != ExprNode.Kind.METHOD_CALL_NODE || !((MethodCallNode)exprNode).getMethodName().identifier().equals("bind")) {
            return null;
        }
        MethodCallNode bind = (MethodCallNode)exprNode;
        if (bind.getChild(0).getKind() != ExprNode.Kind.TEMPLATE_LITERAL_NODE) {
            return null;
        }
        return ((TemplateLiteralNode)bind.getChild(0)).getResolvedName();
    }

    private HtmlElementMetadataP getTemplateMetadataForStaticCall(TemplateNode template, String callee, SourceLocation calleeSourceLocation, Map<String, TemplateNode> templatesInLibrary, Set<TemplateNode> visited) {
        HtmlElementMetadataP calleeMetadata = null;
        boolean isCalleeSoyElement = false;
        TemplateMetadata templateMetadata = this.templateRegistryFromDeps.get().getBasicTemplateOrElement(callee);
        if (templateMetadata != null) {
            calleeMetadata = templateMetadata.getHtmlElement();
            isCalleeSoyElement = templateMetadata.getSoyElement().getIsSoyElement();
        } else if (templatesInLibrary.containsKey(callee)) {
            TemplateNode calledTemplate = templatesInLibrary.get(callee);
            calleeMetadata = calledTemplate.getHtmlElementMetadata();
            if (calleeMetadata == null && (calleeMetadata = this.getTemplateMetadata(calledTemplate, templatesInLibrary, visited)) == null) {
                template.setHtmlElementMetadata(DEFAULT_HTML_METADATA);
                return null;
            }
            isCalleeSoyElement = calledTemplate instanceof TemplateElementNode;
        } else {
            isCalleeSoyElement = false;
            calleeMetadata = DEFAULT_HTML_METADATA;
        }
        String finalCallee = calleeMetadata.getFinalCallee().isEmpty() ? callee : calleeMetadata.getFinalCallee();
        calleeMetadata = calleeMetadata.toBuilder().clearDelegateElement().setDelegateCallee(callee).setFinalCallee(finalCallee).build();
        template.setHtmlElementMetadata(calleeMetadata);
        if (template instanceof TemplateElementNode) {
            if (calleeMetadata.getIsSkip()) {
                this.errorReporter.report(calleeSourceLocation, SOYELEMENT_CANNOT_BE_SKIPPED, new Object[0]);
            }
            if (isCalleeSoyElement) {
                this.errorReporter.report(calleeSourceLocation, SOYELEMENT_CANNOT_WRAP_SOY_ELEMENT, new Object[0]);
            }
            if (!calleeMetadata.getIsHtmlElement()) {
                this.errorReporter.report(calleeSourceLocation, SOY_ELEMENT_EXACTLY_ONE_TAG, new Object[0]);
            }
        }
        return calleeMetadata;
    }

    @Nullable
    static HtmlTagNode checkHtmlOpenTag(SoyNode.BlockNode parent, HtmlOpenTagNode openTagNode, ErrorReporter errorReporter, boolean isSoyElement) {
        if (isSoyElement) {
            SoyElementPass.validateOpenTagProperties(openTagNode, errorReporter);
        }
        if (openTagNode.isSelfClosing() || openTagNode.getTagName().isDefinitelyVoid() && openTagNode.getTaggedPairs().isEmpty()) {
            return openTagNode;
        }
        if (openTagNode.getTaggedPairs().isEmpty()) {
            return openTagNode;
        }
        if (openTagNode.getTaggedPairs().size() == 1) {
            HtmlTagNode closeTag = openTagNode.getTaggedPairs().get(0);
            if (closeTag.getParent() != parent) {
                if (isSoyElement) {
                    errorReporter.report(openTagNode.getSourceLocation(), SOY_ELEMENT_OPEN_TAG_CLOSE_AMBIGUOUS, new Object[0]);
                }
                return null;
            }
            return closeTag;
        }
        if (isSoyElement) {
            errorReporter.report(openTagNode.getSourceLocation(), SOY_ELEMENT_OPEN_TAG_CLOSE_AMBIGUOUS, new Object[0]);
        }
        return null;
    }

    private static void validateOpenTagProperties(HtmlOpenTagNode firstTagNode, ErrorReporter errorReporter) {
        if (firstTagNode.getTagName().isLegacyDynamicTagName()) {
            errorReporter.report(firstTagNode.getSourceLocation(), SOY_ELEMENT_MUST_HAVE_STATIC_TAG, new Object[0]);
        }
        for (SoyNode child : firstTagNode.getChildren()) {
            if (!(child instanceof KeyNode)) continue;
            errorReporter.report(firstTagNode.getSourceLocation(), ROOT_HAS_KEY_NODE, new Object[0]);
        }
    }
}

