/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.passes;

import com.google.template.soy.base.internal.IdGenerator;
import com.google.template.soy.conformance.SoyConformance;
import com.google.template.soy.conformance.ValidatedConformanceConfig;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.passes.CompilerFilePass;
import com.google.template.soy.passes.ResolvePluginsPass;
import com.google.template.soy.passes.RunAfter;
import com.google.template.soy.soytree.SoyFileNode;

@RunAfter(value={ResolvePluginsPass.class})
public final class SoyConformancePass
implements CompilerFilePass {
    private final SoyConformance conformance;
    private final ErrorReporter errorReporter;

    SoyConformancePass(ValidatedConformanceConfig conformanceConfig, ErrorReporter errorReporter) {
        this.conformance = SoyConformance.create(conformanceConfig);
        this.errorReporter = errorReporter;
    }

    @Override
    public void run(SoyFileNode file, IdGenerator nodeIdGen) {
        this.conformance.check(file, this.errorReporter);
    }
}

