/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.passes;

import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.base.internal.IdGenerator;
import com.google.template.soy.base.internal.Identifier;
import com.google.template.soy.exprtree.CallableExprBuilder;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.FieldAccessNode;
import com.google.template.soy.exprtree.FunctionNode;
import com.google.template.soy.exprtree.GlobalNode;
import com.google.template.soy.exprtree.MethodCallNode;
import com.google.template.soy.exprtree.VarRefNode;
import com.google.template.soy.passes.CompilerFilePass;
import com.google.template.soy.passes.LocalVariablesNodeVisitor;
import com.google.template.soy.soytree.SoyFileNode;

public final class RestoreGlobalsPass
implements CompilerFilePass {
    private final LocalVariablesNodeVisitor nodeVisitor = new LocalVariablesNodeVisitor(new Visitor());

    @Override
    public void run(SoyFileNode file, IdGenerator nodeIdGen) {
        this.nodeVisitor.exec(file);
    }

    private static SourceLocation union(SourceLocation l1, SourceLocation l2) {
        SourceLocation.Point b1 = l1.getBeginPoint();
        SourceLocation.Point b2 = l2.getBeginPoint();
        SourceLocation.Point e1 = l1.getEndPoint();
        SourceLocation.Point e2 = l2.getEndPoint();
        return new SourceLocation(l1.getFilePath(), b1.isBefore(b2) ? b1 : b2, e1.isBefore(e2) ? e2 : e1);
    }

    private static class Visitor
    extends LocalVariablesNodeVisitor.ExprVisitor {
        private Visitor() {
        }

        @Override
        protected void visitMethodCallNode(MethodCallNode node) {
            this.visitChildrenAllowingConcurrentModification(node);
        }

        @Override
        protected void visitFieldAccessNode(FieldAccessNode node) {
            this.visitChildrenAllowingConcurrentModification(node);
        }

        @Override
        protected void visitVarRefNode(VarRefNode varRef) {
            if (varRef.getDefnDecl() != null) {
                return;
            }
            boolean isOriginalVar = varRef.getName().startsWith("$");
            if (isOriginalVar) {
                return;
            }
            if (this.getLocalVariables().lookup(varRef) != null) {
                return;
            }
            ExprNode node = varRef;
            while (node.getParent() != null && node.getParent().getKind() == ExprNode.Kind.FIELD_ACCESS_NODE && !((FieldAccessNode)node.getParent()).isNullSafe()) {
                node = node.getParent();
            }
            if (node.getParent().getKind() == ExprNode.Kind.METHOD_CALL_NODE && !((MethodCallNode)node.getParent()).isNullSafe() && node.getParent().getChildIndex(node) == 0) {
                MethodCallNode methodNode = (MethodCallNode)node.getParent();
                String fullName = node.toSourceString() + "." + methodNode.getMethodName().identifier();
                FunctionNode functionNode = CallableExprBuilder.builder(methodNode).setTarget(null).setIdentifier(Identifier.create(fullName, RestoreGlobalsPass.union(varRef.getSourceLocation(), methodNode.getMethodName().location()))).setSourceLocation(RestoreGlobalsPass.union(varRef.getSourceLocation(), methodNode.getSourceLocation())).buildFunction();
                methodNode.getParent().replaceChild(methodNode, functionNode);
            } else {
                GlobalNode globalNode = new GlobalNode(Identifier.create(node.toSourceString(), RestoreGlobalsPass.union(varRef.getSourceLocation(), node.getSourceLocation())));
                node.getParent().replaceChild(node, globalNode);
            }
        }
    }
}

