/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.passes;

import com.google.template.soy.base.internal.IdGenerator;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.passes.CompilerFilePass;
import com.google.template.soy.soytree.AbstractSoyNodeVisitor;
import com.google.template.soy.soytree.HtmlCloseTagNode;
import com.google.template.soy.soytree.HtmlOpenTagNode;
import com.google.template.soy.soytree.KeyNode;
import com.google.template.soy.soytree.SkipNode;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.TemplateNode;
import java.util.ArrayDeque;
import java.util.concurrent.atomic.AtomicInteger;

final class IncrementalDomKeysPass
implements CompilerFilePass {
    private static final SoyErrorKind SOY_SKIP_OPEN_TAG_CLOSE_AMBIGUOUS = SoyErrorKind.of("Skip element open tags must map to exactly one close tag.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind SOY_SKIP_MUST_BE_DIRECT_CHILD_OF_TAG = SoyErrorKind.of("Skip commands must be direct children of html tags.", new SoyErrorKind.StyleAllowance[0]);
    private final ErrorReporter errorReporter;

    public IncrementalDomKeysPass(ErrorReporter errorReporter) {
        this.errorReporter = errorReporter;
    }

    @Override
    public void run(SoyFileNode file, IdGenerator nodeIdGen) {
        new IncrementalDomKeysPassVisitor(this.errorReporter).exec(file);
    }

    private static final class IncrementalDomKeysPassVisitor
    extends AbstractSoyNodeVisitor<Void> {
        private ArrayDeque<AtomicInteger> keyCounterStack;
        private final ErrorReporter errorReporter;
        private TemplateNode template;

        public IncrementalDomKeysPassVisitor(ErrorReporter errorReporter) {
            this.errorReporter = errorReporter;
        }

        @Override
        public void visitTemplateNode(TemplateNode templateNode) {
            this.keyCounterStack = new ArrayDeque();
            this.keyCounterStack.push(new AtomicInteger());
            this.template = templateNode;
            this.visitChildren(templateNode);
        }

        @Override
        public void visitHtmlOpenTagNode(HtmlOpenTagNode openTagNode) {
            KeyNode keyNode = openTagNode.getKeyNode();
            if (keyNode != null) {
                this.keyCounterStack.push(new AtomicInteger());
            } else {
                openTagNode.setKeyId(this.incrementKeyForTemplate(this.template, openTagNode.isElementRoot()));
            }
            this.visitChildren(openTagNode);
        }

        @Override
        public void visitHtmlCloseTagNode(HtmlCloseTagNode closeTagNode) {
            HtmlOpenTagNode openTag;
            if (closeTagNode.getTaggedPairs().size() == 1 && (openTag = (HtmlOpenTagNode)closeTagNode.getTaggedPairs().get(0)).getKeyNode() != null && !(openTag.getParent() instanceof SkipNode)) {
                this.keyCounterStack.pop();
            }
        }

        @Override
        public void visitSkipNode(SkipNode skipNode) {
            if (skipNode.getParent() instanceof HtmlOpenTagNode) {
                HtmlOpenTagNode openTag = (HtmlOpenTagNode)skipNode.getParent();
                openTag.setSkipRoot();
                if (!openTag.isSelfClosing() && openTag.getTaggedPairs().size() > 1) {
                    this.errorReporter.report(openTag.getSourceLocation(), SOY_SKIP_OPEN_TAG_CLOSE_AMBIGUOUS, new Object[0]);
                }
            } else {
                this.errorReporter.report(skipNode.getSourceLocation(), SOY_SKIP_MUST_BE_DIRECT_CHILD_OF_TAG, new Object[0]);
            }
        }

        @Override
        public void visitSoyNode(SoyNode node) {
            if (node instanceof SoyNode.ParentSoyNode) {
                this.visitChildren((SoyNode.ParentSoyNode)node);
            }
        }

        private String incrementKeyForTemplate(TemplateNode template, boolean isElementRoot) {
            if (isElementRoot) {
                return template.getTemplateName() + "-root";
            }
            AtomicInteger keyCounter = this.keyCounterStack.peek();
            return template.getTemplateName() + "-" + keyCounter.getAndIncrement();
        }
    }
}

