/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.passes;

import com.google.common.collect.ImmutableList;
import com.google.template.soy.base.internal.IdGenerator;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.passes.CompilerFileSetPass;
import com.google.template.soy.passes.RunAfter;
import com.google.template.soy.passes.SoyElementPass;
import com.google.template.soy.soytree.FileSetMetadata;
import com.google.template.soy.soytree.Metadata;
import com.google.template.soy.soytree.SoyFileNode;
import java.util.function.Consumer;
import java.util.function.Supplier;

@RunAfter(value={SoyElementPass.class})
class FinalizeTemplateRegistryPass
implements CompilerFileSetPass {
    private final ErrorReporter errorReporter;
    private final Supplier<FileSetMetadata> registryFromDeps;
    private final Consumer<FileSetMetadata> fullRegSetter;

    public FinalizeTemplateRegistryPass(ErrorReporter errorReporter, Supplier<FileSetMetadata> registryFromDeps, Consumer<FileSetMetadata> fullRegSetter) {
        this.errorReporter = errorReporter;
        this.registryFromDeps = registryFromDeps;
        this.fullRegSetter = fullRegSetter;
    }

    @Override
    public CompilerFileSetPass.Result run(ImmutableList<SoyFileNode> sourceFiles, IdGenerator idGenerator) {
        this.fullRegSetter.accept(Metadata.metadataForAst(this.registryFromDeps.get(), sourceFiles, this.errorReporter, null));
        return CompilerFileSetPass.Result.CONTINUE;
    }
}

