/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.passes;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.template.soy.base.internal.IdGenerator;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.exprtree.OperatorNodes;
import com.google.template.soy.passes.CompilerFilePass;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyTreeUtils;
import com.google.template.soy.soytree.TemplateElementNode;

final class EnforceExperimentalFeaturesPass
implements CompilerFilePass {
    private static final SoyErrorKind NON_NULL_ASSERTION_BANNED = SoyErrorKind.of("Non-null assertion operator not supported, use the ''checkNotNull'' function instead.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind WIT_BLOCK_BANNED = SoyErrorKind.of("Do not use jsnamespace or jsclass. They are currently experimental.", new SoyErrorKind.StyleAllowance[0]);
    private final ImmutableSet<String> features;
    private final ErrorReporter reporter;

    EnforceExperimentalFeaturesPass(ImmutableSet<String> features, ErrorReporter reporter) {
        this.features = (ImmutableSet)Preconditions.checkNotNull(features);
        this.reporter = (ErrorReporter)Preconditions.checkNotNull((Object)reporter);
    }

    @Override
    public void run(SoyFileNode file, IdGenerator nodeIdGen) {
        if (!this.features.contains((Object)"enableNonNullAssertionOperator")) {
            SoyTreeUtils.allNodesOfType(file, OperatorNodes.AssertNonNullOpNode.class).forEach(assertNonNullOpNode -> this.reporter.report(assertNonNullOpNode.getSourceLocation(), NON_NULL_ASSERTION_BANNED, new Object[0]));
        }
        if (!this.features.contains((Object)"enableWitBlock")) {
            SoyTreeUtils.allNodesOfType(file, TemplateElementNode.class).forEach(elementNode -> {
                if (elementNode.jsnamespace != null) {
                    this.reporter.report(elementNode.getSourceLocation(), WIT_BLOCK_BANNED, new Object[0]);
                }
            });
        }
    }
}

