/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.passes;

import com.google.template.soy.base.internal.IdGenerator;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.passes.CompilerFilePass;
import com.google.template.soy.soytree.MsgFallbackGroupNode;
import com.google.template.soy.soytree.MsgNode;
import com.google.template.soy.soytree.RawTextNode;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.SoyTreeUtils;

final class CheckNonEmptyMsgNodesPass
implements CompilerFilePass {
    private static final SoyErrorKind EMPTY_MSG_ERROR = SoyErrorKind.of("Empty messages are forbidden.", new SoyErrorKind.StyleAllowance[0]);
    private final ErrorReporter errorReporter;

    CheckNonEmptyMsgNodesPass(ErrorReporter errorReporter) {
        this.errorReporter = errorReporter;
    }

    @Override
    public void run(SoyFileNode file, IdGenerator nodeIdGen) {
        block0: for (MsgFallbackGroupNode groupNode : SoyTreeUtils.getAllNodesOfType(file, MsgFallbackGroupNode.class)) {
            for (MsgNode msg : groupNode.getChildren()) {
                if (!CheckNonEmptyMsgNodesPass.isEmpty(msg)) continue;
                this.errorReporter.report(msg.getSourceLocation(), EMPTY_MSG_ERROR, new Object[0]);
                groupNode.getParent().removeChild(groupNode);
                continue block0;
            }
        }
    }

    private static boolean isEmpty(MsgNode msg) {
        for (SoyNode child : msg.getChildren()) {
            if (child instanceof RawTextNode && ((RawTextNode)child).getRawText().isEmpty()) continue;
            return false;
        }
        return true;
    }
}

