/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.passes;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.template.soy.base.SourceFilePath;
import com.google.template.soy.base.internal.IdGenerator;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.passes.CompilerFileSetPass;
import com.google.template.soy.passes.FinalizeTemplateRegistryPass;
import com.google.template.soy.passes.RunBefore;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.TemplateNode;
import java.util.regex.Pattern;

@RunBefore(value={FinalizeTemplateRegistryPass.class})
public class CheckGeneratedSourcesPass
implements CompilerFileSetPass {
    private static final SoyErrorKind UNBLESSED_GENERATED_FILE = SoyErrorKind.of("Encountered a generated Soy source file but compiler was not invoked with --allow_unblessed_generated_files.", new SoyErrorKind.StyleAllowance[0]);
    private static final Pattern BLESS_COMMENT = Pattern.compile("@SoySourceGenerator=[\\w\\-/]+\\b");
    private final ErrorReporter errorReporter;
    private final ImmutableSet<SourceFilePath> generatedPaths;

    public CheckGeneratedSourcesPass(ErrorReporter errorReporter, ImmutableSet<SourceFilePath> generatedPaths) {
        this.errorReporter = errorReporter;
        this.generatedPaths = generatedPaths;
    }

    @Override
    public CompilerFileSetPass.Result run(ImmutableList<SoyFileNode> sourceFiles, IdGenerator idGenerator) {
        for (SoyFileNode sourceFile : sourceFiles) {
            if (this.check(sourceFile)) continue;
            this.errorReporter.report(sourceFile.getNamespaceDeclaration().getSourceLocation(), UNBLESSED_GENERATED_FILE, new Object[0]);
            return CompilerFileSetPass.Result.STOP;
        }
        return CompilerFileSetPass.Result.CONTINUE;
    }

    private boolean check(SoyFileNode sourceFile) {
        if (!this.generatedPaths.contains((Object)sourceFile.getFilePath())) {
            return true;
        }
        if (sourceFile.getNamespace().equals(TemplateNode.SoyFileHeaderInfo.EMPTY.getNamespace())) {
            return true;
        }
        return sourceFile.getComments().stream().anyMatch(c -> BLESS_COMMENT.matcher(c.getSource()).find());
    }
}

