/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.passes;

import com.google.common.collect.ImmutableList;
import com.google.template.soy.base.internal.IdGenerator;
import com.google.template.soy.passes.CheckTemplateHeaderVarsPass;
import com.google.template.soy.passes.CompilerFileSetPass;
import com.google.template.soy.passes.RunAfter;
import com.google.template.soy.soytree.AbstractSoyNodeVisitor;
import com.google.template.soy.soytree.CallNode;
import com.google.template.soy.soytree.HtmlCloseTagNode;
import com.google.template.soy.soytree.HtmlOpenTagNode;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.TemplateNode;
import java.util.ArrayDeque;

@RunAfter(value={CheckTemplateHeaderVarsPass.class})
final class CallAnnotationPass
implements CompilerFileSetPass {
    CallAnnotationPass() {
    }

    @Override
    public CompilerFileSetPass.Result run(ImmutableList<SoyFileNode> sourceFiles, IdGenerator idGenerator) {
        for (SoyFileNode file : sourceFiles) {
            for (TemplateNode template : file.getTemplates()) {
                new KeyGenerator(template.getTemplateName()).exec(template);
            }
        }
        return CompilerFileSetPass.Result.CONTINUE;
    }

    private static class KeyGenerator
    extends AbstractSoyNodeVisitor<Void> {
        private final ArrayDeque<Integer> idStack = new ArrayDeque();
        private final String templateName;

        public KeyGenerator(String templateName) {
            this.idStack.push(0);
            this.templateName = templateName;
        }

        @Override
        protected void visitHtmlOpenTagNode(HtmlOpenTagNode node) {
            if (node.getKeyNode() != null && !node.isSkipRoot()) {
                this.idStack.push(0);
            }
            this.visitChildren(node);
        }

        @Override
        protected void visitCallNode(CallNode node) {
            int id = this.idStack.pop();
            node.setTemplateCallKey(this.templateName + "-call-" + id);
            this.idStack.push(id + 1);
            this.visitChildren(node);
        }

        @Override
        protected void visitHtmlCloseTagNode(HtmlCloseTagNode node) {
            HtmlOpenTagNode openTag;
            if (node.getTaggedPairs().size() == 1 && (openTag = (HtmlOpenTagNode)node.getTaggedPairs().get(0)).getKeyNode() != null && !openTag.isSkipRoot()) {
                this.idStack.pop();
            }
        }

        @Override
        protected void visitSoyNode(SoyNode node) {
            if (node instanceof SoyNode.ParentSoyNode) {
                this.visitChildren((SoyNode.ParentSoyNode)node);
            }
        }
    }
}

