/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.parsepasses.contextautoesc;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.template.soy.base.internal.IdGenerator;
import com.google.template.soy.base.internal.Identifier;
import com.google.template.soy.base.internal.SanitizedContentKind;
import com.google.template.soy.data.SanitizedContent;
import com.google.template.soy.data.SanitizedContentOperator;
import com.google.template.soy.data.internal.Converters;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.exprtree.TemplateLiteralNode;
import com.google.template.soy.exprtree.VarRefNode;
import com.google.template.soy.parsepasses.contextautoesc.Inferences;
import com.google.template.soy.shared.internal.ShortCircuitable;
import com.google.template.soy.shared.internal.ShortCircuitables;
import com.google.template.soy.shared.restricted.SoyPrintDirective;
import com.google.template.soy.soytree.AbstractSoyNodeVisitor;
import com.google.template.soy.soytree.CallBasicNode;
import com.google.template.soy.soytree.CallNode;
import com.google.template.soy.soytree.CallParamContentNode;
import com.google.template.soy.soytree.CallParamNode;
import com.google.template.soy.soytree.CallParamValueNode;
import com.google.template.soy.soytree.EscapingMode;
import com.google.template.soy.soytree.LetContentNode;
import com.google.template.soy.soytree.MsgFallbackGroupNode;
import com.google.template.soy.soytree.PrintDirectiveNode;
import com.google.template.soy.soytree.PrintNode;
import com.google.template.soy.soytree.RawTextNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.SoyTreeUtils;
import com.google.template.soy.soytree.TemplateNode;
import com.google.template.soy.soytree.Visibility;
import com.google.template.soy.soytree.defn.LocalVar;
import com.google.template.soy.soytree.defn.TemplateParam;
import com.google.template.soy.types.SanitizedType;
import com.google.template.soy.types.TemplateType;
import java.util.function.Function;
import javax.annotation.Nullable;

final class Rewriter {
    private final Inferences inferences;
    private final IdGenerator idGen;
    private final ImmutableMap<String, ? extends SoyPrintDirective> printDirectives;
    private final RewriterVisitor mutator = new RewriterVisitor();

    Rewriter(Inferences inferences, IdGenerator idGen, ImmutableList<? extends SoyPrintDirective> printDirectives) {
        this.inferences = inferences;
        this.idGen = idGen;
        this.printDirectives = (ImmutableMap)printDirectives.stream().filter(d -> EscapingMode.fromDirective(d.getName()) != null).collect(ImmutableMap.toImmutableMap(SoyPrintDirective::getName, Function.identity()));
    }

    public void rewrite(SoyNode node) {
        this.mutator.exec(node);
    }

    private final class RewriterVisitor
    extends AbstractSoyNodeVisitor<Void> {
        private RewriterVisitor() {
        }

        @Override
        protected void visitPrintNode(PrintNode printNode) {
            SanitizedContentKind trustedKind;
            Object directive;
            ImmutableList<EscapingMode> escapingModes = Rewriter.this.inferences.getEscapingModesForNode(printNode);
            for (EscapingMode escapingMode : escapingModes) {
                int newPrintDirectiveIndex;
                directive = (SoyPrintDirective)Rewriter.this.printDirectives.get((Object)escapingMode.directiveName);
                if (directive == null) {
                    throw new IllegalStateException("Couldn't find directive for EscapingMode " + (Object)((Object)escapingMode));
                }
                PrintDirectiveNode newPrintDirective = PrintDirectiveNode.createSyntheticNode(Rewriter.this.idGen.genId(), Identifier.create(escapingMode.directiveName, printNode.getSourceLocation()), printNode.getSourceLocation(), (SoyPrintDirective)directive);
                for (newPrintDirectiveIndex = printNode.numChildren(); newPrintDirectiveIndex > 0; --newPrintDirectiveIndex) {
                    SanitizedContentKind contentKind;
                    SoyPrintDirective printDirective = ((PrintDirectiveNode)printNode.getChild(newPrintDirectiveIndex - 1)).getPrintDirective();
                    SanitizedContentKind sanitizedContentKind = contentKind = printDirective instanceof SanitizedContentOperator ? SanitizedContentKind.valueOf(((SanitizedContentOperator)((Object)printDirective)).getContentKind().name()) : null;
                    if (contentKind == null || contentKind != escapingMode.contentKind) break;
                }
                printNode.addChild(newPrintDirectiveIndex, newPrintDirective);
            }
            if (!printNode.hasUserSpecifiedPrintDirectives() && (trustedKind = this.getTrustedContentKindForNode(printNode)) != null) {
                SanitizedContent.ContentKind trustedContentKind = SanitizedContent.ContentKind.valueOf(trustedKind.name());
                while (printNode.numChildren() > 0 && ((PrintDirectiveNode)(directive = (PrintDirectiveNode)printNode.getChild(0))).getPrintDirective() instanceof ShortCircuitable && ((ShortCircuitable)((Object)((PrintDirectiveNode)directive).getPrintDirective())).isNoopForKind(trustedContentKind)) {
                    printNode.removeChild(0);
                }
            }
        }

        @Nullable
        private SanitizedContentKind getTrustedContentKindForNode(SoyNode.ExprHolderNode exprHolder) {
            return this.getTrustedContentKindForNode(exprHolder, true);
        }

        @Nullable
        private SanitizedContentKind getTrustedContentKindForNode(SoyNode.ExprHolderNode exprHolder, boolean followCalls) {
            ExprNode expr = ((ExprRootNode)Iterables.getOnlyElement(exprHolder.getExprList())).getRoot();
            if (!(expr instanceof VarRefNode)) {
                return null;
            }
            VarRefNode varRef = (VarRefNode)expr;
            if (varRef.getDefnDecl() instanceof LocalVar) {
                LocalVar var = (LocalVar)varRef.getDefnDecl();
                if (var.declaringNode() instanceof LetContentNode) {
                    return ((LetContentNode)var.declaringNode()).getContentKind();
                }
            } else if (varRef.getDefnDecl() instanceof TemplateParam && followCalls) {
                TemplateParam param = (TemplateParam)varRef.getDefnDecl();
                return this.getTrustedContentKindForParameter(exprHolder.getNearestAncestor(TemplateNode.class), param);
            }
            return null;
        }

        private SanitizedContentKind getTrustedContentKindForParameter(TemplateNode template, TemplateParam param) {
            if (param.isInjected()) {
                return null;
            }
            if (!param.type().getKind().isKnownSanitizedContent()) {
                return null;
            }
            if (SoyTreeUtils.allNodesOfType(template.getParent(), TemplateLiteralNode.class).anyMatch(templateLiteral -> !templateLiteral.isStaticCall() && templateLiteral.getResolvedName().equals(template.getTemplateName()))) {
                return null;
            }
            SanitizedContentKind expectedKind = ((SanitizedType)param.type()).getContentKind();
            if (template.getVisibility() != Visibility.PRIVATE) {
                return null;
            }
            for (CallBasicNode callNode : SoyTreeUtils.getAllNodesOfType(template.getParent(), CallBasicNode.class)) {
                if (!callNode.isStaticCall() || !callNode.getCalleeName().equals(template.getTemplateName()) || this.doesCallPassCompatibleContentForParameter(callNode, expectedKind, param.name())) continue;
                return null;
            }
            return expectedKind;
        }

        private boolean doesCallPassCompatibleContentForParameter(CallNode callNode, SanitizedContentKind expectedKind, String parameter) {
            for (CallParamNode callParam : callNode.getChildren()) {
                if (!callParam.getKey().identifier().equals(parameter)) continue;
                if (callParam instanceof CallParamContentNode && ((CallParamContentNode)callParam).getContentKind() == expectedKind) {
                    return true;
                }
                if (!(callParam instanceof CallParamValueNode) || this.getTrustedContentKindForNode((CallParamValueNode)callParam, false) != expectedKind) continue;
                return true;
            }
            return false;
        }

        @Override
        protected void visitRawTextNode(RawTextNode rawTextNode) {
        }

        private ImmutableList<SoyPrintDirective> getDirectivesForNode(SoyNode node) {
            ImmutableList.Builder escapingDirectiveNames = new ImmutableList.Builder();
            for (EscapingMode escapingMode : Rewriter.this.inferences.getEscapingModesForNode(node)) {
                escapingDirectiveNames.add((Object)((SoyPrintDirective)Rewriter.this.printDirectives.get((Object)escapingMode.directiveName)));
            }
            return escapingDirectiveNames.build();
        }

        @Override
        protected void visitMsgFallbackGroupNode(MsgFallbackGroupNode node) {
            node.setEscapingDirectives(this.getDirectivesForNode(node));
            this.visitChildren(node);
        }

        @Override
        protected void visitCallNode(CallNode node) {
            ImmutableList<TemplateType> targets;
            ImmutableList<SoyPrintDirective> directives = this.getDirectivesForNode(node);
            if (node instanceof CallBasicNode && !(targets = Rewriter.this.inferences.lookupTemplates(node)).isEmpty()) {
                directives = ShortCircuitables.filterDirectivesForKind(Converters.contentKindfromSanitizedContentKind(((TemplateType)targets.get(0)).getContentKind().getSanitizedContentKind()), directives);
            }
            node.setEscapingDirectives(directives);
            this.visitChildren(node);
        }

        @Override
        protected void visitSoyNode(SoyNode node) {
            if (node instanceof SoyNode.ParentSoyNode) {
                this.visitChildren((SoyNode.ParentSoyNode)node);
            }
        }
    }
}

