/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.parsepasses.contextautoesc;

import com.google.common.base.Preconditions;
import com.google.template.soy.parsepasses.contextautoesc.Context;
import com.google.template.soy.parsepasses.contextautoesc.JsLexerConstants;
import com.google.template.soy.parsepasses.contextautoesc.LexerError;
import com.google.template.soy.parsepasses.contextautoesc.SimpleCharStream;
import com.google.template.soy.parsepasses.contextautoesc.Token;
import com.google.template.soy.parsepasses.contextautoesc.TokenMgrError;
import com.google.template.soy.soytree.HtmlContext;
import java.io.IOException;
import java.io.PrintStream;
import java.io.StringReader;

class JsLexerTokenManager
implements JsLexerConstants {
    private Context currentContext;
    public PrintStream debugStream = System.out;
    static final long[] jjbitVec0 = new long[]{0x30000000000L, 0L, 0L, 0L};
    static final long[] jjbitVec1 = new long[]{-2L, -1L, -1L, -1L};
    static final long[] jjbitVec3 = new long[]{0L, 0L, -1L, -1L};
    static final int[] jjnextStates = new int[]{12, 13, 18, 19, 8, 9, 16, 17, 20, 21, 4, 6};
    public static final String[] jjstrLiteralImages = new String[]{"", null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null};
    int curLexState = 8;
    int defaultLexState = 8;
    int jjnewStateCnt;
    int jjround;
    int jjmatchedPos;
    int jjmatchedKind;
    public static final String[] lexStateNames = new String[]{"TEMPLATE_LITERAL", "SQ_STRING", "DQ_STRING", "REGEX_CHARACTER_CLASS", "REGEX", "LINE_COMMENT", "BLOCK_COMMENT", "TEMPLATE_LITERAL_EXPRESSION", "DEFAULT"};
    public static final int[] jjnewLexState = new int[]{-1, -1, -1, 0, -1, -1, 6, 5, 2, 1, 0, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 3, -1, 4, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 7, -1, -1};
    static final long[] jjtoToken = new long[]{1L, 0L};
    static final long[] jjtoSkip = new long[]{-8L, 0x3FFFFFDFFFFL};
    protected SimpleCharStream input_stream;
    private final int[] jjrounds = new int[26];
    private final int[] jjstateSet = new int[52];
    private final StringBuilder jjimage;
    private StringBuilder image = this.jjimage = new StringBuilder();
    private int jjimageLen;
    private int lengthOfMatch;
    protected int curChar;

    static Context calculateTransitions(Context starting, String text, int offset) {
        StringReader reader = new StringReader(text);
        if (offset > 0) {
            try {
                reader.skip(offset);
            }
            catch (IOException ioe) {
                throw new AssertionError((Object)ioe);
            }
        } else if (offset < 0) {
            throw new IllegalArgumentException("negative offset?: " + offset);
        }
        JsLexerTokenManager mgr = new JsLexerTokenManager(new SimpleCharStream(reader), JsLexerTokenManager.lexicalStateFromContext(starting));
        mgr.currentContext = starting;
        Token tok = mgr.getNextToken();
        if (tok.kind != 0) {
            throw new IllegalStateException("Failed to process all of the text");
        }
        if (mgr.curLexState == 3) {
            mgr.error("Invalid JS regular expression character class.  Expected ']'.");
        }
        return mgr.currentContext;
    }

    private static int lexicalStateFromContext(Context context) {
        switch (context.state()) {
            case HTML_PCDATA: 
            case HTML_RCDATA: 
            case HTML_BEFORE_OPEN_TAG_NAME: 
            case HTML_BEFORE_CLOSE_TAG_NAME: 
            case HTML_TAG_NAME: 
            case HTML_TAG: 
            case HTML_ATTRIBUTE_NAME: 
            case HTML_COMMENT: 
            case HTML_NORMAL_ATTR_VALUE: 
            case HTML_HTML_ATTR_VALUE: 
            case HTML_META_REFRESH_CONTENT: 
            case CSS: 
            case CSS_COMMENT: 
            case CSS_DQ_STRING: 
            case CSS_SQ_STRING: 
            case CSS_URI: 
            case CSS_DQ_URI: 
            case CSS_SQ_URI: 
            case URI: 
            case TEXT: 
            case HTML_SCRIPT_PHRASING_DATA: {
                throw new IllegalArgumentException("the js lexer doesn't support this context: " + context);
            }
            case JS: {
                return context.jsTemplateLiteralNestDepth() > 0 ? 7 : 8;
            }
            case JS_LINE_COMMENT: {
                return 5;
            }
            case JS_BLOCK_COMMENT: {
                return 6;
            }
            case JS_DQ_STRING: {
                return 2;
            }
            case JS_SQ_STRING: {
                return 1;
            }
            case JS_REGEX: {
                return 4;
            }
            case JS_TEMPLATE_LITERAL: {
                return 0;
            }
        }
        throw new AssertionError((Object)("unhandled state: " + context));
    }

    private void transitionToState(HtmlContext state) {
        this.currentContext = this.currentContext.transitionToState(state);
    }

    private void transitionToJsStringLiteral(HtmlContext state) {
        this.currentContext = this.currentContext.toBuilder().withState(state).withSlashType(Context.JsFollowingSlash.NONE).withUriPart(Context.UriPart.NONE).build();
    }

    private void switchToDefaultOrTemplateLiteral() {
        if (this.currentContext.jsTemplateLiteralNestDepth() > 0) {
            this.SwitchTo(7);
        } else {
            this.SwitchTo(8);
        }
    }

    private void transitionToJsDivPreceder() {
        Preconditions.checkState((this.currentContext.state() == HtmlContext.JS || this.currentContext.state() == HtmlContext.JS_TEMPLATE_LITERAL ? 1 : 0) != 0, (String)"Expected state to be JS was: %s", (Object)this.currentContext);
        this.currentContext = this.currentContext.derive(Context.JsFollowingSlash.DIV_OP);
    }

    private void transitionToJsRegexPreceder() {
        Preconditions.checkState((this.currentContext.state() == HtmlContext.JS || this.currentContext.state() == HtmlContext.JS_TEMPLATE_LITERAL ? 1 : 0) != 0, (String)"Expected state to be JS was: %s", (Object)this.currentContext);
        this.currentContext = this.currentContext.derive(Context.JsFollowingSlash.REGEX);
    }

    private void error(String explanation) {
        throw new LexerError(explanation, this.input_stream.bufpos);
    }

    public String toString() {
        return "TokenManager{" + lexStateNames[this.curLexState] + ", context=" + this.currentContext + "}";
    }

    public void setDebugStream(PrintStream ds) {
        this.debugStream = ds;
    }

    private final int jjStopStringLiteralDfa_7(int pos, long active0, long active1) {
        switch (pos) {
            case 0: {
                if ((active0 & 0x10000000L) != 0L) {
                    return 10;
                }
                if ((active0 & 0x700000000L) != 0L) {
                    return 6;
                }
                if ((active1 & 0x1FFEL) != 0L) {
                    this.jjmatchedKind = 82;
                    return 10;
                }
                return -1;
            }
            case 1: {
                if ((active1 & 0x20L) != 0L) {
                    return 10;
                }
                if ((active1 & 0x1FDEL) != 0L) {
                    if (this.jjmatchedPos != 1) {
                        this.jjmatchedKind = 82;
                        this.jjmatchedPos = 1;
                    }
                    return 10;
                }
                return -1;
            }
            case 2: {
                if ((active1 & 0x800L) != 0L) {
                    return 10;
                }
                if ((active1 & 0x17DEL) != 0L) {
                    if (this.jjmatchedPos != 2) {
                        this.jjmatchedKind = 82;
                        this.jjmatchedPos = 2;
                    }
                    return 10;
                }
                return -1;
            }
            case 3: {
                if ((active1 & 0x44L) != 0L) {
                    return 10;
                }
                if ((active1 & 0x179AL) != 0L) {
                    this.jjmatchedKind = 82;
                    this.jjmatchedPos = 3;
                    return 10;
                }
                return -1;
            }
            case 4: {
                if ((active1 & 0x1002L) != 0L) {
                    return 10;
                }
                if ((active1 & 0x798L) != 0L) {
                    this.jjmatchedKind = 82;
                    this.jjmatchedPos = 4;
                    return 10;
                }
                return -1;
            }
            case 5: {
                if ((active1 & 0x610L) != 0L) {
                    return 10;
                }
                if ((active1 & 0x188L) != 0L) {
                    this.jjmatchedKind = 82;
                    this.jjmatchedPos = 5;
                    return 10;
                }
                return -1;
            }
            case 6: {
                if ((active1 & 0x80L) != 0L) {
                    return 10;
                }
                if ((active1 & 0x108L) != 0L) {
                    this.jjmatchedKind = 82;
                    this.jjmatchedPos = 6;
                    return 10;
                }
                return -1;
            }
            case 7: {
                if ((active1 & 8L) != 0L) {
                    return 10;
                }
                if ((active1 & 0x100L) != 0L) {
                    this.jjmatchedKind = 82;
                    this.jjmatchedPos = 7;
                    return 10;
                }
                return -1;
            }
            case 8: {
                if ((active1 & 0x100L) != 0L) {
                    this.jjmatchedKind = 82;
                    this.jjmatchedPos = 8;
                    return 10;
                }
                return -1;
            }
        }
        return -1;
    }

    private final int jjStartNfa_7(int pos, long active0, long active1) {
        return this.jjMoveNfa_7(this.jjStopStringLiteralDfa_7(pos, active0, active1), pos + 1);
    }

    private int jjStopAtPos(int pos, int kind) {
        this.jjmatchedKind = kind;
        this.jjmatchedPos = pos;
        return pos + 1;
    }

    private int jjMoveStringLiteralDfa0_7() {
        switch (this.curChar) {
            case 33: {
                this.jjmatchedKind = 14;
                return this.jjMoveStringLiteralDfa1_7(98304L, 0L);
            }
            case 34: {
                return this.jjStopAtPos(0, 8);
            }
            case 35: {
                return this.jjStopAtPos(0, 17);
            }
            case 37: {
                this.jjmatchedKind = 18;
                return this.jjMoveStringLiteralDfa1_7(524288L, 0L);
            }
            case 38: {
                this.jjmatchedKind = 20;
                return this.jjMoveStringLiteralDfa1_7(0x600000L, 0L);
            }
            case 39: {
                return this.jjStopAtPos(0, 9);
            }
            case 40: {
                return this.jjStopAtPos(0, 23);
            }
            case 42: {
                this.jjmatchedKind = 24;
                return this.jjMoveStringLiteralDfa1_7(0x2000000L, 0L);
            }
            case 43: {
                this.jjmatchedKind = 26;
                return this.jjMoveStringLiteralDfa1_7(0x8001000L, 0L);
            }
            case 44: {
                return this.jjStartNfaWithStates_7(0, 28, 10);
            }
            case 45: {
                this.jjmatchedKind = 29;
                return this.jjMoveStringLiteralDfa1_7(0xC0002000L, 0L);
            }
            case 46: {
                this.jjmatchedKind = 32;
                return this.jjMoveStringLiteralDfa1_7(0x600000000L, 0L);
            }
            case 47: {
                this.jjmatchedKind = 11;
                return this.jjMoveStringLiteralDfa1_7(0x8000000C0L, 0L);
            }
            case 58: {
                this.jjmatchedKind = 36;
                return this.jjMoveStringLiteralDfa1_7(0x2000000000L, 0L);
            }
            case 59: {
                return this.jjStopAtPos(0, 38);
            }
            case 60: {
                this.jjmatchedKind = 39;
                return this.jjMoveStringLiteralDfa1_7(0x70000000000L, 0L);
            }
            case 61: {
                this.jjmatchedKind = 43;
                return this.jjMoveStringLiteralDfa1_7(0x300000000000L, 0L);
            }
            case 62: {
                this.jjmatchedKind = 46;
                return this.jjMoveStringLiteralDfa1_7(0xF800000000000L, 0L);
            }
            case 63: {
                return this.jjStopAtPos(0, 52);
            }
            case 64: {
                return this.jjStopAtPos(0, 53);
            }
            case 91: {
                return this.jjStopAtPos(0, 54);
            }
            case 94: {
                this.jjmatchedKind = 55;
                return this.jjMoveStringLiteralDfa1_7(0x700000000000000L, 0L);
            }
            case 96: {
                return this.jjStopAtPos(0, 10);
            }
            case 98: {
                return this.jjMoveStringLiteralDfa1_7(0L, 2L);
            }
            case 99: {
                return this.jjMoveStringLiteralDfa1_7(0L, 12L);
            }
            case 100: {
                return this.jjMoveStringLiteralDfa1_7(0L, 48L);
            }
            case 101: {
                return this.jjMoveStringLiteralDfa1_7(0L, 64L);
            }
            case 102: {
                return this.jjMoveStringLiteralDfa1_7(0L, 128L);
            }
            case 105: {
                return this.jjMoveStringLiteralDfa1_7(0L, 256L);
            }
            case 114: {
                return this.jjMoveStringLiteralDfa1_7(0L, 512L);
            }
            case 116: {
                return this.jjMoveStringLiteralDfa1_7(0L, 7168L);
            }
            case 123: {
                return this.jjStopAtPos(0, 59);
            }
            case 124: {
                this.jjmatchedKind = 60;
                return this.jjMoveStringLiteralDfa1_7(-2305843009213693952L, 0L);
            }
            case 125: {
                return this.jjStopAtPos(0, 3);
            }
            case 126: {
                return this.jjStopAtPos(0, 64);
            }
        }
        return this.jjMoveNfa_7(0, 0);
    }

    private int jjMoveStringLiteralDfa1_7(long active0, long active1) {
        try {
            this.curChar = this.input_stream.readChar();
        }
        catch (IOException e) {
            this.jjStopStringLiteralDfa_7(0, active0, active1);
            return 1;
        }
        switch (this.curChar) {
            case 38: {
                if ((active0 & 0x200000L) != 0L) {
                    this.jjmatchedKind = 21;
                    this.jjmatchedPos = 1;
                }
                return this.jjMoveStringLiteralDfa2_7(active0, 0x400000L, active1, 0L);
            }
            case 42: {
                if ((active0 & 0x40L) == 0L) break;
                return this.jjStopAtPos(1, 6);
            }
            case 43: {
                if ((active0 & 0x1000L) == 0L) break;
                return this.jjStopAtPos(1, 12);
            }
            case 45: {
                if ((active0 & 0x2000L) == 0L) break;
                return this.jjStopAtPos(1, 13);
            }
            case 46: {
                if ((active0 & 0x200000000L) != 0L) {
                    this.jjmatchedKind = 33;
                    this.jjmatchedPos = 1;
                }
                return this.jjMoveStringLiteralDfa2_7(active0, 0x400000000L, active1, 0L);
            }
            case 47: {
                if ((active0 & 0x80L) == 0L) break;
                return this.jjStopAtPos(1, 7);
            }
            case 58: {
                if ((active0 & 0x2000000000L) == 0L) break;
                return this.jjStopAtPos(1, 37);
            }
            case 60: {
                if ((active0 & 0x20000000000L) != 0L) {
                    this.jjmatchedKind = 41;
                    this.jjmatchedPos = 1;
                }
                return this.jjMoveStringLiteralDfa2_7(active0, 0x40000000000L, active1, 0L);
            }
            case 61: {
                if ((active0 & 0x8000L) != 0L) {
                    this.jjmatchedKind = 15;
                    this.jjmatchedPos = 1;
                } else {
                    if ((active0 & 0x80000L) != 0L) {
                        return this.jjStopAtPos(1, 19);
                    }
                    if ((active0 & 0x2000000L) != 0L) {
                        return this.jjStopAtPos(1, 25);
                    }
                    if ((active0 & 0x8000000L) != 0L) {
                        return this.jjStopAtPos(1, 27);
                    }
                    if ((active0 & 0x40000000L) != 0L) {
                        return this.jjStopAtPos(1, 30);
                    }
                    if ((active0 & 0x800000000L) != 0L) {
                        return this.jjStopAtPos(1, 35);
                    }
                    if ((active0 & 0x10000000000L) != 0L) {
                        return this.jjStopAtPos(1, 40);
                    }
                    if ((active0 & 0x100000000000L) != 0L) {
                        this.jjmatchedKind = 44;
                        this.jjmatchedPos = 1;
                    } else {
                        if ((active0 & 0x800000000000L) != 0L) {
                            return this.jjStopAtPos(1, 47);
                        }
                        if ((active0 & 0x100000000000000L) != 0L) {
                            return this.jjStopAtPos(1, 56);
                        }
                        if ((active0 & 0x2000000000000000L) != 0L) {
                            return this.jjStopAtPos(1, 61);
                        }
                    }
                }
                return this.jjMoveStringLiteralDfa2_7(active0, 0x200000010000L, active1, 0L);
            }
            case 62: {
                if ((active0 & 0x80000000L) != 0L) {
                    return this.jjStopAtPos(1, 31);
                }
                if ((active0 & 0x1000000000000L) != 0L) {
                    this.jjmatchedKind = 48;
                    this.jjmatchedPos = 1;
                }
                return this.jjMoveStringLiteralDfa2_7(active0, 0xE000000000000L, active1, 0L);
            }
            case 94: {
                if ((active0 & 0x200000000000000L) != 0L) {
                    this.jjmatchedKind = 57;
                    this.jjmatchedPos = 1;
                }
                return this.jjMoveStringLiteralDfa2_7(active0, 0x400000000000000L, active1, 0L);
            }
            case 97: {
                return this.jjMoveStringLiteralDfa2_7(active0, 0L, active1, 4L);
            }
            case 101: {
                return this.jjMoveStringLiteralDfa2_7(active0, 0L, active1, 528L);
            }
            case 104: {
                return this.jjMoveStringLiteralDfa2_7(active0, 0L, active1, 4096L);
            }
            case 105: {
                return this.jjMoveStringLiteralDfa2_7(active0, 0L, active1, 128L);
            }
            case 108: {
                return this.jjMoveStringLiteralDfa2_7(active0, 0L, active1, 64L);
            }
            case 110: {
                return this.jjMoveStringLiteralDfa2_7(active0, 0L, active1, 256L);
            }
            case 111: {
                if ((active1 & 0x20L) != 0L) {
                    return this.jjStartNfaWithStates_7(1, 69, 10);
                }
                return this.jjMoveStringLiteralDfa2_7(active0, 0L, active1, 8L);
            }
            case 114: {
                return this.jjMoveStringLiteralDfa2_7(active0, 0L, active1, 2050L);
            }
            case 121: {
                return this.jjMoveStringLiteralDfa2_7(active0, 0L, active1, 1024L);
            }
            case 124: {
                if ((active0 & 0x4000000000000000L) != 0L) {
                    this.jjmatchedKind = 62;
                    this.jjmatchedPos = 1;
                }
                return this.jjMoveStringLiteralDfa2_7(active0, Long.MIN_VALUE, active1, 0L);
            }
        }
        return this.jjStartNfa_7(0, active0, active1);
    }

    private int jjMoveStringLiteralDfa2_7(long old0, long active0, long old1, long active1) {
        if (((active0 &= old0) | (active1 &= old1)) == 0L) {
            return this.jjStartNfa_7(0, old0, old1);
        }
        try {
            this.curChar = this.input_stream.readChar();
        }
        catch (IOException e) {
            this.jjStopStringLiteralDfa_7(1, active0, active1);
            return 2;
        }
        switch (this.curChar) {
            case 46: {
                if ((active0 & 0x400000000L) == 0L) break;
                return this.jjStopAtPos(2, 34);
            }
            case 61: {
                if ((active0 & 0x10000L) != 0L) {
                    return this.jjStopAtPos(2, 16);
                }
                if ((active0 & 0x400000L) != 0L) {
                    return this.jjStopAtPos(2, 22);
                }
                if ((active0 & 0x40000000000L) != 0L) {
                    return this.jjStopAtPos(2, 42);
                }
                if ((active0 & 0x200000000000L) != 0L) {
                    return this.jjStopAtPos(2, 45);
                }
                if ((active0 & 0x2000000000000L) != 0L) {
                    return this.jjStopAtPos(2, 49);
                }
                if ((active0 & 0x400000000000000L) != 0L) {
                    return this.jjStopAtPos(2, 58);
                }
                if ((active0 & Long.MIN_VALUE) == 0L) break;
                return this.jjStopAtPos(2, 63);
            }
            case 62: {
                if ((active0 & 0x4000000000000L) != 0L) {
                    this.jjmatchedKind = 50;
                    this.jjmatchedPos = 2;
                }
                return this.jjMoveStringLiteralDfa3_7(active0, 0x8000000000000L, active1, 0L);
            }
            case 101: {
                return this.jjMoveStringLiteralDfa3_7(active0, 0L, active1, 2L);
            }
            case 108: {
                return this.jjMoveStringLiteralDfa3_7(active0, 0L, active1, 16L);
            }
            case 110: {
                return this.jjMoveStringLiteralDfa3_7(active0, 0L, active1, 136L);
            }
            case 112: {
                return this.jjMoveStringLiteralDfa3_7(active0, 0L, active1, 1024L);
            }
            case 114: {
                return this.jjMoveStringLiteralDfa3_7(active0, 0L, active1, 4096L);
            }
            case 115: {
                return this.jjMoveStringLiteralDfa3_7(active0, 0L, active1, 324L);
            }
            case 116: {
                return this.jjMoveStringLiteralDfa3_7(active0, 0L, active1, 512L);
            }
            case 121: {
                if ((active1 & 0x800L) == 0L) break;
                return this.jjStartNfaWithStates_7(2, 75, 10);
            }
        }
        return this.jjStartNfa_7(1, active0, active1);
    }

    private int jjMoveStringLiteralDfa3_7(long old0, long active0, long old1, long active1) {
        if (((active0 &= old0) | (active1 &= old1)) == 0L) {
            return this.jjStartNfa_7(1, old0, old1);
        }
        try {
            this.curChar = this.input_stream.readChar();
        }
        catch (IOException e) {
            this.jjStopStringLiteralDfa_7(2, active0, active1);
            return 3;
        }
        switch (this.curChar) {
            case 61: {
                if ((active0 & 0x8000000000000L) == 0L) break;
                return this.jjStopAtPos(3, 51);
            }
            case 97: {
                return this.jjMoveStringLiteralDfa4_7(active0, 0L, active1, 130L);
            }
            case 101: {
                if ((active1 & 4L) != 0L) {
                    return this.jjStartNfaWithStates_7(3, 66, 10);
                }
                if ((active1 & 0x40L) != 0L) {
                    return this.jjStartNfaWithStates_7(3, 70, 10);
                }
                return this.jjMoveStringLiteralDfa4_7(active0, 0L, active1, 1040L);
            }
            case 111: {
                return this.jjMoveStringLiteralDfa4_7(active0, 0L, active1, 4096L);
            }
            case 116: {
                return this.jjMoveStringLiteralDfa4_7(active0, 0L, active1, 264L);
            }
            case 117: {
                return this.jjMoveStringLiteralDfa4_7(active0, 0L, active1, 512L);
            }
        }
        return this.jjStartNfa_7(2, active0, active1);
    }

    private int jjMoveStringLiteralDfa4_7(long old0, long active0, long old1, long active1) {
        if (((active0 &= old0) | (active1 &= old1)) == 0L) {
            return this.jjStartNfa_7(2, old0, old1);
        }
        try {
            this.curChar = this.input_stream.readChar();
        }
        catch (IOException e) {
            this.jjStopStringLiteralDfa_7(3, 0L, active1);
            return 4;
        }
        switch (this.curChar) {
            case 97: {
                return this.jjMoveStringLiteralDfa5_7(active1, 256L);
            }
            case 105: {
                return this.jjMoveStringLiteralDfa5_7(active1, 8L);
            }
            case 107: {
                if ((active1 & 2L) == 0L) break;
                return this.jjStartNfaWithStates_7(4, 65, 10);
            }
            case 108: {
                return this.jjMoveStringLiteralDfa5_7(active1, 128L);
            }
            case 111: {
                return this.jjMoveStringLiteralDfa5_7(active1, 1024L);
            }
            case 114: {
                return this.jjMoveStringLiteralDfa5_7(active1, 512L);
            }
            case 116: {
                return this.jjMoveStringLiteralDfa5_7(active1, 16L);
            }
            case 119: {
                if ((active1 & 0x1000L) == 0L) break;
                return this.jjStartNfaWithStates_7(4, 76, 10);
            }
        }
        return this.jjStartNfa_7(3, 0L, active1);
    }

    private int jjMoveStringLiteralDfa5_7(long old1, long active1) {
        if ((active1 &= old1) == 0L) {
            return this.jjStartNfa_7(3, 0L, old1);
        }
        try {
            this.curChar = this.input_stream.readChar();
        }
        catch (IOException e) {
            this.jjStopStringLiteralDfa_7(4, 0L, active1);
            return 5;
        }
        switch (this.curChar) {
            case 101: {
                if ((active1 & 0x10L) == 0L) break;
                return this.jjStartNfaWithStates_7(5, 68, 10);
            }
            case 102: {
                if ((active1 & 0x400L) == 0L) break;
                return this.jjStartNfaWithStates_7(5, 74, 10);
            }
            case 108: {
                return this.jjMoveStringLiteralDfa6_7(active1, 128L);
            }
            case 110: {
                if ((active1 & 0x200L) != 0L) {
                    return this.jjStartNfaWithStates_7(5, 73, 10);
                }
                return this.jjMoveStringLiteralDfa6_7(active1, 264L);
            }
        }
        return this.jjStartNfa_7(4, 0L, active1);
    }

    private int jjMoveStringLiteralDfa6_7(long old1, long active1) {
        if ((active1 &= old1) == 0L) {
            return this.jjStartNfa_7(4, 0L, old1);
        }
        try {
            this.curChar = this.input_stream.readChar();
        }
        catch (IOException e) {
            this.jjStopStringLiteralDfa_7(5, 0L, active1);
            return 6;
        }
        switch (this.curChar) {
            case 99: {
                return this.jjMoveStringLiteralDfa7_7(active1, 256L);
            }
            case 117: {
                return this.jjMoveStringLiteralDfa7_7(active1, 8L);
            }
            case 121: {
                if ((active1 & 0x80L) == 0L) break;
                return this.jjStartNfaWithStates_7(6, 71, 10);
            }
        }
        return this.jjStartNfa_7(5, 0L, active1);
    }

    private int jjMoveStringLiteralDfa7_7(long old1, long active1) {
        if ((active1 &= old1) == 0L) {
            return this.jjStartNfa_7(5, 0L, old1);
        }
        try {
            this.curChar = this.input_stream.readChar();
        }
        catch (IOException e) {
            this.jjStopStringLiteralDfa_7(6, 0L, active1);
            return 7;
        }
        switch (this.curChar) {
            case 101: {
                if ((active1 & 8L) != 0L) {
                    return this.jjStartNfaWithStates_7(7, 67, 10);
                }
                return this.jjMoveStringLiteralDfa8_7(active1, 256L);
            }
        }
        return this.jjStartNfa_7(6, 0L, active1);
    }

    private int jjMoveStringLiteralDfa8_7(long old1, long active1) {
        if ((active1 &= old1) == 0L) {
            return this.jjStartNfa_7(6, 0L, old1);
        }
        try {
            this.curChar = this.input_stream.readChar();
        }
        catch (IOException e) {
            this.jjStopStringLiteralDfa_7(7, 0L, active1);
            return 8;
        }
        switch (this.curChar) {
            case 111: {
                return this.jjMoveStringLiteralDfa9_7(active1, 256L);
            }
        }
        return this.jjStartNfa_7(7, 0L, active1);
    }

    private int jjMoveStringLiteralDfa9_7(long old1, long active1) {
        if ((active1 &= old1) == 0L) {
            return this.jjStartNfa_7(7, 0L, old1);
        }
        try {
            this.curChar = this.input_stream.readChar();
        }
        catch (IOException e) {
            this.jjStopStringLiteralDfa_7(8, 0L, active1);
            return 9;
        }
        switch (this.curChar) {
            case 102: {
                if ((active1 & 0x100L) == 0L) break;
                return this.jjStartNfaWithStates_7(9, 72, 10);
            }
        }
        return this.jjStartNfa_7(8, 0L, active1);
    }

    private int jjStartNfaWithStates_7(int pos, int kind, int state) {
        this.jjmatchedKind = kind;
        this.jjmatchedPos = pos;
        try {
            this.curChar = this.input_stream.readChar();
        }
        catch (IOException e) {
            return pos + 1;
        }
        return this.jjMoveNfa_7(state, pos + 1);
    }

    private int jjMoveNfa_7(int startState, int curPos) {
        int startsAt = 0;
        this.jjnewStateCnt = 26;
        int i = 1;
        this.jjstateSet[0] = startState;
        int kind = Integer.MAX_VALUE;
        while (true) {
            if (++this.jjround == Integer.MAX_VALUE) {
                this.ReInitRounds();
            }
            if (this.curChar < 64) {
                long l = 1L << this.curChar;
                block39: do {
                    switch (this.jjstateSet[--i]) {
                        case 0: {
                            if ((0x3FF1010FFFFD9FFL & l) != 0L) {
                                if (kind > 82) {
                                    kind = 82;
                                }
                                this.jjCheckNAdd(10);
                            } else if ((0x100002600L & l) != 0L) {
                                if (kind > 5) {
                                    kind = 5;
                                }
                            } else if (this.curChar == 46) {
                                this.jjCheckNAdd(6);
                            }
                            if ((0x3FF000000000000L & l) != 0L) {
                                if (kind > 80) {
                                    kind = 80;
                                }
                                this.jjCheckNAddStates(0, 3);
                            } else if (this.curChar == 13) {
                                this.jjstateSet[this.jjnewStateCnt++] = 1;
                            }
                            if ((0x3FE000000000000L & l) != 0L) {
                                if (kind > 77) {
                                    kind = 77;
                                }
                                this.jjCheckNAdd(4);
                                break;
                            }
                            if (this.curChar != 48) break;
                            if (kind > 79) {
                                kind = 79;
                            }
                            this.jjCheckNAddTwoStates(23, 25);
                            break;
                        }
                        case 1: {
                            if (this.curChar != 10 || kind <= 5) continue block39;
                            kind = 5;
                            break;
                        }
                        case 2: {
                            if (this.curChar != 13) break;
                            this.jjstateSet[this.jjnewStateCnt++] = 1;
                            break;
                        }
                        case 3: {
                            if ((0x3FE000000000000L & l) == 0L) continue block39;
                            if (kind > 77) {
                                kind = 77;
                            }
                            this.jjCheckNAdd(4);
                            break;
                        }
                        case 4: {
                            if ((0x3FF000000000000L & l) == 0L) continue block39;
                            if (kind > 77) {
                                kind = 77;
                            }
                            this.jjCheckNAdd(4);
                            break;
                        }
                        case 5: {
                            if (this.curChar != 46) break;
                            this.jjCheckNAdd(6);
                            break;
                        }
                        case 6: {
                            if ((0x3FF000000000000L & l) == 0L) continue block39;
                            if (kind > 80) {
                                kind = 80;
                            }
                            this.jjCheckNAddTwoStates(6, 7);
                            break;
                        }
                        case 8: {
                            if ((0x280000000000L & l) == 0L) break;
                            this.jjCheckNAdd(9);
                            break;
                        }
                        case 9: {
                            if ((0x3FF000000000000L & l) == 0L) continue block39;
                            if (kind > 80) {
                                kind = 80;
                            }
                            this.jjCheckNAdd(9);
                            break;
                        }
                        case 10: {
                            if ((0x3FF1010FFFFD9FFL & l) == 0L) continue block39;
                            if (kind > 82) {
                                kind = 82;
                            }
                            this.jjCheckNAdd(10);
                            break;
                        }
                        case 11: {
                            if ((0x3FF000000000000L & l) == 0L) continue block39;
                            if (kind > 80) {
                                kind = 80;
                            }
                            this.jjCheckNAddStates(0, 3);
                            break;
                        }
                        case 12: {
                            if ((0x3FF000000000000L & l) == 0L) break;
                            this.jjCheckNAddTwoStates(12, 13);
                            break;
                        }
                        case 13: {
                            if (this.curChar != 46) continue block39;
                            if (kind > 80) {
                                kind = 80;
                            }
                            this.jjCheckNAddTwoStates(14, 15);
                            break;
                        }
                        case 14: {
                            if ((0x3FF000000000000L & l) == 0L) continue block39;
                            if (kind > 80) {
                                kind = 80;
                            }
                            this.jjCheckNAddTwoStates(14, 15);
                            break;
                        }
                        case 16: {
                            if ((0x280000000000L & l) == 0L) break;
                            this.jjCheckNAdd(17);
                            break;
                        }
                        case 17: {
                            if ((0x3FF000000000000L & l) == 0L) continue block39;
                            if (kind > 80) {
                                kind = 80;
                            }
                            this.jjCheckNAdd(17);
                            break;
                        }
                        case 18: {
                            if ((0x3FF000000000000L & l) == 0L) continue block39;
                            if (kind > 80) {
                                kind = 80;
                            }
                            this.jjCheckNAddTwoStates(18, 19);
                            break;
                        }
                        case 20: {
                            if ((0x280000000000L & l) == 0L) break;
                            this.jjCheckNAdd(21);
                            break;
                        }
                        case 21: {
                            if ((0x3FF000000000000L & l) == 0L) continue block39;
                            if (kind > 80) {
                                kind = 80;
                            }
                            this.jjCheckNAdd(21);
                            break;
                        }
                        case 22: {
                            if (this.curChar != 48) continue block39;
                            if (kind > 79) {
                                kind = 79;
                            }
                            this.jjCheckNAddTwoStates(23, 25);
                            break;
                        }
                        case 24: {
                            if ((0x3FF000000000000L & l) == 0L) continue block39;
                            if (kind > 78) {
                                kind = 78;
                            }
                            this.jjstateSet[this.jjnewStateCnt++] = 24;
                            break;
                        }
                        case 25: {
                            if ((0xFF000000000000L & l) == 0L) continue block39;
                            if (kind > 79) {
                                kind = 79;
                            }
                            this.jjCheckNAdd(25);
                            break;
                        }
                    }
                } while (i != startsAt);
            } else if (this.curChar < 128) {
                long l = 1L << (this.curChar & 0x3F);
                block40: do {
                    switch (this.jjstateSet[--i]) {
                        case 0: 
                        case 10: {
                            if ((0x87FFFFFE97FFFFFEL & l) == 0L) continue block40;
                            if (kind > 82) {
                                kind = 82;
                            }
                            this.jjCheckNAdd(10);
                            break;
                        }
                        case 7: {
                            if ((0x2000000020L & l) == 0L) break;
                            this.jjAddStates(4, 5);
                            break;
                        }
                        case 15: {
                            if ((0x2000000020L & l) == 0L) break;
                            this.jjAddStates(6, 7);
                            break;
                        }
                        case 19: {
                            if ((0x2000000020L & l) == 0L) break;
                            this.jjAddStates(8, 9);
                            break;
                        }
                        case 23: {
                            if ((0x100000001000000L & l) == 0L) break;
                            this.jjCheckNAdd(24);
                            break;
                        }
                        case 24: {
                            if ((0x7E0000007EL & l) == 0L) continue block40;
                            if (kind > 78) {
                                kind = 78;
                            }
                            this.jjCheckNAdd(24);
                            break;
                        }
                    }
                } while (i != startsAt);
            } else {
                int hiByte = this.curChar >> 8;
                int i1 = hiByte >> 6;
                long l1 = 1L << (hiByte & 0x3F);
                int i2 = (this.curChar & 0xFF) >> 6;
                long l2 = 1L << (this.curChar & 0x3F);
                block41: do {
                    switch (this.jjstateSet[--i]) {
                        case 0: {
                            if (JsLexerTokenManager.jjCanMove_0(hiByte, i1, i2, l1, l2) && kind > 5) {
                                kind = 5;
                            }
                            if (!JsLexerTokenManager.jjCanMove_1(hiByte, i1, i2, l1, l2)) continue block41;
                            if (kind > 82) {
                                kind = 82;
                            }
                            this.jjCheckNAdd(10);
                            break;
                        }
                        case 10: {
                            if (!JsLexerTokenManager.jjCanMove_1(hiByte, i1, i2, l1, l2)) continue block41;
                            if (kind > 82) {
                                kind = 82;
                            }
                            this.jjCheckNAdd(10);
                            break;
                        }
                        default: {
                            if (i1 != 0 && l1 != 0L && i2 != 0 && l2 != 0L) continue block41;
                        }
                    }
                } while (i != startsAt);
            }
            if (kind != Integer.MAX_VALUE) {
                this.jjmatchedKind = kind;
                this.jjmatchedPos = curPos;
                kind = Integer.MAX_VALUE;
            }
            ++curPos;
            i = this.jjnewStateCnt;
            this.jjnewStateCnt = startsAt;
            if (i == (startsAt = 26 - this.jjnewStateCnt)) {
                return curPos;
            }
            try {
                this.curChar = this.input_stream.readChar();
            }
            catch (IOException e) {
                return curPos;
            }
        }
    }

    private int jjMoveStringLiteralDfa0_5() {
        return this.jjMoveNfa_5(0, 0);
    }

    private int jjMoveNfa_5(int startState, int curPos) {
        int startsAt = 0;
        this.jjnewStateCnt = 3;
        int i = 1;
        this.jjstateSet[0] = startState;
        int kind = Integer.MAX_VALUE;
        while (true) {
            if (++this.jjround == Integer.MAX_VALUE) {
                this.ReInitRounds();
            }
            if (this.curChar < 64) {
                long l = 1L << this.curChar;
                block13: do {
                    switch (this.jjstateSet[--i]) {
                        case 0: {
                            if ((0x2400L & l) != 0L && kind > 85) {
                                kind = 85;
                            }
                            if (this.curChar != 13) break;
                            this.jjstateSet[this.jjnewStateCnt++] = 1;
                            break;
                        }
                        case 1: {
                            if (this.curChar != 10 || kind <= 85) continue block13;
                            kind = 85;
                            break;
                        }
                        case 2: {
                            if (this.curChar != 13) break;
                            this.jjstateSet[this.jjnewStateCnt++] = 1;
                            break;
                        }
                    }
                } while (i != startsAt);
            } else if (this.curChar < 128) {
                long l = 1L << (this.curChar & 0x3F);
                do {
                    switch (this.jjstateSet[--i]) {
                        default: 
                    }
                } while (i != startsAt);
            } else {
                int hiByte = this.curChar >> 8;
                int i1 = hiByte >> 6;
                long l1 = 1L << (hiByte & 0x3F);
                int i2 = (this.curChar & 0xFF) >> 6;
                long l2 = 1L << (this.curChar & 0x3F);
                block15: do {
                    switch (this.jjstateSet[--i]) {
                        case 0: {
                            if (!JsLexerTokenManager.jjCanMove_0(hiByte, i1, i2, l1, l2) || kind <= 85) continue block15;
                            kind = 85;
                            break;
                        }
                        default: {
                            if (i1 != 0 && l1 != 0L && i2 != 0 && l2 != 0L) continue block15;
                        }
                    }
                } while (i != startsAt);
            }
            if (kind != Integer.MAX_VALUE) {
                this.jjmatchedKind = kind;
                this.jjmatchedPos = curPos;
                kind = Integer.MAX_VALUE;
            }
            ++curPos;
            i = this.jjnewStateCnt;
            this.jjnewStateCnt = startsAt;
            if (i == (startsAt = 3 - this.jjnewStateCnt)) {
                return curPos;
            }
            try {
                this.curChar = this.input_stream.readChar();
            }
            catch (IOException e) {
                return curPos;
            }
        }
    }

    private int jjMoveStringLiteralDfa0_0() {
        switch (this.curChar) {
            case 36: {
                return this.jjMoveStringLiteralDfa1_0(0x8000000000L);
            }
            case 92: {
                return this.jjMoveStringLiteralDfa1_0(0x7000000000L);
            }
            case 96: {
                return this.jjStopAtPos(0, 104);
            }
        }
        return 1;
    }

    private int jjMoveStringLiteralDfa1_0(long active1) {
        try {
            this.curChar = this.input_stream.readChar();
        }
        catch (IOException e) {
            return 1;
        }
        switch (this.curChar) {
            case 36: {
                if ((active1 & 0x1000000000L) == 0L) break;
                return this.jjStopAtPos(1, 100);
            }
            case 96: {
                if ((active1 & 0x4000000000L) == 0L) break;
                return this.jjStopAtPos(1, 102);
            }
            case 123: {
                if ((active1 & 0x2000000000L) != 0L) {
                    return this.jjStopAtPos(1, 101);
                }
                if ((active1 & 0x8000000000L) == 0L) break;
                return this.jjStopAtPos(1, 103);
            }
            default: {
                return 2;
            }
        }
        return 2;
    }

    private final int jjStopStringLiteralDfa_3(int pos, long active0, long active1) {
        switch (pos) {
            default: 
        }
        return -1;
    }

    private final int jjStartNfa_3(int pos, long active0, long active1) {
        return this.jjMoveNfa_3(this.jjStopStringLiteralDfa_3(pos, active0, active1), pos + 1);
    }

    private int jjMoveStringLiteralDfa0_3() {
        switch (this.curChar) {
            case 92: {
                return this.jjMoveStringLiteralDfa1_3(0x10000000L);
            }
            case 93: {
                return this.jjStopAtPos(0, 91);
            }
        }
        return this.jjMoveNfa_3(0, 0);
    }

    private int jjMoveStringLiteralDfa1_3(long active1) {
        try {
            this.curChar = this.input_stream.readChar();
        }
        catch (IOException e) {
            this.jjStopStringLiteralDfa_3(0, 0L, active1);
            return 1;
        }
        switch (this.curChar) {
            case 93: {
                if ((active1 & 0x10000000L) == 0L) break;
                return this.jjStopAtPos(1, 92);
            }
        }
        return this.jjStartNfa_3(0, 0L, active1);
    }

    private int jjMoveNfa_3(int startState, int curPos) {
        int startsAt = 0;
        this.jjnewStateCnt = 3;
        int i = 1;
        this.jjstateSet[0] = startState;
        int kind = Integer.MAX_VALUE;
        while (true) {
            if (++this.jjround == Integer.MAX_VALUE) {
                this.ReInitRounds();
            }
            if (this.curChar < 64) {
                long l = 1L << this.curChar;
                block13: do {
                    switch (this.jjstateSet[--i]) {
                        case 0: {
                            if ((0x2400L & l) != 0L && kind > 93) {
                                kind = 93;
                            }
                            if (this.curChar != 13) break;
                            this.jjstateSet[this.jjnewStateCnt++] = 1;
                            break;
                        }
                        case 1: {
                            if (this.curChar != 10 || kind <= 93) continue block13;
                            kind = 93;
                            break;
                        }
                        case 2: {
                            if (this.curChar != 13) break;
                            this.jjstateSet[this.jjnewStateCnt++] = 1;
                            break;
                        }
                    }
                } while (i != startsAt);
            } else if (this.curChar < 128) {
                long l = 1L << (this.curChar & 0x3F);
                do {
                    switch (this.jjstateSet[--i]) {
                        default: 
                    }
                } while (i != startsAt);
            } else {
                int hiByte = this.curChar >> 8;
                int i1 = hiByte >> 6;
                long l1 = 1L << (hiByte & 0x3F);
                int i2 = (this.curChar & 0xFF) >> 6;
                long l2 = 1L << (this.curChar & 0x3F);
                block15: do {
                    switch (this.jjstateSet[--i]) {
                        case 0: {
                            if (!JsLexerTokenManager.jjCanMove_0(hiByte, i1, i2, l1, l2) || kind <= 93) continue block15;
                            kind = 93;
                            break;
                        }
                        default: {
                            if (i1 != 0 && l1 != 0L && i2 != 0 && l2 != 0L) continue block15;
                        }
                    }
                } while (i != startsAt);
            }
            if (kind != Integer.MAX_VALUE) {
                this.jjmatchedKind = kind;
                this.jjmatchedPos = curPos;
                kind = Integer.MAX_VALUE;
            }
            ++curPos;
            i = this.jjnewStateCnt;
            this.jjnewStateCnt = startsAt;
            if (i == (startsAt = 3 - this.jjnewStateCnt)) {
                return curPos;
            }
            try {
                this.curChar = this.input_stream.readChar();
            }
            catch (IOException e) {
                return curPos;
            }
        }
    }

    private final int jjStopStringLiteralDfa_1(int pos, long active0, long active1) {
        switch (pos) {
            case 0: {
                if ((active1 & 0x200000000L) != 0L) {
                    return 4;
                }
                return -1;
            }
        }
        return -1;
    }

    private final int jjStartNfa_1(int pos, long active0, long active1) {
        return this.jjMoveNfa_1(this.jjStopStringLiteralDfa_1(pos, active0, active1), pos + 1);
    }

    private int jjMoveStringLiteralDfa0_1() {
        switch (this.curChar) {
            case 39: {
                return this.jjStopAtPos(0, 96);
            }
            case 92: {
                return this.jjMoveStringLiteralDfa1_1(0x200000000L);
            }
        }
        return this.jjMoveNfa_1(0, 0);
    }

    private int jjMoveStringLiteralDfa1_1(long active1) {
        try {
            this.curChar = this.input_stream.readChar();
        }
        catch (IOException e) {
            this.jjStopStringLiteralDfa_1(0, 0L, active1);
            return 1;
        }
        switch (this.curChar) {
            case 39: {
                if ((active1 & 0x200000000L) == 0L) break;
                return this.jjStopAtPos(1, 97);
            }
        }
        return this.jjStartNfa_1(0, 0L, active1);
    }

    private int jjMoveNfa_1(int startState, int curPos) {
        int startsAt = 0;
        this.jjnewStateCnt = 7;
        int i = 1;
        this.jjstateSet[0] = startState;
        int kind = Integer.MAX_VALUE;
        while (true) {
            if (++this.jjround == Integer.MAX_VALUE) {
                this.ReInitRounds();
            }
            if (this.curChar < 64) {
                long l = 1L << this.curChar;
                block18: do {
                    switch (this.jjstateSet[--i]) {
                        case 0: {
                            if ((0x2400L & l) != 0L && kind > 98) {
                                kind = 98;
                            }
                            if (this.curChar != 13) break;
                            this.jjstateSet[this.jjnewStateCnt++] = 1;
                            break;
                        }
                        case 4: {
                            if ((0x2400L & l) != 0L && kind > 99) {
                                kind = 99;
                            }
                            if (this.curChar != 13) break;
                            this.jjstateSet[this.jjnewStateCnt++] = 5;
                            break;
                        }
                        case 1: {
                            if (this.curChar != 10 || kind <= 98) continue block18;
                            kind = 98;
                            break;
                        }
                        case 2: {
                            if (this.curChar != 13) break;
                            this.jjstateSet[this.jjnewStateCnt++] = 1;
                            break;
                        }
                        case 5: {
                            if (this.curChar != 10 || kind <= 99) continue block18;
                            kind = 99;
                            break;
                        }
                        case 6: {
                            if (this.curChar != 13) break;
                            this.jjstateSet[this.jjnewStateCnt++] = 5;
                            break;
                        }
                    }
                } while (i != startsAt);
            } else if (this.curChar < 128) {
                long l = 1L << (this.curChar & 0x3F);
                do {
                    switch (this.jjstateSet[--i]) {
                        case 0: {
                            if (this.curChar != 92) break;
                            this.jjAddStates(10, 11);
                            break;
                        }
                    }
                } while (i != startsAt);
            } else {
                int hiByte = this.curChar >> 8;
                int i1 = hiByte >> 6;
                long l1 = 1L << (hiByte & 0x3F);
                int i2 = (this.curChar & 0xFF) >> 6;
                long l2 = 1L << (this.curChar & 0x3F);
                block20: do {
                    switch (this.jjstateSet[--i]) {
                        case 0: {
                            if (!JsLexerTokenManager.jjCanMove_0(hiByte, i1, i2, l1, l2) || kind <= 98) continue block20;
                            kind = 98;
                            break;
                        }
                        case 4: {
                            if (!JsLexerTokenManager.jjCanMove_0(hiByte, i1, i2, l1, l2) || kind <= 99) continue block20;
                            kind = 99;
                            break;
                        }
                        default: {
                            if (i1 != 0 && l1 != 0L && i2 != 0 && l2 != 0L) continue block20;
                        }
                    }
                } while (i != startsAt);
            }
            if (kind != Integer.MAX_VALUE) {
                this.jjmatchedKind = kind;
                this.jjmatchedPos = curPos;
                kind = Integer.MAX_VALUE;
            }
            ++curPos;
            i = this.jjnewStateCnt;
            this.jjnewStateCnt = startsAt;
            if (i == (startsAt = 7 - this.jjnewStateCnt)) {
                return curPos;
            }
            try {
                this.curChar = this.input_stream.readChar();
            }
            catch (IOException e) {
                return curPos;
            }
        }
    }

    private final int jjStopStringLiteralDfa_8(int pos, long active0, long active1) {
        switch (pos) {
            case 0: {
                if ((active0 & 0x10000000L) != 0L) {
                    return 10;
                }
                if ((active0 & 0x700000000L) != 0L) {
                    return 6;
                }
                if ((active1 & 0x1FFEL) != 0L) {
                    this.jjmatchedKind = 82;
                    return 10;
                }
                return -1;
            }
            case 1: {
                if ((active1 & 0x20L) != 0L) {
                    return 10;
                }
                if ((active1 & 0x1FDEL) != 0L) {
                    if (this.jjmatchedPos != 1) {
                        this.jjmatchedKind = 82;
                        this.jjmatchedPos = 1;
                    }
                    return 10;
                }
                return -1;
            }
            case 2: {
                if ((active1 & 0x800L) != 0L) {
                    return 10;
                }
                if ((active1 & 0x17DEL) != 0L) {
                    if (this.jjmatchedPos != 2) {
                        this.jjmatchedKind = 82;
                        this.jjmatchedPos = 2;
                    }
                    return 10;
                }
                return -1;
            }
            case 3: {
                if ((active1 & 0x44L) != 0L) {
                    return 10;
                }
                if ((active1 & 0x179AL) != 0L) {
                    this.jjmatchedKind = 82;
                    this.jjmatchedPos = 3;
                    return 10;
                }
                return -1;
            }
            case 4: {
                if ((active1 & 0x1002L) != 0L) {
                    return 10;
                }
                if ((active1 & 0x798L) != 0L) {
                    this.jjmatchedKind = 82;
                    this.jjmatchedPos = 4;
                    return 10;
                }
                return -1;
            }
            case 5: {
                if ((active1 & 0x610L) != 0L) {
                    return 10;
                }
                if ((active1 & 0x188L) != 0L) {
                    this.jjmatchedKind = 82;
                    this.jjmatchedPos = 5;
                    return 10;
                }
                return -1;
            }
            case 6: {
                if ((active1 & 0x80L) != 0L) {
                    return 10;
                }
                if ((active1 & 0x108L) != 0L) {
                    this.jjmatchedKind = 82;
                    this.jjmatchedPos = 6;
                    return 10;
                }
                return -1;
            }
            case 7: {
                if ((active1 & 8L) != 0L) {
                    return 10;
                }
                if ((active1 & 0x100L) != 0L) {
                    this.jjmatchedKind = 82;
                    this.jjmatchedPos = 7;
                    return 10;
                }
                return -1;
            }
            case 8: {
                if ((active1 & 0x100L) != 0L) {
                    this.jjmatchedKind = 82;
                    this.jjmatchedPos = 8;
                    return 10;
                }
                return -1;
            }
        }
        return -1;
    }

    private final int jjStartNfa_8(int pos, long active0, long active1) {
        return this.jjMoveNfa_8(this.jjStopStringLiteralDfa_8(pos, active0, active1), pos + 1);
    }

    private int jjMoveStringLiteralDfa0_8() {
        switch (this.curChar) {
            case 33: {
                this.jjmatchedKind = 14;
                return this.jjMoveStringLiteralDfa1_8(98304L, 0L);
            }
            case 34: {
                return this.jjStopAtPos(0, 8);
            }
            case 35: {
                return this.jjStopAtPos(0, 17);
            }
            case 37: {
                this.jjmatchedKind = 18;
                return this.jjMoveStringLiteralDfa1_8(524288L, 0L);
            }
            case 38: {
                this.jjmatchedKind = 20;
                return this.jjMoveStringLiteralDfa1_8(0x600000L, 0L);
            }
            case 39: {
                return this.jjStopAtPos(0, 9);
            }
            case 40: {
                return this.jjStopAtPos(0, 23);
            }
            case 42: {
                this.jjmatchedKind = 24;
                return this.jjMoveStringLiteralDfa1_8(0x2000000L, 0L);
            }
            case 43: {
                this.jjmatchedKind = 26;
                return this.jjMoveStringLiteralDfa1_8(0x8001000L, 0L);
            }
            case 44: {
                return this.jjStartNfaWithStates_8(0, 28, 10);
            }
            case 45: {
                this.jjmatchedKind = 29;
                return this.jjMoveStringLiteralDfa1_8(0xC0002000L, 0L);
            }
            case 46: {
                this.jjmatchedKind = 32;
                return this.jjMoveStringLiteralDfa1_8(0x600000000L, 0L);
            }
            case 47: {
                this.jjmatchedKind = 11;
                return this.jjMoveStringLiteralDfa1_8(0x8000000C0L, 0L);
            }
            case 58: {
                this.jjmatchedKind = 36;
                return this.jjMoveStringLiteralDfa1_8(0x2000000000L, 0L);
            }
            case 59: {
                return this.jjStopAtPos(0, 38);
            }
            case 60: {
                this.jjmatchedKind = 39;
                return this.jjMoveStringLiteralDfa1_8(0x70000000000L, 0L);
            }
            case 61: {
                this.jjmatchedKind = 43;
                return this.jjMoveStringLiteralDfa1_8(0x300000000000L, 0L);
            }
            case 62: {
                this.jjmatchedKind = 46;
                return this.jjMoveStringLiteralDfa1_8(0xF800000000000L, 0L);
            }
            case 63: {
                return this.jjStopAtPos(0, 52);
            }
            case 64: {
                return this.jjStopAtPos(0, 53);
            }
            case 91: {
                return this.jjStopAtPos(0, 54);
            }
            case 94: {
                this.jjmatchedKind = 55;
                return this.jjMoveStringLiteralDfa1_8(0x700000000000000L, 0L);
            }
            case 96: {
                return this.jjStopAtPos(0, 10);
            }
            case 98: {
                return this.jjMoveStringLiteralDfa1_8(0L, 2L);
            }
            case 99: {
                return this.jjMoveStringLiteralDfa1_8(0L, 12L);
            }
            case 100: {
                return this.jjMoveStringLiteralDfa1_8(0L, 48L);
            }
            case 101: {
                return this.jjMoveStringLiteralDfa1_8(0L, 64L);
            }
            case 102: {
                return this.jjMoveStringLiteralDfa1_8(0L, 128L);
            }
            case 105: {
                return this.jjMoveStringLiteralDfa1_8(0L, 256L);
            }
            case 114: {
                return this.jjMoveStringLiteralDfa1_8(0L, 512L);
            }
            case 116: {
                return this.jjMoveStringLiteralDfa1_8(0L, 7168L);
            }
            case 123: {
                return this.jjStopAtPos(0, 59);
            }
            case 124: {
                this.jjmatchedKind = 60;
                return this.jjMoveStringLiteralDfa1_8(-2305843009213693952L, 0L);
            }
            case 125: {
                return this.jjStopAtPos(0, 4);
            }
            case 126: {
                return this.jjStopAtPos(0, 64);
            }
        }
        return this.jjMoveNfa_8(0, 0);
    }

    private int jjMoveStringLiteralDfa1_8(long active0, long active1) {
        try {
            this.curChar = this.input_stream.readChar();
        }
        catch (IOException e) {
            this.jjStopStringLiteralDfa_8(0, active0, active1);
            return 1;
        }
        switch (this.curChar) {
            case 38: {
                if ((active0 & 0x200000L) != 0L) {
                    this.jjmatchedKind = 21;
                    this.jjmatchedPos = 1;
                }
                return this.jjMoveStringLiteralDfa2_8(active0, 0x400000L, active1, 0L);
            }
            case 42: {
                if ((active0 & 0x40L) == 0L) break;
                return this.jjStopAtPos(1, 6);
            }
            case 43: {
                if ((active0 & 0x1000L) == 0L) break;
                return this.jjStopAtPos(1, 12);
            }
            case 45: {
                if ((active0 & 0x2000L) == 0L) break;
                return this.jjStopAtPos(1, 13);
            }
            case 46: {
                if ((active0 & 0x200000000L) != 0L) {
                    this.jjmatchedKind = 33;
                    this.jjmatchedPos = 1;
                }
                return this.jjMoveStringLiteralDfa2_8(active0, 0x400000000L, active1, 0L);
            }
            case 47: {
                if ((active0 & 0x80L) == 0L) break;
                return this.jjStopAtPos(1, 7);
            }
            case 58: {
                if ((active0 & 0x2000000000L) == 0L) break;
                return this.jjStopAtPos(1, 37);
            }
            case 60: {
                if ((active0 & 0x20000000000L) != 0L) {
                    this.jjmatchedKind = 41;
                    this.jjmatchedPos = 1;
                }
                return this.jjMoveStringLiteralDfa2_8(active0, 0x40000000000L, active1, 0L);
            }
            case 61: {
                if ((active0 & 0x8000L) != 0L) {
                    this.jjmatchedKind = 15;
                    this.jjmatchedPos = 1;
                } else {
                    if ((active0 & 0x80000L) != 0L) {
                        return this.jjStopAtPos(1, 19);
                    }
                    if ((active0 & 0x2000000L) != 0L) {
                        return this.jjStopAtPos(1, 25);
                    }
                    if ((active0 & 0x8000000L) != 0L) {
                        return this.jjStopAtPos(1, 27);
                    }
                    if ((active0 & 0x40000000L) != 0L) {
                        return this.jjStopAtPos(1, 30);
                    }
                    if ((active0 & 0x800000000L) != 0L) {
                        return this.jjStopAtPos(1, 35);
                    }
                    if ((active0 & 0x10000000000L) != 0L) {
                        return this.jjStopAtPos(1, 40);
                    }
                    if ((active0 & 0x100000000000L) != 0L) {
                        this.jjmatchedKind = 44;
                        this.jjmatchedPos = 1;
                    } else {
                        if ((active0 & 0x800000000000L) != 0L) {
                            return this.jjStopAtPos(1, 47);
                        }
                        if ((active0 & 0x100000000000000L) != 0L) {
                            return this.jjStopAtPos(1, 56);
                        }
                        if ((active0 & 0x2000000000000000L) != 0L) {
                            return this.jjStopAtPos(1, 61);
                        }
                    }
                }
                return this.jjMoveStringLiteralDfa2_8(active0, 0x200000010000L, active1, 0L);
            }
            case 62: {
                if ((active0 & 0x80000000L) != 0L) {
                    return this.jjStopAtPos(1, 31);
                }
                if ((active0 & 0x1000000000000L) != 0L) {
                    this.jjmatchedKind = 48;
                    this.jjmatchedPos = 1;
                }
                return this.jjMoveStringLiteralDfa2_8(active0, 0xE000000000000L, active1, 0L);
            }
            case 94: {
                if ((active0 & 0x200000000000000L) != 0L) {
                    this.jjmatchedKind = 57;
                    this.jjmatchedPos = 1;
                }
                return this.jjMoveStringLiteralDfa2_8(active0, 0x400000000000000L, active1, 0L);
            }
            case 97: {
                return this.jjMoveStringLiteralDfa2_8(active0, 0L, active1, 4L);
            }
            case 101: {
                return this.jjMoveStringLiteralDfa2_8(active0, 0L, active1, 528L);
            }
            case 104: {
                return this.jjMoveStringLiteralDfa2_8(active0, 0L, active1, 4096L);
            }
            case 105: {
                return this.jjMoveStringLiteralDfa2_8(active0, 0L, active1, 128L);
            }
            case 108: {
                return this.jjMoveStringLiteralDfa2_8(active0, 0L, active1, 64L);
            }
            case 110: {
                return this.jjMoveStringLiteralDfa2_8(active0, 0L, active1, 256L);
            }
            case 111: {
                if ((active1 & 0x20L) != 0L) {
                    return this.jjStartNfaWithStates_8(1, 69, 10);
                }
                return this.jjMoveStringLiteralDfa2_8(active0, 0L, active1, 8L);
            }
            case 114: {
                return this.jjMoveStringLiteralDfa2_8(active0, 0L, active1, 2050L);
            }
            case 121: {
                return this.jjMoveStringLiteralDfa2_8(active0, 0L, active1, 1024L);
            }
            case 124: {
                if ((active0 & 0x4000000000000000L) != 0L) {
                    this.jjmatchedKind = 62;
                    this.jjmatchedPos = 1;
                }
                return this.jjMoveStringLiteralDfa2_8(active0, Long.MIN_VALUE, active1, 0L);
            }
        }
        return this.jjStartNfa_8(0, active0, active1);
    }

    private int jjMoveStringLiteralDfa2_8(long old0, long active0, long old1, long active1) {
        if (((active0 &= old0) | (active1 &= old1)) == 0L) {
            return this.jjStartNfa_8(0, old0, old1);
        }
        try {
            this.curChar = this.input_stream.readChar();
        }
        catch (IOException e) {
            this.jjStopStringLiteralDfa_8(1, active0, active1);
            return 2;
        }
        switch (this.curChar) {
            case 46: {
                if ((active0 & 0x400000000L) == 0L) break;
                return this.jjStopAtPos(2, 34);
            }
            case 61: {
                if ((active0 & 0x10000L) != 0L) {
                    return this.jjStopAtPos(2, 16);
                }
                if ((active0 & 0x400000L) != 0L) {
                    return this.jjStopAtPos(2, 22);
                }
                if ((active0 & 0x40000000000L) != 0L) {
                    return this.jjStopAtPos(2, 42);
                }
                if ((active0 & 0x200000000000L) != 0L) {
                    return this.jjStopAtPos(2, 45);
                }
                if ((active0 & 0x2000000000000L) != 0L) {
                    return this.jjStopAtPos(2, 49);
                }
                if ((active0 & 0x400000000000000L) != 0L) {
                    return this.jjStopAtPos(2, 58);
                }
                if ((active0 & Long.MIN_VALUE) == 0L) break;
                return this.jjStopAtPos(2, 63);
            }
            case 62: {
                if ((active0 & 0x4000000000000L) != 0L) {
                    this.jjmatchedKind = 50;
                    this.jjmatchedPos = 2;
                }
                return this.jjMoveStringLiteralDfa3_8(active0, 0x8000000000000L, active1, 0L);
            }
            case 101: {
                return this.jjMoveStringLiteralDfa3_8(active0, 0L, active1, 2L);
            }
            case 108: {
                return this.jjMoveStringLiteralDfa3_8(active0, 0L, active1, 16L);
            }
            case 110: {
                return this.jjMoveStringLiteralDfa3_8(active0, 0L, active1, 136L);
            }
            case 112: {
                return this.jjMoveStringLiteralDfa3_8(active0, 0L, active1, 1024L);
            }
            case 114: {
                return this.jjMoveStringLiteralDfa3_8(active0, 0L, active1, 4096L);
            }
            case 115: {
                return this.jjMoveStringLiteralDfa3_8(active0, 0L, active1, 324L);
            }
            case 116: {
                return this.jjMoveStringLiteralDfa3_8(active0, 0L, active1, 512L);
            }
            case 121: {
                if ((active1 & 0x800L) == 0L) break;
                return this.jjStartNfaWithStates_8(2, 75, 10);
            }
        }
        return this.jjStartNfa_8(1, active0, active1);
    }

    private int jjMoveStringLiteralDfa3_8(long old0, long active0, long old1, long active1) {
        if (((active0 &= old0) | (active1 &= old1)) == 0L) {
            return this.jjStartNfa_8(1, old0, old1);
        }
        try {
            this.curChar = this.input_stream.readChar();
        }
        catch (IOException e) {
            this.jjStopStringLiteralDfa_8(2, active0, active1);
            return 3;
        }
        switch (this.curChar) {
            case 61: {
                if ((active0 & 0x8000000000000L) == 0L) break;
                return this.jjStopAtPos(3, 51);
            }
            case 97: {
                return this.jjMoveStringLiteralDfa4_8(active0, 0L, active1, 130L);
            }
            case 101: {
                if ((active1 & 4L) != 0L) {
                    return this.jjStartNfaWithStates_8(3, 66, 10);
                }
                if ((active1 & 0x40L) != 0L) {
                    return this.jjStartNfaWithStates_8(3, 70, 10);
                }
                return this.jjMoveStringLiteralDfa4_8(active0, 0L, active1, 1040L);
            }
            case 111: {
                return this.jjMoveStringLiteralDfa4_8(active0, 0L, active1, 4096L);
            }
            case 116: {
                return this.jjMoveStringLiteralDfa4_8(active0, 0L, active1, 264L);
            }
            case 117: {
                return this.jjMoveStringLiteralDfa4_8(active0, 0L, active1, 512L);
            }
        }
        return this.jjStartNfa_8(2, active0, active1);
    }

    private int jjMoveStringLiteralDfa4_8(long old0, long active0, long old1, long active1) {
        if (((active0 &= old0) | (active1 &= old1)) == 0L) {
            return this.jjStartNfa_8(2, old0, old1);
        }
        try {
            this.curChar = this.input_stream.readChar();
        }
        catch (IOException e) {
            this.jjStopStringLiteralDfa_8(3, 0L, active1);
            return 4;
        }
        switch (this.curChar) {
            case 97: {
                return this.jjMoveStringLiteralDfa5_8(active1, 256L);
            }
            case 105: {
                return this.jjMoveStringLiteralDfa5_8(active1, 8L);
            }
            case 107: {
                if ((active1 & 2L) == 0L) break;
                return this.jjStartNfaWithStates_8(4, 65, 10);
            }
            case 108: {
                return this.jjMoveStringLiteralDfa5_8(active1, 128L);
            }
            case 111: {
                return this.jjMoveStringLiteralDfa5_8(active1, 1024L);
            }
            case 114: {
                return this.jjMoveStringLiteralDfa5_8(active1, 512L);
            }
            case 116: {
                return this.jjMoveStringLiteralDfa5_8(active1, 16L);
            }
            case 119: {
                if ((active1 & 0x1000L) == 0L) break;
                return this.jjStartNfaWithStates_8(4, 76, 10);
            }
        }
        return this.jjStartNfa_8(3, 0L, active1);
    }

    private int jjMoveStringLiteralDfa5_8(long old1, long active1) {
        if ((active1 &= old1) == 0L) {
            return this.jjStartNfa_8(3, 0L, old1);
        }
        try {
            this.curChar = this.input_stream.readChar();
        }
        catch (IOException e) {
            this.jjStopStringLiteralDfa_8(4, 0L, active1);
            return 5;
        }
        switch (this.curChar) {
            case 101: {
                if ((active1 & 0x10L) == 0L) break;
                return this.jjStartNfaWithStates_8(5, 68, 10);
            }
            case 102: {
                if ((active1 & 0x400L) == 0L) break;
                return this.jjStartNfaWithStates_8(5, 74, 10);
            }
            case 108: {
                return this.jjMoveStringLiteralDfa6_8(active1, 128L);
            }
            case 110: {
                if ((active1 & 0x200L) != 0L) {
                    return this.jjStartNfaWithStates_8(5, 73, 10);
                }
                return this.jjMoveStringLiteralDfa6_8(active1, 264L);
            }
        }
        return this.jjStartNfa_8(4, 0L, active1);
    }

    private int jjMoveStringLiteralDfa6_8(long old1, long active1) {
        if ((active1 &= old1) == 0L) {
            return this.jjStartNfa_8(4, 0L, old1);
        }
        try {
            this.curChar = this.input_stream.readChar();
        }
        catch (IOException e) {
            this.jjStopStringLiteralDfa_8(5, 0L, active1);
            return 6;
        }
        switch (this.curChar) {
            case 99: {
                return this.jjMoveStringLiteralDfa7_8(active1, 256L);
            }
            case 117: {
                return this.jjMoveStringLiteralDfa7_8(active1, 8L);
            }
            case 121: {
                if ((active1 & 0x80L) == 0L) break;
                return this.jjStartNfaWithStates_8(6, 71, 10);
            }
        }
        return this.jjStartNfa_8(5, 0L, active1);
    }

    private int jjMoveStringLiteralDfa7_8(long old1, long active1) {
        if ((active1 &= old1) == 0L) {
            return this.jjStartNfa_8(5, 0L, old1);
        }
        try {
            this.curChar = this.input_stream.readChar();
        }
        catch (IOException e) {
            this.jjStopStringLiteralDfa_8(6, 0L, active1);
            return 7;
        }
        switch (this.curChar) {
            case 101: {
                if ((active1 & 8L) != 0L) {
                    return this.jjStartNfaWithStates_8(7, 67, 10);
                }
                return this.jjMoveStringLiteralDfa8_8(active1, 256L);
            }
        }
        return this.jjStartNfa_8(6, 0L, active1);
    }

    private int jjMoveStringLiteralDfa8_8(long old1, long active1) {
        if ((active1 &= old1) == 0L) {
            return this.jjStartNfa_8(6, 0L, old1);
        }
        try {
            this.curChar = this.input_stream.readChar();
        }
        catch (IOException e) {
            this.jjStopStringLiteralDfa_8(7, 0L, active1);
            return 8;
        }
        switch (this.curChar) {
            case 111: {
                return this.jjMoveStringLiteralDfa9_8(active1, 256L);
            }
        }
        return this.jjStartNfa_8(7, 0L, active1);
    }

    private int jjMoveStringLiteralDfa9_8(long old1, long active1) {
        if ((active1 &= old1) == 0L) {
            return this.jjStartNfa_8(7, 0L, old1);
        }
        try {
            this.curChar = this.input_stream.readChar();
        }
        catch (IOException e) {
            this.jjStopStringLiteralDfa_8(8, 0L, active1);
            return 9;
        }
        switch (this.curChar) {
            case 102: {
                if ((active1 & 0x100L) == 0L) break;
                return this.jjStartNfaWithStates_8(9, 72, 10);
            }
        }
        return this.jjStartNfa_8(8, 0L, active1);
    }

    private int jjStartNfaWithStates_8(int pos, int kind, int state) {
        this.jjmatchedKind = kind;
        this.jjmatchedPos = pos;
        try {
            this.curChar = this.input_stream.readChar();
        }
        catch (IOException e) {
            return pos + 1;
        }
        return this.jjMoveNfa_8(state, pos + 1);
    }

    private int jjMoveNfa_8(int startState, int curPos) {
        int startsAt = 0;
        this.jjnewStateCnt = 26;
        int i = 1;
        this.jjstateSet[0] = startState;
        int kind = Integer.MAX_VALUE;
        while (true) {
            if (++this.jjround == Integer.MAX_VALUE) {
                this.ReInitRounds();
            }
            if (this.curChar < 64) {
                long l = 1L << this.curChar;
                block39: do {
                    switch (this.jjstateSet[--i]) {
                        case 0: {
                            if ((0x3FF1010FFFFD9FFL & l) != 0L) {
                                if (kind > 82) {
                                    kind = 82;
                                }
                                this.jjCheckNAdd(10);
                            } else if ((0x100002600L & l) != 0L) {
                                if (kind > 5) {
                                    kind = 5;
                                }
                            } else if (this.curChar == 46) {
                                this.jjCheckNAdd(6);
                            }
                            if ((0x3FF000000000000L & l) != 0L) {
                                if (kind > 80) {
                                    kind = 80;
                                }
                                this.jjCheckNAddStates(0, 3);
                            } else if (this.curChar == 13) {
                                this.jjstateSet[this.jjnewStateCnt++] = 1;
                            }
                            if ((0x3FE000000000000L & l) != 0L) {
                                if (kind > 77) {
                                    kind = 77;
                                }
                                this.jjCheckNAdd(4);
                                break;
                            }
                            if (this.curChar != 48) break;
                            if (kind > 79) {
                                kind = 79;
                            }
                            this.jjCheckNAddTwoStates(23, 25);
                            break;
                        }
                        case 1: {
                            if (this.curChar != 10 || kind <= 5) continue block39;
                            kind = 5;
                            break;
                        }
                        case 2: {
                            if (this.curChar != 13) break;
                            this.jjstateSet[this.jjnewStateCnt++] = 1;
                            break;
                        }
                        case 3: {
                            if ((0x3FE000000000000L & l) == 0L) continue block39;
                            if (kind > 77) {
                                kind = 77;
                            }
                            this.jjCheckNAdd(4);
                            break;
                        }
                        case 4: {
                            if ((0x3FF000000000000L & l) == 0L) continue block39;
                            if (kind > 77) {
                                kind = 77;
                            }
                            this.jjCheckNAdd(4);
                            break;
                        }
                        case 5: {
                            if (this.curChar != 46) break;
                            this.jjCheckNAdd(6);
                            break;
                        }
                        case 6: {
                            if ((0x3FF000000000000L & l) == 0L) continue block39;
                            if (kind > 80) {
                                kind = 80;
                            }
                            this.jjCheckNAddTwoStates(6, 7);
                            break;
                        }
                        case 8: {
                            if ((0x280000000000L & l) == 0L) break;
                            this.jjCheckNAdd(9);
                            break;
                        }
                        case 9: {
                            if ((0x3FF000000000000L & l) == 0L) continue block39;
                            if (kind > 80) {
                                kind = 80;
                            }
                            this.jjCheckNAdd(9);
                            break;
                        }
                        case 10: {
                            if ((0x3FF1010FFFFD9FFL & l) == 0L) continue block39;
                            if (kind > 82) {
                                kind = 82;
                            }
                            this.jjCheckNAdd(10);
                            break;
                        }
                        case 11: {
                            if ((0x3FF000000000000L & l) == 0L) continue block39;
                            if (kind > 80) {
                                kind = 80;
                            }
                            this.jjCheckNAddStates(0, 3);
                            break;
                        }
                        case 12: {
                            if ((0x3FF000000000000L & l) == 0L) break;
                            this.jjCheckNAddTwoStates(12, 13);
                            break;
                        }
                        case 13: {
                            if (this.curChar != 46) continue block39;
                            if (kind > 80) {
                                kind = 80;
                            }
                            this.jjCheckNAddTwoStates(14, 15);
                            break;
                        }
                        case 14: {
                            if ((0x3FF000000000000L & l) == 0L) continue block39;
                            if (kind > 80) {
                                kind = 80;
                            }
                            this.jjCheckNAddTwoStates(14, 15);
                            break;
                        }
                        case 16: {
                            if ((0x280000000000L & l) == 0L) break;
                            this.jjCheckNAdd(17);
                            break;
                        }
                        case 17: {
                            if ((0x3FF000000000000L & l) == 0L) continue block39;
                            if (kind > 80) {
                                kind = 80;
                            }
                            this.jjCheckNAdd(17);
                            break;
                        }
                        case 18: {
                            if ((0x3FF000000000000L & l) == 0L) continue block39;
                            if (kind > 80) {
                                kind = 80;
                            }
                            this.jjCheckNAddTwoStates(18, 19);
                            break;
                        }
                        case 20: {
                            if ((0x280000000000L & l) == 0L) break;
                            this.jjCheckNAdd(21);
                            break;
                        }
                        case 21: {
                            if ((0x3FF000000000000L & l) == 0L) continue block39;
                            if (kind > 80) {
                                kind = 80;
                            }
                            this.jjCheckNAdd(21);
                            break;
                        }
                        case 22: {
                            if (this.curChar != 48) continue block39;
                            if (kind > 79) {
                                kind = 79;
                            }
                            this.jjCheckNAddTwoStates(23, 25);
                            break;
                        }
                        case 24: {
                            if ((0x3FF000000000000L & l) == 0L) continue block39;
                            if (kind > 78) {
                                kind = 78;
                            }
                            this.jjstateSet[this.jjnewStateCnt++] = 24;
                            break;
                        }
                        case 25: {
                            if ((0xFF000000000000L & l) == 0L) continue block39;
                            if (kind > 79) {
                                kind = 79;
                            }
                            this.jjCheckNAdd(25);
                            break;
                        }
                    }
                } while (i != startsAt);
            } else if (this.curChar < 128) {
                long l = 1L << (this.curChar & 0x3F);
                block40: do {
                    switch (this.jjstateSet[--i]) {
                        case 0: 
                        case 10: {
                            if ((0x87FFFFFE97FFFFFEL & l) == 0L) continue block40;
                            if (kind > 82) {
                                kind = 82;
                            }
                            this.jjCheckNAdd(10);
                            break;
                        }
                        case 7: {
                            if ((0x2000000020L & l) == 0L) break;
                            this.jjAddStates(4, 5);
                            break;
                        }
                        case 15: {
                            if ((0x2000000020L & l) == 0L) break;
                            this.jjAddStates(6, 7);
                            break;
                        }
                        case 19: {
                            if ((0x2000000020L & l) == 0L) break;
                            this.jjAddStates(8, 9);
                            break;
                        }
                        case 23: {
                            if ((0x100000001000000L & l) == 0L) break;
                            this.jjCheckNAdd(24);
                            break;
                        }
                        case 24: {
                            if ((0x7E0000007EL & l) == 0L) continue block40;
                            if (kind > 78) {
                                kind = 78;
                            }
                            this.jjCheckNAdd(24);
                            break;
                        }
                    }
                } while (i != startsAt);
            } else {
                int hiByte = this.curChar >> 8;
                int i1 = hiByte >> 6;
                long l1 = 1L << (hiByte & 0x3F);
                int i2 = (this.curChar & 0xFF) >> 6;
                long l2 = 1L << (this.curChar & 0x3F);
                block41: do {
                    switch (this.jjstateSet[--i]) {
                        case 0: {
                            if (JsLexerTokenManager.jjCanMove_0(hiByte, i1, i2, l1, l2) && kind > 5) {
                                kind = 5;
                            }
                            if (!JsLexerTokenManager.jjCanMove_1(hiByte, i1, i2, l1, l2)) continue block41;
                            if (kind > 82) {
                                kind = 82;
                            }
                            this.jjCheckNAdd(10);
                            break;
                        }
                        case 10: {
                            if (!JsLexerTokenManager.jjCanMove_1(hiByte, i1, i2, l1, l2)) continue block41;
                            if (kind > 82) {
                                kind = 82;
                            }
                            this.jjCheckNAdd(10);
                            break;
                        }
                        default: {
                            if (i1 != 0 && l1 != 0L && i2 != 0 && l2 != 0L) continue block41;
                        }
                    }
                } while (i != startsAt);
            }
            if (kind != Integer.MAX_VALUE) {
                this.jjmatchedKind = kind;
                this.jjmatchedPos = curPos;
                kind = Integer.MAX_VALUE;
            }
            ++curPos;
            i = this.jjnewStateCnt;
            this.jjnewStateCnt = startsAt;
            if (i == (startsAt = 26 - this.jjnewStateCnt)) {
                return curPos;
            }
            try {
                this.curChar = this.input_stream.readChar();
            }
            catch (IOException e) {
                return curPos;
            }
        }
    }

    private final int jjStopStringLiteralDfa_4(int pos, long active0, long active1) {
        switch (pos) {
            default: 
        }
        return -1;
    }

    private final int jjStartNfa_4(int pos, long active0, long active1) {
        return this.jjMoveNfa_4(this.jjStopStringLiteralDfa_4(pos, active0, active1), pos + 1);
    }

    private int jjMoveStringLiteralDfa0_4() {
        switch (this.curChar) {
            case 47: {
                return this.jjStopAtPos(0, 90);
            }
            case 91: {
                return this.jjStopAtPos(0, 89);
            }
            case 92: {
                return this.jjMoveStringLiteralDfa1_4(0x1800000L);
            }
        }
        return this.jjMoveNfa_4(0, 0);
    }

    private int jjMoveStringLiteralDfa1_4(long active1) {
        try {
            this.curChar = this.input_stream.readChar();
        }
        catch (IOException e) {
            this.jjStopStringLiteralDfa_4(0, 0L, active1);
            return 1;
        }
        switch (this.curChar) {
            case 47: {
                if ((active1 & 0x800000L) == 0L) break;
                return this.jjStopAtPos(1, 87);
            }
            case 91: {
                if ((active1 & 0x1000000L) == 0L) break;
                return this.jjStopAtPos(1, 88);
            }
        }
        return this.jjStartNfa_4(0, 0L, active1);
    }

    private int jjMoveNfa_4(int startState, int curPos) {
        int startsAt = 0;
        this.jjnewStateCnt = 3;
        int i = 1;
        this.jjstateSet[0] = startState;
        int kind = Integer.MAX_VALUE;
        while (true) {
            if (++this.jjround == Integer.MAX_VALUE) {
                this.ReInitRounds();
            }
            if (this.curChar < 64) {
                long l = 1L << this.curChar;
                block13: do {
                    switch (this.jjstateSet[--i]) {
                        case 0: {
                            if ((0x2400L & l) != 0L && kind > 86) {
                                kind = 86;
                            }
                            if (this.curChar != 13) break;
                            this.jjstateSet[this.jjnewStateCnt++] = 1;
                            break;
                        }
                        case 1: {
                            if (this.curChar != 10 || kind <= 86) continue block13;
                            kind = 86;
                            break;
                        }
                        case 2: {
                            if (this.curChar != 13) break;
                            this.jjstateSet[this.jjnewStateCnt++] = 1;
                            break;
                        }
                    }
                } while (i != startsAt);
            } else if (this.curChar < 128) {
                long l = 1L << (this.curChar & 0x3F);
                do {
                    switch (this.jjstateSet[--i]) {
                        default: 
                    }
                } while (i != startsAt);
            } else {
                int hiByte = this.curChar >> 8;
                int i1 = hiByte >> 6;
                long l1 = 1L << (hiByte & 0x3F);
                int i2 = (this.curChar & 0xFF) >> 6;
                long l2 = 1L << (this.curChar & 0x3F);
                block15: do {
                    switch (this.jjstateSet[--i]) {
                        case 0: {
                            if (!JsLexerTokenManager.jjCanMove_0(hiByte, i1, i2, l1, l2) || kind <= 86) continue block15;
                            kind = 86;
                            break;
                        }
                        default: {
                            if (i1 != 0 && l1 != 0L && i2 != 0 && l2 != 0L) continue block15;
                        }
                    }
                } while (i != startsAt);
            }
            if (kind != Integer.MAX_VALUE) {
                this.jjmatchedKind = kind;
                this.jjmatchedPos = curPos;
                kind = Integer.MAX_VALUE;
            }
            ++curPos;
            i = this.jjnewStateCnt;
            this.jjnewStateCnt = startsAt;
            if (i == (startsAt = 3 - this.jjnewStateCnt)) {
                return curPos;
            }
            try {
                this.curChar = this.input_stream.readChar();
            }
            catch (IOException e) {
                return curPos;
            }
        }
    }

    private final int jjStopStringLiteralDfa_2(int pos, long active0, long active1) {
        switch (pos) {
            case 0: {
                if ((active1 & 0x80000000L) != 0L) {
                    return 4;
                }
                return -1;
            }
        }
        return -1;
    }

    private final int jjStartNfa_2(int pos, long active0, long active1) {
        return this.jjMoveNfa_2(this.jjStopStringLiteralDfa_2(pos, active0, active1), pos + 1);
    }

    private int jjMoveStringLiteralDfa0_2() {
        switch (this.curChar) {
            case 34: {
                return this.jjStopAtPos(0, 94);
            }
            case 92: {
                return this.jjMoveStringLiteralDfa1_2(0x80000000L);
            }
        }
        return this.jjMoveNfa_2(0, 0);
    }

    private int jjMoveStringLiteralDfa1_2(long active1) {
        try {
            this.curChar = this.input_stream.readChar();
        }
        catch (IOException e) {
            this.jjStopStringLiteralDfa_2(0, 0L, active1);
            return 1;
        }
        switch (this.curChar) {
            case 34: {
                if ((active1 & 0x80000000L) == 0L) break;
                return this.jjStopAtPos(1, 95);
            }
        }
        return this.jjStartNfa_2(0, 0L, active1);
    }

    private int jjMoveNfa_2(int startState, int curPos) {
        int startsAt = 0;
        this.jjnewStateCnt = 7;
        int i = 1;
        this.jjstateSet[0] = startState;
        int kind = Integer.MAX_VALUE;
        while (true) {
            if (++this.jjround == Integer.MAX_VALUE) {
                this.ReInitRounds();
            }
            if (this.curChar < 64) {
                long l = 1L << this.curChar;
                block18: do {
                    switch (this.jjstateSet[--i]) {
                        case 0: {
                            if ((0x2400L & l) != 0L && kind > 98) {
                                kind = 98;
                            }
                            if (this.curChar != 13) break;
                            this.jjstateSet[this.jjnewStateCnt++] = 1;
                            break;
                        }
                        case 4: {
                            if ((0x2400L & l) != 0L && kind > 99) {
                                kind = 99;
                            }
                            if (this.curChar != 13) break;
                            this.jjstateSet[this.jjnewStateCnt++] = 5;
                            break;
                        }
                        case 1: {
                            if (this.curChar != 10 || kind <= 98) continue block18;
                            kind = 98;
                            break;
                        }
                        case 2: {
                            if (this.curChar != 13) break;
                            this.jjstateSet[this.jjnewStateCnt++] = 1;
                            break;
                        }
                        case 5: {
                            if (this.curChar != 10 || kind <= 99) continue block18;
                            kind = 99;
                            break;
                        }
                        case 6: {
                            if (this.curChar != 13) break;
                            this.jjstateSet[this.jjnewStateCnt++] = 5;
                            break;
                        }
                    }
                } while (i != startsAt);
            } else if (this.curChar < 128) {
                long l = 1L << (this.curChar & 0x3F);
                do {
                    switch (this.jjstateSet[--i]) {
                        case 0: {
                            if (this.curChar != 92) break;
                            this.jjAddStates(10, 11);
                            break;
                        }
                    }
                } while (i != startsAt);
            } else {
                int hiByte = this.curChar >> 8;
                int i1 = hiByte >> 6;
                long l1 = 1L << (hiByte & 0x3F);
                int i2 = (this.curChar & 0xFF) >> 6;
                long l2 = 1L << (this.curChar & 0x3F);
                block20: do {
                    switch (this.jjstateSet[--i]) {
                        case 0: {
                            if (!JsLexerTokenManager.jjCanMove_0(hiByte, i1, i2, l1, l2) || kind <= 98) continue block20;
                            kind = 98;
                            break;
                        }
                        case 4: {
                            if (!JsLexerTokenManager.jjCanMove_0(hiByte, i1, i2, l1, l2) || kind <= 99) continue block20;
                            kind = 99;
                            break;
                        }
                        default: {
                            if (i1 != 0 && l1 != 0L && i2 != 0 && l2 != 0L) continue block20;
                        }
                    }
                } while (i != startsAt);
            }
            if (kind != Integer.MAX_VALUE) {
                this.jjmatchedKind = kind;
                this.jjmatchedPos = curPos;
                kind = Integer.MAX_VALUE;
            }
            ++curPos;
            i = this.jjnewStateCnt;
            this.jjnewStateCnt = startsAt;
            if (i == (startsAt = 7 - this.jjnewStateCnt)) {
                return curPos;
            }
            try {
                this.curChar = this.input_stream.readChar();
            }
            catch (IOException e) {
                return curPos;
            }
        }
    }

    private int jjMoveStringLiteralDfa0_6() {
        switch (this.curChar) {
            case 42: {
                return this.jjMoveStringLiteralDfa1_6(0x100000L);
            }
        }
        return 1;
    }

    private int jjMoveStringLiteralDfa1_6(long active1) {
        try {
            this.curChar = this.input_stream.readChar();
        }
        catch (IOException e) {
            return 1;
        }
        switch (this.curChar) {
            case 47: {
                if ((active1 & 0x100000L) == 0L) break;
                return this.jjStopAtPos(1, 84);
            }
            default: {
                return 2;
            }
        }
        return 2;
    }

    private static final boolean jjCanMove_0(int hiByte, int i1, int i2, long l1, long l2) {
        switch (hiByte) {
            case 32: {
                return (jjbitVec0[i2] & l2) != 0L;
            }
        }
        return false;
    }

    private static final boolean jjCanMove_1(int hiByte, int i1, int i2, long l1, long l2) {
        switch (hiByte) {
            case 0: {
                return (jjbitVec3[i2] & l2) != 0L;
            }
        }
        return (jjbitVec1[i1] & l1) != 0L;
    }

    protected Token jjFillToken() {
        String im = jjstrLiteralImages[this.jjmatchedKind];
        String curTokenImage = im == null ? this.input_stream.GetImage() : im;
        int beginLine = this.input_stream.getBeginLine();
        int beginColumn = this.input_stream.getBeginColumn();
        int endLine = this.input_stream.getEndLine();
        int endColumn = this.input_stream.getEndColumn();
        Token t = Token.newToken(this.jjmatchedKind, curTokenImage);
        t.beginLine = beginLine;
        t.endLine = endLine;
        t.beginColumn = beginColumn;
        t.endColumn = endColumn;
        return t;
    }

    public Token getNextToken() {
        int curPos = 0;
        while (true) {
            try {
                this.curChar = this.input_stream.BeginToken();
            }
            catch (Exception e) {
                this.jjmatchedKind = 0;
                this.jjmatchedPos = -1;
                Token matchedToken = this.jjFillToken();
                return matchedToken;
            }
            this.image = this.jjimage;
            this.image.setLength(0);
            this.jjimageLen = 0;
            switch (this.curLexState) {
                case 0: {
                    this.jjmatchedKind = Integer.MAX_VALUE;
                    this.jjmatchedPos = 0;
                    curPos = this.jjMoveStringLiteralDfa0_0();
                    if (this.jjmatchedPos != 0 || this.jjmatchedKind <= 105) break;
                    this.jjmatchedKind = 105;
                    break;
                }
                case 1: {
                    this.jjmatchedKind = Integer.MAX_VALUE;
                    this.jjmatchedPos = 0;
                    curPos = this.jjMoveStringLiteralDfa0_1();
                    if (this.jjmatchedPos != 0 || this.jjmatchedKind <= 105) break;
                    this.jjmatchedKind = 105;
                    break;
                }
                case 2: {
                    this.jjmatchedKind = Integer.MAX_VALUE;
                    this.jjmatchedPos = 0;
                    curPos = this.jjMoveStringLiteralDfa0_2();
                    if (this.jjmatchedPos != 0 || this.jjmatchedKind <= 105) break;
                    this.jjmatchedKind = 105;
                    break;
                }
                case 3: {
                    this.jjmatchedKind = Integer.MAX_VALUE;
                    this.jjmatchedPos = 0;
                    curPos = this.jjMoveStringLiteralDfa0_3();
                    if (this.jjmatchedPos != 0 || this.jjmatchedKind <= 105) break;
                    this.jjmatchedKind = 105;
                    break;
                }
                case 4: {
                    this.jjmatchedKind = Integer.MAX_VALUE;
                    this.jjmatchedPos = 0;
                    curPos = this.jjMoveStringLiteralDfa0_4();
                    if (this.jjmatchedPos != 0 || this.jjmatchedKind <= 105) break;
                    this.jjmatchedKind = 105;
                    break;
                }
                case 5: {
                    this.jjmatchedKind = Integer.MAX_VALUE;
                    this.jjmatchedPos = 0;
                    curPos = this.jjMoveStringLiteralDfa0_5();
                    if (this.jjmatchedPos != 0 || this.jjmatchedKind <= 105) break;
                    this.jjmatchedKind = 105;
                    break;
                }
                case 6: {
                    this.jjmatchedKind = Integer.MAX_VALUE;
                    this.jjmatchedPos = 0;
                    curPos = this.jjMoveStringLiteralDfa0_6();
                    if (this.jjmatchedPos != 0 || this.jjmatchedKind <= 105) break;
                    this.jjmatchedKind = 105;
                    break;
                }
                case 7: {
                    this.jjmatchedKind = Integer.MAX_VALUE;
                    this.jjmatchedPos = 0;
                    curPos = this.jjMoveStringLiteralDfa0_7();
                    if (this.jjmatchedPos != 0 || this.jjmatchedKind <= 83) break;
                    this.jjmatchedKind = 83;
                    break;
                }
                case 8: {
                    this.jjmatchedKind = Integer.MAX_VALUE;
                    this.jjmatchedPos = 0;
                    curPos = this.jjMoveStringLiteralDfa0_8();
                    if (this.jjmatchedPos != 0 || this.jjmatchedKind <= 83) break;
                    this.jjmatchedKind = 83;
                }
            }
            if (this.jjmatchedKind == Integer.MAX_VALUE) break;
            if (this.jjmatchedPos + 1 < curPos) {
                this.input_stream.backup(curPos - this.jjmatchedPos - 1);
            }
            if ((jjtoToken[this.jjmatchedKind >> 6] & 1L << (this.jjmatchedKind & 0x3F)) != 0L) {
                Token matchedToken = this.jjFillToken();
                if (jjnewLexState[this.jjmatchedKind] != -1) {
                    this.curLexState = jjnewLexState[this.jjmatchedKind];
                }
                return matchedToken;
            }
            this.SkipLexicalActions(null);
            if (jjnewLexState[this.jjmatchedKind] == -1) continue;
            this.curLexState = jjnewLexState[this.jjmatchedKind];
        }
        int error_line = this.input_stream.getEndLine();
        int error_column = this.input_stream.getEndColumn();
        String error_after = null;
        boolean EOFSeen = false;
        try {
            this.input_stream.readChar();
            this.input_stream.backup(1);
        }
        catch (IOException e1) {
            EOFSeen = true;
            String string = error_after = curPos <= 1 ? "" : this.input_stream.GetImage();
            if (this.curChar == 10 || this.curChar == 13) {
                ++error_line;
                error_column = 0;
            }
            ++error_column;
        }
        if (!EOFSeen) {
            this.input_stream.backup(1);
            error_after = curPos <= 1 ? "" : this.input_stream.GetImage();
        }
        throw new TokenMgrError(EOFSeen, this.curLexState, error_line, error_column, error_after, this.curChar, 0);
    }

    void SkipLexicalActions(Token matchedToken) {
        switch (this.jjmatchedKind) {
            case 3: {
                this.lengthOfMatch = this.jjmatchedPos + 1;
                this.image.append(this.input_stream.GetSuffix(this.jjimageLen + this.lengthOfMatch));
                this.transitionToState(HtmlContext.JS_TEMPLATE_LITERAL);
                break;
            }
            case 4: {
                this.lengthOfMatch = this.jjmatchedPos + 1;
                this.image.append(this.input_stream.GetSuffix(this.jjimageLen + this.lengthOfMatch));
                this.transitionToJsRegexPreceder();
                break;
            }
            case 6: {
                this.lengthOfMatch = this.jjmatchedPos + 1;
                this.image.append(this.input_stream.GetSuffix(this.jjimageLen + this.lengthOfMatch));
                this.transitionToState(HtmlContext.JS_BLOCK_COMMENT);
                break;
            }
            case 7: {
                this.lengthOfMatch = this.jjmatchedPos + 1;
                this.image.append(this.input_stream.GetSuffix(this.jjimageLen + this.lengthOfMatch));
                this.transitionToState(HtmlContext.JS_LINE_COMMENT);
                break;
            }
            case 8: {
                this.lengthOfMatch = this.jjmatchedPos + 1;
                this.image.append(this.input_stream.GetSuffix(this.jjimageLen + this.lengthOfMatch));
                this.transitionToJsStringLiteral(HtmlContext.JS_DQ_STRING);
                break;
            }
            case 9: {
                this.lengthOfMatch = this.jjmatchedPos + 1;
                this.image.append(this.input_stream.GetSuffix(this.jjimageLen + this.lengthOfMatch));
                this.transitionToJsStringLiteral(HtmlContext.JS_SQ_STRING);
                break;
            }
            case 10: {
                this.lengthOfMatch = this.jjmatchedPos + 1;
                this.image.append(this.input_stream.GetSuffix(this.jjimageLen + this.lengthOfMatch));
                this.currentContext = this.currentContext.toBuilder().withState(HtmlContext.JS_TEMPLATE_LITERAL).withJsTemplateLiteralNestDepth(this.currentContext.jsTemplateLiteralNestDepth() + 1).build();
                break;
            }
            case 11: {
                this.lengthOfMatch = this.jjmatchedPos + 1;
                this.image.append(this.input_stream.GetSuffix(this.jjimageLen + this.lengthOfMatch));
                switch (this.currentContext.slashType()) {
                    case DIV_OP: {
                        this.currentContext = this.currentContext.toBuilder().withState(HtmlContext.JS).withSlashType(Context.JsFollowingSlash.REGEX).build();
                        break;
                    }
                    case REGEX: {
                        this.currentContext = this.currentContext.toBuilder().withState(HtmlContext.JS_REGEX).withSlashType(Context.JsFollowingSlash.NONE).build();
                        this.SwitchTo(4);
                        break;
                    }
                    case NONE: 
                    case UNKNOWN: {
                        this.error("Slash (/) cannot follow the preceding branches since it is unclear whether the slash is a RegExp literal or division operator.  Consider adding parentheses to disambiguate");
                    }
                }
                break;
            }
            case 12: {
                this.lengthOfMatch = this.jjmatchedPos + 1;
                this.image.append(this.input_stream.GetSuffix(this.jjimageLen + this.lengthOfMatch));
                this.transitionToJsDivPreceder();
                break;
            }
            case 13: {
                this.lengthOfMatch = this.jjmatchedPos + 1;
                this.image.append(this.input_stream.GetSuffix(this.jjimageLen + this.lengthOfMatch));
                this.transitionToJsDivPreceder();
                break;
            }
            case 14: {
                this.lengthOfMatch = this.jjmatchedPos + 1;
                this.image.append(this.input_stream.GetSuffix(this.jjimageLen + this.lengthOfMatch));
                this.transitionToJsRegexPreceder();
                break;
            }
            case 15: {
                this.lengthOfMatch = this.jjmatchedPos + 1;
                this.image.append(this.input_stream.GetSuffix(this.jjimageLen + this.lengthOfMatch));
                this.transitionToJsRegexPreceder();
                break;
            }
            case 16: {
                this.lengthOfMatch = this.jjmatchedPos + 1;
                this.image.append(this.input_stream.GetSuffix(this.jjimageLen + this.lengthOfMatch));
                this.transitionToJsRegexPreceder();
                break;
            }
            case 17: {
                this.lengthOfMatch = this.jjmatchedPos + 1;
                this.image.append(this.input_stream.GetSuffix(this.jjimageLen + this.lengthOfMatch));
                this.transitionToJsRegexPreceder();
                break;
            }
            case 18: {
                this.lengthOfMatch = this.jjmatchedPos + 1;
                this.image.append(this.input_stream.GetSuffix(this.jjimageLen + this.lengthOfMatch));
                this.transitionToJsRegexPreceder();
                break;
            }
            case 19: {
                this.lengthOfMatch = this.jjmatchedPos + 1;
                this.image.append(this.input_stream.GetSuffix(this.jjimageLen + this.lengthOfMatch));
                this.transitionToJsRegexPreceder();
                break;
            }
            case 20: {
                this.lengthOfMatch = this.jjmatchedPos + 1;
                this.image.append(this.input_stream.GetSuffix(this.jjimageLen + this.lengthOfMatch));
                this.transitionToJsRegexPreceder();
                break;
            }
            case 21: {
                this.lengthOfMatch = this.jjmatchedPos + 1;
                this.image.append(this.input_stream.GetSuffix(this.jjimageLen + this.lengthOfMatch));
                this.transitionToJsRegexPreceder();
                break;
            }
            case 22: {
                this.lengthOfMatch = this.jjmatchedPos + 1;
                this.image.append(this.input_stream.GetSuffix(this.jjimageLen + this.lengthOfMatch));
                this.transitionToJsRegexPreceder();
                break;
            }
            case 23: {
                this.lengthOfMatch = this.jjmatchedPos + 1;
                this.image.append(this.input_stream.GetSuffix(this.jjimageLen + this.lengthOfMatch));
                this.transitionToJsRegexPreceder();
                break;
            }
            case 24: {
                this.lengthOfMatch = this.jjmatchedPos + 1;
                this.image.append(this.input_stream.GetSuffix(this.jjimageLen + this.lengthOfMatch));
                this.transitionToJsRegexPreceder();
                break;
            }
            case 25: {
                this.lengthOfMatch = this.jjmatchedPos + 1;
                this.image.append(this.input_stream.GetSuffix(this.jjimageLen + this.lengthOfMatch));
                this.transitionToJsRegexPreceder();
                break;
            }
            case 26: {
                this.lengthOfMatch = this.jjmatchedPos + 1;
                this.image.append(this.input_stream.GetSuffix(this.jjimageLen + this.lengthOfMatch));
                this.transitionToJsRegexPreceder();
                break;
            }
            case 27: {
                this.lengthOfMatch = this.jjmatchedPos + 1;
                this.image.append(this.input_stream.GetSuffix(this.jjimageLen + this.lengthOfMatch));
                this.transitionToJsRegexPreceder();
                break;
            }
            case 28: {
                this.lengthOfMatch = this.jjmatchedPos + 1;
                this.image.append(this.input_stream.GetSuffix(this.jjimageLen + this.lengthOfMatch));
                this.transitionToJsRegexPreceder();
                break;
            }
            case 29: {
                this.lengthOfMatch = this.jjmatchedPos + 1;
                this.image.append(this.input_stream.GetSuffix(this.jjimageLen + this.lengthOfMatch));
                this.transitionToJsRegexPreceder();
                break;
            }
            case 30: {
                this.lengthOfMatch = this.jjmatchedPos + 1;
                this.image.append(this.input_stream.GetSuffix(this.jjimageLen + this.lengthOfMatch));
                this.transitionToJsRegexPreceder();
                break;
            }
            case 31: {
                this.lengthOfMatch = this.jjmatchedPos + 1;
                this.image.append(this.input_stream.GetSuffix(this.jjimageLen + this.lengthOfMatch));
                this.transitionToJsRegexPreceder();
                break;
            }
            case 32: {
                this.lengthOfMatch = this.jjmatchedPos + 1;
                this.image.append(this.input_stream.GetSuffix(this.jjimageLen + this.lengthOfMatch));
                this.transitionToJsRegexPreceder();
                break;
            }
            case 33: {
                this.lengthOfMatch = this.jjmatchedPos + 1;
                this.image.append(this.input_stream.GetSuffix(this.jjimageLen + this.lengthOfMatch));
                this.transitionToJsRegexPreceder();
                break;
            }
            case 34: {
                this.lengthOfMatch = this.jjmatchedPos + 1;
                this.image.append(this.input_stream.GetSuffix(this.jjimageLen + this.lengthOfMatch));
                this.transitionToJsRegexPreceder();
                break;
            }
            case 35: {
                this.lengthOfMatch = this.jjmatchedPos + 1;
                this.image.append(this.input_stream.GetSuffix(this.jjimageLen + this.lengthOfMatch));
                this.transitionToJsRegexPreceder();
                break;
            }
            case 36: {
                this.lengthOfMatch = this.jjmatchedPos + 1;
                this.image.append(this.input_stream.GetSuffix(this.jjimageLen + this.lengthOfMatch));
                this.transitionToJsRegexPreceder();
                break;
            }
            case 37: {
                this.lengthOfMatch = this.jjmatchedPos + 1;
                this.image.append(this.input_stream.GetSuffix(this.jjimageLen + this.lengthOfMatch));
                this.transitionToJsRegexPreceder();
                break;
            }
            case 38: {
                this.lengthOfMatch = this.jjmatchedPos + 1;
                this.image.append(this.input_stream.GetSuffix(this.jjimageLen + this.lengthOfMatch));
                this.transitionToJsRegexPreceder();
                break;
            }
            case 39: {
                this.lengthOfMatch = this.jjmatchedPos + 1;
                this.image.append(this.input_stream.GetSuffix(this.jjimageLen + this.lengthOfMatch));
                this.transitionToJsRegexPreceder();
                break;
            }
            case 40: {
                this.lengthOfMatch = this.jjmatchedPos + 1;
                this.image.append(this.input_stream.GetSuffix(this.jjimageLen + this.lengthOfMatch));
                this.transitionToJsRegexPreceder();
                break;
            }
            case 41: {
                this.lengthOfMatch = this.jjmatchedPos + 1;
                this.image.append(this.input_stream.GetSuffix(this.jjimageLen + this.lengthOfMatch));
                this.transitionToJsRegexPreceder();
                break;
            }
            case 42: {
                this.lengthOfMatch = this.jjmatchedPos + 1;
                this.image.append(this.input_stream.GetSuffix(this.jjimageLen + this.lengthOfMatch));
                this.transitionToJsRegexPreceder();
                break;
            }
            case 43: {
                this.lengthOfMatch = this.jjmatchedPos + 1;
                this.image.append(this.input_stream.GetSuffix(this.jjimageLen + this.lengthOfMatch));
                this.transitionToJsRegexPreceder();
                break;
            }
            case 44: {
                this.lengthOfMatch = this.jjmatchedPos + 1;
                this.image.append(this.input_stream.GetSuffix(this.jjimageLen + this.lengthOfMatch));
                this.transitionToJsRegexPreceder();
                break;
            }
            case 45: {
                this.lengthOfMatch = this.jjmatchedPos + 1;
                this.image.append(this.input_stream.GetSuffix(this.jjimageLen + this.lengthOfMatch));
                this.transitionToJsRegexPreceder();
                break;
            }
            case 46: {
                this.lengthOfMatch = this.jjmatchedPos + 1;
                this.image.append(this.input_stream.GetSuffix(this.jjimageLen + this.lengthOfMatch));
                this.transitionToJsRegexPreceder();
                break;
            }
            case 47: {
                this.lengthOfMatch = this.jjmatchedPos + 1;
                this.image.append(this.input_stream.GetSuffix(this.jjimageLen + this.lengthOfMatch));
                this.transitionToJsRegexPreceder();
                break;
            }
            case 48: {
                this.lengthOfMatch = this.jjmatchedPos + 1;
                this.image.append(this.input_stream.GetSuffix(this.jjimageLen + this.lengthOfMatch));
                this.transitionToJsRegexPreceder();
                break;
            }
            case 49: {
                this.lengthOfMatch = this.jjmatchedPos + 1;
                this.image.append(this.input_stream.GetSuffix(this.jjimageLen + this.lengthOfMatch));
                this.transitionToJsRegexPreceder();
                break;
            }
            case 50: {
                this.lengthOfMatch = this.jjmatchedPos + 1;
                this.image.append(this.input_stream.GetSuffix(this.jjimageLen + this.lengthOfMatch));
                this.transitionToJsRegexPreceder();
                break;
            }
            case 51: {
                this.lengthOfMatch = this.jjmatchedPos + 1;
                this.image.append(this.input_stream.GetSuffix(this.jjimageLen + this.lengthOfMatch));
                this.transitionToJsRegexPreceder();
                break;
            }
            case 52: {
                this.lengthOfMatch = this.jjmatchedPos + 1;
                this.image.append(this.input_stream.GetSuffix(this.jjimageLen + this.lengthOfMatch));
                this.transitionToJsRegexPreceder();
                break;
            }
            case 53: {
                this.lengthOfMatch = this.jjmatchedPos + 1;
                this.image.append(this.input_stream.GetSuffix(this.jjimageLen + this.lengthOfMatch));
                this.transitionToJsRegexPreceder();
                break;
            }
            case 54: {
                this.lengthOfMatch = this.jjmatchedPos + 1;
                this.image.append(this.input_stream.GetSuffix(this.jjimageLen + this.lengthOfMatch));
                this.transitionToJsRegexPreceder();
                break;
            }
            case 55: {
                this.lengthOfMatch = this.jjmatchedPos + 1;
                this.image.append(this.input_stream.GetSuffix(this.jjimageLen + this.lengthOfMatch));
                this.transitionToJsRegexPreceder();
                break;
            }
            case 56: {
                this.lengthOfMatch = this.jjmatchedPos + 1;
                this.image.append(this.input_stream.GetSuffix(this.jjimageLen + this.lengthOfMatch));
                this.transitionToJsRegexPreceder();
                break;
            }
            case 57: {
                this.lengthOfMatch = this.jjmatchedPos + 1;
                this.image.append(this.input_stream.GetSuffix(this.jjimageLen + this.lengthOfMatch));
                this.transitionToJsRegexPreceder();
                break;
            }
            case 58: {
                this.lengthOfMatch = this.jjmatchedPos + 1;
                this.image.append(this.input_stream.GetSuffix(this.jjimageLen + this.lengthOfMatch));
                this.transitionToJsRegexPreceder();
                break;
            }
            case 59: {
                this.lengthOfMatch = this.jjmatchedPos + 1;
                this.image.append(this.input_stream.GetSuffix(this.jjimageLen + this.lengthOfMatch));
                this.transitionToJsRegexPreceder();
                break;
            }
            case 60: {
                this.lengthOfMatch = this.jjmatchedPos + 1;
                this.image.append(this.input_stream.GetSuffix(this.jjimageLen + this.lengthOfMatch));
                this.transitionToJsRegexPreceder();
                break;
            }
            case 61: {
                this.lengthOfMatch = this.jjmatchedPos + 1;
                this.image.append(this.input_stream.GetSuffix(this.jjimageLen + this.lengthOfMatch));
                this.transitionToJsRegexPreceder();
                break;
            }
            case 62: {
                this.lengthOfMatch = this.jjmatchedPos + 1;
                this.image.append(this.input_stream.GetSuffix(this.jjimageLen + this.lengthOfMatch));
                this.transitionToJsRegexPreceder();
                break;
            }
            case 63: {
                this.lengthOfMatch = this.jjmatchedPos + 1;
                this.image.append(this.input_stream.GetSuffix(this.jjimageLen + this.lengthOfMatch));
                this.transitionToJsRegexPreceder();
                break;
            }
            case 64: {
                this.lengthOfMatch = this.jjmatchedPos + 1;
                this.image.append(this.input_stream.GetSuffix(this.jjimageLen + this.lengthOfMatch));
                this.transitionToJsRegexPreceder();
                break;
            }
            case 65: {
                this.lengthOfMatch = this.jjmatchedPos + 1;
                this.image.append(this.input_stream.GetSuffix(this.jjimageLen + this.lengthOfMatch));
                this.transitionToJsRegexPreceder();
                break;
            }
            case 66: {
                this.lengthOfMatch = this.jjmatchedPos + 1;
                this.image.append(this.input_stream.GetSuffix(this.jjimageLen + this.lengthOfMatch));
                this.transitionToJsRegexPreceder();
                break;
            }
            case 67: {
                this.lengthOfMatch = this.jjmatchedPos + 1;
                this.image.append(this.input_stream.GetSuffix(this.jjimageLen + this.lengthOfMatch));
                this.transitionToJsRegexPreceder();
                break;
            }
            case 68: {
                this.lengthOfMatch = this.jjmatchedPos + 1;
                this.image.append(this.input_stream.GetSuffix(this.jjimageLen + this.lengthOfMatch));
                this.transitionToJsRegexPreceder();
                break;
            }
            case 69: {
                this.lengthOfMatch = this.jjmatchedPos + 1;
                this.image.append(this.input_stream.GetSuffix(this.jjimageLen + this.lengthOfMatch));
                this.transitionToJsRegexPreceder();
                break;
            }
            case 70: {
                this.lengthOfMatch = this.jjmatchedPos + 1;
                this.image.append(this.input_stream.GetSuffix(this.jjimageLen + this.lengthOfMatch));
                this.transitionToJsRegexPreceder();
                break;
            }
            case 71: {
                this.lengthOfMatch = this.jjmatchedPos + 1;
                this.image.append(this.input_stream.GetSuffix(this.jjimageLen + this.lengthOfMatch));
                this.transitionToJsRegexPreceder();
                break;
            }
            case 72: {
                this.lengthOfMatch = this.jjmatchedPos + 1;
                this.image.append(this.input_stream.GetSuffix(this.jjimageLen + this.lengthOfMatch));
                this.transitionToJsRegexPreceder();
                break;
            }
            case 73: {
                this.lengthOfMatch = this.jjmatchedPos + 1;
                this.image.append(this.input_stream.GetSuffix(this.jjimageLen + this.lengthOfMatch));
                this.transitionToJsRegexPreceder();
                break;
            }
            case 74: {
                this.lengthOfMatch = this.jjmatchedPos + 1;
                this.image.append(this.input_stream.GetSuffix(this.jjimageLen + this.lengthOfMatch));
                this.transitionToJsRegexPreceder();
                break;
            }
            case 75: {
                this.lengthOfMatch = this.jjmatchedPos + 1;
                this.image.append(this.input_stream.GetSuffix(this.jjimageLen + this.lengthOfMatch));
                this.transitionToJsRegexPreceder();
                break;
            }
            case 76: {
                this.lengthOfMatch = this.jjmatchedPos + 1;
                this.image.append(this.input_stream.GetSuffix(this.jjimageLen + this.lengthOfMatch));
                this.transitionToJsRegexPreceder();
                break;
            }
            case 77: {
                this.lengthOfMatch = this.jjmatchedPos + 1;
                this.image.append(this.input_stream.GetSuffix(this.jjimageLen + this.lengthOfMatch));
                this.transitionToJsDivPreceder();
                break;
            }
            case 78: {
                this.lengthOfMatch = this.jjmatchedPos + 1;
                this.image.append(this.input_stream.GetSuffix(this.jjimageLen + this.lengthOfMatch));
                this.transitionToJsDivPreceder();
                break;
            }
            case 79: {
                this.lengthOfMatch = this.jjmatchedPos + 1;
                this.image.append(this.input_stream.GetSuffix(this.jjimageLen + this.lengthOfMatch));
                this.transitionToJsDivPreceder();
                break;
            }
            case 80: {
                this.lengthOfMatch = this.jjmatchedPos + 1;
                this.image.append(this.input_stream.GetSuffix(this.jjimageLen + this.lengthOfMatch));
                this.transitionToJsDivPreceder();
                break;
            }
            case 82: {
                this.lengthOfMatch = this.jjmatchedPos + 1;
                this.image.append(this.input_stream.GetSuffix(this.jjimageLen + this.lengthOfMatch));
                this.transitionToJsDivPreceder();
                break;
            }
            case 83: {
                this.lengthOfMatch = this.jjmatchedPos + 1;
                this.image.append(this.input_stream.GetSuffix(this.jjimageLen + this.lengthOfMatch));
                this.transitionToJsDivPreceder();
                break;
            }
            case 84: {
                this.lengthOfMatch = this.jjmatchedPos + 1;
                this.image.append(this.input_stream.GetSuffix(this.jjimageLen + this.lengthOfMatch));
                this.transitionToState(HtmlContext.JS);
                this.switchToDefaultOrTemplateLiteral();
                break;
            }
            case 85: {
                this.lengthOfMatch = this.jjmatchedPos + 1;
                this.image.append(this.input_stream.GetSuffix(this.jjimageLen + this.lengthOfMatch));
                this.transitionToState(HtmlContext.JS);
                this.switchToDefaultOrTemplateLiteral();
                break;
            }
            case 86: {
                this.lengthOfMatch = this.jjmatchedPos + 1;
                this.image.append(this.input_stream.GetSuffix(this.jjimageLen + this.lengthOfMatch));
                this.error("unexpected end of line in JavaScript regex literal");
                break;
            }
            case 90: {
                this.lengthOfMatch = this.jjmatchedPos + 1;
                this.image.append(this.input_stream.GetSuffix(this.jjimageLen + this.lengthOfMatch));
                this.transitionToState(HtmlContext.JS);
                this.transitionToJsDivPreceder();
                this.switchToDefaultOrTemplateLiteral();
                break;
            }
            case 93: {
                this.lengthOfMatch = this.jjmatchedPos + 1;
                this.image.append(this.input_stream.GetSuffix(this.jjimageLen + this.lengthOfMatch));
                this.error("unexpected end of line in JavaScript regex literal");
                break;
            }
            case 94: {
                this.lengthOfMatch = this.jjmatchedPos + 1;
                this.image.append(this.input_stream.GetSuffix(this.jjimageLen + this.lengthOfMatch));
                this.transitionToState(HtmlContext.JS);
                this.transitionToJsDivPreceder();
                this.switchToDefaultOrTemplateLiteral();
                break;
            }
            case 96: {
                this.lengthOfMatch = this.jjmatchedPos + 1;
                this.image.append(this.input_stream.GetSuffix(this.jjimageLen + this.lengthOfMatch));
                this.transitionToState(HtmlContext.JS);
                this.transitionToJsDivPreceder();
                this.switchToDefaultOrTemplateLiteral();
                break;
            }
            case 98: {
                this.lengthOfMatch = this.jjmatchedPos + 1;
                this.image.append(this.input_stream.GetSuffix(this.jjimageLen + this.lengthOfMatch));
                this.error("unexpected end of line in JavaScript String literal");
                break;
            }
            case 103: {
                this.lengthOfMatch = this.jjmatchedPos + 1;
                this.image.append(this.input_stream.GetSuffix(this.jjimageLen + this.lengthOfMatch));
                this.transitionToState(HtmlContext.JS);
                break;
            }
            case 104: {
                this.lengthOfMatch = this.jjmatchedPos + 1;
                this.image.append(this.input_stream.GetSuffix(this.jjimageLen + this.lengthOfMatch));
                this.currentContext = this.currentContext.toBuilder().withState(HtmlContext.JS).withJsTemplateLiteralNestDepth(this.currentContext.jsTemplateLiteralNestDepth() - 1).withSlashType(Context.JsFollowingSlash.REGEX).build();
                this.switchToDefaultOrTemplateLiteral();
                break;
            }
        }
    }

    private void jjCheckNAdd(int state) {
        if (this.jjrounds[state] != this.jjround) {
            this.jjstateSet[this.jjnewStateCnt++] = state;
            this.jjrounds[state] = this.jjround;
        }
    }

    private void jjAddStates(int start, int end) {
        do {
            this.jjstateSet[this.jjnewStateCnt++] = jjnextStates[start];
        } while (start++ != end);
    }

    private void jjCheckNAddTwoStates(int state1, int state2) {
        this.jjCheckNAdd(state1);
        this.jjCheckNAdd(state2);
    }

    private void jjCheckNAddStates(int start, int end) {
        do {
            this.jjCheckNAdd(jjnextStates[start]);
        } while (start++ != end);
    }

    public JsLexerTokenManager(SimpleCharStream stream) {
        this.input_stream = stream;
    }

    public JsLexerTokenManager(SimpleCharStream stream, int lexState) {
        this.ReInit(stream);
        this.SwitchTo(lexState);
    }

    public void ReInit(SimpleCharStream stream) {
        this.jjnewStateCnt = 0;
        this.jjmatchedPos = 0;
        this.curLexState = this.defaultLexState;
        this.input_stream = stream;
        this.ReInitRounds();
    }

    private void ReInitRounds() {
        this.jjround = -2147483647;
        int i = 26;
        while (i-- > 0) {
            this.jjrounds[i] = Integer.MIN_VALUE;
        }
    }

    public void ReInit(SimpleCharStream stream, int lexState) {
        this.ReInit(stream);
        this.SwitchTo(lexState);
    }

    public void SwitchTo(int lexState) {
        if (lexState >= 9 || lexState < 0) {
            throw new TokenMgrError("Error: Ignoring invalid lexical state : " + lexState + ". State unchanged.", 2);
        }
        this.curLexState = lexState;
    }
}

