/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.parseinfo.passes;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Ascii;
import com.google.common.base.CaseFormat;
import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import com.google.template.soy.base.internal.BaseUtils;
import com.google.template.soy.base.internal.IndentedLinesBuilder;
import com.google.template.soy.exprtree.AbstractVarDefn;
import com.google.template.soy.exprtree.StringNode;
import com.google.template.soy.invocationbuilders.passes.SoyFileNodeTransformer;
import com.google.template.soy.passes.IndirectParamsCalculator;
import com.google.template.soy.shared.internal.BuiltinFunction;
import com.google.template.soy.shared.internal.gencode.GeneratedFile;
import com.google.template.soy.shared.internal.gencode.JavaGenerationUtils;
import com.google.template.soy.soytree.AbstractSoyNodeVisitor;
import com.google.template.soy.soytree.FileSetMetadata;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyFileSetNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.SoyTreeUtils;
import com.google.template.soy.soytree.TemplateDelegateNode;
import com.google.template.soy.soytree.TemplateMetadata;
import com.google.template.soy.soytree.TemplateNode;
import com.google.template.soy.soytree.Visibility;
import com.google.template.soy.soytree.defn.TemplateParam;
import com.google.template.soy.types.TemplateType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;

public final class GenerateParseInfoVisitor
extends AbstractSoyNodeVisitor<ImmutableList<GeneratedFile>> {
    private final String javaPackage;
    private final JavaClassNameSource javaClassNameSource;
    private Map<SoyFileNode, String> soyFileToJavaClassNameMap;
    private final FileSetMetadata fileSetMetadata;
    private final SoyFileNodeTransformer soyFileNodeTransformer;
    private final Map<String, String> convertedIdents = Maps.newLinkedHashMap();
    private ImmutableList.Builder<GeneratedFile> generatedFiles;
    private IndentedLinesBuilder ilb;
    private SoyFileNodeTransformer.FileInfo builderReport;
    private Set<String> paramFields = new HashSet<String>();

    public GenerateParseInfoVisitor(String javaPackage, String javaClassNameSource, FileSetMetadata registry) {
        this.javaPackage = javaPackage;
        this.fileSetMetadata = registry;
        switch (javaClassNameSource) {
            case "filename": {
                this.javaClassNameSource = JavaClassNameSource.SOY_FILE_NAME;
                break;
            }
            case "namespace": {
                this.javaClassNameSource = JavaClassNameSource.SOY_NAMESPACE_LAST_PART;
                break;
            }
            case "generic": {
                this.javaClassNameSource = JavaClassNameSource.GENERIC;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid value for javaClassNameSource \"" + javaClassNameSource + "\" (valid values are \"filename\", \"namespace\", and \"generic\").");
            }
        }
        this.soyFileNodeTransformer = new SoyFileNodeTransformer(javaPackage, registry);
    }

    @Override
    public ImmutableList<GeneratedFile> exec(SoyNode node) {
        this.generatedFiles = new ImmutableList.Builder();
        this.ilb = null;
        this.visit(node);
        return this.generatedFiles.build();
    }

    @Override
    protected void visitSoyFileSetNode(SoyFileSetNode node) {
        LinkedHashMultimap baseGeneratedClassNameToSoyFilesMap = LinkedHashMultimap.create();
        for (SoyFileNode soyFile : node.getChildren()) {
            baseGeneratedClassNameToSoyFilesMap.put((Object)this.javaClassNameSource.generateBaseClassName(soyFile), (Object)soyFile);
        }
        this.soyFileToJavaClassNameMap = Maps.newHashMap();
        for (String baseClassName : baseGeneratedClassNameToSoyFilesMap.keySet()) {
            Collection soyFiles = baseGeneratedClassNameToSoyFilesMap.get((Object)baseClassName);
            if (soyFiles.size() == 1) {
                for (SoyFileNode soyFile : soyFiles) {
                    this.soyFileToJavaClassNameMap.put(soyFile, baseClassName + "SoyInfo");
                }
                continue;
            }
            int numberSuffix = 1;
            for (SoyFileNode soyFile : soyFiles) {
                this.soyFileToJavaClassNameMap.put(soyFile, baseClassName + numberSuffix + "SoyInfo");
                ++numberSuffix;
            }
        }
        for (SoyFileNode soyFile : node.getChildren()) {
            this.visit(soyFile);
        }
    }

    @Override
    protected void visitSoyFileNode(SoyFileNode node) {
        String upperUnderscoreKey;
        String javaClassName = this.soyFileToJavaClassNameMap.get(node);
        this.builderReport = this.soyFileNodeTransformer.transform(node);
        LinkedHashMap publicBasicTemplateMap = Maps.newLinkedHashMap();
        LinkedHashSet allParamKeys = Sets.newLinkedHashSet();
        LinkedHashMultimap paramKeyToTemplatesMultimap = LinkedHashMultimap.create();
        for (TemplateNode template : node.getTemplates()) {
            if (template.getVisibility() == Visibility.PUBLIC && template.getKind() != SoyNode.Kind.TEMPLATE_DELEGATE_NODE) {
                publicBasicTemplateMap.put(this.convertToUpperUnderscore(template.getLocalTemplateSymbol()), template);
            }
            for (TemplateParam param : template.getParams()) {
                if (param.isImplicit()) continue;
                allParamKeys.add(param.name());
                paramKeyToTemplatesMultimap.put((Object)param.name(), (Object)template);
            }
        }
        TreeSet protoTypes = Sets.newTreeSet(JavaGenerationUtils.getProtoTypes(node, node.getSoyTypeRegistry()));
        TreeMap allParamKeysMap = Maps.newTreeMap();
        for (String key : allParamKeys) {
            upperUnderscoreKey = this.convertToUpperUnderscore(key);
            while (allParamKeysMap.containsKey(upperUnderscoreKey)) {
                upperUnderscoreKey = upperUnderscoreKey + "_";
            }
            allParamKeysMap.put(upperUnderscoreKey, key);
            this.convertedIdents.put(key, upperUnderscoreKey);
        }
        this.ilb = new IndentedLinesBuilder(2);
        this.ilb.appendLine("// This file was automatically generated by the Soy compiler.");
        this.ilb.appendLine("// Please don't edit this file by hand.");
        this.ilb.appendLine("// source: ", node.getFilePath().path());
        this.ilb.appendLine(new Object[0]);
        this.ilb.appendLine("package ", this.javaPackage, ";");
        this.ilb.appendLine(new Object[0]);
        this.ilb.appendLine("import com.google.common.collect.ImmutableList;");
        this.ilb.appendLine("import com.google.common.collect.ImmutableMap;");
        this.ilb.appendLine("import com.google.common.collect.ImmutableSet;");
        this.ilb.appendLine("import com.google.common.collect.ImmutableSortedSet;");
        if (!protoTypes.isEmpty()) {
            this.ilb.appendLine("import com.google.protobuf.Descriptors.FileDescriptor;");
        }
        this.ilb.appendLine("import com.google.template.soy.parseinfo.SoyFileInfo;");
        this.ilb.appendLine("import com.google.template.soy.parseinfo.SoyTemplateInfo;");
        this.ilb.appendLine("import javax.annotation.Generated;");
        this.ilb.appendLine(new Object[0]);
        this.ilb.appendLine(new Object[0]);
        JavaGenerationUtils.appendJavadoc(this.ilb, GenerateParseInfoVisitor.deprecatedJavaDoc("Soy parse info for " + node.getFileName() + ".", this.builderReport.complete(), this.builderReport.fqClassName()), true, false);
        GenerateParseInfoVisitor.deprecatedAnnotation(this.ilb, this.builderReport.complete());
        this.ilb.appendLine("@Generated(\"com.google.template.soy.SoyParseInfoGenerator\")");
        this.ilb.appendLine("public final class ", javaClassName, " extends SoyFileInfo {");
        this.ilb.increaseIndent();
        this.ilb.appendLine(new Object[0]);
        this.ilb.appendLine(new Object[0]);
        this.ilb.appendLine("/** This Soy file's namespace. */");
        this.ilb.appendLine("public static final String __NAMESPACE__ = \"", node.getNamespace(), "\";");
        if (!protoTypes.isEmpty()) {
            this.ilb.appendLine(new Object[0]);
            this.ilb.appendLine(new Object[0]);
            this.ilb.appendLine("/** Protocol buffer types used by these templates. */");
            this.ilb.appendLine("@Override public ImmutableList<FileDescriptor> getProtoDescriptors() {");
            this.ilb.increaseIndent();
            Iterator defaultInstances = Lists.newArrayList();
            defaultInstances.addAll(protoTypes);
            this.ilb.appendLineStart("return ");
            JavaGenerationUtils.appendImmutableListInline(this.ilb, "", (Collection<String>)((Object)defaultInstances));
            this.ilb.appendLineEnd(";");
            this.ilb.decreaseIndent();
            this.ilb.appendLine("}");
        }
        this.ilb.appendLine(new Object[0]);
        this.ilb.appendLine(new Object[0]);
        GenerateParseInfoVisitor.deprecatedAnnotation(this.ilb, this.builderReport.complete());
        this.ilb.appendLine("public static final class TemplateName {");
        this.ilb.increaseIndent();
        this.ilb.appendLine("private TemplateName() {}");
        this.ilb.appendLine(new Object[0]);
        for (Map.Entry templateEntry : publicBasicTemplateMap.entrySet()) {
            StringBuilder javadocSb = new StringBuilder();
            javadocSb.append("The full template name of the ").append(((TemplateNode)templateEntry.getValue()).getPartialTemplateName()).append(" template.");
            JavaGenerationUtils.appendJavadoc(this.ilb, javadocSb.toString(), false, true);
            this.ilb.appendLine("public static final String ", templateEntry.getKey(), " = \"", ((TemplateNode)templateEntry.getValue()).getTemplateName(), "\";");
            this.ilb.appendLine("public static final com.google.template.soy.parseinfo.TemplateName ", templateEntry.getKey(), "__NAME = com.google.template.soy.parseinfo.TemplateName.of(", templateEntry.getKey(), ");");
        }
        this.ilb.decreaseIndent();
        this.ilb.appendLine("}");
        this.ilb.appendLine(new Object[0]);
        this.ilb.appendLine(new Object[0]);
        this.ilb.appendLine("/**");
        this.ilb.appendLine(" * Param names from all templates in this Soy file.");
        this.ilb.appendLine(" */");
        GenerateParseInfoVisitor.deprecatedAnnotation(this.ilb, this.builderReport.complete());
        this.ilb.appendLine("public static final class Param {");
        this.ilb.increaseIndent();
        this.ilb.appendLine("private Param() {}");
        this.ilb.appendLine(new Object[0]);
        this.paramFields.clear();
        for (Map.Entry paramEntry : allParamKeysMap.entrySet()) {
            upperUnderscoreKey = (String)paramEntry.getKey();
            String key = (String)paramEntry.getValue();
            StringBuilder javadocSb = new StringBuilder();
            javadocSb.append("Listed by ");
            boolean isFirst = true;
            for (TemplateNode template : paramKeyToTemplatesMultimap.get((Object)key)) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    javadocSb.append(", ");
                }
                javadocSb.append(GenerateParseInfoVisitor.buildTemplateNameForJavadoc(node, this.fileSetMetadata.getTemplate(template)));
            }
            javadocSb.append('.');
            JavaGenerationUtils.appendJavadoc(this.ilb, javadocSb.toString(), false, true);
            this.paramFields.add(upperUnderscoreKey);
            this.ilb.appendLine("public static final String ", upperUnderscoreKey, " = \"", key, "\";");
        }
        this.ilb.decreaseIndent();
        this.ilb.appendLine("}");
        for (TemplateNode template : publicBasicTemplateMap.values()) {
            this.visit(template);
        }
        this.ilb.appendLine(new Object[0]);
        this.ilb.appendLine(new Object[0]);
        this.ilb.appendLine("private ", javaClassName, "() {");
        this.ilb.increaseIndent();
        this.ilb.appendLine("super(");
        this.ilb.increaseIndent(2);
        this.ilb.appendLine("\"", node.getFileName(), "\",");
        this.ilb.appendLine("__NAMESPACE__,");
        ArrayList itemSnippets = Lists.newArrayList();
        itemSnippets.addAll(publicBasicTemplateMap.keySet());
        JavaGenerationUtils.appendImmutableList(this.ilb, "<SoyTemplateInfo>", itemSnippets);
        this.ilb.appendLineEnd(",");
        SortedSet cssNames = (SortedSet)GenerateParseInfoVisitor.collectCssNames(node).stream().map(s -> String.format("\"%s\"", s)).collect(ImmutableSortedSet.toImmutableSortedSet((Comparator)Ordering.natural()));
        JavaGenerationUtils.appendImmutableSet(this.ilb, "<String>", cssNames);
        this.ilb.appendLineEnd(");");
        this.ilb.decreaseIndent(2);
        this.ilb.decreaseIndent();
        this.ilb.appendLine("}");
        this.ilb.appendLine(new Object[0]);
        this.ilb.appendLine(new Object[0]);
        this.ilb.appendLine("private static final ", javaClassName, " __INSTANCE__ =");
        this.ilb.increaseIndent(2);
        this.ilb.appendLine("new ", javaClassName, "();");
        this.ilb.decreaseIndent(2);
        this.ilb.appendLine(new Object[0]);
        this.ilb.appendLine("public static ", javaClassName, " getInstance() {");
        this.ilb.increaseIndent();
        this.ilb.appendLine("return __INSTANCE__;");
        this.ilb.decreaseIndent();
        this.ilb.appendLine("}");
        this.ilb.appendLine(new Object[0]);
        this.ilb.decreaseIndent();
        this.ilb.appendLine("}");
        this.generatedFiles.add((Object)GeneratedFile.create(javaClassName + ".java", this.ilb.toString()));
        this.ilb = null;
    }

    @Override
    protected void visitTemplateNode(TemplateNode node) {
        if (node.getVisibility() != Visibility.PUBLIC || node instanceof TemplateDelegateNode) {
            return;
        }
        HashSet directParamNames = Sets.newHashSet();
        for (TemplateParam param : node.getParams()) {
            if (param.isImplicit()) continue;
            directParamNames.add(param.name());
        }
        TemplateMetadata nodeMetadata = this.fileSetMetadata.getTemplate(node);
        IndirectParamsCalculator.IndirectParamsInfo indirectParamsInfo = new IndirectParamsCalculator(this.fileSetMetadata).calculateIndirectParams(node);
        String upperUnderscoreName = this.convertToUpperUnderscore(node.getLocalTemplateSymbol());
        String templateInfoClassName = CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, upperUnderscoreName) + "SoyTemplateInfo";
        SoyFileNodeTransformer.TemplateInfo templateInfo = this.builderReport.findTemplate(node);
        boolean isDeprecated = templateInfo.complete();
        this.ilb.appendLine(new Object[0]);
        this.ilb.appendLine(new Object[0]);
        JavaGenerationUtils.appendJavadoc(this.ilb, GenerateParseInfoVisitor.deprecatedJavaDoc(Optional.ofNullable(node.getSoyDocDesc()).orElse(""), isDeprecated, templateInfo.fqClassName()), true, false);
        GenerateParseInfoVisitor.deprecatedAnnotation(this.ilb, isDeprecated);
        this.ilb.appendLine("public static final class ", templateInfoClassName, " extends SoyTemplateInfo {");
        this.ilb.increaseIndent();
        String templateFieldName = this.convertToUpperUnderscore(node.getLocalTemplateSymbol());
        this.ilb.appendLine(new Object[0]);
        this.ilb.appendLine("/** This template's full name. */");
        this.ilb.appendLine("public static final String __NAME__ = TemplateName.", templateFieldName, ";");
        this.ilb.appendLine("private static final com.google.template.soy.parseinfo.TemplateName __TEMPLATE_NAME__ =", " TemplateName.", templateFieldName, "__NAME", ";");
        boolean hasSeenFirstDirectParam = false;
        boolean hasSwitchedToIndirectParams = false;
        for (Object param : node.getParams()) {
            if (((TemplateParam)param).isImplicit()) continue;
            if (!hasSeenFirstDirectParam) {
                this.ilb.appendLine(new Object[0]);
                hasSeenFirstDirectParam = true;
            }
            if (((TemplateParam)param).desc() != null) {
                JavaGenerationUtils.appendJavadoc(this.ilb, ((TemplateParam)param).desc(), false, false);
            }
            String fieldName = this.convertToUpperUnderscore(((AbstractVarDefn)param).name());
            this.ilb.appendLine("public static final String ", this.convertToUpperUnderscore(((AbstractVarDefn)param).name()), " = ", this.paramFields.contains(fieldName) ? "Param." + fieldName : "\"" + ((AbstractVarDefn)param).name() + "\"", ";");
        }
        for (Object param : indirectParamsInfo.indirectParams.values()) {
            if (directParamNames.contains(((TemplateType.Parameter)param).getName())) continue;
            if (!hasSwitchedToIndirectParams) {
                this.ilb.appendLine(new Object[0]);
                this.ilb.appendLine("// Indirect params.");
                hasSwitchedToIndirectParams = true;
            }
            TreeSet sortedJavadocCalleeNames = Sets.newTreeSet();
            for (TemplateMetadata transitiveCallee : indirectParamsInfo.paramKeyToCalleesMultimap.get((Object)((TemplateType.Parameter)param).getName())) {
                String javadocCalleeName = GenerateParseInfoVisitor.buildTemplateNameForJavadoc(node.getParent(), transitiveCallee);
                sortedJavadocCalleeNames.add(javadocCalleeName);
            }
            String javadoc = "Listed by " + Joiner.on((String)", ").join((Iterable)sortedJavadocCalleeNames) + ".";
            JavaGenerationUtils.appendJavadoc(this.ilb, javadoc, false, true);
            String fieldName = this.convertToUpperUnderscore(((TemplateType.Parameter)param).getName());
            this.ilb.appendLine("public static final String ", fieldName, " = ", this.paramFields.contains(fieldName) ? "Param." + fieldName : "\"" + ((TemplateType.Parameter)param).getName() + "\"", ";");
        }
        this.ilb.appendLine(new Object[0]);
        this.ilb.appendLine("private ", templateInfoClassName, "() {");
        this.ilb.increaseIndent();
        this.ilb.appendLine("super(");
        this.ilb.increaseIndent(2);
        this.ilb.appendLine("__NAME__,");
        this.ilb.appendLine("__TEMPLATE_NAME__,");
        if (!nodeMetadata.getTemplateType().getParameters().isEmpty() || !indirectParamsInfo.indirectParams.isEmpty()) {
            ImmutableMap.Builder entrySnippetPairs = ImmutableMap.builder();
            HashSet seenParams = Sets.newHashSet();
            for (TemplateType.Parameter param : Iterables.concat(nodeMetadata.getTemplateType().getParameters(), (Iterable)indirectParamsInfo.indirectParams.values())) {
                if (param.isImplicit() || !seenParams.add(param.getName())) continue;
                entrySnippetPairs.put((Object)this.convertToUpperUnderscore(param.getName()), (Object)(param.isRequired() ? "ParamRequisiteness.REQUIRED" : "ParamRequisiteness.OPTIONAL"));
            }
            JavaGenerationUtils.appendImmutableMap(this.ilb, "<String, ParamRequisiteness>", (Map<String, String>)entrySnippetPairs.build());
            this.ilb.appendLineEnd(");");
        } else {
            this.ilb.appendLine("ImmutableMap.<String, ParamRequisiteness>of());");
        }
        this.ilb.decreaseIndent(2);
        this.ilb.decreaseIndent();
        this.ilb.appendLine("}");
        this.ilb.appendLine(new Object[0]);
        this.ilb.appendLine("private static final ", templateInfoClassName, " __INSTANCE__ =");
        this.ilb.increaseIndent(2);
        this.ilb.appendLine("new ", templateInfoClassName, "();");
        this.ilb.decreaseIndent(2);
        this.ilb.appendLine(new Object[0]);
        this.ilb.appendLine("public static ", templateInfoClassName, " getInstance() {");
        this.ilb.increaseIndent();
        this.ilb.appendLine("return __INSTANCE__;");
        this.ilb.decreaseIndent();
        this.ilb.appendLine("}");
        this.ilb.decreaseIndent();
        this.ilb.appendLine("}");
        this.ilb.appendLine(new Object[0]);
        this.ilb.appendLine("/** Same as ", templateInfoClassName, ".getInstance(). */");
        GenerateParseInfoVisitor.deprecatedAnnotation(this.ilb, isDeprecated);
        this.ilb.appendLine("public static final ", templateInfoClassName, " ", upperUnderscoreName, " =");
        this.ilb.increaseIndent(2);
        this.ilb.appendLine(templateInfoClassName, ".getInstance();");
        this.ilb.decreaseIndent(2);
    }

    private static void deprecatedAnnotation(IndentedLinesBuilder ilb, boolean deprecated) {
        if (deprecated) {
            ilb.appendLine("@Deprecated");
        }
    }

    private static String deprecatedJavaDoc(String content, boolean deprecated, String useInstead) {
        if (deprecated) {
            String instead = "";
            if (!Strings.isNullOrEmpty((String)useInstead)) {
                instead = " Use {@link " + useInstead + "} instead.";
            }
            String dep = "@deprecated" + instead;
            return content.isEmpty() ? dep : content + "\n\n" + dep;
        }
        return content;
    }

    private String convertToUpperUnderscore(String ident) {
        String result = this.convertedIdents.computeIfAbsent(ident, BaseUtils::convertToUpperUnderscore);
        return result;
    }

    private static String buildTemplateNameForJavadoc(SoyFileNode currSoyFile, TemplateMetadata template) {
        StringBuilder resultSb = new StringBuilder();
        if (template.getSourceLocation().getFilePath().equals(currSoyFile.getFilePath()) && template.getTemplateType().getTemplateKind() != TemplateType.TemplateKind.DELTEMPLATE) {
            resultSb.append(template.getTemplateName().substring(template.getTemplateName().lastIndexOf(46)));
        } else {
            switch (template.getTemplateType().getTemplateKind()) {
                case BASIC: 
                case ELEMENT: {
                    resultSb.append(template.getTemplateName());
                    break;
                }
                case DELTEMPLATE: {
                    resultSb.append(template.getDelTemplateName());
                    if (template.getDelTemplateVariant().isEmpty()) break;
                    resultSb.append(':');
                    resultSb.append(template.getDelTemplateVariant());
                }
            }
        }
        if (template.getVisibility() != Visibility.PUBLIC) {
            resultSb.append(" (private)");
        }
        if (template.getTemplateType().getTemplateKind() == TemplateType.TemplateKind.DELTEMPLATE) {
            resultSb.append(" (delegate)");
        }
        return resultSb.toString();
    }

    private static SortedSet<String> collectCssNames(SoyNode node) {
        TreeSet<String> cssNames = new TreeSet<String>();
        SoyTreeUtils.allFunctionInvocations(node, BuiltinFunction.CSS).forEach(fn -> {
            String selector = ((StringNode)Iterables.getLast(fn.getChildren())).getValue();
            cssNames.add(selector);
        });
        return cssNames;
    }

    @VisibleForTesting
    static enum JavaClassNameSource {
        SOY_FILE_NAME,
        SOY_NAMESPACE_LAST_PART,
        GENERIC;


        @VisibleForTesting
        String generateBaseClassName(SoyFileNode soyFile) {
            switch (this) {
                case SOY_FILE_NAME: {
                    String prefix;
                    String fileName = soyFile.getFileName();
                    if (fileName == null) {
                        throw new IllegalArgumentException("Trying to generate Java class name based on Soy file name, but Soy file name was not provided.");
                    }
                    if (Ascii.toLowerCase((String)fileName).endsWith(".soy")) {
                        fileName = fileName.substring(0, fileName.length() - 4);
                    }
                    if (Character.isDigit((prefix = JavaGenerationUtils.makeUpperCamelCase(fileName)).charAt(0))) {
                        prefix = "_" + prefix;
                    }
                    return prefix;
                }
                case SOY_NAMESPACE_LAST_PART: {
                    String namespace = soyFile.getNamespace();
                    String namespaceLastPart = namespace.substring(namespace.lastIndexOf(46) + 1);
                    return JavaGenerationUtils.makeUpperCamelCase(namespaceLastPart);
                }
                case GENERIC: {
                    return "File";
                }
            }
            throw new AssertionError();
        }
    }
}

