/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.parseinfo;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.annotations.Immutable;
import com.google.template.soy.parseinfo.TemplateName;

@Immutable
public class SoyTemplateInfo {
    private final String name;
    private final TemplateName templateName;
    private final ImmutableMap<String, ParamRequisiteness> paramMap;

    protected SoyTemplateInfo(String name, TemplateName templateName, ImmutableMap<String, ParamRequisiteness> paramMap) {
        Preconditions.checkArgument((name.lastIndexOf(46) > 0 ? 1 : 0) != 0);
        this.name = name;
        this.templateName = templateName;
        this.paramMap = paramMap;
    }

    @Deprecated
    public final String getName() {
        return this.name;
    }

    public final TemplateName getTemplateName() {
        return (TemplateName)Preconditions.checkNotNull((Object)this.templateName);
    }

    public final String getPartialName() {
        String name = this.getName();
        return name.substring(name.lastIndexOf(46));
    }

    public final int getParamCount() {
        return this.paramMap.size();
    }

    public final ImmutableSet<String> getParamNames() {
        return this.paramMap.keySet();
    }

    public final ImmutableSet<String> getRequiredParamNames() {
        return (ImmutableSet)this.paramMap.keySet().stream().filter(n -> this.paramMap.get(n) == ParamRequisiteness.REQUIRED).collect(ImmutableSet.toImmutableSet());
    }

    public final boolean hasParam(String paramName) {
        return this.getParamNames().contains((Object)paramName);
    }

    public final ParamRequisiteness getParamRequisiteness(String paramName) {
        ParamRequisiteness pr = (ParamRequisiteness)((Object)this.paramMap.get((Object)paramName));
        Preconditions.checkArgument((pr != null ? 1 : 0) != 0);
        return pr;
    }

    public static enum ParamRequisiteness {
        REQUIRED,
        OPTIONAL;

    }
}

