/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.msgs.restricted;

import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.annotations.DoNotMock;
import com.google.errorprone.annotations.Immutable;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.msgs.restricted.AutoValue_SoyMsg;
import com.google.template.soy.msgs.restricted.AutoValue_SoyMsg_SourceLocationAndTemplate;
import com.google.template.soy.msgs.restricted.SoyMsgPart;
import java.util.OptionalLong;
import javax.annotation.Nullable;

@DoNotMock(value="use the builder() instead to construct a real instance")
@Immutable
@AutoValue
public abstract class SoyMsg {
    public static Builder builder() {
        return new Builder();
    }

    SoyMsg() {
    }

    public Builder toBuilder() {
        Builder builder = SoyMsg.builder().setId(this.getId()).setIsHidden(this.isHidden()).setParts((Iterable<? extends SoyMsgPart>)this.getParts()).addAllSourceLocations((Iterable<SourceLocationAndTemplate>)this.getSourceLocations()).setIsPlrselMsg(this.isPlrselMsg()).setHasFallback(this.hasFallback());
        if (this.getLocaleString() != null) {
            builder.setLocaleString(this.getLocaleString());
        }
        if (this.getMeaning() != null) {
            builder.setMeaning(this.getMeaning());
        }
        if (this.getDesc() != null) {
            builder.setDesc(this.getDesc());
        }
        if (this.getContentType() != null) {
            builder.setContentType(this.getContentType());
        }
        this.getAlternateId().ifPresent(builder::setAlternateId);
        return builder;
    }

    @Nullable
    public abstract String getLocaleString();

    public abstract long getId();

    public abstract OptionalLong getAlternateId();

    @Nullable
    public abstract String getMeaning();

    @Nullable
    public abstract String getDesc();

    public abstract boolean isHidden();

    @Nullable
    public abstract String getContentType();

    public abstract boolean isPlrselMsg();

    public abstract ImmutableList<SoyMsgPart> getParts();

    public abstract ImmutableSet<SourceLocationAndTemplate> getSourceLocations();

    public final SourceLocation getExampleSourceLocation() {
        return ((SourceLocationAndTemplate)this.getSourceLocations().iterator().next()).sourceLocation();
    }

    public abstract boolean hasFallback();

    public static final class Builder {
        private long id;
        private OptionalLong alternateId = OptionalLong.empty();
        @Nullable
        private String localeString;
        @Nullable
        private String meaning;
        @Nullable
        private String desc;
        private boolean isHidden;
        @Nullable
        private String contentType;
        private final ImmutableSet.Builder<SourceLocationAndTemplate> sourceLocations = ImmutableSet.builder();
        private boolean isPlrselMsg;
        private ImmutableList<SoyMsgPart> parts;
        private boolean hasFallback;

        private Builder() {
        }

        public Builder setId(long id) {
            Preconditions.checkArgument((id >= 0L ? 1 : 0) != 0);
            this.id = id;
            return this;
        }

        public Builder setAlternateId(long alternateId) {
            Preconditions.checkArgument((alternateId >= 0L ? 1 : 0) != 0);
            this.alternateId = OptionalLong.of(alternateId);
            return this;
        }

        public Builder setLocaleString(String localeString) {
            this.localeString = (String)Preconditions.checkNotNull((Object)localeString);
            return this;
        }

        public Builder setMeaning(String meaning) {
            this.meaning = (String)Preconditions.checkNotNull((Object)meaning);
            return this;
        }

        public Builder setDesc(String desc) {
            this.desc = (String)Preconditions.checkNotNull((Object)desc);
            return this;
        }

        public Builder setIsHidden(boolean isHidden) {
            this.isHidden = isHidden;
            return this;
        }

        public Builder setContentType(String contentType) {
            this.contentType = (String)Preconditions.checkNotNull((Object)contentType);
            return this;
        }

        public Builder addSourceLocation(SourceLocation sourceLocation, String templateName) {
            this.sourceLocations.add((Object)SourceLocationAndTemplate.create((SourceLocation)Preconditions.checkNotNull((Object)sourceLocation), templateName));
            return this;
        }

        public Builder addAllSourceLocations(Iterable<SourceLocationAndTemplate> sourceLocations) {
            this.sourceLocations.addAll(sourceLocations);
            return this;
        }

        public Builder setIsPlrselMsg(boolean isPlrselMsg) {
            this.isPlrselMsg = isPlrselMsg;
            return this;
        }

        public Builder setParts(Iterable<? extends SoyMsgPart> parts) {
            this.parts = ImmutableList.copyOf(parts);
            Preconditions.checkArgument((!this.parts.isEmpty() ? 1 : 0) != 0, (Object)"Parts should never be empty");
            return this;
        }

        public Builder setHasFallback(boolean hasFallback) {
            this.hasFallback = hasFallback;
            return this;
        }

        public SoyMsg build() {
            if (this.alternateId.isPresent() && this.alternateId.getAsLong() == this.id) {
                this.alternateId = OptionalLong.empty();
            }
            return new AutoValue_SoyMsg(this.localeString, this.id, this.alternateId, this.meaning, this.desc, this.isHidden, this.contentType, this.isPlrselMsg, this.parts, (ImmutableSet<SourceLocationAndTemplate>)this.sourceLocations.build(), this.hasFallback);
        }
    }

    @Immutable
    @AutoValue
    public static abstract class SourceLocationAndTemplate {
        static SourceLocationAndTemplate create(SourceLocation srcLoc, String template) {
            return new AutoValue_SoyMsg_SourceLocationAndTemplate(srcLoc, template);
        }

        public abstract SourceLocation sourceLocation();

        public abstract String template();
    }
}

